/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);
static GType vala_local_variable_get_type_once (void);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaSemanticAnalyzer* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSymbol* _tmp54_;
	ValaSymbol* _tmp55_;
	ValaScope* _tmp56_;
	ValaScope* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	gboolean _tmp115_;
	gboolean _tmp116_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp129_;
	ValaDataType* _tmp130_;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_ = FALSE;
	gboolean _tmp133_ = FALSE;
	ValaArrayType* _tmp134_;
	gboolean _tmp146_ = FALSE;
	gboolean _tmp147_ = FALSE;
	gboolean _tmp148_ = FALSE;
	ValaArrayType* _tmp149_;
	gboolean _tmp160_ = FALSE;
	ValaExpression* _tmp161_;
	ValaExpression* _tmp162_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp268_;
	ValaSemanticAnalyzer* _tmp269_;
	ValaSymbol* _tmp270_;
	ValaSymbol* _tmp271_;
	ValaBlock* _tmp272_;
	gboolean _tmp274_;
	gboolean _tmp275_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaVarType* _tmp6_;
		ValaVarType* _tmp7_;
		_tmp6_ = vala_var_type_new (TRUE);
		_tmp7_ = _tmp6_;
		vala_variable_set_variable_type ((ValaVariable*) self, (ValaDataType*) _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	_tmp8_ = vala_code_context_get_experimental_non_null (context);
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_REFERENCE_TYPE (_tmp11_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaArrayType* _tmp15_;
			_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp13_ = _tmp12_;
			array_type = VALA_IS_ARRAY_TYPE (_tmp13_) ? ((ValaArrayType*) _tmp13_) : NULL;
			_tmp15_ = array_type;
			if (_tmp15_ != NULL) {
				ValaArrayType* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = array_type;
				_tmp17_ = vala_array_type_get_fixed_length (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
			} else {
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp20_ = _tmp19_;
				vala_data_type_set_nullable (_tmp20_, TRUE);
			}
		}
	}
	_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp22_ = _tmp21_;
	if (!VALA_IS_VAR_TYPE (_tmp22_)) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp24_ = _tmp23_;
		if (VALA_IS_VOID_TYPE (_tmp24_)) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			_tmp27_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp28_ = _tmp27_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp28_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
		_tmp29_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		if (!_tmp30_) {
			ValaSemanticAnalyzer* _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			_tmp31_ = vala_code_context_get_analyzer (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp34_ = _tmp33_;
			vala_semantic_analyzer_check_type (_tmp32_, _tmp34_);
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp36_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp38_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp39_ = _tmp38_;
		_tmp35_ = !_tmp39_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp50_;
		ValaExpression* _tmp51_;
		_tmp40_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		vala_expression_set_target_type (_tmp41_, _tmp43_);
		_tmp44_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp45_ = _tmp44_;
		if (VALA_IS_INITIALIZER_LIST (_tmp45_)) {
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp49_ = _tmp48_;
			initializer_size = _tmp49_;
			is_initializer_list = TRUE;
		}
		_tmp50_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp51_ = _tmp50_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp51_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp52_ = vala_code_context_get_analyzer (context);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_semantic_analyzer_get_current_symbol (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_symbol_get_scope (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp59_ = _tmp58_;
	vala_scope_add (_tmp57_, _tmp59_, (ValaSymbol*) self);
	_tmp60_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp61_ = _tmp60_;
	if (_tmp61_) {
		result = FALSE;
		return result;
	}
	_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp63_ = _tmp62_;
	if (VALA_IS_VAR_TYPE (_tmp63_)) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		gboolean _tmp74_ = FALSE;
		ValaExpression* _tmp75_;
		ValaExpression* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		gboolean value_owned = FALSE;
		ValaDataType* _tmp95_;
		ValaDataType* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaDataType* _tmp103_;
		ValaDataType* _tmp104_;
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		ValaDataType* _tmp107_;
		ValaDataType* _tmp108_;
		ValaExpression* _tmp109_;
		ValaExpression* _tmp110_;
		ValaDataType* _tmp111_;
		ValaDataType* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		_tmp64_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp65_ = _tmp64_;
		if (_tmp65_ == NULL) {
			ValaSourceReference* _tmp66_;
			ValaSourceReference* _tmp67_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp67_ = _tmp66_;
			vala_report_error (_tmp67_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp68_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_expression_get_value_type (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ == NULL) {
			ValaSourceReference* _tmp72_;
			ValaSourceReference* _tmp73_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp73_ = _tmp72_;
			vala_report_error (_tmp73_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_expression_get_value_type (_tmp76_);
		_tmp78_ = _tmp77_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp78_)) {
			_tmp74_ = TRUE;
		} else {
			ValaExpression* _tmp79_;
			ValaExpression* _tmp80_;
			ValaDataType* _tmp81_;
			ValaDataType* _tmp82_;
			_tmp79_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_expression_get_value_type (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp74_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp82_);
		}
		if (_tmp74_) {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			ValaSourceReference* _tmp85_;
			ValaSourceReference* _tmp86_;
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			ValaSymbol* _tmp89_;
			ValaSymbol* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_expression_get_symbol_reference (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_symbol_get_full_name (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp92_);
			_tmp94_ = _tmp93_;
			vala_report_error (_tmp86_, _tmp94_);
			_g_free0 (_tmp94_);
			_g_free0 (_tmp92_);
			result = FALSE;
			return result;
		}
		_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_data_type_get_value_owned (_tmp96_);
		_tmp98_ = _tmp97_;
		value_owned = _tmp98_;
		_tmp99_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_expression_get_value_type (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_copy (_tmp102_);
		_tmp104_ = _tmp103_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp104_);
		_vala_code_node_unref0 (_tmp104_);
		_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp106_ = _tmp105_;
		vala_data_type_set_value_owned (_tmp106_, value_owned);
		_tmp107_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp108_ = _tmp107_;
		vala_data_type_set_floating_reference (_tmp108_, FALSE);
		_tmp109_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		vala_expression_set_target_type (_tmp110_, _tmp112_);
		_tmp113_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
	}
	_tmp115_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp116_ = _tmp115_;
	if (!_tmp116_) {
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaTypeSymbol* _tmp119_;
		ValaTypeSymbol* _tmp120_;
		_tmp117_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_data_type_get_type_symbol (_tmp118_);
		_tmp120_ = _tmp119_;
		if (_tmp120_ != NULL) {
			ValaDataType* _tmp121_;
			ValaDataType* _tmp122_;
			ValaTypeSymbol* _tmp123_;
			ValaTypeSymbol* _tmp124_;
			ValaVersionAttribute* _tmp125_;
			ValaVersionAttribute* _tmp126_;
			ValaSourceReference* _tmp127_;
			ValaSourceReference* _tmp128_;
			_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_data_type_get_type_symbol (_tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_symbol_get_version ((ValaSymbol*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp128_ = _tmp127_;
			vala_version_attribute_check (_tmp126_, _tmp128_);
		}
	}
	_tmp129_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp130_ = _tmp129_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp130_) ? ((ValaArrayType*) _tmp130_) : NULL;
	_tmp134_ = variable_array_type;
	if (_tmp134_ != NULL) {
		ValaArrayType* _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp137_;
		_tmp135_ = variable_array_type;
		_tmp136_ = vala_array_type_get_inline_allocated (_tmp135_);
		_tmp137_ = _tmp136_;
		_tmp133_ = _tmp137_;
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaExpression* _tmp138_;
		ValaExpression* _tmp139_;
		_tmp138_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp139_ = _tmp138_;
		_tmp132_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp139_);
	} else {
		_tmp132_ = FALSE;
	}
	if (_tmp132_) {
		ValaExpression* _tmp140_;
		ValaExpression* _tmp141_;
		ValaInitializerList* _tmp142_;
		ValaInitializerList* _tmp143_;
		_tmp140_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp143_ = _tmp142_;
		_tmp131_ = _tmp143_ == NULL;
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		ValaSourceReference* _tmp144_;
		ValaSourceReference* _tmp145_;
		_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp145_ = _tmp144_;
		vala_report_warning (_tmp145_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp149_ = variable_array_type;
	if (_tmp149_ != NULL) {
		ValaArrayType* _tmp150_;
		gboolean _tmp151_;
		gboolean _tmp152_;
		_tmp150_ = variable_array_type;
		_tmp151_ = vala_array_type_get_inline_allocated (_tmp150_);
		_tmp152_ = _tmp151_;
		_tmp148_ = _tmp152_;
	} else {
		_tmp148_ = FALSE;
	}
	if (_tmp148_) {
		ValaArrayType* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		_tmp153_ = variable_array_type;
		_tmp154_ = vala_array_type_get_length (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp147_ = _tmp155_ == NULL;
	} else {
		_tmp147_ = FALSE;
	}
	if (_tmp147_) {
		ValaExpression* _tmp156_;
		ValaExpression* _tmp157_;
		_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp157_ = _tmp156_;
		_tmp146_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp157_);
	} else {
		_tmp146_ = FALSE;
	}
	if (_tmp146_) {
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		vala_report_error (_tmp159_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp161_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp162_ = _tmp161_;
	if (_tmp162_ != NULL) {
		ValaExpression* _tmp163_;
		ValaExpression* _tmp164_;
		gboolean _tmp165_;
		gboolean _tmp166_;
		_tmp163_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp164_ = _tmp163_;
		_tmp165_ = vala_code_node_get_error ((ValaCodeNode*) _tmp164_);
		_tmp166_ = _tmp165_;
		_tmp160_ = !_tmp166_;
	} else {
		_tmp160_ = FALSE;
	}
	if (_tmp160_) {
		ValaExpression* _tmp167_;
		ValaExpression* _tmp168_;
		ValaDataType* _tmp169_;
		ValaDataType* _tmp170_;
		ValaExpression* _tmp206_;
		ValaExpression* _tmp207_;
		ValaDataType* _tmp208_;
		ValaDataType* _tmp209_;
		ValaDataType* _tmp210_;
		ValaDataType* _tmp211_;
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		gboolean _tmp228_ = FALSE;
		ValaArrayType* _tmp229_;
		gboolean _tmp243_ = FALSE;
		gboolean _tmp244_ = FALSE;
		ValaArrayType* _tmp245_;
		ValaExpression* _tmp255_;
		ValaExpression* _tmp256_;
		ValaDataType* _tmp257_;
		ValaDataType* _tmp258_;
		_tmp167_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp168_ = _tmp167_;
		_tmp169_ = vala_expression_get_value_type (_tmp168_);
		_tmp170_ = _tmp169_;
		if (VALA_IS_METHOD_TYPE (_tmp170_)) {
			gboolean _tmp171_ = FALSE;
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp178_;
			ValaDataType* _tmp179_;
			_tmp172_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp173_ = _tmp172_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp173_)) {
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				_tmp174_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp175_ = _tmp174_;
				_tmp171_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp175_);
			} else {
				_tmp171_ = FALSE;
			}
			if (_tmp171_) {
				ValaSourceReference* _tmp176_;
				ValaSourceReference* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp177_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp178_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp179_ = _tmp178_;
			if (VALA_IS_DELEGATE_TYPE (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				_tmp180_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_value_type (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp185_ = _tmp184_;
				if (!vala_data_type_compatible (_tmp183_, _tmp185_)) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp186_;
					ValaExpression* _tmp187_;
					ValaSymbol* _tmp188_;
					ValaSymbol* _tmp189_;
					ValaDelegate* cb = NULL;
					ValaDataType* _tmp190_;
					ValaDataType* _tmp191_;
					ValaDelegate* _tmp192_;
					ValaDelegate* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaMethod* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					ValaDelegate* _tmp199_;
					gchar* _tmp200_;
					gchar* _tmp201_;
					gchar* _tmp202_;
					gchar* _tmp203_;
					_tmp186_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
					_tmp189_ = _tmp188_;
					m = G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_METHOD, ValaMethod);
					_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp193_ = _tmp192_;
					cb = _tmp193_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp195_ = _tmp194_;
					_tmp196_ = m;
					_tmp197_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = cb;
					_tmp200_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp198_, _tmp201_);
					_tmp203_ = _tmp202_;
					vala_report_error (_tmp195_, _tmp203_);
					_g_free0 (_tmp203_);
					_g_free0 (_tmp201_);
					_g_free0 (_tmp198_);
					result = FALSE;
					return result;
				}
			} else {
				ValaSourceReference* _tmp204_;
				ValaSourceReference* _tmp205_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp205_ = _tmp204_;
				vala_report_error (_tmp205_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp206_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp207_ = _tmp206_;
		_tmp208_ = vala_expression_get_value_type (_tmp207_);
		_tmp209_ = _tmp208_;
		_tmp210_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp211_ = _tmp210_;
		if (!vala_data_type_compatible (_tmp209_, _tmp211_)) {
			ValaSourceReference* _tmp212_;
			ValaSourceReference* _tmp213_;
			ValaExpression* _tmp214_;
			ValaExpression* _tmp215_;
			ValaDataType* _tmp216_;
			ValaDataType* _tmp217_;
			gchar* _tmp218_;
			gchar* _tmp219_;
			ValaDataType* _tmp220_;
			ValaDataType* _tmp221_;
			gchar* _tmp222_;
			gchar* _tmp223_;
			gchar* _tmp224_;
			gchar* _tmp225_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp215_ = _tmp214_;
			_tmp216_ = vala_expression_get_value_type (_tmp215_);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_code_node_to_string ((ValaCodeNode*) _tmp217_);
			_tmp219_ = _tmp218_;
			_tmp220_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp221_ = _tmp220_;
			_tmp222_ = vala_code_node_to_string ((ValaCodeNode*) _tmp221_);
			_tmp223_ = _tmp222_;
			_tmp224_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp219_, _tmp223_);
			_tmp225_ = _tmp224_;
			vala_report_error (_tmp213_, _tmp225_);
			_g_free0 (_tmp225_);
			_g_free0 (_tmp223_);
			_g_free0 (_tmp219_);
			result = FALSE;
			return result;
		}
		_tmp229_ = variable_array_type;
		if (_tmp229_ != NULL) {
			ValaArrayType* _tmp230_;
			gboolean _tmp231_;
			gboolean _tmp232_;
			_tmp230_ = variable_array_type;
			_tmp231_ = vala_array_type_get_inline_allocated (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp228_ = _tmp232_;
		} else {
			_tmp228_ = FALSE;
		}
		if (_tmp228_) {
			ValaArrayType* _tmp233_;
			gboolean _tmp234_;
			gboolean _tmp235_;
			_tmp233_ = variable_array_type;
			_tmp234_ = vala_array_type_get_fixed_length (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp227_ = !_tmp235_;
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			_tmp226_ = is_initializer_list;
		} else {
			_tmp226_ = FALSE;
		}
		if (_tmp226_) {
			ValaArrayType* _tmp236_;
			gchar* _tmp237_;
			gchar* _tmp238_;
			ValaIntegerLiteral* _tmp239_;
			ValaIntegerLiteral* _tmp240_;
			ValaArrayType* _tmp241_;
			ValaArrayType* _tmp242_;
			_tmp236_ = variable_array_type;
			_tmp237_ = g_strdup_printf ("%i", initializer_size);
			_tmp238_ = _tmp237_;
			_tmp239_ = vala_integer_literal_new (_tmp238_, NULL);
			_tmp240_ = _tmp239_;
			vala_array_type_set_length (_tmp236_, (ValaExpression*) _tmp240_);
			_vala_code_node_unref0 (_tmp240_);
			_g_free0 (_tmp238_);
			_tmp241_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp241_, TRUE);
			_tmp242_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp242_, FALSE);
		}
		_tmp245_ = variable_array_type;
		if (_tmp245_ != NULL) {
			ValaArrayType* _tmp246_;
			gboolean _tmp247_;
			gboolean _tmp248_;
			_tmp246_ = variable_array_type;
			_tmp247_ = vala_array_type_get_inline_allocated (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp244_ = _tmp248_;
		} else {
			_tmp244_ = FALSE;
		}
		if (_tmp244_) {
			ValaExpression* _tmp249_;
			ValaExpression* _tmp250_;
			ValaDataType* _tmp251_;
			ValaDataType* _tmp252_;
			_tmp249_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_expression_get_value_type (_tmp250_);
			_tmp252_ = _tmp251_;
			_tmp243_ = VALA_IS_ARRAY_TYPE (_tmp252_) == FALSE;
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			ValaSourceReference* _tmp253_;
			ValaSourceReference* _tmp254_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp254_ = _tmp253_;
			vala_report_error (_tmp254_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp255_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = vala_expression_get_value_type (_tmp256_);
		_tmp258_ = _tmp257_;
		if (vala_data_type_is_disposable (_tmp258_)) {
			gboolean _tmp259_ = FALSE;
			ValaDataType* _tmp260_;
			ValaDataType* _tmp261_;
			_tmp260_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp261_ = _tmp260_;
			if (!VALA_IS_POINTER_TYPE (_tmp261_)) {
				ValaDataType* _tmp262_;
				ValaDataType* _tmp263_;
				gboolean _tmp264_;
				gboolean _tmp265_;
				_tmp262_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_data_type_get_value_owned (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp259_ = !_tmp265_;
			} else {
				_tmp259_ = FALSE;
			}
			if (_tmp259_) {
				ValaSourceReference* _tmp266_;
				ValaSourceReference* _tmp267_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp267_ = _tmp266_;
				vala_report_error (_tmp267_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp268_ = vala_code_context_get_analyzer (context);
	_tmp269_ = _tmp268_;
	_tmp270_ = vala_semantic_analyzer_get_current_symbol (_tmp269_);
	_tmp271_ = _tmp270_;
	block = VALA_IS_BLOCK (_tmp271_) ? ((ValaBlock*) _tmp271_) : NULL;
	_tmp272_ = block;
	if (_tmp272_ != NULL) {
		ValaBlock* _tmp273_;
		_tmp273_ = block;
		vala_block_add_local_variable (_tmp273_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp274_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp275_ = _tmp274_;
	result = !_tmp275_;
	return result;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
static GType
vala_local_variable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
	GType vala_local_variable_type_id;
	vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
	ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
	return vala_local_variable_type_id;
}

GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = vala_local_variable_get_type_once ();
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

