---
title: Detector
---

# flowrouter.py

"flowrouter.py" serves as a drop in replacement for
[dfrouter](../dfrouter.md) which calculates a set of routes **-o** and
traffic flows **-e** from given detectors **-d** and their measurements **-f** on a given
network (option **-n**).

Flowrouter works by solving a maximum flow problem in the given network
assuming the measured flows as capacity. The input data is by default
aggregated over the whole file but can be split into intervals by
setting **-i**. Example call for hourly aggregation:

```
<SUMO_HOME>/tools/detector/flowrouter.py -n input_net.net.xml -d detectors.xml -f flows20140520.csv -o routes.xml -e flows.xml -i 60
```

Detectors which have no data (in the specified interval) or are
permanently zero are ignored by default. To include them into the
calculations use **--respect-zero**.

For additional parameters call

```
<SUMO_HOME>/tools/detector/flowrouter.py --help
```

!!! caution
    flowrouter.py is under continuous development. If it fails to deliver the expected results, try using the [latest development version](../Downloads.md#sumo_-_latest_development_version).

## Input files

The traffic flow file is described in the corresponding [dfrouter documentation](../Demand/Routes_from_Observation_Points.md#computing_flows).

As detector file input you can either use

- The detector file as described in the [dfrouter documentation](../Demand/Routes_from_Observation_Points.md#computing_detector_types)
- A detector file with types as [generated by dfrouter](../Demand/Routes_from_Observation_Points.md#computing_detector_types)
- a file with [induction loop definitions](../Simulation/Output/Induction_Loops_Detectors_(E1).md)

When loading a detector file without `type` information or setting the option **--revalidate-detectors**, all network edges will be re-classified as *sources*, *sinks* or
*in-between*.

- any edge without incoming edges will be marked as a source
- any edge without outgoing edges will be marked as a sink
- any edge that is neither source or sink is *in-between*

## Generating vehicles with additional parameters

With the option **--params** {{DT_STR}}, additional parameters can be given to the generated
vehicles (note, usage of the quoting characters).

```
<SUMO_HOME>/tools/detector/flowrouter.py -n input_net.net.xml --params="departLane=\"best\" departSpeed=\"max\" type=\"myType""
```

This would insert the vehicle with high speed on a reasonable lane. The
vehicles would be defined with type *myType* (which could also be the
name of a typeDistribution).

## Ambiguity

In many cases, the solutions for a given input is not unique. By setting
the option **--limit** {{DT_INT}}, the flow is assigned in multiple iterations which causes
flows to be distributed more evenly so that all routes are used in
proportion to the incoming and outgoing flows (as done by
[dfrouter](../dfrouter.md)).

Another way to resolve ambiguity is to add route restrictions:

### Restricting generated routes

With the option **--flow-restrictions** {{DT_FILE}}, flow restriction for routes may be given. Each line in the input file takes the form:

```
<FLOW1> <EDGE1> <EDGE2> ... <EDGEk>
```

This specifies the maximum flow for a route that consists of the given
edges. Alternatively, the flow for a single edge can be restricted with an input line:

```
<FLOW1> <EDGE1>
```

The tool [implausibleRoutes.py](Routes.md#implausibleroutespy) can be used to generate restrictions for routes that are implausible according to a configurable heuristic.

# flowFromRoutes.py

This script does the reverse of flowrouter.py and
[dfrouter](../dfrouter.md) in generating a traffic counts for
detectors from a route or flow file. It can also be used to compare the
input counts with the outputs of flowrouter.py and
[dfrouter](../dfrouter.md). Example:

```
<SUMO_HOME>/tools/detector/flowFromRoutes.py -d detectors.xml -r routes.xml -e flows.xml
```

# edgeDataFromFlow.py

This script converts detector flow files to into edgeData format (i.e. to be used by [routeSampler.py](Turns.md#routesamplerpy))
Example:
```
<SUMO_HOME>/tools/detector/edgeDataFromFlow.py -d input_detectors.det.xml -f input_flows.txt -o edgedata.xml 
```