@echo off
rem
rem  Uses SED to generate the module definition file for linking into
rem  a DLL, and the rsxdll.h header that tricks DLL variable references
rem  into working with RSXNT.
rem

echo Scanning for global symbols...
gcc -E -I. -I./include -dD -DSCAN_EXPORT -o _expdef.tmp src/inline.c
echo ; generated by fixdll.bat > _all.def
echo EXPORTS >> _all.def
sed -n -e "s/^alldll[fi][un][nl]  *\**\(.*\)_dll.*/    \1/p" _expdef.tmp > _expdef1.tmp
sed -n -e "s/^alldll[vfa][apr][rtr]  *\**\(.*\)_dll.*/    \1 DATA/p" _expdef.tmp >> _expdef1.tmp
sort _expdef1.tmp > _expdef2.tmp
sed -e "p" -e "=" -e "d" _expdef2.tmp > _expdef3.tmp
sed -e "N" -e "s/\n/ @/" -e "s/DATA \(.*\)/\1 DATA/" _expdef3.tmp >> _all.def

echo Generating lib\msvc\allegro.def...
copy _all.def lib\msvc\allegro.def > nul

echo Generating lib\mingw32\allegro.def...
copy _all.def lib\mingw32\allegro.def > nul

echo Generating include\allegro\rsxdll.h...
echo /* generated by fixdll.bat for RSXNT */ > include\allegro\rsxdll.h
sed -n -e "s/^alldll[vf][ap][rt] *\**\(.*\)_dll.*/#define \1 (*\1)/p" _expdef.tmp >> include\allegro\rsxdll.h

rm _expdef.tmp _expdef1.tmp _expdef2.tmp _expdef3.tmp _all.def

echo Done!
