// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LdapManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class LdapManager_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.LdapManager:2.0.0", null);

    public LdapManager_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public LdapManager_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new LdapManager_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new LdapManager_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class GetLdapServersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0> _ret_;
    }

    public GetLdapServersResult getLdapServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getLdapServers", _parameters);
      var _ret = new GetLdapServersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLdapServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getLdapServers", _parameters,
        _result => {
          try {
            var _ret = new GetLdapServersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_CYCLIC_DEP = 1;

    public const int ERR_INVALID_CFG = 2;

    public class SetLdapServersResult {
      public int _ret_;
    }

    public SetLdapServersResult setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0> serverList) {
      var _parameters = new LightJson.JsonObject();
      _parameters["serverList"] = new JsonArray(serverList.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("setLdapServers", _parameters);
      var _ret = new SetLdapServersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0> serverList, AsyncRpcResponse<SetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setLdapServers(serverList, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0> serverList, AsyncRpcResponse<SetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["serverList"] = new JsonArray(serverList.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setLdapServers", _parameters,
        _result => {
          try {
            var _ret = new SetLdapServersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_SERVER_UNSPECIFIED = 1;

    public const int ERR_SERVER_UNREACHABLE = 3;

    public const int ERR_AUTHENTICATION_FAILED = 4;

    public const int ERR_NO_ROLES = 5;

    public const int ERR_NO_KNOWN_ROLES = 6;

    public class TestLdapServerResult {
      public int _ret_;
      public string diagMsg;
    }

    public TestLdapServerResult testLdapServer(string username, string password, Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0 settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("testLdapServer", _parameters);
      var _ret = new TestLdapServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.diagMsg = (string)_result["diagMsg"];
      return _ret;
    }

    public AsyncRequest testLdapServer(string username, string password, Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0 settings, AsyncRpcResponse<TestLdapServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testLdapServer(username, password, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testLdapServer(string username, string password, Com.Raritan.Idl.auth.ldapsrv.ServerSettings_2_0_0 settings, AsyncRpcResponse<TestLdapServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testLdapServer", _parameters,
        _result => {
          try {
            var _ret = new TestLdapServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.diagMsg = (string)_result["diagMsg"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
