% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcdk.R
\name{generate.2d.coordinates}
\alias{generate.2d.coordinates}
\title{Generate 2D coordinates for a molecule.}
\usage{
generate.2d.coordinates(mol)
}
\arguments{
\item{mol}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}
}
\value{
The input molecule, with 2D coordinates added
}
\description{
Some file formats such as SMILES do not support 2D (or 3D) coordinates
for the atoms. Other formats such as SD or MOL have support for coordinates
but may not include them. This method will generate reasonable 2D coordinates 
based purely on connectivity information, overwriting
any existing coordinates if present.
}
\details{
Note that when depicting a molecule (\code{\link{view.molecule.2d}}), 2D coordinates
are generated, but since it does not modify the input molecule, we do not have access
to the generated coordinates.
}
\seealso{
\code{\link{get.point2d}}, \code{\link{view.molecule.2d}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
