% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal.R
\name{ordinal<-}
\alias{ordinal<-}
\alias{ordinal}
\title{Define variables as ordinal}
\usage{
ordinal(x, ...) <- value
}
\arguments{
\item{x}{Object}

\item{...}{additional arguments to lower level functions}

\item{value}{variable (formula or character vector)}
}
\description{
Define variables as ordinal in latent variable model object
}
\examples{
if (requireNamespace("mets")) {
m <- lvm(y + z ~ x + 1*u[0], latent=~u)
ordinal(m, K=3) <- ~y+z
d <- sim(m, 100, seed=1)
e <- estimate(m, d)
}

}
