% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nslookup.R
\name{nslookup}
\alias{nslookup}
\alias{has_internet}
\title{Lookup a hostname}
\usage{
nslookup(host, ipv4_only = FALSE, multiple = FALSE, error = TRUE)

has_internet()
}
\arguments{
\item{host}{a string with a hostname}

\item{ipv4_only}{always return ipv4 address. Set to `FALSE` to allow for ipv6 as well.}

\item{multiple}{returns multiple ip addresses if possible}

\item{error}{raise an error for failed DNS lookup. Otherwise returns \code{NULL}.}
}
\description{
The \code{nslookup} function is similar to \code{nsl} but works on all platforms
and can resolve ipv6 addresses if supported by the OS. Default behavior raises an
error if lookup fails.
}
\details{
The \code{has_internet} function tests for internet connectivity by performing a
dns lookup. If a proxy server is detected, it will also check for connectivity by
connecting via the proxy.
}
\examples{
# Should always work if we are online
nslookup("www.r-project.org")

# If your OS supports IPv6
nslookup("ipv6.test-ipv6.com", ipv4_only = FALSE, error = FALSE)
}
