% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data_overview}
\alias{plot_data_overview}
\title{Overview of the input data}
\usage{
plot_data_overview(
  object,
  covariate = 1,
  colors = NULL,
  show_covariate = FALSE,
  show_dimensions = TRUE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{covariate}{(only for MEFISTO) specifies sample covariate to order samples by in the plot. This should be
a character or  a numeric index giving the name or position of a column present in the covariates slot of the object.
Default is the first sample covariate in covariates slot. \code{NULL} does not order by covariate}

\item{colors}{a vector specifying the colors per view (see example for details).}

\item{show_covariate}{(only for MEFISTO) boolean specifying whether to include the covariate in the plot}

\item{show_dimensions}{logical indicating whether to plot the dimensions of the data (default is TRUE).}
}
\value{
A \code{\link{ggplot}} object
}
\description{
Function to do a tile plot showing the missing value structure of the input data
}
\details{
This function is helpful to get an overview of the structure of the data. 
It shows the model dimensionalities (number of samples, groups, views and features) 
and it indicates which measurements are missing.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_data_overview(model)
}
