% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/gsvaParam.R
\docType{class}
\name{gsvaParam-class}
\alias{gsvaParam-class}
\alias{gsvaParam}
\title{\code{gsvaParam} class}
\usage{
gsvaParam(
  exprData,
  geneSets,
  assay = NA_character_,
  annotation = NA_character_,
  minSize = 1,
  maxSize = Inf,
  kcdf = c("Gaussian", "Poisson", "none"),
  tau = 1,
  maxDiff = TRUE,
  absRanking = FALSE
)
}
\arguments{
\item{exprData}{The expression data.  Must be one of the classes
supported by \code{\linkS4class{GsvaExprData}}.}

\item{geneSets}{The gene sets.  Must be one of the classes supported by
\code{\linkS4class{GsvaGeneSets}}.}

\item{assay}{The name of the assay to use in case \code{exprData} is a multi-assay
container, otherwise ignored.  By default, the first assay is used.}

\item{annotation}{The name of a Bioconductor annotation package for the gene
identifiers occurring in the row names of the expression data matrix.  This
can be used to map gene identifiers occurring in the gene sets if those are
provided in a \code{\link{GeneSetCollection}}.  By default gene identifiers used in
expression data matrix and gene sets are matched directly.}

\item{minSize}{Minimum size of the resulting gene sets after gene identifier
mapping. By default, the minimum size is 1.}

\item{maxSize}{Maximum size of the resulting gene sets after gene identifier
mapping. By default, the maximum size is \code{Inf}.}

\item{kcdf}{Character vector of length 1 denoting the kernel to use during
the non-parametric estimation of the cumulative distribution function of
expression levels across samples.  By default, \code{kcdf="Gaussian"} which is
suitable when input expression values are continuous, such as microarray
fluorescent units in logarithmic scale, RNA-seq log-CPMs, log-RPKMs or
log-TPMs.  When input expression values are integer counts, such as those
derived from RNA-seq experiments, then this argument should be set to
\code{kcdf="Poisson"}.}

\item{tau}{Numeric vector of length 1.  The exponent defining the weight of
the tail in the random walk performed by the \code{GSVA} (Hänzelmann et al.,
2013) method.  The default value is 1 as described in the paper.}

\item{maxDiff}{Logical vector of length 1 which offers two approaches to
calculate the enrichment statistic (ES) from the KS random walk statistic.
\itemize{
\item \code{FALSE}: ES is calculated as the maximum distance of the random walk
from 0.
\item \code{TRUE} (the default): ES is calculated as the magnitude difference between
the largest positive and negative random walk deviations.
}}

\item{absRanking}{Logical vector of length 1 used only when \code{maxDiff=TRUE}.
When \code{absRanking=FALSE} (default) a modified Kuiper statistic is used to
calculate enrichment scores, taking the magnitude difference between the
largest positive and negative random walk deviations. When
\code{absRanking=TRUE} the original Kuiper statistic that sums the largest
positive and negative random walk deviations, is used. In this latter case,
gene sets with genes enriched on either extreme (high or low) will be
regarded as ’highly’ activated.}
}
\value{
A new \code{\linkS4class{gsvaParam}} object.
}
\description{
Method-specific parameters for the GSVA method.

Objects of class \code{gsvaParam} contain the parameters for running
the \code{GSVA} method.
}
\details{
In addition to the two common parameter slots inherited from
\verb{[GsvaMethodParam]}, this class has slots for the two method-specific
parameters of the GSVA method described below.

In addition to an expression data set and a collection of
gene sets, \code{GSVA} takes four method-specific parameters as described below.
}
\section{Slots}{

\describe{
\item{\code{kcdf}}{Character vector of length 1 denoting the kernel to use during
the non-parametric estimation of the cumulative distribution function of
expression levels across samples. \code{kcdf="Gaussian"} is suitable when input
expression values are continuous, such as microarray fluorescent units in
logarithmic scale, RNA-seq log-CPMs, log-RPKMs or log-TPMs. When input
expression values are integer counts, such as those derived from RNA-seq
experiments, then this argument should be set to \code{kcdf="Poisson"}.}

\item{\code{tau}}{Numeric vector of length 1.  The exponent defining the weight of
the tail in the random walk performed by the GSVA (Hänzelmann et al., 2013)
method.}

\item{\code{maxDiff}}{Logical vector of length 1 which offers two approaches to
calculate the enrichment statistic (ES) from the KS random walk statistic.
\itemize{
\item \code{FALSE}: ES is calculated as the maximum distance of the random walk from 0.
\item \code{TRUE}: ES is calculated as the magnitude difference between
the largest positive and negative random walk deviations.
}}

\item{\code{absRanking}}{Logical vector of length 1 used only when \code{mx.diff=TRUE}.
When \code{abs.ranking=FALSE} a modified Kuiper statistic is used to calculate
enrichment scores, taking the magnitude difference between the largest
positive and negative random walk deviations. When \code{abs.ranking=TRUE} the
original Kuiper statistic that sums the largest positive and negative
random walk deviations, is used. In this latter case, gene sets with genes
enriched on either extreme (high or low) will be regarded as ’highly’
activated.}
}}

\examples{
library(GSVA)
library(GSVAdata)

data(leukemia)
data(c2BroadSets)

## for simplicity, use only a subset of the sample data
ses <- leukemia_eset[1:1000, ]
gsc <- c2BroadSets[1:100]
gp1 <- gsvaParam(ses, gsc)
gp1


}
\references{
Hänzelmann, S., Castelo, R. and Guinney, J. GSVA: Gene set
variation analysis for microarray and RNA-Seq data.
\emph{BMC Bioinformatics}, 14:7, 2013.
\href{https://doi.org/10.1186/1471-2105-14-7}{DOI}
}
\seealso{
\code{\linkS4class{GsvaExprData}},
\code{\linkS4class{GsvaGeneSets}},
\code{\linkS4class{GsvaMethodParam}},
\code{\linkS4class{plageParam}},
\code{\linkS4class{zscoreParam}},
\code{\linkS4class{ssgseaParam}}
}
