% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRangedSummarizedExperiment.R
\name{readRangedSummarizedExperiment}
\alias{readRangedSummarizedExperiment}
\title{Read a RangedSummarizedExperiment from disk}
\usage{
readRangedSummarizedExperiment(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{saveObject}} method for \linkS4class{RangedSummarizedExperiment} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to \code{\link{readSummarizedExperiment}} and internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{RangedSummarizedExperiment} object.
}
\description{
Read a \linkS4class{RangedSummarizedExperiment} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
# Mocking up an experiment:
mat <- matrix(rpois(10000, 10), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

gr <- GRanges("chrA", IRanges(1:1000, width=10))
se <- SummarizedExperiment(list(counts=mat), rowRanges=gr)
se$stuff <- LETTERS[1:10]
rowData(se)$blah <- runif(1000)
metadata(se)$whee <- "YAY"

tmp <- tempfile()
saveObject(se, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,RangedSummarizedExperiment-method}"}, to save the RangedSummarizedExperiment to disk.
}
\author{
Aaron Lun
}
