# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._files_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_request,
    build_read_request,
    build_read_write_request,
    build_update_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class FilesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.datamigration.aio.DataMigrationManagementClient`'s
        :attr:`files` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, group_name: str, service_name: str, project_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProjectFile"]:
        """Get files in a project.

        The project resource is a nested resource representing a stored migration project. This method
        returns a list of files owned by a project resource.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProjectFile or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.datamigration.models.ProjectFile]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.FileList] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    group_name=group_name,
                    service_name=service_name,
                    project_name=project_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("FileList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files"
    }

    @distributed_trace_async
    async def get(
        self, group_name: str, service_name: str, project_name: str, file_name: str, **kwargs: Any
    ) -> _models.ProjectFile:
        """Get file information.

        The files resource is a nested, proxy-only resource representing a file stored under the
        project resource. This method retrieves information about a file.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ProjectFile] = kwargs.pop("cls", None)

        request = build_get_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProjectFile", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}"
    }

    @overload
    async def create_or_update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: _models.ProjectFile,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Create a file resource.

        The PUT method creates a new file or updates an existing one.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Required.
        :type parameters: ~azure.mgmt.datamigration.models.ProjectFile
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Create a file resource.

        The PUT method creates a new file or updates an existing one.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: Union[_models.ProjectFile, IO],
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Create a file resource.

        The PUT method creates a new file or updates an existing one.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Is either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.datamigration.models.ProjectFile or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProjectFile] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ProjectFile")

        request = build_create_or_update_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ProjectFile", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ProjectFile", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, group_name: str, service_name: str, project_name: str, file_name: str, **kwargs: Any
    ) -> None:
        """Delete file.

        This method deletes a file.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}"
    }

    @overload
    async def update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: _models.ProjectFile,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Update a file.

        This method updates an existing file.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Required.
        :type parameters: ~azure.mgmt.datamigration.models.ProjectFile
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Update a file.

        This method updates an existing file.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        group_name: str,
        service_name: str,
        project_name: str,
        file_name: str,
        parameters: Union[_models.ProjectFile, IO],
        **kwargs: Any
    ) -> _models.ProjectFile:
        """Update a file.

        This method updates an existing file.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :param parameters: Information about the file. Is either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.datamigration.models.ProjectFile or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProjectFile or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.ProjectFile
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProjectFile] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ProjectFile")

        request = build_update_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProjectFile", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}"
    }

    @distributed_trace_async
    async def read(
        self, group_name: str, service_name: str, project_name: str, file_name: str, **kwargs: Any
    ) -> _models.FileStorageInfo:
        """Request storage information for downloading the file content.

        This method is used for requesting storage information using which contents of the file can be
        downloaded.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FileStorageInfo or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.FileStorageInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.FileStorageInfo] = kwargs.pop("cls", None)

        request = build_read_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.read.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FileStorageInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    read.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/read"
    }

    @distributed_trace_async
    async def read_write(
        self, group_name: str, service_name: str, project_name: str, file_name: str, **kwargs: Any
    ) -> _models.FileStorageInfo:
        """Request information for reading and writing file content.

        This method is used for requesting information for reading and writing the file content.

        :param group_name: Name of the resource group. Required.
        :type group_name: str
        :param service_name: Name of the service. Required.
        :type service_name: str
        :param project_name: Name of the project. Required.
        :type project_name: str
        :param file_name: Name of the File. Required.
        :type file_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FileStorageInfo or the result of cls(response)
        :rtype: ~azure.mgmt.datamigration.models.FileStorageInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-30-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.FileStorageInfo] = kwargs.pop("cls", None)

        request = build_read_write_request(
            group_name=group_name,
            service_name=service_name,
            project_name=project_name,
            file_name=file_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.read_write.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FileStorageInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    read_write.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/readwrite"
    }
