# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventsBrowserTimingInfo(Model):
    """The browser timing information.

    :param url_path: The path of the URL
    :type url_path: str
    :param url_host: The host of the URL
    :type url_host: str
    :param name: The name of the page
    :type name: str
    :param url: The url of the page
    :type url: str
    :param total_duration: The total duration of the load
    :type total_duration: long
    :param performance_bucket: The performance bucket of the load
    :type performance_bucket: str
    :param network_duration: The network duration of the load
    :type network_duration: long
    :param send_duration: The send duration of the load
    :type send_duration: long
    :param receive_duration: The receive duration of the load
    :type receive_duration: long
    :param processing_duration: The processing duration of the load
    :type processing_duration: long
    """

    _attribute_map = {
        'url_path': {'key': 'urlPath', 'type': 'str'},
        'url_host': {'key': 'urlHost', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'total_duration': {'key': 'totalDuration', 'type': 'long'},
        'performance_bucket': {'key': 'performanceBucket', 'type': 'str'},
        'network_duration': {'key': 'networkDuration', 'type': 'long'},
        'send_duration': {'key': 'sendDuration', 'type': 'long'},
        'receive_duration': {'key': 'receiveDuration', 'type': 'long'},
        'processing_duration': {'key': 'processingDuration', 'type': 'long'},
    }

    def __init__(self, *, url_path: str=None, url_host: str=None, name: str=None, url: str=None, total_duration: int=None, performance_bucket: str=None, network_duration: int=None, send_duration: int=None, receive_duration: int=None, processing_duration: int=None, **kwargs) -> None:
        super(EventsBrowserTimingInfo, self).__init__(**kwargs)
        self.url_path = url_path
        self.url_host = url_host
        self.name = name
        self.url = url
        self.total_duration = total_duration
        self.performance_bucket = performance_bucket
        self.network_duration = network_duration
        self.send_duration = send_duration
        self.receive_duration = receive_duration
        self.processing_duration = processing_duration
