# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SubscriptionContract(Resource):
    """Subscription details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param owner_id: The user resource identifier of the subscription owner.
     The value is a valid relative URL in the format of /users/{userId} where
     {userId} is a user identifier.
    :type owner_id: str
    :param scope: Required. Scope like /products/{productId} or /apis or
     /apis/{apiId}.
    :type scope: str
    :param display_name: The name of the subscription, or null if the
     subscription has no name.
    :type display_name: str
    :param state: Required. Subscription state. Possible states are * active –
     the subscription is active, * suspended – the subscription is blocked, and
     the subscriber cannot call any APIs of the product, * submitted – the
     subscription request has been made by the developer, but has not yet been
     approved or rejected, * rejected – the subscription request has been
     denied by an administrator, * cancelled – the subscription has been
     cancelled by the developer or administrator, * expired – the subscription
     reached its expiration date and was deactivated. Possible values include:
     'suspended', 'active', 'expired', 'submitted', 'rejected', 'cancelled'
    :type state: str or ~azure.mgmt.apimanagement.models.SubscriptionState
    :ivar created_date: Subscription creation date. The date conforms to the
     following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     standard.
    :vartype created_date: datetime
    :param start_date: Subscription activation date. The setting is for audit
     purposes only and the subscription is not automatically activated. The
     subscription lifecycle can be managed by using the `state` property. The
     date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified
     by the ISO 8601 standard.
    :type start_date: datetime
    :param expiration_date: Subscription expiration date. The setting is for
     audit purposes only and the subscription is not automatically expired. The
     subscription lifecycle can be managed by using the `state` property. The
     date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified
     by the ISO 8601 standard.
    :type expiration_date: datetime
    :param end_date: Date when subscription was cancelled or expired. The
     setting is for audit purposes only and the subscription is not
     automatically cancelled. The subscription lifecycle can be managed by
     using the `state` property. The date conforms to the following format:
     `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
    :type end_date: datetime
    :param notification_date: Upcoming subscription expiration notification
     date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as
     specified by the ISO 8601 standard.
    :type notification_date: datetime
    :param primary_key: Required. Subscription primary key.
    :type primary_key: str
    :param secondary_key: Required. Subscription secondary key.
    :type secondary_key: str
    :param state_comment: Optional subscription comment added by an
     administrator.
    :type state_comment: str
    :param allow_tracing: Determines whether tracing is enabled
    :type allow_tracing: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'required': True},
        'display_name': {'max_length': 100, 'min_length': 0},
        'state': {'required': True},
        'created_date': {'readonly': True},
        'primary_key': {'required': True, 'max_length': 256, 'min_length': 1},
        'secondary_key': {'required': True, 'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SubscriptionState'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'notification_date': {'key': 'properties.notificationDate', 'type': 'iso-8601'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state_comment': {'key': 'properties.stateComment', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionContract, self).__init__(**kwargs)
        self.owner_id = kwargs.get('owner_id', None)
        self.scope = kwargs.get('scope', None)
        self.display_name = kwargs.get('display_name', None)
        self.state = kwargs.get('state', None)
        self.created_date = None
        self.start_date = kwargs.get('start_date', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.notification_date = kwargs.get('notification_date', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.state_comment = kwargs.get('state_comment', None)
        self.allow_tracing = kwargs.get('allow_tracing', None)
