/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/
#ifndef ARITH_H__
#define ARITH_H__


typedef double (*uniproc)(double);
typedef double (*binproc)(double, double);

struct binop
{
    const char* symb;
    binproc proc;
    const char* info;
};
struct mulop
{
    const char* symb;
    binproc proc;
    const char* info;
};
struct uniop
{
    const char* symb;
    uniproc proc;
    const char* info;
};

extern binop BinOps[];
extern mulop MulOps[];
extern uniop UniOps[];

#endif
