/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQGribDumpModel_H
#define MvQGribDumpModel_H

#include <QAbstractItemModel>

#include "GribMetaData.h" 

class GribItem;
class GribMvDump;
class GribStdDump;
class GribWmoDump;
class GribValueDump;

class MvQGribMvDumpModel : public QAbstractItemModel
{

public:
   	MvQGribMvDumpModel();
 	
   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	void dataIsAboutToChange();
	void setDumpData(GribMvDump*);
	GribMvDump* dumpData() {return data_;}
	void setGribNameSpace(QString);

	Qt::ItemFlags flags ( const QModelIndex &) const;
	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

protected:
	QString label(GribItem*,const int) const;

private:
	GribMvDump* data_;
	QString gribNameSpace_;
	
};

class MvQGribWmoDumpModel : public QAbstractItemModel
{

public:
   	MvQGribWmoDumpModel();
 	
   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	void dataIsAboutToChange();
	void setDumpData(GribWmoDump*);
	GribWmoDump* dumpData() {return data_;}

	Qt::ItemFlags flags ( const QModelIndex &) const;
	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

protected:
	QString label(GribSection*,const int) const;
	QString label(GribItem*,const int) const;
	QString label(QString,const int) const;
	int idToLevel(int) const;
	int idToParentRow(int) const;
	int idToGrandParentRow(int) const;

private:
	GribWmoDump* data_;
	
};

class MvQGribStdDumpModel : public QAbstractItemModel
{

public:
   	MvQGribStdDumpModel();
 	
   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	void dataIsAboutToChange();
	void setDumpData(GribStdDump*);
	GribStdDump* dumpData() {return data_;}

	Qt::ItemFlags flags ( const QModelIndex &) const;
	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

protected:
	QString label(GribItem*,const int) const;
	QString label(string,const int) const;
	int idToLevel(int) const;
	int idToParentRow(int) const;

private:
	GribStdDump* data_;
	
};

class MvQGribValueDumpModel : public QAbstractItemModel
{

public:
   	MvQGribValueDumpModel();
 	
   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	void dataIsAboutToChange();
	void setDumpData(GribValueDump*);
	GribValueDump* dumpData() {return data_;}
	

private:
	GribValueDump* data_;
	double minValAsDecimal_;
	
};

#endif
