/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef RequestPanelLine_H
#include "RequestPanelLine.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif

#include <Xm/ToggleB.h>

#include <mars.h>

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanelItem_H
#include "RequestPanelItem.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef XPixmap_H
#include "XPixmap.h"
#endif


RequestPanelLine::RequestPanelLine(RequestPanel& owner,const Parameter& param): 
	RequestPanelItem(owner,param),
	help_(0),
	gray_(false)
{
}

RequestPanelLine::~RequestPanelLine()
{
}

RequestPanelLine* RequestPanelLine::build(Widget w,RequestPanel& owner,const Parameter& param)
{
	RequestPanelLine* p = LineFactory::create(owner,param);
	p->init(w);
	return p;
}

void RequestPanelLine::create(Widget w, char* name)
{
	UILine_c::create(w,name);
	XMLabel(name_).set(param_.beautifiedName());

	help_ = RequestPanelHelp::build(helper_, owner_, param_);
	XtUnmanageChild(help_arrow_);
	XtUnmanageChild(help_button_);

	if(help_)
	{
		if (help_->dialog())
		{
			XPixmap p(param_.help_icon());
			p.setLabel(help_button_);
			XtManageChild(help_button_);
		}
		else 	 
			XtManageChild(help_arrow_);
	}

	Manage();
}

void RequestPanelLine::comboCB(Widget,XtPointer)
{
	if(XtIsManaged(helper_))
	{
		XtVaSetValues(help_arrow_,XmNarrowDirection, XmARROW_RIGHT,0);
		XtUnmanageChild(helper_);
	}
	else
	{
		XtVaSetValues(help_arrow_,XmNarrowDirection, XmARROW_DOWN,0);
		XtManageChild(helper_);
	}
}

void RequestPanelLine::setCB(Widget,XtPointer)
{
	owner_.clear(param_.name());
	XmToggleButtonSetState(name_,False,False);
}

void RequestPanelLine::helpCB(Widget,XtPointer)
{
	if(help_) help_->start();
}

void RequestPanelLine::gray(bool g)
{
	// g = g && param_.hasDefaults();
	if(gray_ != g)
	{
		gray_ = g;
		if(gray_)
			UILine_c::xd_disable();
		else
			UILine_c::xd_enable();
	}
}

void RequestPanelLine::mark(bool g)
{
	XmToggleButtonSetState(name_,g,False);
}

void RequestPanelLine::getSizes(Dimension& a,Dimension& b)
{
	XtVaGetValues(name_,XmNwidth,&a,0);
	XtVaGetValues(form_,XmNwidth,&b,0);
}

void RequestPanelLine::setSizes(Dimension a,Dimension b)
{
	XtVaSetValues(name_,XmNwidth,a,0);
	XtVaSetValues(form_,XmNwidth,b,0);
}

Widget RequestPanelLine::where()
{
	return where_;
}


