
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file Proj4ProjectionAttributes.h
    \\brief Definition of Proj4Projection Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "Proj4ProjectionWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



Proj4ProjectionWrapper::Proj4ProjectionWrapper(): proj4projection_(new Proj4Projection())


{


	
	TransformationWrapper::object(proj4projection_);
	

}
Proj4ProjectionWrapper::Proj4ProjectionWrapper(Proj4Projection* proj4projection): proj4projection_(proj4projection)
{

	
	TransformationWrapper::object(proj4projection_);
	
}

Proj4ProjectionWrapper::~Proj4ProjectionWrapper()
{

}

void Proj4ProjectionWrapper::set(const MagRequest& request)
{

	

	TransformationWrapper::set(request);
	

	if  (request.countValues("SUBPAGE_MAP_AREA_DEFINITION") ) {
		string setting_value = request("SUBPAGE_MAP_AREA_DEFINITION");
		proj4projection_->setting_ = setting_value;
		}
	if  (request.countValues("SUBPAGE_LOWER_LEFT_LATITUDE") ) {
		double min_latitude_value = request("SUBPAGE_LOWER_LEFT_LATITUDE");
		proj4projection_->min_latitude_ = min_latitude_value;
		}
	if  (request.countValues("SUBPAGE_LOWER_LEFT_LONGITUDE") ) {
		double min_longitude_value = request("SUBPAGE_LOWER_LEFT_LONGITUDE");
		proj4projection_->min_longitude_ = min_longitude_value;
		}
	if  (request.countValues("SUBPAGE_UPPER_RIGHT_LATITUDE") ) {
		double max_latitude_value = request("SUBPAGE_UPPER_RIGHT_LATITUDE");
		proj4projection_->max_latitude_ = max_latitude_value;
		}
	if  (request.countValues("SUBPAGE_UPPER_RIGHT_LONGITUDE") ) {
		double max_longitude_value = request("SUBPAGE_UPPER_RIGHT_LONGITUDE");
		proj4projection_->max_longitude_ = max_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_VERTICAL_LONGITUDE") ) {
		double vertical_longitude_value = request("SUBPAGE_MAP_VERTICAL_LONGITUDE");
		proj4projection_->vertical_longitude_ = vertical_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_TRUE_SCALE_NORTH") ) {
		double true_scale_north_value = request("SUBPAGE_MAP_TRUE_SCALE_NORTH");
		proj4projection_->true_scale_north_ = true_scale_north_value;
		}
	if  (request.countValues("SUBPAGE_MAP_TRUE_SCALE_SOUTH") ) {
		double true_scale_south_value = request("SUBPAGE_MAP_TRUE_SCALE_SOUTH");
		proj4projection_->true_scale_south_ = true_scale_south_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJECTION_HEIGHT") ) {
		double projection_height_value = request("SUBPAGE_MAP_PROJECTION_HEIGHT");
		proj4projection_->projection_height_ = projection_height_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJECTION_TILT") ) {
		double projection_tilt_value = request("SUBPAGE_MAP_PROJECTION_TILT");
		proj4projection_->projection_tilt_ = projection_tilt_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJECTION_AZIMUTH") ) {
		double projection_azimuth_value = request("SUBPAGE_MAP_PROJECTION_AZIMUTH");
		proj4projection_->projection_azimuth_ = projection_azimuth_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJECTION_VIEW_LATITUDE") ) {
		double projection_view_latitude_value = request("SUBPAGE_MAP_PROJECTION_VIEW_LATITUDE");
		proj4projection_->projection_view_latitude_ = projection_view_latitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJECTION_VIEW_LONGITUDE") ) {
		double projection_view_longitude_value = request("SUBPAGE_MAP_PROJECTION_VIEW_LONGITUDE");
		proj4projection_->projection_view_longitude_ = projection_view_longitude_value;
		}
	if  (request.countValues("SUBPAGE_MAP_GEOS_SWEEP") ) {
		double sweep_value = request("SUBPAGE_MAP_GEOS_SWEEP");
		proj4projection_->sweep_ = sweep_value;
		}
	if  (request.countValues("SUBPAGE_MAP_PROJ4_DEFINITION") ) {
		string proj4_definition_value = request("SUBPAGE_MAP_PROJ4_DEFINITION");
		proj4projection_->proj4_definition_ = proj4_definition_value;
		}
	if  (request.countValues("SUBPAGE_COORDINATES_SYSTEM") ) {
		string coordinates_system_value = request("SUBPAGE_COORDINATES_SYSTEM");
		proj4projection_->coordinates_system_ = coordinates_system_value;
		}
	if  (request.countValues("SUBPAGE_GUTTER_PERCENTAGE") ) {
		double gutter_value = request("SUBPAGE_GUTTER_PERCENTAGE");
		proj4projection_->gutter_ = gutter_value;
		}
	
	
}

void Proj4ProjectionWrapper::print(ostream& out)  const
{
	out << "Proj4ProjectionWrapper[]";
}


