# TinierGLTF

A safe, modern, tiny glTF loader for C++ 17.

What this is:

* A tiny glTF deserializer which maps JSON objects to appropriate C++ structures.
* Intended to be safe for loading untrusted input.
* Slightly tailored to the needs of [Minetest](https://github.com/minetest/minetest).

What this doesn't and shouldn't do:

* Serialization
* Loading images
* Resolving resources
* Support glTF extensions

## TODOs

- [ ] Add GLB support.
- [ ] Add further checks according to the specification.
  - Everything in the JSON schema (+ indices and misc. stuff) is already validated.
    Much of the code was generated by a Lua script from the JSON schemata.

## License

`tiniergltf.hpp` was written by Lars Müller and is licensed under the MIT license:

> Copyright 2024 Lars Müller
>
> Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
>
> The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

## Bug Bounty

I offer a reward of one (1) virtual headpat per valid bug report.
