#!/bin/bash

set -eu

if [ ! -d "src" ]; then
	echo "Usage: ./tools/$(basename "$0")"
	exit 1
fi

echo "Reading \"VERSION\" file..."

KS_APP_VERSION=$(sed 1!d VERSION)
KS_RELEASE_DATE=$(sed 2!d VERSION)
KS_QT_INT_VERSION=$(sed 3!d VERSION)
KS_QT_FULL_VERSION=$(sed 4!d VERSION)
KS_QT_WIN32_VERSION=$(sed 5!d VERSION)

echo "Generating \"src/version.h\" file..."

cat > "src/version.h" <<EOF
// Generated by $0, do not modify!
#ifndef KSHUTDOWN_VERSION_H
#define KSHUTDOWN_VERSION_H

#include <QString>

const QString KS_APP_VERSION = "$KS_APP_VERSION";
const QString KS_RELEASE_DATE = "$KS_RELEASE_DATE";

const QString KS_CONTACT = "https://kshutdown.sourceforge.io/contact.html";
const QString KS_COPYRIGHT = "(C) 2003-3000 Konrad Twardowski";
const QString KS_HOME_PAGE = "https://kshutdown.sourceforge.io/";

#if QT_VERSION < $KS_QT_INT_VERSION
	#error "KShutdown $KS_APP_VERSION requires Qt $KS_QT_FULL_VERSION or newer"
#endif // QT_VERSION

#if defined(KS_KF5) && defined(KS_PURE_QT)
	#error "Please use only one -DKS_KF5 or -DKS_PURE_QT compiler option"
#endif

#if !defined(KS_KF5) && !defined(KS_PURE_QT)
	#error "Please use either -DKS_KF5 or -DKS_PURE_QT compiler option (see Setup*.sh)"
#endif

#ifdef KS_NATIVE_KDE
	#error "Please use KS_KF5 instead of KS_NATIVE_KDE"
#endif // KS_NATIVE_KDE

#endif // KSHUTDOWN_VERSION_H
EOF

echo
echo "Application version (used in file names and UI): \"$KS_APP_VERSION\""
echo "Release date (updated manually)                : \"$KS_RELEASE_DATE\""
echo "Minimal required Qt version                    : $KS_QT_FULL_VERSION ($KS_QT_INT_VERSION)"
echo "Qt version used to build win32 version         : $KS_QT_WIN32_VERSION"
