// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1/finding.proto

package securitycenter

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The state of the finding.
type Finding_State int32

const (
	// Unspecified state.
	Finding_STATE_UNSPECIFIED Finding_State = 0
	// The finding requires attention and has not been addressed yet.
	Finding_ACTIVE Finding_State = 1
	// The finding has been fixed, triaged as a non-issue or otherwise addressed
	// and is no longer active.
	Finding_INACTIVE Finding_State = 2
)

var Finding_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "INACTIVE",
}

var Finding_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"INACTIVE":          2,
}

func (x Finding_State) String() string {
	return proto.EnumName(Finding_State_name, int32(x))
}

func (Finding_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b75f23af5a63668d, []int{0, 0}
}

// Cloud Security Command Center (Cloud SCC) finding.
//
// A finding is a record of assessment data like security, risk, health, or
// privacy, that is ingested into Cloud SCC for presentation, notification,
// analysis, policy testing, and enforcement. For example, a
// cross-site scripting (XSS) vulnerability in an App Engine application is a
// finding.
type Finding struct {
	// The relative resource name of this finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The relative resource name of the source the finding belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time.
	// For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// For findings on Google Cloud Platform (GCP) resources, the full resource
	// name of the GCP resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-GCP resource, the resourceName can be a
	// customer or partner defined string.
	// This field is immutable after creation time.
	ResourceName string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The state of the finding.
	State Finding_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.securitycenter.v1.Finding_State" json:"state,omitempty"`
	// The additional taxonomy group within findings from a given source.
	// This field is immutable after creation time.
	// Example: "XSS_FLASH_INJECTION"
	Category string `protobuf:"bytes,5,opt,name=category,proto3" json:"category,omitempty"`
	// The URI that, if available, points to a web page outside of Cloud SCC
	// where additional information about the finding can be found. This field is
	// guaranteed to be either empty or a well formed URL.
	ExternalUri string `protobuf:"bytes,6,opt,name=external_uri,json=externalUri,proto3" json:"external_uri,omitempty"`
	// Source specific properties. These properties are managed by the source
	// that writes the finding. The key names in the source_properties map must be
	// between 1 and 255 characters, and must start with a letter and contain
	// alphanumeric characters or underscores only.
	SourceProperties map[string]*_struct.Value `protobuf:"bytes,7,rep,name=source_properties,json=sourceProperties,proto3" json:"source_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. User specified security marks. These marks are entirely
	// managed by the user and come from the SecurityMarks resource that belongs
	// to the finding.
	SecurityMarks *SecurityMarks `protobuf:"bytes,8,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The time at which the event took place. For example, if the finding
	// represents an open firewall it would capture the time the detector believes
	// the firewall became open. The accuracy is determined by the detector.
	EventTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// The time at which the finding was created in Cloud SCC.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Finding) Reset()         { *m = Finding{} }
func (m *Finding) String() string { return proto.CompactTextString(m) }
func (*Finding) ProtoMessage()    {}
func (*Finding) Descriptor() ([]byte, []int) {
	return fileDescriptor_b75f23af5a63668d, []int{0}
}

func (m *Finding) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Finding.Unmarshal(m, b)
}
func (m *Finding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Finding.Marshal(b, m, deterministic)
}
func (m *Finding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Finding.Merge(m, src)
}
func (m *Finding) XXX_Size() int {
	return xxx_messageInfo_Finding.Size(m)
}
func (m *Finding) XXX_DiscardUnknown() {
	xxx_messageInfo_Finding.DiscardUnknown(m)
}

var xxx_messageInfo_Finding proto.InternalMessageInfo

func (m *Finding) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Finding) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Finding) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Finding) GetState() Finding_State {
	if m != nil {
		return m.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (m *Finding) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *Finding) GetExternalUri() string {
	if m != nil {
		return m.ExternalUri
	}
	return ""
}

func (m *Finding) GetSourceProperties() map[string]*_struct.Value {
	if m != nil {
		return m.SourceProperties
	}
	return nil
}

func (m *Finding) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *Finding) GetEventTime() *timestamp.Timestamp {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *Finding) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.securitycenter.v1.Finding_State", Finding_State_name, Finding_State_value)
	proto.RegisterType((*Finding)(nil), "google.cloud.securitycenter.v1.Finding")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1.Finding.SourcePropertiesEntry")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1/finding.proto", fileDescriptor_b75f23af5a63668d)
}

var fileDescriptor_b75f23af5a63668d = []byte{
	// 633 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xdd, 0x4e, 0x13, 0x41,
	0x14, 0x76, 0x5b, 0x5a, 0xe0, 0x14, 0x48, 0x99, 0x04, 0xb2, 0x36, 0x06, 0x0a, 0xc6, 0xa4, 0x17,
	0xb8, 0x9b, 0xc2, 0x0d, 0x2e, 0x31, 0xb1, 0xd4, 0x62, 0x9a, 0x28, 0x21, 0x6d, 0x69, 0xa2, 0x92,
	0x34, 0xc3, 0x32, 0xac, 0x23, 0xdb, 0x99, 0xcd, 0xec, 0x6c, 0x63, 0x25, 0xbc, 0x8c, 0x97, 0x3e,
	0x8a, 0x8f, 0xe0, 0x95, 0xd7, 0x3c, 0x85, 0xd9, 0x99, 0x59, 0xa4, 0xf5, 0xa7, 0xde, 0x9d, 0xf3,
	0x9d, 0xef, 0x3b, 0x3f, 0x73, 0xce, 0x2e, 0xec, 0x04, 0x9c, 0x07, 0x21, 0x71, 0xfd, 0x90, 0x27,
	0x17, 0x6e, 0x4c, 0xfc, 0x44, 0x50, 0x39, 0xf6, 0x09, 0x93, 0x44, 0xb8, 0xa3, 0xba, 0x7b, 0x49,
	0xd9, 0x05, 0x65, 0x81, 0x13, 0x09, 0x2e, 0x39, 0xda, 0xd0, 0x6c, 0x47, 0xb1, 0x9d, 0x49, 0xb6,
	0x33, 0xaa, 0x57, 0x36, 0x4d, 0x36, 0x1c, 0x51, 0xf7, 0x92, 0x92, 0xf0, 0x62, 0x70, 0x4e, 0x3e,
	0xe0, 0x11, 0xe5, 0x42, 0x27, 0xa8, 0x3c, 0xbc, 0x47, 0x10, 0x24, 0xe6, 0x89, 0xf0, 0x89, 0x09,
	0xed, 0xcd, 0xe8, 0x24, 0x43, 0x06, 0x43, 0x2c, 0xae, 0x62, 0x23, 0x7a, 0x64, 0x44, 0xca, 0x3b,
	0x4f, 0x2e, 0xdd, 0x58, 0x8a, 0xc4, 0x97, 0x26, 0xba, 0x39, 0x1d, 0x95, 0x74, 0x48, 0x62, 0x89,
	0x87, 0xd1, 0x94, 0x3c, 0x6d, 0x07, 0x33, 0xc6, 0x25, 0x96, 0x94, 0x33, 0x93, 0x7c, 0xfb, 0x4b,
	0x11, 0xe6, 0x8f, 0xf4, 0xfc, 0x08, 0xc1, 0x1c, 0xc3, 0x43, 0x62, 0x5b, 0x55, 0xab, 0xb6, 0xd8,
	0x51, 0x36, 0x5a, 0x87, 0x62, 0x84, 0x05, 0x61, 0xd2, 0xce, 0x29, 0xd4, 0x78, 0xe8, 0x31, 0x2c,
	0x67, 0xb3, 0x0d, 0x94, 0x28, 0xaf, 0xc2, 0x4b, 0x19, 0x78, 0x9c, 0x8a, 0x9b, 0x50, 0x88, 0x25,
	0x96, 0xc4, 0x9e, 0xab, 0x5a, 0xb5, 0x95, 0xdd, 0xa7, 0xce, 0xbf, 0x9f, 0xd6, 0x31, 0x8d, 0x38,
	0xdd, 0x54, 0xd4, 0xd1, 0x5a, 0x54, 0x81, 0x05, 0x1f, 0x4b, 0x12, 0x70, 0x31, 0xb6, 0x0b, 0xaa,
	0xc8, 0x9d, 0x8f, 0xb6, 0x60, 0x89, 0x7c, 0x92, 0x44, 0x30, 0x1c, 0x0e, 0x12, 0x41, 0xed, 0xa2,
	0x8a, 0x97, 0x32, 0xec, 0x54, 0x50, 0xf4, 0x11, 0x56, 0x4d, 0x9b, 0x91, 0xe0, 0x11, 0x11, 0x92,
	0x92, 0xd8, 0x9e, 0xaf, 0xe6, 0x6b, 0xa5, 0xdd, 0xe7, 0xff, 0xdd, 0x8f, 0x4a, 0x70, 0x72, 0xa7,
	0x6f, 0x31, 0x29, 0xc6, 0x9d, 0x72, 0x3c, 0x05, 0xa3, 0xb7, 0xb0, 0x32, 0xb9, 0x41, 0x7b, 0xa1,
	0x6a, 0xd5, 0x4a, 0xb3, 0x07, 0xef, 0x1a, 0xe4, 0x4d, 0x2a, 0x3a, 0xcc, 0xff, 0x68, 0xe4, 0x3b,
	0xcb, 0xf1, 0x7d, 0x0c, 0x3d, 0x03, 0x20, 0x23, 0xc2, 0xe4, 0x20, 0x5d, 0xaf, 0xbd, 0xa8, 0xd2,
	0x56, 0xb2, 0xb4, 0xd9, 0xee, 0x9d, 0x5e, 0xb6, 0xfb, 0xce, 0xa2, 0x62, 0xa7, 0x3e, 0x3a, 0x80,
	0x92, 0x2f, 0x08, 0x96, 0x44, 0x6b, 0x61, 0xa6, 0x16, 0x34, 0x3d, 0x05, 0x2a, 0xef, 0x61, 0xed,
	0x8f, 0xd3, 0xa3, 0x32, 0xe4, 0xaf, 0xc8, 0xd8, 0xdc, 0x4a, 0x6a, 0xa2, 0x1d, 0x28, 0x8c, 0x70,
	0x98, 0x10, 0x75, 0x29, 0xa5, 0xdd, 0xf5, 0xdf, 0x2a, 0xf4, 0xd3, 0x68, 0x47, 0x93, 0xbc, 0xdc,
	0xbe, 0xb5, 0xbd, 0x0f, 0x05, 0xb5, 0x6a, 0xb4, 0x06, 0xab, 0xdd, 0x5e, 0xa3, 0xd7, 0x1a, 0x9c,
	0x1e, 0x77, 0x4f, 0x5a, 0xcd, 0xf6, 0x51, 0xbb, 0xf5, 0xb2, 0xfc, 0x00, 0x01, 0x14, 0x1b, 0xcd,
	0x5e, 0xbb, 0xdf, 0x2a, 0x5b, 0x68, 0x09, 0x16, 0xda, 0xc7, 0xc6, 0xcb, 0x79, 0xe1, 0x6d, 0x83,
	0xc2, 0x93, 0xa9, 0x87, 0xd4, 0xf5, 0x70, 0x44, 0x63, 0xc7, 0xe7, 0x43, 0x37, 0x3b, 0xeb, 0x17,
	0x5c, 0x04, 0x98, 0xd1, 0xcf, 0xfa, 0xee, 0xdd, 0xeb, 0xfb, 0xee, 0x8d, 0xab, 0x97, 0x18, 0xbb,
	0xd7, 0xda, 0xb8, 0xc9, 0xfe, 0x06, 0xb1, 0x7b, 0x6d, 0xac, 0x9b, 0xc3, 0xef, 0x16, 0x6c, 0xfb,
	0x7c, 0x38, 0x63, 0x8b, 0x27, 0xd6, 0xbb, 0xd7, 0x86, 0x11, 0xf0, 0x10, 0xb3, 0xc0, 0xe1, 0x22,
	0x70, 0x03, 0xc2, 0xd4, 0x03, 0xb8, 0xbf, 0xba, 0xfb, 0xdb, 0xe7, 0x7f, 0x30, 0x89, 0x7c, 0xcd,
	0x6d, 0xbc, 0xd2, 0xe9, 0x9a, 0xaa, 0x60, 0x76, 0x24, 0x4d, 0x5d, 0xb0, 0x5f, 0xff, 0x96, 0x11,
	0xce, 0x14, 0xe1, 0x6c, 0x92, 0x70, 0xd6, 0xaf, 0xdf, 0xe6, 0xb6, 0x34, 0xc1, 0xf3, 0x14, 0xc3,
	0xf3, 0x26, 0x29, 0x9e, 0xd7, 0xaf, 0x9f, 0x17, 0x55, 0x7b, 0x7b, 0x3f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x68, 0xec, 0xf4, 0xff, 0x26, 0x05, 0x00, 0x00,
}
