/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "config.h"
#include "geoclue-stumbler-accuracy-circle.h"

#define _GNU_SOURCE
#include <glib.h>
#include <glib/gi18n.h>
#include <glib-object.h>
#include <math.h>
#include <graphene.h>
#include <math.h>
#include <graphene.h>

struct _GeoclueStumblerAcccuracyCircle
{
  GtkWidget       parent_instance;

  double circle_diameter;
};

G_DEFINE_TYPE (GeoclueStumblerAcccuracyCircle, geoclue_stumbler_accuracy_circle, GTK_TYPE_WIDGET)

void geoclue_stumbler_accuracy_circle_refresh (GeoclueStumblerAcccuracyCircle *self,
                                               double circle_diameter)
{
  if (circle_diameter == self->circle_diameter) {
    g_debug ("same size, not changing");
    return;
  }

  self->circle_diameter = circle_diameter;
  g_debug ("Circle Diameter set: %f", self->circle_diameter);
  gtk_widget_queue_draw (GTK_WIDGET (self));
}

static void
geoclue_stumbler_accuracy_circle_refresh_snapshot (GtkWidget *widget, GtkSnapshot *snapshot)
{
  GeoclueStumblerAcccuracyCircle *self = GEOCLUE_STUMBLER_ACCURACY_CIRCLE (widget);
  graphene_rect_t *new_circle;
  cairo_t *cr;

  if (self->circle_diameter == 0) {
    g_debug("no circle");
    return;
  }

  new_circle = graphene_rect_alloc ();
  new_circle = graphene_rect_init (new_circle,
                                  -self->circle_diameter/2,
                                  -self->circle_diameter/2,
                                  self->circle_diameter,
                                  self->circle_diameter);

  cr = gtk_snapshot_append_cairo (snapshot, new_circle);

  cairo_set_operator(cr, CAIRO_OPERATOR_OVER);
  cairo_set_source_rgba (cr, 0, 0, 255, 0.1);
  cairo_arc (cr, 0, 0, self->circle_diameter / 2, 0, M_PI * 2);
  cairo_fill_preserve (cr);

  cairo_destroy (cr);
  graphene_rect_free (new_circle);
}

static void
geoclue_stumbler_accuracy_circle_class_init (GeoclueStumblerAcccuracyCircleClass *klass)
{
  GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);
  widget_class->snapshot = geoclue_stumbler_accuracy_circle_refresh_snapshot;
}

static void
geoclue_stumbler_accuracy_circle_init (GeoclueStumblerAcccuracyCircle *self)
{
}
