#A  BOUNDS FOR q = 2
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the
##  second upperbounds) for a code with wordlength n and
##  dimension k. Each entry contains one of the following
##  items:
##
##  FOR LOWER- AND UPPERBOUNDSTABLE
##  [ 0, <d>, <ref> ]  from Brouwers table
##
##  FOR LOWERBOUNDSTABLE
##  empty           k= 0, 1, n or d= 2 or (k= 2 and q= 2)
##  1               shortening a [ n + 1, k + 1 ] code
##  2               puncturing a [ n + 1, k ] code
##  3               extending a [ n - 1, k ] code
##  [ 4, <dd> ]     constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]     an UUV-construction with a [ n / 2, k1 ]
##                  and a [ n / 2, k - k1 ] code
##  [ 6, <n1> ]     concatenation of a [ n1, k ] and a
##                  [ n - n1, k ] code
##  [ 7, <n1> ]     taking the residue of a [ n1, k + 1 ] code
##  20              taking the subcode of a [ n, k + 1 ] code
##  [21,<s>,<j>]    constr. B2 of a [ n+s, k+s-2j-1, d+2j] code
##  [22,<k1>,<k2>]  an UUAVUVW-construction with a [ n/3, k1 ],
##                  a [ n/3, k2 ] and a [ n/3, k-(k1+k2) ] code
##
##  FOR UPPERBOUNDSTABLE
##  empty        trivial and Singleton bound
##  11           shortening a [ n + 1, k + 1 ] code
##  12           puncturing a [ n + 1, k ] code
##  13           extending a [ n - 1, k ] code
##  [ 14, <dd> ] constr. B, with dd = dual distance
##  [ 15, <d> ]  Griesmer bound
##  [ 16, <d> ]  One-step Griesmer bound


GUAVA_BOUNDS_TABLE[1][2] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ ,],
#V   n = 5
[ ,, 20],
#V   n = 6
[ ,, 1, 20],
#V   n = 7
[ ,, 1, 2, 20],
#V   n = 8
[ ,, 20, [5, 3], 20, 20],
#V   n = 9
[ ,, 20, 1, 1, 20, 20],
#V   n = 10
[ ,, 1, 20, 1, 1, 20, 20],
#V   n = 11
[ ,, 1, 2, 20, 1, 1, 20, 20],
#V   n = 12
[ ,, 20, [5, 3], 20, 20, 1, 1, 20, 20],
#V   n = 13
[ ,, 1, 1, 1, 20, 20, 1, 1, 20, 20],
#V   n = 14
[ ,, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20],
#V   n = 15
[ ,, 20, 1, 2, 1, 1, 20, 20, 1, 2, 20, 20],
#V   n = 16
[ ,, 20, 20, [5, 4], 20, 1, 1, 20, 20, [5, 7], 20, 20, 20],
#V   n = 17
[ ,, [6, 3], 20, 1, 1, 20, 1, 2, 20, 1, 1, 20, 20, 20],
#V   n = 18
[ ,, 3, 20, 20, 1, 1, 20, [0, 6, "QR"], 20, 20, 1, 1, 20, 20, 20],
#V   n = 19
[ ,, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 20
[ ,, [6, 6], 1, [7, 37], 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 21
[ ,, 3, 20, 3, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 22
[ ,, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 23
[ ,, 20, 1, 2, 1, [0, 9, "HP"], 20, 20, 20, 1, 2, 1, [0, 5, "Wa"], 20, 20, 1, 1, 20, 20, 20],
#V   n = 24
[ ,, [6, 3], 20, [5, 4], 20, 3, 20, 20, 20, 20, [0, 8, "QR"], 20, 3, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 25
[ ,, 3, 20, 1, 1, 1, 1, 20, 20, 20, 3, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 26
[ ,, 1, 1, 20, 1, 2, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 27
[ ,, [6, 6], 1, 2, 20, [7, 50], 20, 1, [0, 9, "Pi2"], 20, 20, 1, [0, 7, "Ka"], 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 28
[ ,, 3, 20, [5, 4], 20, 1, 1, 20, 3, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 29
[ ,, 1, 1, 1, 2, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 30
[ ,, 20, 1, 1, 2, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 31
[ ,, [6, 3], 20, 1, 2, 1, 20, 20, 1, 2, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 20],
#V   n = 32
[ ,, 3, 20, 20, [5, 5], 1, 2, 20, 20, [0, 12, "XBC"], 20, [0, 10, "Sh1"], 20, 20, 20, [0, 8, "CS"], 20, 20, 20, 1, 1, 20, 20, 20, [5, 15], 20, 20, 20, 20],
#V   n = 33
[ ,, 2, 20, 20, 3, 20, [0, 14, "HY2"], 20, 20, 1, 2, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, [0, 5, "Ch0"], 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 34
[ ,, [6, 6], [6, 4], 20, 1, 1, 1, 2, 20, 20, [0, 12, "Sh1"], 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 35
[ ,, 3, 3, 20, 20, 1, 2, [0, 14, "Pi"], 20, 20, 1, 1, 20, 1, 2, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 36
[ ,, 3, 1, 1, 20, 20, [0, 16, "DHM"], 1, 1, 20, 20, 1, [0, 11, "Mo"], 20, [0, 10, "Sh1"], 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 37
[ ,, 1, [6, 7], 1, [7, 70], 20, 1, [0, 15, "FB"], 1, 1, 20, 20, 3, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 38
[ ,, [6, 3], 3, 20, 3, 20, 20, 3, 20, 1, 2, 20, 1, 1, 20, 1, 1, 20, 20, 20, [0, 8, "Sh1"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 39
[ ,, 3, 1, [6, 15], 1, [0, 17, "vT3"], 20, 1, [0, 15, "X"], 20, [0, 14, "BE"], 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 40
[ ,, 2, 20, 3, 20, 3, 20, 20, 3, 20, 3, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 41
[ ,, [6, 6], [6, 11], 1, 1, 1, 2, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 42
[ ,, 3, 3, 20, 1, [0, 19, "vT1"], [0, 18, "BZ"], 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, [0, 10, "QR"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 43
[ ,, 3, 1, 1, 20, 3, 1, 1, 20, 20, 1, 1, 1, [0, 13, "cy"], 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 44
[ ,, 1, [6, 14], 1, [0, 21, "Bel"], 1, 2, 1, 2, 20, 20, 1, 2, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 45
[ ,, [6, 3], 3, 20, 3, 20, [0, 20, "BZ"], 20, [0, 18, "Gu9"], 20, 20, 20, [0, 16, "Bo0"], 1, [0, 13, "DJ"], 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 46
[ ,, 3, 1, 1, 1, 1, 1, 1, 1, [0, 17, "GG"], 20, 20, 3, 20, 3, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 47
[ ,, 2, 20, 1, 2, 1, 2, 1, 2, 3, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 20, 1, 2, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, [0, 5, "Ch0"], 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 48
[ ,, [6, 6], 20, 20, [5, 5], 20, [0, 22, "BZ"], 20, [0, 20, "GB5"], 1, 1, 20, 20, 1, [0, 15, "FB"], [0, 14, "BZ"], 20, 20, 20, 20, 20, 20, [0, 12, "QR"], 1, 1, 20, 20, 20, 20, [0, 8, "RR"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 49
[ ,, 3, [6, 4], 20, 1, 1, 2, 20, 1, [0, 19, "B2x"], 1, [0, 17, "B2x"], 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 3, 20, 1, [0, 9, "EB3"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 50
[ ,, 3, 3, 20, 20, 1, 2, 20, 20, 3, 20, 3, 20, 20, 1, 2, 1, 2, 20, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 51
[ ,, 2, 1, 1, 20, 20, [0, 24, "cy"], 1, 20, 1, 1, 1, 1, 20, 20, [0, 16, "cy"], 20, [0, 14, "cy"], 20, 20, 20, 20, 1, [0, 11, "DJ"], 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 52
[ ,, [6, 3], [6, 7], 1, [7, 101], 20, 3, 1, [0, 21, "Pu"], 20, 1, 1, 1, 1, 20, 1, 1, 1, 1, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 53
[ ,, 3, 3, 20, 3, 20, 3, 20, 3, 20, 20, 1, 1, 1, 2, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 54
[ ,, 2, 1, 1, 2, 20, 1, 1, 1, [0, 21, "GG"], 20, 20, 1, 1, 2, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 55
[ ,, [6, 6], 20, 1, 2, 2, 20, 1, 2, 3, 20, 20, 20, 1, [0, 19, "LC"], 20, 20, 20, 1, [0, 15, "cy"], 1, [0, 13, "GG"], 20, 20, 20, 1, 1, 20, 20, [0, 10, "Sh1"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 56
[ ,, 3, [6, 11], 20, [5, 5], [7, 107], 20, 20, [0, 24, "BZ"], 1, 1, 20, 20, 20, 3, [0, 17, "MoY"], 20, 20, 20, 3, 20, 3, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 57
[ ,, 3, 3, 20, 3, 1, 2, 20, 1, [0, 23, "SRC"], 1, 2, 20, 20, 3, 3, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 58
[ ,, 2, 1, 1, 1, 2, [0, 26, "?"], 20, 20, 3, 20, [0, 22, "GG"], 20, 20, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 59
[ ,, [6, 3], [6, 14], 1, 2, [0, 28, "?"], 1, 1, 20, 1, 1, 1, 1, 20, 1, 2, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 60
[ ,, 3, 3, 20, [5, 5], 1, [0, 27, "Sa"], 1, [0, 25, "Ch"], 20, 1, 1, 1, 1, 20, [0, 20, "CDJ"], 20, 1, [0, 17, "We"], 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 61
[ ,, 2, 1, 1, 1, 2, 3, 20, 3, 20, 20, 1, 1, 1, 1, 1, 1, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 62
[ ,, [6, 6], 20, 1, 1, 2, 1, 1, 1, 2, 20, 20, 1, 1, 1, 1, 1, 2, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20],
#V   n = 63
[ ,, 3, 20, 20, 1, 2, 20, 1, 2, [0, 26, "BCH"], 20, 20, 20, 1, 2, 1, 2, [0, 20, "GW2"], 20, 1, 1, 20, 20, 20, 20, 1, [0, 15, "B2x"], 1, 2, 20, 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 7, "cy"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20],
#V   n = 64
[ ,, 3, [6, 4], 20, 20, [5, 6], 2, 20, [0, 28, "XBC"], 1, 1, 20, 20, 20, [0, 24, "XBC"], 20, [0, 22, "XBC"], 1, 1, 20, 1, 1, 20, 20, 20, 20, 3, 20, [0, 14, "B2x"], 20, 20, 20, 20, 20, [0, 12, "XBC"], 20, 20, 1, 2, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, [5, 31], 20, 20, 20, 20, 20],
#V   n = 65
[ ,, 2, 3, 20, 20, 3, [0, 30, "DHM"], 20, 1, [0, 27, "X"], 1, [0, 25, "cy"], 20, 20, 1, 1, 2, 20, 1, 2, 20, 1, [0, 17, "GG1"], 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, [0, 10, "BCH"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 5, "cy"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 66
[ ,, [6, 3], 2, 20, 20, 3, 1, 1, 20, 3, 20, 3, 20, 20, 20, 1, [0, 23, "X"], 20, 20, [0, 20, "CZ"], 20, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 67
[ ,, 3, [6, 7], [6, 5], 20, 1, [0, 31, "X"], 1, [0, 29, "X"], 3, 20, 3, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 3, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, [0, 11, "X"], 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 68
[ ,, 2, 3, 3, 20, 20, 3, 20, 3, 1, 1, 1, 1, 20, 20, 20, 3, 2, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 69
[ ,, [6, 6], 3, 1, 1, 20, 1, 1, 2, 20, 1, 2, 1, 1, 20, 20, 3, [0, 22, "BZ"], 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, [0, 8, "Sh1"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 70
[ ,, 3, 1, [6, 15], 1, [7, 135], 20, 1, [0, 31, "X"], [0, 29, "GG1"], 20, [0, 28, "GB0"], 20, 1, [0, 25, "X"], 20, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 71
[ ,, 3, [6, 11], 3, 20, 3, 20, 20, 3, 3, 20, 1, 2, 20, 3, 20, 1, 2, 1, 2, 20, 20, 20, 1, 1, 1, [0, 17, "SRC"], 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 72
[ ,, 2, 3, 1, [7, 141], 3, 20, 20, 3, 1, [0, 29, "GG1"], 20, [7, 127], 20, 1, [0, 25, "XX"], 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 20, 20, 20, 20, 1, 2, 3, 20, 20, 20, 20, 20, 20, 1, 2, 1, 20, 20, 20, [0, 12, "To"], 20, 20, 20, 20, 1, [0, 9, "EB3"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 73
[ ,, [6, 3], 2, 20, 3, 1, 2, 20, 1, [0, 31, "GG1"], 3, 20, 1, 1, 20, 3, 20, 1, 1, 1, 1, 20, 20, 20, 20, [0, 20, "cy"], 1, 1, 20, 20, 20, 20, 20, 20, [0, 16, "cy"], 1, [0, 13, "XX"], 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 74
[ ,, 3, [6, 14], [6, 15], 1, 2, [0, 34, "?"], 20, 20, 3, 1, 2, 20, 1, [0, 27, "X"], 1, [0, 25, "XX"], 20, 1, 2, 1, 2, 20, 20, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 3, 20, 20, 20, 1, [0, 11, "To"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 75
[ ,, 2, 3, 3, 20, [0, 36, "?"], 1, 2, 20, 1, [0, 31, "GG1"], [0, 30, "To2"], 20, 20, 3, 20, 3, 20, 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 3, 20, 1, [0, 13, "XX"], 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 76
[ ,, [6, 6], 3, 1, [6, 31], 1, [0, 35, "Sa"], [0, 34, "Bo0"], 20, 20, 3, 1, 1, 20, 1, [0, 27, "XX"], 3, 20, 20, 1, 1, 1, 1, 20, 20, 20, [0, 20, "cyx"], 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 77
[ ,, 3, 1, [6, 15], 3, 20, 3, 1, 2, 20, 1, 2, 1, 1, 20, 3, 2, 20, 20, 20, 1, 2, 1, 2, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 9, "EB3"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 78
[ ,, 3, 20, 3, 1, [7, 151], 1, 2, [0, 34, "EB2"], 20, 20, [0, 32, "To"], 20, 1, [0, 29, "GG1"], 1, [0, 27, "XX"], 20, 20, 20, 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, [0, 11, "ZL"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 79
[ ,, 2, [6, 4], 1, [6, 31], 3, 20, [0, 36, "JS"], 2, 20, 20, 1, 2, 20, 3, 20, 3, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 2, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 80
[ ,, [6, 3], 3, 20, 3, 1, 2, 1, [0, 35, "GB1"], 20, 20, 20, [0, 32, "Pi"], 20, 3, 20, 3, 1, 2, 20, 20, 20, 1, 2, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, [0, 16, "QR"], 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 81
[ ,, 3, 2, 20, 1, [7, 158], [0, 38, "BZ"], 20, 3, 2, 20, 20, 3, 20, 3, 20, 3, 20, [0, 26, "CZ"], 20, 20, 20, 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 20, 20, 20, [0, 20, "GG"], 20, 20, 20, 20, 1, 1, 20, 20, 3, 20, [0, 14, "BET"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 82
[ ,, 2, [6, 7], [6, 20], 20, 3, 1, 1, 2, 2, 20, 20, 1, 1, 2, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 3, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, [0, 6, "Sh1"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 83
[ ,, [6, 6], 3, 3, 20, 1, 2, 1, 2, 2, 1, 20, 20, 1, [0, 31, "GG1"], [0, 29, "GG1"], 20, 1, 1, 2, 20, 20, 20, 20, 1, 2, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 84
[ ,, 3, 3, 1, [6, 31], 20, [0, 40, "BZ"], 20, [0, 38, "EB2"], [0, 36, "GB0"], 1, 2, 20, 20, 3, 3, 20, 20, 1, [0, 27, "We"], 2, 20, 20, 20, 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 85
[ ,, 3, 1, [6, 23], 3, 20, 1, 1, 2, 1, 2, [0, 34, "GG"], 20, 20, 3, 3, 20, 20, 20, 3, [0, 26, "GG1"], 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 86
[ ,, 2, [6, 11], 3, 1, [7, 167], 20, 1, 2, 2, [0, 36, "GW2"], 1, 1, 20, 3, 1, [0, 29, "X"], 20, 20, 3, 1, 2, 20, 20, 20, 20, 1, 2, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 87
[ ,, [6, 3], 3, 1, [6, 31], 3, 20, 20, [0, 40, "EB2"], 2, 1, [0, 35, "GG"], 1, 2, 1, 2, 3, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, [0, 24, "BZ"], 20, [0, 22, "cy"], 20, 20, 20, 20, [0, 20, "GG1"], 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 88
[ ,, 3, 2, 20, 3, 1, [0, 41, "GG1"], 20, 1, 2, 2, 3, 20, [0, 34, "GG"], 20, [0, 32, "cyx"], 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 89
[ ,, 2, [6, 14], [6, 27], 1, 2, 3, 20, 20, [0, 40, "cy"], 2, 1, 1, 2, 20, 1, [0, 31, "BEx"], 1, 20, 20, 20, [0, 28, "HS"], [0, 25, "MoY"], 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 11, "cy"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, [0, 8, "Sh1"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 90
[ ,, [6, 6], 3, 3, 20, [5, 6], 2, 20, 20, 1, 2, 20, 1, [0, 35, "GG"], 20, 20, 3, 1, 1, 20, 20, 3, 3, 20, 20, 20, 20, 20, 20, [0, 24, "BZ"], [0, 21, "XBZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, [0, 18, "QR"], 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 91
[ ,, 3, 3, 1, 1, 1, 2, 1, 20, 20, [0, 40, "Gu9"], 20, 20, 3, [0, 33, "GG1"], 20, 1, 1, 1, 1, 20, 3, 1, 1, 20, 20, 20, 20, 20, 3, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 2, 20, 20, 20, 20, [0, 14, "cy"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 9, "Hg"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 92
[ ,, 3, 1, [6, 30], 1, [0, 45, "Bel"], [0, 44, "Ja2"], 1, 2, 20, 3, 2, 20, 3, 3, 20, 20, 1, 1, 1, 1, 2, 20, 1, 2, 20, 20, 20, 20, 3, 1, 2, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 3, [0, 16, "AGP"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 93
[ ,, 2, 20, 3, 20, 3, 3, 20, [0, 42, "EB2"], 20, 3, 2, 20, 3, 3, 20, 20, 20, 1, 1, 1, 2, 2, 20, [0, 26, "DaH"], 20, 20, 20, 20, 3, 20, [0, 22, "cy"], 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 3, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 94
[ ,, [6, 3], [6, 4], 1, 1, 2, 1, 1, 2, 20, 1, 2, 1, 2, 2, 20, 20, 20, 20, 1, 1, 2, [0, 28, "GG1"], 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 3, 20, 1, [0, 15, "Ch"], 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 95
[ ,, 3, 3, 20, 1, 2, 2, 1, 2, 20, 20, [0, 40, "CZ"], 1, 2, 2, 1, 20, 20, 20, 20, 1, [0, 31, "GG1"], 1, [0, 27, "GG1"], 1, 1, 20, 20, 20, 20, 1, [0, 23, "Ch"], 1, 2, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 3, 20, 20, 20, 20, 20, [0, 14, "cyx"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 96
[ ,, 2, 2, 20, 20, [5, 6], [0, 46, "vT1"], 20, [0, 44, "GB5"], 2, 20, 3, 20, [0, 38, "GG"], [0, 36, "BZ"], 1, 1, 20, 20, 20, 20, 3, 20, 3, 20, 1, 1, 20, 20, 20, 20, 3, 20, [0, 22, "BZ"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, [0, 8, "Sh1"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 97
[ ,, [6, 6], [6, 7], 20, 20, 3, 2, 20, 3, [0, 42, "GG1"], 20, 1, 1, 2, 3, 20, 1, 1, 20, 20, 20, 3, 1, 1, 2, 20, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 98
[ ,, 3, 3, [6, 5], 20, 1, 2, 1, 2, 2, 20, 20, 1, [0, 39, "GG"], 1, 1, 20, 1, 2, 20, 20, 3, 1, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 2, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 99
[ ,, 3, 3, 3, 20, 20, [0, 48, "DHM"], 1, 2, [0, 43, "GB"], 1, 20, 20, 3, 1, 1, 2, 20, [0, 34, "CZ"], 20, 20, 1, 1, 1, 2, 2, 20, 20, 1, [0, 25, "DaH"], 20, 20, 20, [0, 24, "To"], 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 11, "Roe"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 100
[ ,, 2, 2, 1, 1, 20, 3, 20, [7, 191], 3, 1, [0, 41, "GG"], 20, 3, 1, 1, 2, 20, 3, 20, 20, 20, 1, 1, 2, 2, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 1, [0, 21, "Ch"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 101
[ ,, [6, 3], [6, 11], [6, 15], 1, [7, 198], 1, 1, 2, 2, 20, 3, 20, 3, 20, 1, [0, 37, "Gra"], 20, 3, 20, 20, 20, 20, 1, 2, 2, 20, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 3, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 1, 20, 20, 20, 20, 20, 1, [0, 13, "Roe"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 102
[ ,, 3, 3, 3, 20, 3, 20, 1, [7, 195], 2, 1, 1, 1, 1, 1, 20, 3, 1, 1, 2, 20, 20, 20, 20, [0, 32, "DaH"], [0, 30, "DaH"], 20, 20, 20, 20, 1, 1, 20, 20, 20, [0, 24, "QC"], 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 103
[ ,, 2, 2, 1, 1, 2, 20, 20, 3, [0, 46, "GG1"], 1, [7, 188], 1, [0, 41, "GG"], 1, 2, 3, 1, 1, 2, 20, 20, 20, 20, 3, 3, 1, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 104
[ ,, [6, 6], [6, 14], 20, 1, [0, 51, "Bel"], 2, 20, 3, 2, 20, 3, 20, 3, 20, [0, 40, "GW2"], 1, 2, 1, 2, 1, 20, 20, 20, 3, 3, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, [0, 20, "QR"], 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 105
[ ,, 3, 3, [6, 15], 20, 3, [0, 50, "JS"], 20, 1, 2, 20, 1, 1, 2, 20, 3, 20, [0, 38, "GW2"], 20, [0, 36, "We"], 1, [0, 33, "GG1"], 20, 20, 3, 1, 1, 1, 1, 20, 20, 20, 20, [0, 26, "GW2"], 20, 20, 20, [0, 24, "QC"], 20, 20, 1, [0, 21, "HS"], 20, 20, 20, 20, 20, 20, 20, 20, 3, 1, 2, 20, 1, [0, 15, "Roe"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 106
[ ,, 3, 3, 3, 20, 3, 2, 20, 20, [0, 48, "GG1"], 20, 20, 1, [7, 191], 20, 3, 20, 3, 20, 3, 20, 3, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 107
[ ,, 2, 3, 1, 1, 1, 2, 1, 20, 3, 2, 20, 20, 3, 20, 1, 1, 1, 2, 3, 20, 1, 2, 20, 20, 1, 2, 1, 2, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, [0, 19, "Ka"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 108
[ ,, [6, 3], 1, [6, 15], 1, [7, 213], [0, 52, "Ja2"], 1, 2, 3, [0, 46, "GB"], 20, 20, 3, [0, 41, "Ch"], 20, 1, 1, 2, 1, 1, 20, [0, 34, "DaH"], 20, 20, 20, [0, 32, "B2x"], 20, [0, 30, "B2x"], 20, [0, 28, "B2x"], 20, 20, 20, [0, 26, "BJK"], 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 109
[ ,, 3, [6, 4], 3, 20, 3, 3, 20, [0, 50, "EB1"], 3, 1, 2, 20, 3, 3, 20, 20, 1, 2, 20, 1, [0, 35, "GG1"], 1, 1, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 3, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 110
[ ,, 2, 3, 1, 1, 2, 1, 1, 2, 1, 1, 2, 20, 3, 2, 20, 20, 20, [0, 40, "Pi"], 20, 20, 3, 20, 1, 2, 20, 20, 1, 1, 1, 1, 1, 1, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 111
[ ,, [6, 6], 2, 20, 1, 2, 2, 1, 2, 20, 1, 2, 20, 1, 2, 1, 20, 20, 3, 1, 20, 1, 2, 20, [0, 34, "GW2"], 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, [0, 26, "BJK"], 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 112
[ ,, 3, [6, 7], 20, 20, [5, 6], [0, 54, "vT1"], 20, [0, 52, "EB1"], 2, 20, [0, 48, "CZ"], [7, 201], 20, [0, 44, "BZ"], 1, 2, 20, 3, 1, 2, 20, [0, 36, "BZ"], 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, [0, 24, "B2x"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 113
[ ,, 3, 3, [6, 20], 20, 3, 2, 20, 3, [0, 50, "GG1"], 20, 3, 3, 20, 3, 20, [0, 42, "GG"], 20, 3, 20, [0, 38, "GG"], 20, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 114
[ ,, 2, 3, 3, 20, 1, 2, 1, 2, 2, 20, 3, 1, [7, 203], 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 2, 1, 20, 20, 20, 20, 20, 1, 1, 1, 2, 1, [0, 27, "BHJ"], 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 115
[ ,, [6, 3], 2, 1, 1, 20, [0, 56, "DHM"], 1, 2, 2, 2, 1, 2, 3, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 36, "GW2"], 1, 2, 20, 20, 20, 20, 20, 1, 1, 2, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 116
[ ,, 3, [6, 11], [6, 23], 1, [7, 229], 3, 20, [7, 223], [0, 52, "GG1"], [0, 50, "GG"], 20, [0, 48, "GW2"], 1, [0, 45, "Ch"], 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, 1, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 117
[ ,, 2, 3, 3, 20, 3, 1, 1, 2, 2, 2, 20, 3, 20, 3, 20, 20, 1, [0, 43, "HS"], 1, 2, 1, 2, 1, 2, 1, 2, 2, 20, 20, 20, 20, 20, 20, [0, 32, "cy"], 2, 20, 1, 1, 20, [0, 26, "cy"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 118
[ ,, [6, 6], 2, 1, 1, 2, 20, 1, [7, 227], 2, 2, 1, 1, 1, 2, 20, 20, 20, 3, 20, [0, 42, "GG"], 20, [0, 40, "GG"], 20, [0, 38, "GG"], 20, [0, 36, "GG"], 2, 20, 20, 20, 20, 20, 20, 3, 2, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 119
[ ,, 3, [6, 14], 20, 1, 2, 2, 20, 3, [0, 54, "GG1"], [0, 52, "GG"], 1, 2, 1, 2, [21, 8, 1], 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 120
[ ,, 3, 3, [6, 27], 20, [5, 6], [0, 58, "Bo0"], 20, 3, 2, 1, 1, 2, 20, [0, 48, "BZ"], 3, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 20, 20, 20, 20, 20, [0, 32, "cyx"], 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 121
[ ,, 2, 3, 3, 20, 3, 3, 20, 1, [7, 230], [21, 4, 1], 1, [21, 5, 2], 2, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 122
[ ,, [6, 3], 3, 1, 1, 2, 1, 2, 20, 3, 3, 20, 3, 2, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 123
[ ,, 3, 1, [6, 30], 1, 2, 2, [0, 58, "JS"], 20, 3, 1, 1, 1, 2, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 124
[ ,, 2, [6, 4], 3, 20, [5, 6], 2, 1, [0, 57, "GG1"], 1, 1, 1, 1, 2, [0, 49, "Ch"], 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 125
[ ,, [6, 6], 3, 1, 1, 1, 2, 2, 3, 20, 1, 1, 1, 2, 3, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 126
[ ,, 3, 2, 20, 1, 1, 2, [0, 60, "Ja2"], 2, 20, 20, 1, 1, 2, 2, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20],
#V   n = 127
[ ,, 3, [6, 7], 20, 20, 1, 2, 1, [0, 59, "GG1"], 20, 20, 20, 1, 2, 2, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 2, [0, 37, "MoY"], 20, 20, 20, 20, 1, [0, 35, "cy"], 20, 20, 20, 20, 20, 1, [0, 31, "BCH"], 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20],
#V   n = 128
[ ,, 2, 3, 20, 20, 20, [5, 7], 20, 3, 2, 20, 20, 20, [0, 56, "XBC"], [0, 52, "BZ"], 20, 20, 20, 20, 20, [0, 48, "XBC"], 20, 20, 20, 20, 20, 20, [0, 44, "XBC"], 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 1, 20, 20, 20, 20, 20, [0, 28, "XBC"], 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, [0, 22, "XBC"], 20, 20, 20, 20, 20, 20, [0, 20, "XBC"], 2, 20, 20, 20, 20, 20, 1, [0, 15, "Gp"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 11, "Gp"], 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, [0, 7, "Gp"], 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, [5, 63], 20, 20, 20, 20, 20, 20],
#V   n = 129
[ ,, [6, 3], 3, [6, 5], 20, 20, 3, 2, 3, [0, 58, "JS"], 20, 20, 20, 3, 3, 1, 20, 20, 20, 20, 3, 1, 20, 20, 20, 20, 20, 3, 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 1, [0, 29, "Dup"], 20, 20, 20, 20, 3, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 3, [0, 18, "BCH"], 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, [0, 13, "MMT"], 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, [0, 10, "BCH"], 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, [0, 6, "BCH"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 130
[ ,, 3, 2, 3, 20, 20, 3, [0, 62, "JS"], 3, 2, 20, 20, 20, 3, 3, 1, 1, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 3, 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 3, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 131
[ ,, 2, [6, 11], 2, 20, 20, 3, 2, 1, 2, 20, 20, 20, 3, 1, 2, 1, 1, 20, 20, 1, [0, 47, "BEx"], 1, 1, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 2, 1, 1, 20, 20, 20, 1, [0, 27, "Su"], 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, [0, 19, "Su"], 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 132
[ ,, [6, 6], 3, [6, 15], [6, 6], 20, 1, 2, [0, 61, "GG"], [0, 60, "Gu9"], 1, 20, 20, 3, [0, 53, "XB"], [0, 52, "BY"], 20, 1, [0, 49, "XB"], 20, 20, 3, 20, 1, 1, 20, 20, 3, [0, 39, "Vx"], 1, [0, 37, "XB"], 20, 20, 20, 3, [0, 33, "Vx"], 20, 20, 20, 20, 20, 20, [0, 32, "BE3"], 20, 1, 1, 20, 20, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 133
[ ,, 3, 2, 3, 3, 20, 20, [0, 64, "Ja2"], 3, 3, 1, 1, 20, 3, 3, 1, 1, 20, 3, 20, 20, 1, 1, 20, 1, 1, 20, 3, 3, 20, 3, 20, 20, 20, 3, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 134
[ ,, 3, [6, 14], 3, 1, 1, 20, 3, 2, 3, 20, 1, 1, 2, 2, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 1, 1, 2, 1, 1, 2, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 135
[ ,, 2, 3, 1, [6, 31], 1, [0, 65, "X"], 1, [0, 63, "GG"], 1, 2, 20, 1, [0, 57, "X"], 2, 20, 20, 1, 2, 1, [0, 49, "X"], 20, 20, 1, [0, 47, "X"], 20, 1, [0, 45, "X"], 20, 1, 2, 20, 20, 20, 1, [0, 35, "Vx"], 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, [0, 29, "X"], 20, 20, 1, [0, 27, "X"], 20, 1, [0, 25, "X"], 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, [0, 21, "X"], 20, 20, 1, [0, 19, "X"], 20, 1, [0, 17, "X"], 20, 20, 20, 20, 20, 1, [0, 15, "X"], 20, 20, 20, 20, 20, 1, [0, 13, "X"], 20, 20, 20, 20, 20, 1, [0, 11, "X"], 20, 20, 20, 20, 20, 1, [0, 9, "X"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 136
[ ,, [6, 3], 3, [6, 15], 3, 20, 3, 20, 3, 20, [7, 255], 20, 20, 3, [0, 56, "BZ"], [0, 53, "BEx"], 20, 20, [0, 52, "BZ"], 20, 3, 20, 20, 20, 3, 20, 20, 3, [0, 41, "Vx"], 20, [0, 40, "BZ"], 20, 20, 20, 20, 3, 20, [0, 34, "BZ"], 20, 20, 20, 20, 20, 20, 20, [0, 32, "BE3"], 20, 20, 3, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, [0, 24, "RS"], 20, 20, 3, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 137
[ ,, 3, 3, 3, 1, 2, 3, 20, 3, [0, 61, "GG1"], 1, 1, 20, 3, 3, 3, 20, 20, 3, 20, 3, 20, 20, 20, 1, 1, 20, 3, 3, 20, 3, 1, 20, 20, 20, 3, 20, 3, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 3, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 138
[ ,, 2, 2, 2, 20, [0, 68, "vT3"], 2, 20, 3, 3, 20, 1, 1, 2, 3, 1, 1, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 2, 2, 20, 3, 1, 1, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 139
[ ,, [6, 6], [6, 4], [6, 15], [6, 31], 1, [0, 67, "X"], 2, 3, 1, [21, 4, 1], 20, 1, [0, 59, "X"], 1, [0, 55, "BEx"], 1, [0, 53, "X"], 20, 1, [0, 51, "X"], 20, 20, 20, 20, 20, 1, [0, 47, "X"], [0, 43, "Vx"], 20, 1, 1, 1, 2, 20, 20, 1, [0, 35, "XBZ"], 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 2, 1, 20, 20, 20, 20, 1, [0, 27, "X"], 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 20, 1, [0, 19, "X"], 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 140
[ ,, 3, 3, 3, 3, 20, 3, [0, 66, "GB5"], 1, [0, 63, "GB6"], 3, 20, 20, 3, 20, 3, 20, 3, 20, 20, 3, 1, 20, 20, 20, 20, 20, 3, 3, 20, 20, 1, 1, 2, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, [0, 32, "BE3"], 1, 1, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 141
[ ,, 3, 2, 3, 1, 2, 3, 3, 20, 3, 1, 1, 20, 3, 20, 1, 1, 1, 1, 20, 3, 1, 1, 20, 20, 20, 20, 3, 3, 1, 20, 20, 1, 2, 2, 20, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, [0, 24, "Kol"], 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 142
[ ,, 2, [6, 7], 1, [6, 31], [0, 70, "vT3"], 2, 1, [0, 65, "GG"], 1, 1, 1, 1, 2, 20, 20, 1, 1, 1, 1, 2, 20, 1, 2, 20, 20, 20, 3, 3, 1, 2, 20, 20, [0, 40, "DaH"], [0, 38, "DaH"], 20, 20, 3, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, [0, 27, "BEx"], 20, 20, 20, 1, [0, 25, "XX"], 20, 20, 20, 20, 20, 1, [0, 23, "XX"], 20, 20, 1, [0, 21, "Su"], 20, 20, 20, 1, [0, 19, "BEx"], 20, 20, 20, 1, [0, 17, "XX"], 20, 20, 20, 20, 20, 1, [0, 15, "XX"], 20, 20, 20, 20, 20, 1, [0, 13, "XX"], 20, 20, 20, 20, 20, 1, [0, 11, "XX"], 20, 20, 20, 20, 20, 1, [0, 9, "XX"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 143
[ ,, [6, 3], 3, 20, 3, 1, [0, 69, "X"], 2, 3, 20, 1, [0, 63, "X"], 1, [0, 61, "X"], 20, 20, 20, 1, 2, 1, [0, 53, "X"], 2, 20, [0, 50, "BE3"], 20, 20, 20, 3, 1, 1, 2, 20, 20, 3, 3, 20, 20, 1, 2, 20, 20, [0, 34, "BE3"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 144
[ ,, 3, 3, [6, 20], 1, 2, 3, [0, 68, "Gu"], 2, 20, 20, 3, 20, 3, [0, 57, "XB"], 20, 20, 20, [7, 255], 20, 3, [0, 52, "BET"], 20, 1, 1, 20, 20, 3, [0, 45, "Gra"], 1, 2, 20, 20, 3, 1, 1, 20, 20, [0, 36, "BE3"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, [0, 27, "BEx"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 23, "XX"], 20, 20, 1, 1, 20, 20, 20, 1, [0, 19, "BEx"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 145
[ ,, 2, 2, 3, 20, [0, 72, "HvT"], 2, 1, 2, 20, 20, 1, 1, 2, 3, 20, 20, 20, 1, 1, 2, 1, 1, 20, 1, 1, 20, 3, 3, 20, [0, 44, "CLC"], 20, 20, 1, 2, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 146
[ ,, [6, 6], [6, 11], 2, 20, 1, [0, 71, "X"], 2, [0, 68, "Ja"], 2, 20, 20, 1, [0, 63, "X"], 1, [21, 6, 2], 20, 20, 20, 1, [0, 55, "X"], 20, 1, 2, 20, 1, [0, 49, "XX"], 3, 3, 20, 3, 20, 20, 20, [0, 40, "DaH"], 20, [0, 38, "BE3"], 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, [0, 21, "XX"], 20, 20, 1, [0, 19, "BEx"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 147
[ ,, 3, 3, [6, 23], [6, 31], 20, 3, [0, 70, "Ja2"], 3, [0, 66, "GB6"], 20, 20, 20, 3, 2, 3, 20, 20, 20, 20, 3, 20, 20, [0, 52, "BE3"], 20, 20, 3, 2, 3, 20, 3, 1, 20, 20, 1, 1, 1, 1, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 148
[ ,, 3, 2, 3, 3, 20, 3, 2, 2, 2, 20, 20, 20, 3, 2, 1, 2, 20, 20, 20, 3, [0, 53, "BE3"], 20, 1, 1, 20, 1, [0, 49, "XX"], 3, 20, 3, 1, [0, 41, "X"], 20, 20, 1, 1, 1, 1, 20, 20, [0, 36, "BE3"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, [0, 21, "XX"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 149
[ ,, 2, [6, 14], 3, 1, [0, 73, "Bel"], 1, 2, 2, 2, 2, 20, 20, 3, 2, 1, 2, 20, 20, 20, 3, 3, 20, 20, 1, 1, 20, 3, 1, 2, 3, 20, 3, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 1, 20, 20, 20, 20, 20, 1, [0, 25, "Su"], 20, 20, 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 17, "Su"], 20, 20, 20, 20, 20, 1, [0, 15, "Su"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 11, "Su"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 150
[ ,, [6, 3], 3, 1, [6, 31], 3, 20, [0, 72, "GB5"], [0, 70, "BZ"], [0, 68, "GB6"], [0, 66, "BZ"], 20, 20, 3, [0, 62, "CZ2"], 1, 2, 1, 20, 20, 3, 2, 20, 20, 20, 1, [0, 51, "XX"], 3, 1, 2, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 1, 2, 20, 20, 20, 1, [0, 33, "BHJ"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 151
[ ,, 3, 3, [6, 27], 3, 1, [0, 73, "BEx"], 3, 2, 3, 1, [0, 65, "GG"], 20, 3, 1, 1, 2, 1, [7, 264], 20, 1, [0, 55, "BE3"], [0, 53, "BEx"], 20, 20, 20, 3, 2, 1, 2, 20, 1, [0, 43, "X"], 1, [0, 41, "BEx"], 20, 20, 20, 1, 2, 1, 2, 20, [0, 36, "Dup"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, [0, 31, "MMT"], 20, 1, [0, 27, "Su"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, [0, 23, "MMT"], 20, 1, 2, 20, 20, 20, 20, 1, [0, 19, "Su"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 13, "MMT"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 5, "GB"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 152
[ ,, 2, 3, 3, 1, [0, 75, "Bel"], 3, 1, 2, 1, 2, 3, 20, 1, 2, 1, 2, 2, 3, 20, 20, 3, 3, 20, 20, 20, 1, [0, 51, "XX"], 20, [0, 48, "Dup"], 2, 20, 3, 20, 3, 20, 20, 20, 20, [0, 40, "BE3"], 20, [0, 38, "BE3"], 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, [0, 22, "BE3"], 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 153
[ ,, [6, 6], 2, 2, 20, 3, 2, 20, [0, 72, "BZ"], 2, [0, 68, "BZ"], 1, [0, 65, "XX"], 20, [0, 64, "CZ"], 20, [0, 62, "CZ"], 2, 1, [0, 57, "XX"], 20, 3, 1, [0, 53, "BEx"], 20, 20, 20, 3, 20, 3, [0, 46, "LLX"], 20, 1, 1, 1, 1, 20, 20, 20, 3, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 3, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 154
[ ,, 3, [6, 4], [6, 30], [6, 31], 1, [0, 75, "X"], 20, 3, 2, 2, 20, 3, 20, 1, 1, 1, 2, 20, 3, 20, 1, [0, 55, "BE3"], 3, 20, 20, 20, 3, 20, 3, 2, 20, 20, 1, [0, 43, "X"], 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, [0, 26, "BET"], 20, 20, 20, 20, 20, 3, 20, 20, 20, [0, 22, "BE3"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 155
[ ,, 3, 3, 3, 3, 20, 3, 2, 1, 2, 2, [0, 67, "GG"], 1, [0, 65, "XX"], 20, 1, [0, 63, "Gra"], [0, 62, "GW2"], [7, 272], 1, [0, 57, "XX"], 20, 3, 1, [0, 53, "BEx"], 20, 20, 3, 20, 1, 2, 20, 20, 20, 3, 20, 1, 2, 20, 20, 1, 2, 1, 2, 20, 20, [0, 36, "BZ"], 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, 20, 20, 20, 20, 3, 2, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 23, "TTH"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, [0, 7, "EB3"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 156
[ ,, 2, 2, 3, 1, [6, 63], 3, [0, 74, "GB5"], 20, [0, 72, "JS"], [0, 70, "BZ"], 3, 20, 3, 20, 20, 3, 3, 3, 20, 3, 20, 1, [0, 55, "BE3"], 3, 20, 20, 3, [0, 49, "Gra"], 20, [0, 48, "LLX"], 20, 20, 20, 1, 1, 20, [0, 42, "BE3"], 20, 20, 20, [0, 40, "BE3"], 20, [0, 38, "GW2"], 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 3, 2, 20, 20, 20, 20, 1, [0, 27, "Su"], 20, 20, 1, [0, 25, "Su"], 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, [0, 17, "Su"], 20, 20, 20, 20, 20, 1, [0, 15, "Su"], 20, 20, 20, 20, 20, 1, [0, 13, "Su"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 157
[ ,, [6, 3], [6, 7], 1, [6, 31], 3, 2, 2, 20, 3, 2, 1, [0, 67, "XX"], 3, 20, 20, 3, 3, 1, [0, 59, "XX"], 3, 20, 20, 3, 1, [0, 53, "BEx"], 20, 3, 3, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 31, "TTH"], 1, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 158
[ ,, 3, 3, 20, 3, 1, 2, 2, 20, 1, 2, 20, 3, 2, 20, 20, 3, 2, 20, 3, 2, 20, 20, 1, [0, 55, "BE3"], 3, 20, 3, 3, 20, 3, 2, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 21, "KSH"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 159
[ ,, 2, 3, 20, 1, [6, 63], [0, 78, "BDH"], [0, 76, "Ja2"], 2, 20, [0, 72, "BZ"], [0, 69, "GG"], 1, [0, 67, "XX"], 20, 20, 1, 2, 20, 1, [0, 59, "XX"], 20, 20, 20, 3, 1, [0, 53, "BE3"], 3, 3, 20, 3, [0, 46, "BE3"], 20, 20, 20, 20, 20, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 3, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 160
[ ,, [6, 6], 2, [6, 5], 20, 3, 2, 2, 2, 20, 3, 3, 20, 3, 20, 20, 20, [0, 64, "GW2"], 20, 20, 3, [0, 57, "BE3"], 20, 20, 3, 20, 3, 2, 2, 20, 3, 1, 1, 20, 20, 20, 20, 20, [0, 44, "BE3"], 20, [0, 42, "BE3"], 20, 20, [0, 40, "GW2"], 20, 20, [0, 38, "BZ"], 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, 20, 1, [0, 31, "TTH"], 20, [0, 30, "BZ"], 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 161
[ ,, 3, [6, 11], 3, 20, 1, 2, 2, 2, 2, 3, 1, [0, 69, "XX"], 3, 2, 20, 20, 3, 20, 20, 3, 3, 20, 20, 1, [0, 55, "BE3"], 1, [0, 53, "BEx"], [0, 51, "Gra"], 20, 3, 20, 1, [0, 45, "XX"], 20, 20, 20, 20, 1, 2, 1, 2, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 162
[ ,, 3, 3, 2, 20, 20, [0, 80, "BDH"], [0, 78, "Ja2"], [0, 76, "Ja2"], [0, 74, "JS"], 1, [0, 71, "GG"], 3, 2, [0, 66, "BZ"], 20, 20, 3, 2, 20, 3, 3, 20, 20, 20, 3, 20, 3, 3, 20, 1, [0, 47, "Vx"], 20, 3, 20, 20, 20, 20, 20, [0, 44, "BE3"], 20, [0, 42, "BE3"], 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, [0, 24, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 7, "EB3"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 163
[ ,, 2, 2, [6, 15], [6, 37], 20, 3, 2, 2, 2, 20, 3, 1, [0, 69, "XX"], 2, 20, 20, 3, 2, 20, 3, 1, 2, 20, 20, 1, 1, 2, 3, 1, 20, 3, 20, 1, 2, 20, 20, 20, 20, 1, 1, 2, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 17, "Su"], 20, 20, 20, 20, 20, 1, [0, 15, "Su"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 164
[ ,, [6, 3], [6, 14], 3, 3, 20, 1, 2, 2, 2, 2, 1, [0, 71, "XX"], 3, 2, 1, 20, 1, 2, 2, 1, [0, 59, "BE3"], [0, 58, "BE3"], 20, 20, 20, 1, [0, 55, "BE3"], 3, 1, [0, 49, "XB"], 3, 20, 20, [7, 255], 20, 20, 20, 20, 20, 1, 2, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 165
[ ,, 3, 3, 3, 1, [6, 63], 20, [0, 80, "Ja2"], [0, 78, "GB5"], [0, 76, "Gu9"], [0, 74, "Ja2"], 20, 3, 2, [0, 68, "BZ"], 1, 2, 20, [0, 64, "CZ"], 2, 20, 3, 1, 2, 20, 20, 20, 3, 3, 20, 3, 1, 1, 20, 1, [7, 254], 20, 20, 20, 20, 20, [0, 44, "BE3"], [0, 42, "BZ"], 20, 20, 20, [0, 40, "BZ"], 20, 20, 20, [0, 38, "BZ"], 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, 1, 2, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 166
[ ,, 2, 3, 1, [6, 47], 3, 20, 3, 2, 3, 2, 20, 1, [0, 71, "XX"], 2, 20, [0, 66, "GW2"], 20, 1, 2, 20, 3, 20, [0, 58, "BE3"], 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 20, 3, 20, 20, 20, 20, 20, 3, 2, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, [0, 34, "XBZ"], 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 167
[ ,, [6, 6], 3, [6, 15], 3, 1, [0, 81, "BEx"], 1, 2, 1, 2, 20, 20, 3, 2, 2, 1, 2, 20, [0, 64, "GW2"], 2, 1, 2, 1, [0, 57, "BE3"], 20, 20, 3, 20, 1, 2, 1, 1, 1, 2, 1, 1, 20, 20, 20, 20, 1, 2, 1, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, 2, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 9, "Hg"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 168
[ ,, 3, 2, 3, 1, [6, 63], 3, 20, [0, 80, "Ja2"], [0, 77, "Gu9"], [0, 76, "GB6"], 20, 20, 3, 2, [0, 68, "GG1"], 20, [0, 66, "GG1"], 20, 3, [0, 62, "BE3"], 20, [0, 60, "BZ"], 20, 3, 20, 20, 3, 20, 20, [0, 52, "BZ"], 20, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, [7, 255], 1, 2, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, [0, 36, "XBZ"], 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, [0, 24, "BZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 169
[ ,, 3, [6, 4], 2, 20, 3, 2, 20, 3, 3, 3, 1, 20, 1, 2, 1, 1, 1, 2, 3, 2, 20, 1, 2, 3, 20, 20, 3, 20, 20, 1, 2, 20, 1, 2, 1, 20, 1, 1, 20, 20, 20, 1, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 170
[ ,, 2, 3, [6, 15], [6, 44], 1, [0, 83, "BEx"], 20, 3, 2, 2, 1, 2, 20, [0, 72, "DaH"], 20, 1, 2, [0, 66, "DaH"], 1, [0, 63, "GG"], 20, 20, [0, 60, "BE3"], 1, 1, 20, 3, 1, 20, 20, [0, 52, "DaH"], 20, 20, [0, 50, "DaH"], 1, 2, 20, 1, 1, 20, 20, 20, 1, [7, 255], 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, [0, 17, "Su"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 171
[ ,, [6, 3], 2, 3, 3, 20, 3, [0, 81, "Gu9"], 1, 2, 2, 20, [0, 74, "BZ"], 20, 3, 1, 20, [0, 68, "GG1"], 3, 20, 3, 1, 20, 1, [0, 59, "BE3"], 1, 2, 3, 1, 1, 20, 3, 20, 20, 3, 20, [0, 48, "Dup"], 20, 20, 1, 1, 20, 20, 20, 3, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, [0, 35, "TTH"], 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 172
[ ,, 3, [6, 7], 3, 1, [6, 63], 3, 3, 20, [0, 80, "Ja"], [0, 78, "GW2"], 1, 1, 1, 2, 1, 2, 3, 3, 20, 3, 1, [0, 61, "XB"], 20, 3, 20, [0, 58, "BE3"], 2, 20, 1, [0, 53, "XB"], 3, 20, 20, 1, 2, 3, 20, 20, 20, 1, [0, 45, "Gra"], 20, 20, 3, 1, [0, 41, "XB"], 20, 20, 1, [0, 39, "XB"], 20, 20, 1, [0, 37, "XB"], 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 173
[ ,, 2, 3, 1, [6, 47], 3, 2, 1, 2, 3, 2, 1, 2, 1, 2, 20, [0, 70, "GW2"], 3, 2, 20, 3, 20, 3, 20, 3, 20, 1, 2, 1, 20, 3, 1, 1, 20, 20, [0, 50, "GW2"], 3, 20, 20, 20, 20, 3, 20, 20, 3, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, [0, 35, "XB"], 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 174
[ ,, [6, 6], 3, 20, 3, 1, [0, 85, "X"], 2, [0, 82, "BKW"], 1, 2, 20, [0, 76, "BZ"], 20, [0, 74, "BZ"], 20, 3, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, [0, 58, "BE3"], 1, 1, 2, 20, 1, 1, 20, 3, 1, 1, 20, 20, 20, 3, 20, 20, 3, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, 20, 1, [0, 31, "TTH"], 20, 20, 1, 1, 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, [0, 24, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 175
[ ,, 3, 2, [6, 20], 1, [6, 63], 3, [0, 84, "Ja2"], 2, 20, [0, 80, "GW2"], 1, 1, 1, 2, 20, 3, 20, [0, 68, "GW2"], 20, 20, 1, 2, 20, 20, 1, 2, 3, 20, 1, 2, 2, 20, 1, 2, 3, 20, 1, 2, 20, 20, 1, [7, 264], 20, 1, 2, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 176
[ ,, 3, [6, 11], 3, 20, 3, 2, 1, 2, 2, 3, 1, 2, 1, 2, 20, 3, 20, 3, 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, [0, 60, "BZ"], 2, 20, 20, [0, 56, "BZ"], 2, 20, 20, [0, 52, "BZ"], 1, 1, 20, [0, 48, "BZ"], 20, 20, 20, 3, 20, 20, [0, 44, "BZ"], 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 177
[ ,, 2, 3, 2, 20, 1, [0, 87, "X"], [0, 85, "Gra"], [0, 84, "BKW"], [0, 82, "EB2"], 3, 20, [0, 78, "BZ"], 20, [0, 76, "BZ"], 20, 1, [0, 69, "GG1"], 3, 1, 20, 20, 3, 1, 20, 20, 1, 2, 20, 20, 1, 2, 1, 20, 3, 20, 1, 1, 2, 20, 20, 20, 1, [7, 266], 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 178
[ ,, [6, 3], 2, [6, 23], [6, 52], 20, 3, 3, 3, 2, 1, 1, 1, 1, 2, 1, 20, 3, 3, 1, 1, 20, 3, 1, 1, 20, 20, [0, 60, "BE3"], 1, 20, 20, [0, 56, "DaH"], 1, 1, 2, 20, 20, 1, 2, 1, 20, 20, 20, 3, 20, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 179
[ ,, 3, [6, 14], 3, 3, 20, 3, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 1, 1, 1, 1, 1, 1, 20, 3, 1, 1, 20, 1, 1, 1, 2, 1, 20, 20, [0, 50, "GW2"], 1, [0, 47, "Gra"], 20, 20, 1, [7, 268], 20, [0, 44, "GW2"], 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 180
[ ,, 2, 3, 3, 1, [6, 63], 1, [0, 87, "Gu9"], 2, [0, 84, "EB2"], [0, 82, "BZ"], 20, [0, 80, "BZ"], 20, [0, 78, "BZ"], 20, [0, 72, "BZ"], 1, [0, 69, "XB"], [0, 68, "BY"], 20, 1, [0, 65, "XB"], 1, 1, 1, [0, 61, "XB"], 3, 20, 1, [0, 57, "XB"], 20, 1, 1, 2, 1, 1, 20, 3, 20, 3, 20, 20, 20, 3, 20, 3, 20, 20, 20, [0, 42, "BZ"], 20, 20, 20, [0, 40, "BZ"], 20, 20, 20, [0, 38, "BZ"], 20, 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 181
[ ,, [6, 6], 3, 1, [6, 55], 3, 20, 3, [0, 86, "Zwa"], 2, 1, 1, 1, 1, 2, 20, 3, 20, 3, 1, 1, 20, 3, 20, 1, 2, 3, 1, 1, 20, 3, 20, 20, 1, 2, 2, 1, 1, 2, 20, 1, 1, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 182
[ ,, 3, 3, [6, 27], 3, 1, 2, 3, 1, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 20, 1, 1, 2, 20, 20, [0, 64, "DaH"], 2, 20, 1, 1, 2, 20, 20, 20, [0, 56, "DaH"], 2, 20, 1, 2, 1, 20, 1, 1, 20, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 183
[ ,, 3, 2, 3, 1, [6, 63], [0, 90, "BZ"], 1, 2, [0, 86, "EB2"], [0, 84, "BZ"], 20, [0, 82, "BZ"], 20, [0, 80, "BZ"], [21, 6, 2], 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, [0, 52, "GW2"], 1, 2, 20, 1, 1, 20, [0, 46, "BZ"], 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 184
[ ,, 2, [6, 4], 2, 20, 3, 2, 20, [0, 88, "Zwa"], 2, 1, 1, 1, 1, 2, 1, 2, 20, [0, 72, "BZ"], 20, 20, 20, [0, 68, "BZ"], 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, [0, 60, "BZ"], 20, 20, 20, 20, [0, 56, "GW2"], 1, 20, 1, 1, 2, 20, 20, 1, 2, 1, 1, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 185
[ ,, [6, 3], 3, [6, 30], [6, 59], 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 20, 3, 1, 2, 20, 1, 2, 1, 20, 20, [0, 48, "Gra"], 20, 1, 2, 20, 20, [0, 44, "BZ"], 20, 20, 20, [0, 42, "BZ"], 20, 20, 20, [0, 40, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 186
[ ,, 3, 2, 3, 3, 20, [5, 7], [0, 90, "EB2"], 20, [0, 88, "EB2"], [0, 86, "BZ"], 20, [0, 84, "BZ"], 20, [0, 82, "BZ"], 1, 2, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 3, 20, [0, 54, "GW2"], 20, 20, [0, 52, "GW2"], 1, 1, 20, 3, 20, 20, [0, 46, "BZ"], 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 187
[ ,, 2, [6, 7], 3, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 20, 1, 1, 2, 20, 20, 3, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 188
[ ,, [6, 6], 3, 1, [6, 62], 1, [0, 93, "Bel"], 2, 1, 2, 2, 1, 2, 1, 2, 1, [0, 77, "GW2"], 1, [0, 73, "XB"], [0, 72, "BY"], 20, 1, [0, 69, "XB"], [0, 68, "BY"], 20, 1, [0, 65, "XB"], 1, 2, 1, [0, 61, "XB"], [0, 60, "BY"], 20, 1, [0, 57, "XB"], 20, 1, 2, [0, 53, "XB"], 20, 1, 2, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 189
[ ,, 3, 3, 20, 3, 20, 3, [0, 92, "EB2"], 20, [0, 90, "EB2"], [0, 88, "BZ"], 20, [0, 86, "BZ"], 20, [0, 84, "BZ"], 20, 3, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 20, [0, 64, "DaH"], 20, 3, 1, 1, 20, 3, 20, 20, [0, 56, "GW2"], 3, 20, 20, [0, 52, "GW2"], 20, 20, 1, 1, 1, 1, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 190
[ ,, 3, 2, 20, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 20, 3, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 20, 3, 2, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, [0, 46, "BZ"], 20, 20, 20, [0, 44, "BZ"], 20, 20, 20, 1, 1, 20, 20, [0, 40, "BZ"], 20, 20, 20, 20, [0, 38, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 191
[ ,, 2, [6, 11], [6, 5], 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 2, 1, 2, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 1, 20, 1, 2, 1, 20, 20, 1, 2, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 21, "X"], 20, 20, 20, 20, 20, 20, 1, [0, 19, "X"], 20, 20, 1, [0, 17, "X"], 20, 20, 20, 20, 20, 20, 1, [0, 15, "Su"], 20, 20, 20, 20, 20, 20, 1, [0, 13, "X"], 20, 20, 20, 20, 20, 20, 1, [0, 11, "X"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 192
[ ,, [6, 3], 3, 3, 20, 20, [5, 7], 2, 20, [0, 92, "EB2"], 20, 20, [0, 88, "BZ"], 20, [0, 86, "BZ"], 1, 2, 20, [0, 76, "BZ"], 20, 20, 20, [0, 72, "BZ"], 20, 20, 20, [0, 68, "BZ"], 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, [0, 60, "BZ"], 1, 1, 20, [0, 56, "BZ"], 1, 2, 20, 20, [0, 52, "GW2"], 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, [0, 40, "XBZ"], 20, 20, 20, 20, [0, 38, "BZ"], 20, 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, 20, [0, 34, "BZ"], 20, 20, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 193
[ ,, 3, 2, 2, 20, 20, 3, [0, 94, "B2x"], 20, 3, 20, 20, 1, 1, 2, 20, [0, 80, "GW2"], 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 20, 1, 1, 1, 1, 2, 20, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 194
[ ,, 2, [6, 14], [6, 15], 20, 20, 3, 1, 1, 2, 20, 20, 20, 1, 2, 20, 3, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 20, 20, 1, 1, 1, 2, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 1, 2, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 195
[ ,, [6, 6], 3, 3, [6, 6], 20, 1, [0, 95, "B2x"], 1, [0, 93, "B2x"], [0, 89, "GG"], 20, 20, 20, [0, 88, "BZ"], 20, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 20, 20, 1, [0, 57, "Dup"], [0, 56, "Dup"], 1, 20, 3, 20, 20, 20, 20, 20, 20, 1, [0, 49, "MMT"], 1, [0, 47, "MMT"], 20, 20, 20, 20, 1, [0, 43, "MMT"], 20, 20, 20, [0, 42, "MMT"], 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 196
[ ,, 3, 3, 3, 3, 20, 20, 3, 20, 3, 3, 20, 20, 20, 3, 20, 3, 1, [0, 77, "Gra"], [0, 76, "BY"], 20, 1, [0, 73, "XB"], [0, 72, "BY"], 20, 1, [0, 69, "XB"], [0, 68, "BY"], 20, 1, [0, 65, "XB"], [0, 64, "BY"], 20, 1, [0, 61, "XB"], [0, 60, "BY"], 20, 20, 20, 3, 3, 1, [0, 53, "XB"], 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 197
[ ,, 3, 3, 2, 1, 1, 20, 1, 1, 2, 1, 1, 20, 20, 3, 20, 3, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 3, 3, 20, 3, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 3, [0, 45, "XB"], 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 198
[ ,, 2, 2, [6, 15], [6, 31], 1, [0, 97, "XX"], 20, 1, [0, 95, "EB2"], 20, 1, [0, 89, "GG"], 20, 3, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 3, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 3, 3, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, [0, 40, "BZ"], 20, 20, 20, 20, [0, 38, "BZ"], 20, 20, 20, 20, [0, 36, "BZ"], 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, 20, [0, 30, "BZ"], 20, 20, 20, 20, [0, 28, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 199
[ ,, [6, 3], [6, 4], 3, 3, 20, 3, 20, 20, 3, [0, 91, "GG"], 20, 3, 20, 3, 1, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 3, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 3, 20, 3, 3, 20, 20, 20, 20, 1, 2, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, [0, 34, "XBZ"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 200
[ ,, 3, 3, 2, 1, [6, 95], 3, 20, 20, 3, 3, 20, 3, 20, 3, 1, [0, 81, "Gra"], 20, [0, 80, "BZ"], 20, 20, 20, [0, 76, "BZ"], 20, 20, 20, [0, 72, "BZ"], 20, 20, 20, [0, 68, "BZ"], 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, [0, 60, "BZ"], 3, 20, 20, [0, 56, "BZ"], 20, 20, 20, [0, 52, "BZ"], 20, 20, 20, 20, 3, 20, 3, 3, 20, 20, 20, 20, 20, [0, 44, "BZ"], 20, 20, 1, [0, 41, "Gra"], 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 2, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 201
[ ,, 2, 2, [6, 15], 20, 3, 2, 20, 20, 3, 1, 1, 1, 2, 3, 20, 3, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 3, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 3, 20, 3, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, [0, 36, "XBZ"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, [0, 29, "Ch"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 202
[ ,, [6, 6], [6, 7], 3, [6, 31], 1, [0, 99, "XX"], [0, 97, "EB2"], 20, 3, 20, 1, [0, 91, "GG"], [0, 90, "EB1"], 2, 1, 2, 20, 3, 2, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 3, 20, 20, 3, 1, 20, 20, 20, 1, 1, 20, 20, 3, 20, 3, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 203
[ ,, 3, 3, 3, 3, 20, 3, 3, 20, 3, 1, 20, 3, 1, [0, 89, "GG"], 1, [0, 83, "Gra"], 20, 3, 2, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 1, [0, 57, "VE"], 20, 3, 1, 1, 20, 20, 20, 1, [0, 51, "XBZ"], 20, 3, 20, 3, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 204
[ ,, 3, 3, 3, 1, [6, 92], 3, 3, 20, 3, 1, 2, 3, 20, 3, 20, 3, [0, 81, "CZ"], 1, 2, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, 2, 3, 20, 3, 20, 1, 1, 20, 20, 20, 3, 20, 3, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 205
[ ,, 2, 2, 1, [6, 31], 3, 2, 1, 1, 2, 20, [0, 94, "EB1"], 1, 2, 3, 1, 2, 3, 20, [0, 80, "Sab"], 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 20, [0, 60, "Dup"], 3, 20, 1, [0, 55, "Gra"], 20, 1, 1, 20, 20, 3, 20, 3, 20, 20, [0, 48, "BZ"], 20, 20, 20, [0, 46, "BZ"], 20, 20, 20, 20, [4, 50], 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 206
[ ,, [6, 3], [6, 11], [6, 20], 3, 1, 2, [0, 99, "EB2"], 1, 2, 2, 1, 2, [0, 92, "EB1"], 2, 1, [0, 85, "Gra"], 3, 20, 3, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 3, 3, 20, 20, 3, 20, 20, 1, 2, 20, 1, [0, 51, "Gra"], 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, [0, 39, "XB"], 20, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, [0, 31, "XB"], 20, 20, 20, 1, [0, 29, "Ch"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 207
[ ,, 3, 3, 3, 1, [6, 95], [0, 102, "BZ"], 3, 20, [0, 98, "EB1"], [0, 96, "BZ"], 20, [0, 94, "BZ"], 1, [0, 91, "GG"], 20, 3, 3, 20, 3, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 3, 1, 1, 20, 3, 20, 20, 20, [0, 54, "GW2"], 20, 20, 3, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 1, [0, 35, "XB"], 20, 20, 20, 1, [0, 33, "XB"], 20, 20, 20, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, [0, 27, "X"], 20, 20, 20, 20, 20, 20, 1, [0, 25, "X"], 20, 20, 20, 20, 20, 20, 1, [0, 23, "X"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 208
[ ,, 2, 2, 2, 20, 3, 2, 1, 1, 2, 1, 1, 2, 20, 3, 1, 2, 1, [0, 81, "XB"], 1, 1, 1, 2, 1, 20, 1, [0, 73, "XB"], 1, 20, 1, [0, 69, "XB"], 1, 20, 1, [0, 65, "XB"], 1, 20, 1, [0, 61, "XB"], 3, 20, 1, [0, 57, "XB"], 3, 20, 20, 20, 3, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 3, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, [0, 31, "Gra"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 209
[ ,, [6, 6], [6, 14], [6, 23], 20, 1, 2, 20, 1, 2, 20, 1, 2, 2, 3, 1, [0, 87, "Gra"], 2, 3, 20, 1, 2, [0, 78, "LLX"], 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 1, 2, 20, 3, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 210
[ ,, 3, 3, 3, [6, 31], 20, [5, 7], [0, 101, "EB2"], 20, [0, 100, "EB1"], 20, 20, [0, 96, "BZ"], [0, 94, "EB1"], 2, 20, 3, [0, 84, "CZ"], 2, 20, 20, [0, 80, "DaH"], 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 20, [0, 54, "GW2"], 20, 3, 20, 20, 20, [0, 50, "BZ"], 20, 20, 20, [0, 48, "BZ"], 20, 20, 20, [0, 46, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, [0, 42, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 3, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 211
[ ,, 3, 3, 3, 3, 20, 3, 3, 20, 3, 20, 20, 3, 1, [0, 93, "GG"], 20, 3, 1, [0, 83, "XB"], 2, 20, 1, [0, 79, "Gra"], 20, 20, 1, [0, 75, "XB"], 20, 20, 1, [0, 71, "XB"], 20, 20, 1, [0, 67, "XB"], 1, 20, 1, [0, 63, "XB"], 20, 20, 1, [0, 59, "XB"], 20, 20, 1, 1, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 212
[ ,, 2, 3, 2, 1, 1, 2, 1, 1, 2, 2, 20, 1, 2, 3, 20, 3, 20, 3, [0, 82, "MTS"], 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 1, 1, 20, 3, 20, 20, 20, 3, [0, 57, "Gra"], 20, 20, 1, 1, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, [0, 29, "Ch"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 213
[ ,, [6, 3], 2, [6, 27], [6, 31], 1, [0, 105, "Bel"], [0, 103, "EB2"], 1, 2, [0, 98, "BZ"], 20, 20, [0, 96, "EB1"], 2, 20, 3, 2, 3, 2, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 3, 1, 20, 20, 1, 1, 1, 1, 2, 1, 20, 20, 3, 3, 20, 20, 20, 1, 1, 2, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 214
[ ,, 3, [6, 4], 3, 3, 20, 3, 3, 20, [0, 102, "EB1"], 1, [0, 97, "XB"], 20, 1, [0, 95, "GG"], [0, 89, "XB"], 3, [0, 86, "GW2"], 1, 2, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 1, 1, 1, 2, 1, 1, 20, 3, 1, 1, 20, 20, 20, 1, [0, 55, "XB"], 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 215
[ ,, 2, 3, 2, 1, 1, 2, 1, 1, 2, 2, 3, 20, 20, 3, 3, 3, 2, 20, [0, 84, "MTS"], 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 20, 1, 1, 2, [0, 63, "Gra"], 1, 1, 1, 1, 1, 1, 20, 20, 20, 3, [0, 54, "BZ"], 20, 20, 20, [0, 52, "BZ"], 20, 20, 20, [0, 50, "BZ"], 20, 20, 20, [0, 48, "BZ"], 20, 20, 20, [0, 46, "BZ"], 20, 20, 20, 20, 20, 1, 1, 20, [0, 42, "BZ"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 216
[ ,, [6, 6], 2, [6, 30], 20, 1, [0, 107, "Bel"], 20, 1, 2, [0, 100, "BZ"], 1, [0, 97, "GG"], 20, 3, 2, 1, 2, 1, 2, 20, 1, 2, 1, 20, 1, 2, 1, 20, 1, 2, 1, 20, 1, 2, 20, 20, 1, 2, 3, 20, 1, 2, 1, [0, 59, "Gra"], 1, 2, 20, 20, 3, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, [0, 34, "BZ"], 20, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 217
[ ,, 3, [6, 7], 3, [6, 31], 20, 3, 2, 20, [0, 104, "EB1"], 2, 20, 3, 20, 3, [0, 91, "XB"], 20, [0, 88, "GW2"], 1, 2, 1, 20, [0, 82, "LLX"], 1, 1, 20, [0, 78, "LLX"], 1, 1, 20, [0, 74, "LLX"], 1, 1, 20, [0, 70, "LLX"], 20, 20, 20, [0, 68, "Dup"], 1, 1, 20, [0, 62, "LLX"], 20, 3, 20, [0, 58, "LLX"], 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 218
[ ,, 3, 3, 3, 3, 20, 3, [0, 106, "JS"], 20, 3, 2, 20, 3, 20, 3, 3, 20, 3, 20, [0, 86, "MTS"], 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 20, 20, 3, 20, 1, 1, 2, 20, 1, 1, 2, 20, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 219
[ ,, 2, 3, 3, 1, 1, 2, 1, 1, 2, [0, 102, "BZ"], 1, 2, 20, 3, 3, 20, 1, 2, 3, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 3, 20, 20, 1, 2, 20, 20, 1, 2, 1, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 220
[ ,, [6, 3], 2, 1, [6, 31], 1, [0, 109, "Bel"], [0, 107, "EB2"], 1, 2, 2, 1, [0, 99, "GG"], 20, 3, 2, 20, 20, [0, 88, "CZ"], 2, 20, 20, [0, 84, "LLX"], 1, 20, 20, [0, 80, "LLX"], 2, 20, 20, [0, 76, "LLX"], 20, 20, 20, [0, 72, "LLX"], 1, 20, 20, 3, 20, 20, 20, [0, 64, "LLX"], 1, 20, 20, [0, 60, "LLX"], 1, 1, 20, [0, 56, "BZ"], 20, 20, 20, [0, 54, "BZ"], 20, 20, 20, [0, 52, "BZ"], 20, 20, 20, [0, 50, "BZ"], 20, 20, 20, [0, 48, "BZ"], 20, 20, 20, [0, 46, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 221
[ ,, 3, [6, 11], 20, 3, 20, 3, 3, 20, [0, 106, "EB1"], 2, 20, 3, 20, 3, [0, 93, "XB"], 1, 20, 1, 2, 1, 20, 3, 1, 1, 20, 3, 2, 20, 20, 3, 20, 20, 20, 3, 1, 2, 20, 3, 20, 20, 20, 3, 1, 2, 20, 3, 20, 1, 2, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 222
[ ,, 2, 3, [6, 5], 1, 1, 2, 1, 1, 2, [0, 104, "BZ"], 2, 3, 1, 2, 3, 1, 1, 20, [0, 88, "GW2"], 1, [21, 10, 1], 1, [21, 10, 2], 1, [21, 10, 3], 1, [21, 10, 4], 2, 20, 3, 20, 20, 20, 1, 1, 2, 20, 3, 20, 20, 20, 3, 20, [0, 62, "GW2"], 20, 3, 20, 20, [0, 58, "GW2"], 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, [0, 32, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 223
[ ,, [6, 6], 2, 3, 20, 1, 2, 20, 1, 2, 2, 2, 2, 1, [0, 97, "GG"], 2, 20, 1, 2, 3, 20, 3, 20, 3, 20, 3, 20, 3, 2, 20, 3, 20, 20, 20, 20, 1, [0, 71, "Dup"], 20, 3, [0, 65, "VE"], 20, 20, 3, 20, 3, 20, 3, 20, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 224
[ ,, 3, [6, 14], 2, 20, 20, [5, 7], 2, 20, [0, 108, "EB1"], 2, 2, [0, 101, "GG"], 20, 3, 2, [0, 91, "GG1"], 20, [0, 90, "MTS"], 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 20, 3, 20, 20, 20, 20, 20, 3, 20, 3, 3, 20, 20, 3, 20, 3, 20, 3, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 225
[ ,, 3, 3, [6, 15], 20, 20, 3, [0, 110, "Gu9"], 20, 3, [0, 106, "BZ"], [0, 104, "BZ"], 3, 20, 3, [0, 96, "BZ"], 3, 20, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 20, 3, 1, 20, 20, 20, 20, 3, 20, 3, 2, 20, 20, 3, 20, 3, 20, 1, 2, 20, 20, [0, 58, "BZ"], 20, 20, 20, [0, 56, "BZ"], 20, 20, 20, [0, 54, "BZ"], 20, 20, 20, [0, 52, "BZ"], 20, 20, 20, [0, 50, "BZ"], 20, 20, 20, [0, 48, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 226
[ ,, 2, 3, 3, [6, 37], 20, 3, 1, 1, 2, 2, 3, 2, 1, 2, 3, 1, 1, 20, [0, 90, "MTS"], 20, 1, 1, 1, 1, 1, 1, 1, 2, 20, 3, 1, 1, 20, 20, 20, 3, 20, 1, [0, 67, "VE"], 1, 20, 1, [0, 63, "Vx"], 3, 20, 20, [0, 60, "Vx"], 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 227
[ ,, [6, 3], 3, 3, 3, 20, 1, [0, 111, "EB2"], 1, 2, 2, 1, [0, 103, "GG"], 1, [0, 99, "GG"], 3, [0, 93, "PD"], 1, 2, 3, 20, 20, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 20, 20, 3, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 20, 20, 20, 1, 2, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 228
[ ,, 3, 2, 2, 1, 1, 20, 3, 20, [0, 110, "EB1"], [0, 108, "BZ"], 20, 3, 20, 3, 2, 3, 20, [0, 92, "MTS"], 2, 20, 20, 20, 1, 1, 1, 1, 1, 2, 1, [0, 77, "XB"], [0, 76, "BY"], 20, 1, [0, 73, "XB"], 20, 3, 1, [0, 69, "XB"], 3, 20, 1, [0, 65, "XB"], 3, 20, 1, [0, 61, "XB"], 3, 20, 20, 20, 20, [0, 58, "GW2"], 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 3, 20, 20, 20, 20, [0, 48, "XBZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 229
[ ,, 2, [6, 4], [6, 15], [6, 47], 1, [0, 113, "Bel"], 1, 1, 2, 2, [0, 105, "XB"], 3, 20, 3, [0, 97, "XB"], 1, 1, 1, 2, [0, 89, "XB"], 20, 20, 20, 1, 1, 1, 1, 2, 20, 3, 1, 1, 20, 3, 20, 3, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 230
[ ,, [6, 6], 3, 3, 3, 20, 3, 20, 1, 2, 2, 3, 3, 1, 2, 3, 20, 1, 2, [0, 92, "MTS"], 3, 20, 20, 20, 20, 1, 1, 1, 2, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 20, 3, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, [0, 50, "XBZ"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 231
[ ,, 3, 2, 2, 1, 1, 2, 20, 20, [0, 112, "EB1"], [0, 110, "BZ"], 3, 3, 1, [0, 101, "GG"], 2, 1, 20, [0, 94, "MTS"], 2, 3, 20, 20, 20, 20, 20, 1, 1, 2, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 2, [0, 61, "Gra"], 20, 1, 2, 20, 1, 2, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 1, 1, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 232
[ ,, 3, [6, 7], [6, 15], 20, 1, [0, 115, "Bel"], 20, 20, 3, 2, 2, 3, 20, 3, [0, 99, "XB"], 1, 1, 1, 2, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, [0, 80, "BZ"], 1, 20, 20, [0, 76, "BZ"], 1, 20, 20, [0, 72, "BZ"], 1, 20, 20, [0, 68, "BZ"], 1, 20, 20, [0, 64, "BZ"], 3, 20, 20, [0, 60, "BZ"], 20, 20, [0, 58, "BZ"], 20, 20, 20, [0, 56, "BZ"], 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 233
[ ,, 2, 3, 3, [6, 44], 20, 3, 20, 20, 1, 2, [0, 107, "Gra"], 1, 1, 2, 3, 20, 1, 2, [0, 94, "MTS"], 2, 20, 20, 20, 20, 20, 20, 20, [0, 88, "MYI"], 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 1, 20, 3, 1, 2, 20, 3, 3, 20, 20, 1, 1, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 234
[ ,, [6, 3], 3, 3, 3, 20, 3, [7, 459], 20, 20, [0, 112, "BZ"], 3, 20, 1, [0, 103, "GG"], 3, 2, 20, [0, 96, "MTS"], 2, [0, 92, "BZ"], 2, 20, 20, 20, 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 20, 3, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 235
[ ,, 3, 2, 3, 1, 1, 2, 3, 20, 20, 3, 3, [0, 105, "GG"], 20, 3, 2, 2, 20, 1, 2, 2, [0, 90, "B2x"], 20, 20, 20, 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 236
[ ,, 2, [6, 11], 1, [6, 47], 1, [0, 117, "Bel"], 2, 20, 20, 3, 2, 3, 20, 3, [0, 101, "XB"], [0, 99, "GG1"], 1, 20, [0, 96, "MTS"], 2, 1, 1, 20, 20, 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, [0, 65, "XB"], [0, 64, "BY"], 20, 1, 1, 20, 20, 1, 1, 20, 1, [0, 57, "XB"], 20, [0, 56, "BZ"], 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 237
[ ,, [6, 6], 3, [6, 20], 3, 20, 3, 2, [7, 462], 20, 3, 2, 3, 20, 3, 3, 3, 1, 2, 3, [0, 94, "BZ"], 1, 1, 2, 20, 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 3, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 238
[ ,, 3, 2, 3, 1, 1, 2, [0, 116, "GB5"], 3, 20, 3, 2, 2, 20, 3, 2, 1, 1, 2, 2, 2, 1, 1, 2, 20, 20, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 239
[ ,, 3, [6, 14], 2, 20, 1, 2, 3, 1, 2, 1, 2, [0, 107, "GG"], 1, 1, 2, 2, 1, [0, 99, "GG1"], 2, 2, 1, 1, 2, 20, 20, 20, 20, 3, 1, [4, 16], 1, [21, 14, 2], 1, [21, 14, 3], 1, [21, 14, 4], 1, [21, 14, 5], 1, [21, 14, 6], 1, [21, 15, 7], 1, [21, 16, 7], 2, 2, 20, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 1, 2, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 240
[ ,, 2, 3, [6, 23], 20, 20, [5, 7], 2, 20, [0, 114, "EB1"], 20, [0, 112, "BZ"], 3, 1, [0, 105, "GG1"], [0, 104, "BZ"], 2, 20, 3, 2, [0, 96, "BZ"], 1, 1, 2, 20, 20, 20, 20, 3, 20, 3, 20, 3, 20, 3, 20, 3, 20, 3, 20, 3, 20, 3, 20, 3, 2, [0, 68, "BZ"], 20, 20, 20, [0, 64, "BZ"], 20, 20, 1, 1, 20, 20, [0, 60, "BZ"], 20, [0, 58, "BZ"], 20, 20, [0, 56, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 241
[ ,, [6, 3], 3, 3, [6, 52], 20, 3, 2, 2, 3, 20, 3, 3, 20, 3, 1, [0, 103, "GG1"], 1, 1, 2, 3, 20, 1, [0, 93, "MYI"], 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 20, 20, 3, 20, 20, 20, 1, 1, 20, 3, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 242
[ ,, 3, 3, 3, 3, 20, 3, [0, 118, "Ja2"], [7, 473], 2, 20, 3, 1, 1, 1, [0, 105, "PD"], 3, 1, 2, [0, 100, "MTS"], 3, 20, 20, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 243
[ ,, 2, 2, 2, 1, 1, 2, 2, 1, 2, [0, 113, "GG1"], 3, [0, 109, "GG"], 1, [0, 107, "GG1"], 3, 1, 1, 2, 2, 3, 20, 20, 3, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 244
[ ,, [6, 6], [6, 4], [6, 27], [6, 55], 1, [0, 121, "Bel"], 2, 20, [0, 116, "EB1"], 3, 2, 3, 20, 3, 1, 2, 1, [0, 103, "GG1"], 2, 1, 1, 20, 3, 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 69, "XB"], [0, 68, "BY"], 20, 1, [0, 65, "XB"], [0, 64, "BY"], 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, [0, 58, "BZ"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 245
[ ,, 3, 3, 3, 3, 20, 3, [0, 120, "JS"], [0, 117, "EB2"], 3, 1, [0, 113, "XB"], 1, 1, 1, 1, 2, 20, 3, [0, 102, "MTS"], 20, 1, [4, 10], 1, [21, 10, 1], 1, [21, 10, 2], 1, [21, 10, 3], 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 20, 3, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 246
[ ,, 3, 2, 2, 1, 1, 2, 3, 3, 3, 20, 3, [0, 111, "GG"], 1, [0, 109, "GG1"], 1, [0, 107, "GG1"], 1, 2, 2, [0, 97, "XB"], 20, 3, 20, 3, 20, 3, 20, 3, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 20, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 247
[ ,, 2, [6, 7], [6, 30], 20, 1, 2, 3, 2, 1, [0, 115, "XB"], 3, 3, 20, 3, 20, 3, 1, 2, 2, 3, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 248
[ ,, [6, 3], 3, 3, [6, 59], 20, [5, 7], 1, [0, 119, "EB2"], 2, 3, 2, 1, 1, 1, 1, 1, 1, 2, 2, 3, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 72, "BZ"], 20, 20, 20, [0, 68, "BZ"], 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 249
[ ,, 3, 3, 3, 3, 20, 3, 2, 3, [0, 118, "EB1"], 1, [0, 115, "XB"], 20, 1, [4, 6], 1, [21, 6, 1], 1, [21, 6, 2], 2, 2, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 20, 20, 3, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 250
[ ,, 2, 2, 3, 1, 1, 2, 2, 3, 2, 20, 3, 20, 20, 3, 20, 3, 20, 3, 2, [0, 99, "XB"], 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 20, 3, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 251
[ ,, [6, 6], [6, 11], 1, [6, 62], 1, 2, 2, 1, 2, [21, 4, 1], 3, 20, 20, 1, 1, 1, 1, 1, 2, 3, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 252
[ ,, 3, 3, 20, 3, 20, [5, 7], 2, 20, [0, 120, "GB6"], 3, 2, 20, 20, 20, 1, 1, 1, 1, 2, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, [0, 73, "XB"], [0, 72, "BY"], 20, 1, [0, 69, "XB"], [0, 68, "BY"], 20, 1, [0, 65, "XB"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 253
[ ,, 3, 2, [6, 5], 1, 1, 1, 2, 2, 3, 1, 2, [0, 113, "GG"], 20, 20, 20, 1, 1, 1, 2, 2, 1, 1, 2, 20, 20, 20, 20, 1, 1, 1, 2, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 3, 1, 1, 20, 3, 1, 1, 20, 3, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 254
[ ,, 2, [6, 14], 3, 20, 1, 1, 2, [7, 497], 1, 1, 2, 3, 20, 20, 20, 20, 1, 1, 2, 2, 20, 1, 2, 2, 20, 20, 20, 20, 1, 1, 2, 20, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 1, 1, 2, 2, 20, 1, 1, 2, 20, 1, 1, 2, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 2, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20],
#V   n = 255
[ ,, [6, 3], 3, 2, 20, 20, 1, 2, 2, 20, 1, 2, 1, 1, 20, 20, 20, 20, 1, 2, 2, 20, 20, [0, 100, "Lun"], [0, 98, "Dup"], 20, 20, 20, 20, 20, 1, 2, 20, 20, 1, 2, [0, 90, "BCH"], 20, 20, 20, 20, 20, 1, 2, 1, 2, 2, 20, 20, 1, 2, 20, 20, 1, 2, [0, 65, "Gra"], 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, [0, 61, "BCH"], 1, 2, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, [0, 34, "BCH"], 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20],
#V   n = 256
[ ,, 3, 3, [6, 15], 20, 20, 20, [5, 8], [7, 501], 20, 20, [0, 120, "XBC"], 20, 1, 1, 20, 20, 20, 20, [0, 112, "XBC"], [0, 104, "GW2"], 20, 20, 3, 3, 20, 20, 20, 20, 20, 20, [0, 96, "Rod"], 20, 20, 20, [0, 92, "XBC"], 2, 20, 20, 20, 20, 20, 20, [0, 88, "XBC"], 20, [0, 86, "XBC"], [0, 76, "BZ"], 20, 20, 20, [0, 72, "BZ"], 20, 20, 20, [0, 68, "BZ"], 3, 20, 20, 20, 20, 20, [0, 64, "BZ"], 20, 20, 20, 20, 20, 20, 20, 3, 20, [0, 58, "BZ"], 20, 20, 20, 20, 20, [0, 56, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 54, "XBC"], 20, 20, 20, [0, 52, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 48, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 46, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 44, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 40, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 38, "XBC"], 20, 20, 3, 20, 20, 20, 20, [0, 32, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 30, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 28, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 26, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 24, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 22, "XBC"], 20, 20, 20, 20, 20, 20, 20, [0, 20, "XBC"], 20, 20, 20, 1, [0, 17, "BCH"], 20, 20, 20, 20, 20, 20, 1, [0, 15, "Gp"], 20, 20, 20, 20, 20, 20, 1, [0, 13, "BCH"], 20, 20, 20, 20, 20, 20, 1, [0, 11, "Gp"], 20, 20, 20, 20, 20, 20, 1, [0, 9, "BCH"], 20, 20, 20, 20, 20, 20, 1, [0, 7, "Gp"], 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, [5, 127], 20, 20, 20, 20, 20, 20, 20],
#V   n = 257
[ ,, 3, 3, 3, 20, 20, 20, 3, 3, [0, 121, "EB1"], 20, 3, 20, 20, 3, [0, 113, "Dup"], 20, 20, 20, 3, 3, 20, 20, 3, 3, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 3, [0, 91, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 87, "X"], 3, 3, 20, 20, 20, 3, 20, 20, 20, 3, 3, 20, 20, 20, 20, 20, 3, [0, 63, "BE3"], 20, 20, 20, 20, 20, 20, 3, 20, 3, [0, 57, "BZ"], 20, 20, 20, 20, 3, [0, 55, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 53, "X"], 20, 20, 3, [0, 49, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 47, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 45, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 41, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 39, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 35, "X"], 20, 3, 20, 20, 20, 20, 3, [0, 31, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 29, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 27, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 25, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 23, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 21, "X"], 20, 20, 20, 20, 20, 20, 3, [0, 19, "X"], 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 20, 20, 20, 20, 20, 3, [0, 5, "GB"], 20, 20, 20, 20, 20, 3, 2, 20, 20, 20, 20, 20, 20, 20],
#V   n = 258
[ , 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, [5, 128], 3, 3, 3, 3, 3, 3, 3, 3, 3]];


GUAVA_BOUNDS_TABLE[2][2] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ , [15, 2]],
#V   n = 5
[ , [15, 3], [15, 2]],
#V   n = 6
[ , [15, 4], [15, 3], [15, 2]],
#V   n = 7
[ , [15, 4], [15, 4], [15, 3], [15, 2]],
#V   n = 8
[ , [15, 5], [15, 4], [15, 4], [14, 4], [15, 2]],
#V   n = 9
[ , [15, 6], [15, 4], [15, 4], 12, 11, [15, 2]],
#V   n = 10
[ , [15, 6], [15, 5], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 11
[ , [15, 7], [15, 6], [15, 5], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 12
[ , [15, 8], [15, 6], [15, 6], [0, 4, "FP"], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 13
[ , [15, 8], [15, 7], [15, 6], 12, [16, 4], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 14
[ , [15, 9], [15, 8], [15, 7], [15, 6], [16, 5], [16, 4], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 15
[ , [15, 10], [15, 8], [15, 8], [15, 7], [15, 6], [16, 5], [16, 4], [15, 4], [15, 4], 11, 11, [15, 2]],
#V   n = 16
[ , [15, 10], [15, 8], [15, 8], [15, 8], [16, 6], [15, 6], [16, 5], [16, 4], [15, 4], [15, 4], [14, 8], 11, [15, 2]],
#V   n = 17
[ , [15, 11], [15, 9], [15, 8], [15, 8], [16, 7], [16, 6], [15, 6], [16, 5], [16, 4], [15, 4], 12, 11, 11, [15, 2]],
#V   n = 18
[ , [15, 12], [15, 10], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], [15, 6], 13, [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 19
[ , [15, 12], [15, 10], [15, 9], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], [14, 6], 11, [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 20
[ , [15, 13], [15, 11], [15, 10], [15, 9], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], 11, 11, [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 21
[ , [15, 14], [15, 12], [15, 10], [15, 10], [16, 8], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 22
[ , [15, 14], [15, 12], [15, 11], [15, 10], [16, 9], [16, 8], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], [16, 5], [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 23
[ , [15, 15], [15, 12], [15, 12], [15, 11], [15, 10], [16, 9], [16, 8], [15, 8], [15, 8], [15, 8], [16, 7], [16, 6], [16, 5], [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 24
[ , [15, 16], [15, 13], [15, 12], [15, 12], [16, 10], [15, 10], 13, [16, 8], [15, 8], [15, 8], [15, 8], [16, 6], [16, 6], 13, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 25
[ , [15, 16], [15, 14], [15, 12], [15, 12], [16, 11], [16, 10], [0, 9, "YH1"], 11, [16, 8], [15, 8], [15, 8], 13, [16, 6], [0, 5, "Si"], 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 26
[ , [15, 17], [15, 14], [15, 13], [15, 12], [15, 12], [16, 11], [16, 10], 11, 11, [16, 8], [15, 8], [0, 7, "Pu2"], 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 27
[ , [15, 18], [15, 15], [15, 14], [15, 13], [15, 12], [15, 12], 13, [16, 10], 11, [16, 8], [16, 8], [15, 8], 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 28
[ , [15, 18], [15, 16], [15, 14], [15, 14], [0, 12, "BM"], [15, 12], [0, 11, "DM"], 11, [16, 10], 13, [16, 8], [16, 8], [15, 8], 13, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 29
[ , [15, 19], [15, 16], [15, 15], [15, 14], 12, [16, 12], [15, 12], 11, 11, [0, 9, "Ja"], 11, [16, 8], [16, 8], [0, 7, "Ja"], 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 30
[ , [15, 20], [15, 16], [15, 16], [15, 15], [15, 14], 13, [16, 12], [15, 12], 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 31
[ , [15, 20], [15, 17], [15, 16], [15, 16], [15, 15], [0, 13, "vT3"], 11, [16, 12], [15, 12], [16, 11], [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], 11, 11, 11, [15, 2]],
#V   n = 32
[ , [15, 21], [15, 18], [15, 16], [15, 16], [15, 16], [16, 14], 11, 11, [16, 12], [15, 12], 13, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [15, 4], [14, 16], 11, 11, [15, 2]],
#V   n = 33
[ , [15, 22], [15, 18], [15, 16], [15, 16], [15, 16], 13, [16, 14], [0, 12, "He"], 11, [16, 12], [0, 11, "Ja"], 11, [16, 10], 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], 12, 11, 11, 11, [15, 2]],
#V   n = 34
[ , [15, 22], [15, 19], [15, 17], [15, 16], [15, 16], [0, 15, "vT3"], 11, 12, 11, 11, [16, 12], 13, 11, [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], [0, 4, "BoV"], 11, [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 35
[ , [15, 23], [15, 20], [15, 18], [15, 16], [15, 16], [15, 16], 11, 11, 11, 11, 11, [0, 11, "Ja"], 11, 11, [16, 10], [0, 8, "Ja"], [16, 8], [16, 8], [16, 8], 11, 11, 11, 12, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 36
[ , [15, 24], [15, 20], [15, 18], [15, 17], [15, 16], [15, 16], [15, 16], [0, 14, "Ja"], 11, 11, 11, 11, 11, 11, [16, 10], 12, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 37
[ , [15, 24], [15, 20], [15, 19], [15, 18], [15, 17], [15, 16], [15, 16], 12, 11, 11, 11, 11, [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 38
[ , [15, 25], [15, 21], [15, 20], [15, 18], [15, 18], [16, 16], [15, 16], [15, 16], 13, 11, 11, 13, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 39
[ , [15, 26], [15, 22], [15, 20], [15, 19], [15, 18], [16, 17], [16, 16], [15, 16], [0, 15, "Bou"], 11, 11, [0, 13, "Ja"], 11, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 40
[ , [15, 26], [15, 22], [15, 20], [15, 20], [0, 18, "BM"], [15, 18], 13, [16, 16], [15, 16], 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 41
[ , [15, 27], [15, 23], [15, 21], [15, 20], 12, [16, 18], [0, 17, "BJV"], [16, 16], [16, 16], [15, 16], 11, 11, [16, 14], 11, [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 13, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 42
[ , [15, 28], [15, 24], [15, 22], [15, 20], [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], [15, 16], 13, 11, [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 13, 11, [16, 10], 11, 11, [16, 8], [16, 8], [0, 7, "Ja"], 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 43
[ , [15, 28], [15, 24], [15, 22], [15, 21], [15, 20], [15, 20], 13, [16, 18], [16, 17], [16, 16], [16, 16], [0, 15, "Ja"], 11, 11, [16, 14], [16, 13], [16, 12], [16, 12], [0, 11, "Ja"], 11, 11, [16, 10], 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 44
[ , [15, 29], [15, 24], [15, 23], [15, 22], [15, 21], [15, 20], [0, 19, "DM"], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], 13, [16, 12], [16, 12], 11, 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 45
[ , [15, 30], [15, 25], [15, 24], [15, 22], [15, 22], [16, 20], [15, 20], [16, 19], [16, 18], [16, 18], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [0, 13, "Ja"], 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 46
[ , [15, 30], [15, 26], [15, 24], [15, 23], [15, 22], [16, 21], [16, 20], [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 47
[ , [15, 31], [15, 26], [15, 24], [15, 24], [15, 23], [15, 22], [16, 21], [16, 20], [15, 20], 13, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 48
[ , [15, 32], [15, 27], [15, 24], [15, 24], [15, 24], [16, 22], [15, 22], [16, 20], [16, 20], [0, 19, "Ja"], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 13, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], [16, 10], [16, 9], [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 49
[ , [15, 32], [15, 28], [15, 25], [15, 24], [15, 24], [16, 23], [16, 22], [0, 20, "Ja"], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [0, 15, "Ja"], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], [16, 10], 13, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 50
[ , [15, 33], [15, 28], [15, 26], [15, 24], [15, 24], [15, 24], [16, 23], 12, 11, [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], [14, 14], 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 51
[ , [15, 34], [15, 28], [15, 26], [15, 25], [15, 24], [15, 24], [15, 24], [16, 22], 11, 11, [16, 20], [16, 20], [0, 18, "Ja"], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 52
[ , [15, 34], [15, 29], [15, 27], [15, 26], [15, 25], [15, 24], [15, 24], 13, [16, 22], 11, 11, [16, 20], 12, 11, [16, 18], [16, 18], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 53
[ , [15, 35], [15, 30], [15, 28], [15, 26], [15, 26], [16, 24], [15, 24], [0, 23, "Bro"], 11, [16, 22], 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 54
[ , [15, 36], [15, 30], [15, 28], [15, 27], [15, 26], 13, [16, 24], [15, 24], 11, 11, [16, 22], 13, [16, 20], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], 13, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 55
[ , [15, 36], [15, 31], [15, 28], [15, 28], [15, 27], [0, 25, "vT4"], [16, 24], [16, 24], [15, 24], 11, 11, [0, 21, "Ja"], [16, 20], [16, 20], [16, 20], 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], [0, 7, "Ja"], 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 56
[ , [15, 37], [15, 32], [15, 29], [15, 28], [15, 28], [16, 26], 13, [16, 24], [16, 24], [15, 24], 13, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 57
[ , [15, 38], [15, 32], [15, 30], [15, 28], [15, 28], 13, [0, 25, "BJV"], 11, [16, 24], [16, 24], [0, 23, "Ja"], 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 58
[ , [15, 38], [15, 32], [15, 30], [15, 29], [15, 28], [0, 27, "vT3"], [16, 26], 11, [16, 24], [16, 24], [16, 24], 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 13, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 59
[ , [15, 39], [15, 33], [15, 31], [15, 30], [15, 29], [15, 28], 13, [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], [0, 22, "Ja"], [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 13, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], [0, 10, "Ja"], 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [14, 24], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 60
[ , [15, 40], [15, 34], [15, 32], [15, 30], [15, 30], [0, 28, "Hel"], [0, 27, "BJV"], 11, [16, 26], 13, [16, 24], [16, 24], 12, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [0, 19, "Ja"], 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [14, 16], [16, 12], [16, 12], 12, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 61
[ , [15, 40], [15, 34], [15, 32], [15, 31], [15, 30], 12, [16, 28], 11, [16, 26], [14, 4], 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 12, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 62
[ , [15, 41], [15, 35], [15, 32], [15, 32], [15, 31], [15, 30], [16, 28], [16, 28], [16, 27], [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 63
[ , [15, 42], [15, 36], [15, 32], [15, 32], [15, 32], [15, 31], [0, 28, "BJV"], [16, 28], [16, 28], [0, 26, "Ja"], [16, 26], 11, [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, [15, 2]],
#V   n = 64
[ , [15, 42], [15, 36], [15, 33], [15, 32], [15, 32], [15, 32], 12, 11, [16, 28], 12, 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], [0, 22, "Ja"], 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], [14, 16], 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], [14, 32], 11, 11, 11, [15, 2]],
#V   n = 65
[ , [15, 43], [15, 36], [15, 34], [15, 32], [15, 32], [15, 32], [16, 30], 11, [16, 28], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], [16, 24], 12, 11, 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], 12, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 12, 11, 11, 11, 11, [15, 2]],
#V   n = 66
[ , [15, 44], [15, 37], [15, 34], [15, 32], [15, 32], [15, 32], 13, [16, 30], 13, [16, 28], [16, 28], 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 67
[ , [15, 44], [15, 38], [15, 35], [15, 33], [15, 32], [15, 32], [0, 31, "DHM"], 11, [0, 29, "Ja"], [16, 28], [16, 28], [16, 28], [16, 27], [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, [16, 12], [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 68
[ , [15, 45], [15, 38], [15, 36], [15, 34], [15, 32], [15, 32], [15, 32], 13, [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], [0, 26, "Ja"], [16, 26], [16, 26], [0, 24, "Ja"], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, 11, [16, 10], [0, 8, "Ja"], [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 69
[ , [15, 46], [15, 39], [15, 36], [15, 34], [15, 33], [15, 32], [15, 32], [0, 31, "BGV"], 11, [16, 30], [16, 29], [16, 28], [16, 28], 12, 11, [16, 26], 12, [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, 11, [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], 11, 11, 11, 12, 11, [16, 8], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 70
[ , [15, 46], [15, 40], [15, 36], [15, 35], [15, 34], [15, 33], [15, 32], [15, 32], 11, [16, 30], [16, 30], 13, [16, 28], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], [16, 12], [0, 10, "Ja"], 11, [16, 10], 11, 11, [16, 8], [16, 8], [16, 8], [0, 6, "Ja"], 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 71
[ , [15, 47], [15, 40], [15, 37], [15, 36], [15, 34], [15, 34], [16, 32], [15, 32], [15, 32], [16, 31], [16, 30], [0, 29, "Ja"], [16, 28], [16, 28], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], 12, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 12, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 72
[ , [15, 48], [15, 40], [15, 38], [15, 36], [15, 35], [15, 34], 13, [16, 32], [15, 32], [15, 32], 13, [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], [0, 26, "Ja"], [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [16, 19], [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 73
[ , [15, 48], [15, 41], [15, 38], [15, 36], [15, 36], [0, 34, "Hel"], [0, 33, "BJV"], [16, 32], [16, 32], [15, 32], [0, 31, "Ja"], 11, [16, 30], [16, 29], [16, 28], [16, 28], 12, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 13, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 74
[ , [15, 49], [15, 42], [15, 39], [15, 37], [15, 36], 12, [16, 34], [16, 33], [16, 32], [16, 32], [15, 32], 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [0, 20, "Ja"], [16, 20], [16, 20], [0, 19, "Bro"], 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], [16, 14], [0, 12, "Ja"], [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 75
[ , [15, 50], [15, 42], [15, 40], [15, 38], [15, 36], [15, 36], 13, [16, 34], [16, 33], [16, 32], [16, 32], [15, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], [0, 22, "Ja"], 11, [16, 22], 12, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 12, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 76
[ , [15, 50], [15, 43], [15, 40], [15, 38], [15, 37], [15, 36], [0, 35, "BJV"], [16, 34], [16, 34], [14, 4], [16, 32], [16, 32], [15, 32], [0, 30, "Ja"], [16, 30], [16, 30], [0, 28, "Ja"], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], 12, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 77
[ , [15, 51], [15, 44], [15, 40], [15, 39], [15, 38], [16, 36], [15, 36], [16, 35], [16, 34], 12, 11, [16, 32], [16, 32], 12, 11, [16, 30], 12, [16, 28], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 78
[ , [15, 52], [15, 44], [15, 40], [15, 40], [15, 38], [16, 37], [16, 36], [15, 36], [16, 35], [16, 34], 11, [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], [0, 14, "Ja"], 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 79
[ , [15, 52], [15, 44], [15, 41], [15, 40], [15, 39], [15, 38], 13, [16, 36], [15, 36], [0, 34, "Ja"], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], [0, 24, "Ja"], [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [0, 16, "Ja"], [16, 16], [16, 16], 12, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 80
[ , [15, 53], [15, 45], [15, 42], [15, 40], [15, 40], [16, 38], [0, 37, "BJV"], [16, 36], [16, 36], 12, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], [0, 30, "Ja"], [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], [0, 26, "Ja"], 11, [16, 26], 12, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], 12, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], [0, 10, "Ja"], 11, 11, [16, 10], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 81
[ , [15, 54], [15, 46], [15, 42], [15, 40], [15, 40], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 12, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 12, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], 12, 11, 11, 11, [16, 10], [0, 8, "Ja"], 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 82
[ , [15, 54], [15, 46], [15, 43], [15, 41], [15, 40], [15, 40], 13, [16, 38], 13, [16, 36], [16, 36], [16, 35], [16, 34], [16, 34], 13, [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 20], [0, 18, "Ja"], 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], 11, 11, 11, 11, 12, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 83
[ , [15, 55], [15, 47], [15, 44], [15, 42], [15, 40], [15, 40], [0, 39, "DHM"], [16, 38], [0, 37, "Ja"], 11, [16, 36], [16, 36], [16, 35], [16, 34], [14, 6], 11, [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], 13, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], [0, 20, "Ja"], [16, 20], [16, 20], 12, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], [0, 12, "Ja"], [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 84
[ , [15, 56], [15, 48], [15, 44], [15, 42], [15, 41], [15, 40], [15, 40], [16, 39], [16, 38], 11, [16, 36], [16, 36], [16, 36], [0, 34, "Ja"], [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, [16, 30], [0, 29, "Bro"], 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], 12, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 12, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 85
[ , [15, 56], [15, 48], [15, 44], [15, 43], [15, 42], [0, 40, "Hel"], [15, 40], [15, 40], [0, 38, "Ja"], [16, 38], [16, 37], [16, 36], [16, 36], 12, 11, [16, 34], 11, [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, [16, 24], [16, 24], [16, 24], 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, [16, 16], [16, 16], [16, 16], 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 86
[ , [15, 57], [15, 48], [15, 45], [15, 44], [15, 42], 12, [16, 40], [15, 40], 12, 11, [16, 38], [0, 36, "Ja"], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 24], 13, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 87
[ , [15, 58], [15, 49], [15, 46], [15, 44], [15, 43], [15, 42], 13, [16, 40], [15, 40], [0, 38, "Ja"], [16, 38], 12, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 13, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], [16, 25], [16, 24], [16, 24], [0, 23, "Bro"], 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 88
[ , [15, 58], [15, 50], [15, 46], [15, 44], [15, 44], [0, 42, "Hel"], [0, 41, "BJV"], 11, [16, 40], 12, 11, [16, 38], 11, [16, 36], [16, 36], [16, 36], 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [0, 31, "Bro"], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, [16, 26], [16, 26], 13, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [16, 16], 13, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 89
[ , [15, 59], [15, 50], [15, 47], [15, 45], [15, 44], 12, [16, 42], 11, [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 13, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, [16, 26], [0, 25, "Bro"], 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, [16, 18], [16, 18], [16, 17], [16, 16], [16, 16], [0, 15, "BK"], 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [16, 6], 13, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 90
[ , [15, 60], [15, 51], [15, 48], [15, 46], [15, 44], [15, 44], 13, [16, 42], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [0, 35, "LP"], 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 13, 11, [16, 18], [16, 18], 13, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, [0, 5, "BK"], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 91
[ , [15, 60], [15, 52], [15, 48], [15, 46], [15, 45], [15, 44], [0, 43, "DMa"], 11, [16, 41], [16, 40], [16, 40], [16, 40], 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], 13, [16, 32], [16, 32], 11, 11, 11, [16, 30], 13, 11, [16, 28], [16, 28], 13, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, [16, 20], [16, 20], [0, 19, "BK"], 11, 11, [16, 18], [0, 17, "Jo2"], 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], [0, 6, "Joplus"], 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 92
[ , [15, 61], [15, 52], [15, 48], [15, 47], [15, 46], [15, 45], [15, 44], 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 13, [16, 38], [16, 38], 13, [16, 36], [16, 36], 13, 11, [16, 34], [0, 33, "Bro"], 11, [16, 32], [16, 32], 11, 11, 11, [0, 29, "Bro"], 11, 11, [16, 28], [0, 27, "Bro"], 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], [16, 21], [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], 12, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 93
[ , [15, 62], [15, 52], [15, 48], [15, 48], [15, 46], [15, 46], [16, 44], [15, 44], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [0, 39, "Bro"], 11, [16, 38], [0, 37, "Bro"], 11, [16, 36], [0, 35, "Bro"], 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 13, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], [16, 21], [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 94
[ , [15, 62], [15, 53], [15, 49], [15, 48], [15, 47], [15, 46], 13, [16, 44], [16, 43], [16, 42], [16, 42], [0, 40, "Ja"], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [0, 31, "Bro"], 11, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 22], 13, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 95
[ , [15, 63], [15, 54], [15, 50], [15, 48], [15, 48], [15, 47], [0, 45, "DHM"], 11, [16, 44], 13, [16, 42], 12, [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 13, 11, [16, 22], [0, 21, "BK"], 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 11, 11, [16, 12], [16, 12], 13, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 96
[ , [15, 64], [15, 54], [15, 50], [15, 48], [15, 48], [15, 48], [16, 46], [0, 44, "Ja"], [16, 44], [0, 43, "Bro"], 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 13, [16, 36], [16, 36], 11, 11, 11, [16, 34], 13, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, [16, 26], 13, 11, [16, 24], [0, 23, "LP"], 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 13, 11, [16, 12], [0, 11, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 97
[ , [15, 64], [15, 55], [15, 51], [15, 48], [15, 48], [15, 48], 13, 12, [16, 44], [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 13, 11, [0, 37, "Bro"], 11, [16, 36], [16, 36], 13, 11, 11, [0, 33, "Bro"], 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 13, 11, 11, [0, 25, "Bro"], 11, 11, [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 13, 11, 11, [0, 13, "BK"], 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 98
[ , [15, 65], [15, 56], [15, 52], [15, 49], [15, 48], [15, 48], [0, 47, "DM"], 11, 13, [16, 44], [16, 44], 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [0, 39, "Bro"], 11, 11, 11, 11, [16, 36], [0, 35, "Bro"], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [0, 27, "Bro"], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, [16, 16], [16, 16], [0, 15, "LP"], 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 99
[ , [15, 66], [15, 56], [15, 52], [15, 50], [15, 48], [15, 48], [15, 48], 13, [0, 45, "Ja"], 11, [16, 44], [16, 44], [0, 42, "Ja"], [16, 42], [16, 42], 13, [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], [16, 32], 13, 11, 11, [16, 30], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 13, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 100
[ , [15, 66], [15, 56], [15, 52], [15, 50], [15, 49], [15, 48], [15, 48], [0, 47, "Bro"], [16, 46], 11, 11, [16, 44], 12, 11, [16, 42], [0, 41, "Bro"], 11, [16, 40], [16, 40], 13, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], [0, 31, "Bro"], 11, 11, 11, [16, 30], 13, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 13, 11, 11, [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, [0, 9, "LP"], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 101
[ , [15, 67], [15, 57], [15, 53], [15, 51], [15, 50], [15, 49], [15, 48], [15, 48], 13, [16, 46], 11, [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], [0, 39, "Bro"], 11, 11, [16, 38], 13, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, [0, 29, "Bro"], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, [16, 20], [16, 20], [0, 19, "Jo2"], 11, 11, [16, 18], [16, 18], 13, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 102
[ , [15, 68], [15, 58], [15, 54], [15, 52], [15, 50], [15, 50], [16, 48], [15, 48], [0, 47, "Bro"], 11, [16, 46], [0, 44, "Ja"], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, [0, 37, "Bro"], 11, 11, [16, 36], 11, 11, 11, [16, 34], 13, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 13, [16, 20], [16, 20], 11, 11, 11, [16, 18], [0, 17, "LP"], 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 103
[ , [15, 68], [15, 58], [15, 54], [15, 52], [15, 51], [15, 50], [16, 48], [16, 48], [15, 48], 13, 11, 12, 11, [16, 44], [16, 44], 13, 11, [16, 42], 13, 11, [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 13, 11, 11, [0, 33, "Bro"], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [0, 21, "BK"], 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 104
[ , [15, 69], [15, 59], [15, 55], [15, 52], [15, 52], [15, 51], [16, 49], [16, 48], [16, 48], [0, 47, "Ja"], 11, [16, 46], 11, [16, 44], [16, 44], [0, 43, "Bro"], 11, 11, [0, 41, "Bro"], 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [0, 35, "Bro"], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 13, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 105
[ , [15, 70], [15, 60], [15, 56], [15, 53], [15, 52], [15, 52], [16, 50], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, 11, 11, [16, 40], [16, 40], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [0, 23, "BK"], 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 106
[ , [15, 70], [15, 60], [15, 56], [15, 54], [15, 52], [15, 52], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 13, [16, 44], [16, 44], 11, 11, 11, 11, 11, [16, 40], [0, 39, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 13, 11, 11, [16, 26], 13, 11, [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 107
[ , [15, 71], [15, 60], [15, 56], [15, 54], [15, 53], [15, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 13, [16, 46], [0, 45, "Bro"], 11, [16, 44], [16, 44], 13, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 13, 11, [16, 28], [0, 27, "LP"], 11, 11, 11, [0, 25, "BK"], 11, 11, [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, [16, 14], 13, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 108
[ , [15, 72], [15, 61], [15, 56], [15, 55], [15, 54], [15, 53], [15, 52], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [0, 47, "Ja"], 11, [16, 46], 11, 11, [16, 44], [0, 43, "Bro"], 11, 11, [16, 42], 13, 11, [16, 40], 11, 11, 11, [0, 37, "Bro"], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [16, 32], 13, 11, 11, [0, 29, "LP"], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 13, 11, 11, [0, 13, "BK"], 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 109
[ , [15, 72], [15, 62], [15, 57], [15, 56], [15, 54], [15, 54], [16, 52], [16, 51], [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, [16, 44], [16, 44], 11, 11, 11, [0, 41, "Bro"], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 33, "Bro"], 11, 11, 11, [0, 31, "Bro"], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [0, 15, "BK"], 11, 11, 11, 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 110
[ , [15, 73], [15, 62], [15, 58], [15, 56], [15, 55], [15, 54], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 13, 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 13, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [16, 22], 13, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], [16, 12], [0, 10, "Joplus"], 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 111
[ , [15, 74], [15, 63], [15, 58], [15, 56], [15, 56], [15, 55], [16, 53], [16, 52], [16, 52], [0, 50, "Ja"], [16, 50], [16, 49], [16, 48], [16, 48], [0, 47, "Bro"], 11, 11, [16, 46], 13, [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [0, 39, "Bro"], 11, 11, 11, 11, 11, 11, [16, 36], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, [0, 21, "BK"], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 13, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 12, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 112
[ , [15, 74], [15, 64], [15, 59], [15, 56], [15, 56], [15, 56], [16, 54], [16, 52], [16, 52], 12, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [0, 45, "Bro"], 11, [16, 44], [16, 44], 13, 11, 11, 13, 11, 11, 11, 11, 11, 11, 13, 11, 11, [0, 35, "Bro"], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 13, 11, 11, [0, 17, "BK"], 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 113
[ , [15, 75], [15, 64], [15, 60], [15, 57], [15, 56], [15, 56], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], [0, 43, "Bro"], 11, 11, [0, 41, "Bro"], 11, 11, 11, 11, 11, 11, [0, 37, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 13, 11, 11, 11, 11, 11, [16, 20], [0, 19, "Jo2"], 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 114
[ , [15, 76], [15, 64], [15, 60], [15, 58], [15, 56], [15, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], 13, [16, 48], [16, 48], 11, 11, [16, 46], 13, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 26], 13, 11, [16, 24], [0, 23, "BK"], 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], [0, 6, "Joplus"], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 115
[ , [15, 76], [15, 65], [15, 60], [15, 58], [15, 57], [15, 56], [15, 56], [16, 54], [16, 54], 13, [16, 52], [16, 52], 13, [16, 50], [0, 49, "Bro"], 11, [16, 48], [16, 48], 13, 11, [0, 45, "Bro"], 11, 11, [16, 44], 13, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [0, 25, "BK"], 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 12, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 116
[ , [15, 77], [15, 66], [15, 61], [15, 59], [15, 58], [15, 57], [15, 56], [16, 55], [16, 54], [0, 53, "Ja"], [16, 52], [16, 52], [0, 51, "Ja"], 11, [16, 50], 11, 11, [16, 48], [0, 47, "Bro"], 11, 11, 11, 11, 11, [0, 43, "Bro"], 11, 11, 11, 11, 11, 11, [16, 40], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 13, 11, 11, 11, 11, 11, 11, [16, 28], 13, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 117
[ , [15, 78], [15, 66], [15, 62], [15, 60], [15, 58], [15, 58], [16, 56], [15, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], 11, 11, [16, 50], 11, [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [0, 39, "Bro"], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 13, 11, 11, [0, 31, "LP"], 11, 11, 11, 11, 13, 11, [16, 28], [0, 27, "BK"], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 118
[ , [15, 78], [15, 67], [15, 62], [15, 60], [15, 59], [15, 58], 13, [16, 56], [15, 56], 13, [16, 54], 13, [16, 52], [16, 52], 13, 11, [16, 50], [16, 49], [16, 48], [16, 48], 13, 11, 11, 11, 11, 11, 11, 11, 11, [0, 41, "Bro"], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [0, 35, "Bro"], 11, 11, 11, [0, 33, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 29, "BK"], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 13, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 119
[ , [15, 79], [15, 68], [15, 63], [15, 60], [15, 60], [15, 59], [0, 57, "DMa"], [16, 56], [16, 56], [0, 55, "Bro"], [16, 54], [0, 53, "Ja"], 11, [16, 52], [0, 51, "Bro"], 11, 11, [16, 50], 13, [16, 48], [0, 47, "Bro"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 37, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, [0, 9, "BK"], 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 120
[ , [15, 80], [15, 68], [15, 64], [15, 61], [15, 60], [15, 60], [16, 58], [16, 56], [16, 56], [16, 56], 13, [16, 54], 11, 11, [16, 52], 11, 11, [16, 50], [0, 49, "Bro"], 11, [16, 48], 11, 11, 11, [0, 45, "Bro"], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, [16, 22], 13, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [16, 16], 13, 11, 11, 11, 13, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 121
[ , [15, 80], [15, 68], [15, 64], [15, 62], [15, 60], [15, 60], 13, [16, 57], [16, 56], [16, 56], [0, 55, "Bro"], 11, [16, 54], 11, [16, 52], [16, 52], 13, 11, [16, 50], 13, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 13, 11, 11, [0, 21, "BK"], 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], 11, 11, [16, 16], [0, 15, "BK"], 11, 11, 11, [0, 13, "LP"], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 122
[ , [15, 81], [15, 69], [15, 64], [15, 62], [15, 61], [15, 60], 13, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], 13, [16, 52], [0, 51, "Bro"], 11, 11, [0, 49, "Bro"], 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [0, 43, "Bro"], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], [0, 23, "LP"], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, [16, 18], [0, 16, "Joplus"], 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 123
[ , [15, 82], [15, 70], [15, 64], [15, 63], [15, 62], [15, 61], [0, 59, "BJV"], [16, 58], [16, 58], [16, 56], [16, 56], [16, 56], 13, 11, [0, 53, "Bro"], 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [0, 39, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 13, 11, 11, 12, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 124
[ , [15, 82], [15, 70], [15, 65], [15, 64], [15, 62], [15, 62], 12, [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [0, 55, "Ja"], 11, [16, 54], 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [0, 47, "Bro"], 11, 11, 11, 13, 11, 11, 11, 11, 11, [0, 41, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 13, 11, 11, [16, 26], 13, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [0, 19, "BK"], 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 125
[ , [15, 83], [15, 71], [15, 66], [15, 64], [15, 63], [15, 62], 12, [16, 60], 13, [16, 58], 13, [16, 56], [16, 56], 11, 11, [16, 54], 13, [16, 52], [16, 52], 13, 11, 11, 11, 11, 11, 11, 11, 11, [0, 45, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [0, 27, "BK"], 11, 11, 11, [0, 25, "BK"], 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 13, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 13, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 126
[ , [15, 84], [15, 72], [15, 66], [15, 64], [15, 64], [15, 63], [15, 62], [16, 60], [0, 59, "Ja"], [16, 58], [0, 57, "Ja"], 11, [16, 56], [16, 56], 13, 11, [0, 53, "Bro"], 11, [16, 52], [0, 51, "Bro"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 13, 11, 11, [16, 32], 11, 11, 11, 11, 13, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [0, 11, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, [0, 5, "BK"], 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 127
[ , [15, 84], [15, 72], [15, 67], [15, 64], [15, 64], [15, 64], [15, 63], [16, 60], [16, 60], [16, 59], [16, 58], 11, [16, 56], [16, 56], [0, 55, "Bro"], 11, 11, 11, 11, [16, 52], 11, 11, 11, [0, 49, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 43, "Bro"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 35, "BK"], 11, 11, 11, [0, 33, "LP"], 11, 11, 11, [16, 32], 11, 11, 11, [0, 29, "BK"], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 128
[ , [15, 85], [15, 72], [15, 68], [15, 64], [15, 64], [15, 64], [15, 64], [16, 61], [16, 60], [16, 60], 13, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], 11, 11, [16, 52], 13, 11, 11, 11, 11, 11, [16, 48], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 13, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], [14, 64], 11, 11, 11, 11, [15, 2]],
#V   n = 129
[ , [15, 86], [15, 73], [15, 68], [15, 65], [15, 64], [15, 64], [15, 64], [16, 62], [16, 60], [16, 60], [0, 59, "Ja"], 11, [16, 58], [16, 57], [16, 56], [16, 56], 13, 11, [16, 54], 13, 11, [0, 51, "BK"], 11, 11, 11, 13, 11, 11, [0, 47, "LP"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 39, "LP"], 11, 11, 11, [0, 37, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 31, "LP"], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 12, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 130
[ , [15, 86], [15, 74], [15, 68], [15, 66], [15, 64], [15, 64], [15, 64], [16, 62], [16, 61], [16, 60], [16, 60], 11, [16, 58], [16, 58], 13, [16, 56], [0, 55, "BK"], 11, 11, [0, 53, "BK"], 11, 11, 11, 11, 11, [0, 49, "BK"], 11, 11, 11, 11, 11, 11, [0, 45, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 13, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 131
[ , [15, 87], [15, 74], [15, 69], [15, 66], [15, 64], [15, 64], [15, 64], 13, [16, 62], [0, 60, "Ja"], [16, 60], [16, 60], 13, [16, 58], [0, 57, "BK"], 11, [16, 56], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [0, 23, "LP"], 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 132
[ , [15, 88], [15, 75], [15, 70], [15, 67], [15, 65], [15, 64], [15, 64], [0, 63, "Gur"], [16, 62], 12, 11, [16, 60], [0, 59, "Ja"], 11, [16, 58], 13, 11, [16, 56], 11, 11, [0, 53, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 47, "LP"], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [0, 41, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 13, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 133
[ , [15, 88], [15, 76], [15, 70], [15, 68], [15, 66], [15, 64], [15, 64], [15, 64], [16, 63], [16, 62], [0, 60, "Ja"], [16, 60], [16, 60], 11, 11, [0, 57, "LP"], 11, [16, 56], [16, 56], 13, 11, 11, 11, 11, [16, 52], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 43, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [0, 25, "LP"], 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [16, 20], 11, 11, 11, 12, 11, 11, 11, [16, 16], [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 134
[ , [15, 89], [15, 76], [15, 71], [15, 68], [15, 66], [15, 65], [15, 64], [15, 64], [15, 64], [0, 62, "Ja"], 12, 11, [16, 60], [16, 60], 13, 11, 11, 11, [16, 56], [0, 55, "BK"], 11, 11, 11, 11, 11, [0, 51, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 135
[ , [15, 90], [15, 76], [15, 72], [15, 68], [15, 67], [15, 66], [15, 65], [15, 64], [15, 64], 12, 11, 11, 11, [16, 60], [0, 59, "BK"], 11, 11, 11, 11, [16, 56], 13, 11, 11, 11, 11, 11, 11, 11, 11, [0, 49, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [16, 22], 11, 11, [16, 20], [16, 20], [0, 18, "Jo"], 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 136
[ , [15, 90], [15, 77], [15, 72], [15, 69], [15, 68], [15, 66], [15, 66], [16, 64], [15, 64], [15, 64], [0, 62, "Ja"], [16, 62], 11, 11, [16, 60], 13, 11, [16, 58], 11, 11, [0, 55, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [16, 22], 11, 11, [16, 20], 12, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 137
[ , [15, 91], [15, 78], [15, 72], [15, 70], [15, 68], [15, 67], [15, 66], [16, 64], [16, 64], [15, 64], 12, 11, [16, 62], 11, [16, 60], [0, 59, "BK"], 11, 11, [16, 58], 13, 11, 11, 11, 11, [0, 53, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [16, 22], 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 12, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 138
[ , [15, 92], [15, 78], [15, 72], [15, 70], [15, 68], [15, 68], [0, 66, "Hel"], [16, 65], [16, 64], [16, 64], [15, 64], 11, 11, [16, 62], 13, [16, 60], 11, 11, 11, [0, 57, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [16, 22], [0, 20, "Jo"], 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 139
[ , [15, 92], [15, 79], [15, 73], [15, 71], [15, 69], [15, 68], 12, [16, 66], [16, 65], [16, 64], [16, 64], [15, 64], 13, 11, [0, 61, "BK"], 11, [16, 60], 11, 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, [0, 51, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 12, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 140
[ , [15, 93], [15, 80], [15, 74], [15, 72], [15, 70], [15, 68], [15, 68], [16, 66], [16, 66], [16, 65], [16, 64], [16, 64], [0, 63, "Ja"], 11, [16, 62], 13, 11, [16, 60], 11, 11, [0, 57, "BK"], 11, 11, [16, 56], 13, 11, [0, 53, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 141
[ , [15, 94], [15, 80], [15, 74], [15, 72], [15, 70], [15, 69], [15, 68], [16, 67], [16, 66], [16, 66], [16, 64], [16, 64], [16, 64], 11, 11, [0, 61, "BK"], 11, [16, 60], [16, 60], 13, 11, 11, 11, 11, [0, 55, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 142
[ , [15, 94], [15, 80], [15, 75], [15, 72], [15, 71], [15, 70], [16, 68], [15, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], [16, 64], 13, 11, 11, 11, [16, 60], [0, 59, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 12, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 143
[ , [15, 95], [15, 81], [15, 76], [15, 72], [15, 72], [15, 70], [16, 69], [16, 68], [15, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], [0, 63, "BK"], 11, 11, 11, 11, [16, 60], 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 144
[ , [15, 96], [15, 82], [15, 76], [15, 73], [15, 72], [15, 71], [15, 70], [16, 68], [16, 68], [15, 68], [16, 66], [16, 66], [16, 65], [16, 64], [16, 64], 13, 11, [16, 62], 11, 11, [0, 59, "BK"], 11, 11, 11, 13, 11, [0, 55, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 145
[ , [15, 96], [15, 82], [15, 76], [15, 74], [15, 72], [15, 72], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 66], [16, 65], [16, 64], [0, 63, "BK"], 11, 11, [16, 62], 13, 11, 13, 11, 11, [0, 57, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [0, 18, "Jo"], 11, 11, 11, [0, 16, "Jo"], 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, 11, [16, 8], [16, 8], [0, 6, "Jo"], 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 146
[ , [15, 97], [15, 83], [15, 77], [15, 74], [15, 72], [15, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 66], 13, [16, 64], 13, 11, 11, [0, 61, "BK"], 11, [0, 59, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], 12, 11, 11, 11, 12, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 12, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 147
[ , [15, 98], [15, 84], [15, 78], [15, 75], [15, 73], [15, 72], [15, 72], [16, 70], [16, 70], [0, 68, "Ja"], [16, 68], [16, 68], [0, 66, "Ja"], [16, 66], [0, 65, "BK"], [16, 64], [0, 63, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, [0, 57, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, 11, [0, 20, "Jo"], 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, [16, 16], [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 148
[ , [15, 98], [15, 84], [15, 78], [15, 76], [15, 74], [15, 72], [15, 72], [16, 71], [16, 70], 12, [16, 68], [16, 68], 12, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, [0, 61, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, 12, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 149
[ , [15, 99], [15, 84], [15, 79], [15, 76], [15, 74], [15, 73], [15, 72], [15, 72], [16, 71], [16, 70], [0, 68, "Ja"], [16, 68], [16, 68], 11, 11, [16, 66], 13, [16, 64], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, [0, 55, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, [16, 28], [16, 28], [16, 28], 11, 11, [16, 26], 11, 11, [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 150
[ , [15, 100], [15, 85], [15, 80], [15, 76], [15, 75], [15, 74], [16, 72], [15, 72], [15, 72], [0, 70, "Ja"], 12, 11, [16, 68], [16, 68], 13, [16, 66], 13, 11, [16, 64], 11, 11, [0, 61, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], [16, 29], [16, 28], [16, 28], [16, 28], [0, 26, "Jo"], 11, [16, 26], 11, 11, [16, 24], [16, 24], [0, 22, "Jo"], 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 151
[ , [15, 100], [15, 86], [15, 80], [15, 77], [15, 76], [15, 74], [16, 73], [16, 72], [15, 72], 12, [16, 70], 11, 11, [16, 68], [0, 67, "BK"], 11, [0, 65, "BK"], 11, 11, [16, 64], 13, 11, 11, 11, 11, [0, 59, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 30], [16, 29], [16, 28], [16, 28], 12, 11, 11, [16, 26], 11, 11, [16, 24], 12, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 152
[ , [15, 101], [15, 86], [15, 80], [15, 78], [15, 76], [15, 75], [15, 74], [16, 72], [16, 72], [15, 72], [0, 70, "Ja"], [16, 70], 11, 11, [16, 68], 13, 11, 11, 11, 11, [0, 63, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 153
[ , [15, 102], [15, 87], [15, 80], [15, 78], [15, 76], [15, 76], [16, 74], [16, 73], [16, 72], [16, 72], 12, 11, [16, 70], 11, [16, 68], [0, 67, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], [14, 22], 11, 11, [16, 46], 13, 11, [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, 11, [16, 26], 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 154
[ , [15, 102], [15, 88], [15, 81], [15, 79], [15, 77], [15, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 13, 11, [16, 70], 13, [16, 68], 13, 11, 11, 11, 11, [0, 63, "BK"], 11, 11, 11, 13, 11, [0, 59, "BK"], 11, 11, 11, 13, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 13, 11, 11, 12, 11, 11, 11, [14, 24], 11, 11, [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, 11, [16, 26], [0, 24, "Jo"], 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 155
[ , [15, 103], [15, 88], [15, 82], [15, 80], [15, 78], [15, 76], [15, 76], [16, 74], [16, 74], [16, 72], [16, 72], [0, 71, "Ja"], 11, 11, [0, 69, "BK"], 11, [0, 67, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, [0, 61, "BK"], 11, 11, 11, 11, 11, [0, 57, "BK"], 11, 11, 11, [0, 55, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, [14, 20], 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 28], 11, 11, 11, 12, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 156
[ , [15, 104], [15, 88], [15, 82], [15, 80], [15, 78], [15, 77], [15, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], 13, 11, 11, 11, 11, [0, 65, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], [16, 30], [0, 28, "Jo"], [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 157
[ , [15, 104], [15, 89], [15, 83], [15, 80], [15, 79], [15, 78], [16, 76], [15, 76], [16, 75], [16, 74], [0, 72, "Ja"], [16, 72], [16, 72], 11, 11, [0, 69, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 18], 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 12, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 158
[ , [15, 105], [15, 90], [15, 84], [15, 80], [15, 80], [15, 78], [16, 77], [16, 76], [15, 76], [16, 74], 12, 11, [16, 72], [16, 72], 13, 11, 13, 11, [16, 68], 11, 11, [0, 65, "BK"], 11, 11, 11, 13, 11, [0, 61, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [16, 52], 13, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 12, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 159
[ , [15, 106], [15, 90], [15, 84], [15, 80], [15, 80], [15, 79], [15, 78], [16, 76], [16, 76], [16, 75], [16, 74], 11, [16, 72], [16, 72], [0, 71, "BK"], 11, [0, 69, "BK"], 11, 11, [16, 68], 11, 11, 11, 11, 11, [0, 63, "BK"], 11, 11, 11, 11, 11, [0, 59, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], [14, 20], 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], [0, 26, "Jo"], 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 160
[ , [15, 106], [15, 91], [15, 84], [15, 81], [15, 80], [15, 80], [16, 78], [16, 77], [16, 76], [16, 76], 13, [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, 11, 11, [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], 12, 11, 11, 11, 11, 11, 11, [16, 24], [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 161
[ , [15, 107], [15, 92], [15, 85], [15, 82], [15, 80], [15, 80], [16, 79], [16, 78], [16, 77], [16, 76], [0, 75, "Ja"], 11, [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, 11, [16, 68], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, [16, 40], [16, 40], [16, 40], 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], [0, 30, "Jo"], 11, [16, 30], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 162
[ , [15, 108], [15, 92], [15, 86], [15, 82], [15, 80], [15, 80], [15, 80], [16, 78], [16, 78], [16, 76], [16, 76], [0, 74, "Ja"], [16, 74], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, 11, [16, 68], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], [16, 44], 13, 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 12, 11, 11, [16, 30], 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 16], [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 163
[ , [15, 108], [15, 92], [15, 86], [15, 83], [15, 81], [15, 80], [15, 80], [16, 79], [16, 78], 13, [16, 76], 12, 11, [16, 74], [16, 74], 13, [16, 72], [16, 72], 11, 11, 11, 11, [16, 68], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], [14, 30], 11, 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], [0, 28, "Jo"], [16, 28], [16, 28], 11, 11, 11, 11, [0, 24, "Jo"], 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 164
[ , [15, 109], [15, 93], [15, 87], [15, 84], [15, 82], [15, 80], [15, 80], [15, 80], 13, [0, 77, "Ja"], [16, 76], [16, 76], 11, 11, [16, 74], [14, 6], 11, [16, 72], [16, 72], 11, [16, 70], 11, 11, [16, 68], [16, 68], [14, 10], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [14, 36], 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, 12, 11, [16, 28], [16, 28], 11, 11, 11, 12, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 165
[ , [15, 110], [15, 94], [15, 88], [15, 84], [15, 82], [15, 81], [15, 80], [15, 80], [0, 79, "Gur"], [16, 78], [0, 76, "Ja"], [16, 76], [16, 76], 11, 11, [16, 74], 11, [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], 11, 11, [16, 68], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, [16, 42], [16, 42], [14, 34], [16, 40], [16, 40], 12, 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 166
[ , [15, 110], [15, 94], [15, 88], [15, 84], [15, 83], [15, 82], [16, 80], [15, 80], [15, 80], [0, 78, "Ja"], 12, 11, [16, 76], [16, 76], 11, 11, [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [14, 8], [16, 70], 11, [16, 68], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 12, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], [16, 38], [14, 38], [16, 36], [16, 36], [16, 36], 13, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 167
[ , [15, 111], [15, 95], [15, 88], [15, 85], [15, 84], [15, 82], [16, 81], [16, 80], [15, 80], 12, [16, 78], 11, 11, [16, 76], [16, 76], 11, 11, [16, 74], [16, 73], [16, 72], [16, 72], 12, 11, [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, 11, 11, 11, [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 12, 11, [16, 36], [16, 36], [14, 40], 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], 11, 11, [16, 30], 11, 11, [16, 28], [16, 28], [0, 26, "Jo"], 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 168
[ , [15, 112], [15, 96], [15, 88], [15, 86], [15, 84], [15, 83], [15, 82], [16, 80], [16, 80], [15, 80], [0, 78, "Ja"], [16, 78], [0, 76, "Ja"], 11, [16, 76], [16, 76], 13, [16, 74], [16, 74], 13, [16, 72], [16, 72], 13, 11, [16, 70], [14, 10], [16, 68], [16, 68], 11, 11, 11, 11, 11, [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], [16, 32], [0, 30, "Jo"], 11, [16, 30], 11, 11, [16, 28], 12, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 169
[ , [15, 112], [15, 96], [15, 89], [15, 86], [15, 84], [15, 84], [16, 82], [16, 81], [16, 80], [16, 80], 12, 11, 12, 11, [16, 76], [16, 76], 13, 11, [16, 74], 13, [16, 72], [16, 72], 13, 11, [16, 70], 12, 11, [16, 68], [16, 68], 11, 11, 11, [14, 12], 11, [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 12, 11, 11, [16, 30], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, [16, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 170
[ , [15, 113], [15, 96], [15, 90], [15, 87], [15, 85], [15, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [0, 78, "Ja"], 11, 11, 11, [16, 76], 13, 11, 11, 13, 11, [16, 72], 13, 11, 11, [16, 70], 11, 11, [16, 68], [16, 68], 11, 11, 12, 11, 11, [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 12, 11, 11, 11, [16, 20], [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 171
[ , [15, 114], [15, 97], [15, 90], [15, 88], [15, 86], [15, 84], [15, 84], [16, 82], [16, 82], [16, 80], [16, 80], 12, 11, 11, 11, 11, [0, 75, "BK"], 11, 11, [0, 73, "BK"], 11, 11, [0, 71, "BK"], 11, 11, 11, [16, 70], 11, 11, [16, 68], [16, 68], 13, 11, 11, 11, 11, [16, 64], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], [0, 28, "Jo"], 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 172
[ , [15, 114], [15, 98], [15, 91], [15, 88], [15, 86], [15, 85], [15, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, [16, 78], 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, [16, 68], [16, 68], 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], 11, 11, [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, 12, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 173
[ , [15, 115], [15, 98], [15, 92], [15, 88], [15, 87], [15, 86], [16, 84], [15, 84], [16, 83], [16, 82], [0, 80, "Ja"], [16, 80], [16, 80], 11, 11, [0, 77, "BK"], 11, [0, 75, "BK"], 11, 11, 11, 13, 11, 11, 13, 11, 11, 11, [16, 70], [16, 69], [16, 68], 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], 11, [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 174
[ , [15, 116], [15, 99], [15, 92], [15, 88], [15, 88], [15, 86], [16, 85], [16, 84], [15, 84], [16, 82], 12, 11, [16, 80], [16, 80], 13, 11, 13, 11, 11, 11, 11, [0, 73, "BK"], 11, 11, [0, 71, "BK"], 11, 11, 11, 11, [16, 70], [16, 69], 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, [14, 16], 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [0, 32, "Jo"], [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 175
[ , [15, 116], [15, 100], [15, 92], [15, 89], [15, 88], [15, 87], [15, 86], [16, 84], [16, 84], [16, 83], [16, 82], 13, [16, 80], [16, 80], [0, 79, "BK"], 11, [0, 77, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [0, 67, "BK"], 11, 11, 11, 11, 11, [0, 63, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 12, 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 176
[ , [15, 117], [15, 100], [15, 93], [15, 90], [15, 88], [15, 88], [16, 86], [16, 85], [16, 84], [16, 84], [0, 82, "Ja"], [0, 81, "Ja"], 11, [16, 80], [16, 80], 13, 11, 13, 11, 11, 11, 11, [0, 73, "BK"], 11, 11, 11, 13, 11, 11, 11, [16, 70], 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, [16, 28], [16, 28], [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 177
[ , [15, 118], [15, 100], [15, 94], [15, 90], [15, 88], [15, 88], [16, 87], [16, 86], 13, [16, 84], 12, 11, 11, 11, [16, 80], [0, 79, "BK"], 11, [0, 77, "BK"], 11, 11, [16, 76], 13, 11, 11, 11, 11, [0, 71, "BK"], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 11, 11, [16, 32], 12, 11, 11, 11, 11, 11, [16, 28], 12, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 178
[ , [15, 118], [15, 101], [15, 94], [15, 91], [15, 89], [15, 88], [15, 88], [16, 86], [0, 85, "Ja"], [16, 84], [16, 84], [0, 82, "Ja"], [16, 82], 11, 11, [16, 80], 13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 13, 11, 11, 11, 11, 11, 11, [16, 56], 13, 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], [0, 34, "Jo"], 11, [16, 34], 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 179
[ , [15, 119], [15, 102], [15, 95], [15, 92], [15, 90], [15, 88], [15, 88], [16, 87], [16, 86], [16, 85], [16, 84], 12, 11, [16, 82], 11, 11, [0, 79, "BK"], 11, 11, 11, 11, [0, 75, "BK"], 11, 11, 11, 13, 11, [0, 71, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 12, 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 180
[ , [15, 120], [15, 102], [15, 96], [15, 92], [15, 90], [15, 89], [15, 88], [15, 88], [0, 86, "Ja"], [16, 86], [16, 84], [16, 84], 11, 11, [16, 82], 13, [16, 80], 13, 11, 11, 13, 11, 11, 11, 11, [0, 73, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 30], [0, 28, "Jo"], 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, [0, 4, "Jo"], 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 181
[ , [15, 120], [15, 103], [15, 96], [15, 92], [15, 91], [15, 90], [0, 88, "Hel"], [15, 88], 12, [16, 86], [0, 84, "Ja"], [16, 84], [16, 84], 11, 11, [0, 81, "BK"], 11, [0, 79, "BK"], 11, 11, [0, 77, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 34], [0, 32, "Jo"], [16, 32], [16, 32], 11, 11, 11, 12, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 12, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 182
[ , [15, 121], [15, 104], [15, 96], [15, 93], [15, 92], [15, 90], 12, [16, 88], [15, 88], [0, 86, "Ja"], 12, 11, [16, 84], [16, 84], 13, 11, 13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 12, 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, [16, 24], [0, 22, "Jo"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 183
[ , [15, 122], [15, 104], [15, 96], [15, 94], [15, 92], [15, 91], [15, 90], [16, 88], [16, 88], 12, [16, 86], 13, 11, [16, 84], [0, 83, "BK"], 11, [0, 81, "BK"], 11, 11, 11, 11, [0, 77, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 184
[ , [15, 122], [15, 104], [15, 97], [15, 94], [15, 92], [15, 92], [0, 90, "Hel"], [16, 89], [16, 88], [16, 88], [0, 86, "Ja"], [0, 85, "Ja"], 11, [16, 84], [16, 84], 13, 11, 13, 11, [16, 80], 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 11, 11, [16, 32], [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [0, 6, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 185
[ , [15, 123], [15, 105], [15, 98], [15, 95], [15, 93], [15, 92], 12, [16, 90], [16, 88], [16, 88], 12, 11, 11, 11, [16, 84], [0, 83, "BK"], 11, [0, 81, "BK"], 11, 11, [0, 79, "BK"], 11, [0, 77, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, [16, 34], 11, 11, [16, 32], 12, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 186
[ , [15, 124], [15, 106], [15, 98], [15, 96], [15, 94], [15, 92], [15, 92], [16, 90], [16, 89], [16, 88], [16, 88], [0, 86, "Ja"], 11, 11, 11, [16, 84], 13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [16, 39], [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], [0, 34, "Jo"], 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 187
[ , [15, 124], [15, 106], [15, 99], [15, 96], [15, 94], [15, 93], [15, 92], [0, 90, "Ja"], [16, 90], [16, 88], [16, 88], 12, 11, [16, 86], 11, 11, [0, 83, "BK"], 11, 11, 11, 11, [0, 79, "BK"], 11, 11, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [16, 39], [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 12, 11, 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 188
[ , [15, 125], [15, 107], [15, 100], [15, 96], [15, 95], [15, 94], [15, 93], 12, [16, 90], [16, 89], [16, 88], [16, 88], [0, 86, "Ja"], 11, [16, 86], 13, [16, 84], 13, 11, 11, 13, 11, 13, 11, 11, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [16, 40], [16, 40], [16, 40], [16, 40], [16, 39], [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 189
[ , [15, 126], [15, 108], [15, 100], [15, 96], [15, 96], [15, 94], [15, 94], [16, 92], [16, 91], [16, 90], [0, 88, "Ja"], [16, 88], 12, 11, 11, [0, 85, "BK"], 11, [0, 83, "BK"], 11, 11, [0, 81, "BK"], 11, [0, 79, "BK"], 11, 11, 11, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 54], 13, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [16, 40], [16, 39], [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], [0, 32, "Jo"], 11, [16, 32], 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 190
[ , [15, 126], [15, 108], [15, 100], [15, 96], [15, 96], [15, 95], [15, 94], [16, 92], [16, 92], [16, 90], 12, 11, [16, 88], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [14, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [14, 32], 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [16, 40], [0, 38, "Jo"], [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, 12, 11, 11, [16, 32], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 191
[ , [15, 127], [15, 108], [15, 101], [15, 97], [15, 96], [15, 96], [15, 95], [0, 92, "Ja"], [16, 92], [16, 91], [16, 90], [0, 88, "Ja"], [16, 88], [16, 88], 11, 11, [16, 86], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 12, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 192
[ , [15, 128], [15, 109], [15, 102], [15, 98], [15, 96], [15, 96], [15, 96], 12, [16, 92], [16, 92], 13, 12, 11, [16, 88], [16, 88], 11, 11, [16, 86], 13, [16, 84], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [0, 36, "Jo"], [16, 36], [16, 36], 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 193
[ , [15, 128], [15, 110], [15, 102], [15, 98], [15, 96], [15, 96], [15, 96], [16, 94], [0, 92, "Ja"], [16, 92], [0, 91, "BK"], 11, 11, 11, [16, 88], [16, 88], 13, 11, 13, 11, [16, 84], 13, 11, 13, 11, 11, 13, 11, 11, 11, 13, 11, 11, [16, 76], 11, 11, 11, 11, [14, 14], 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 12, 11, [16, 36], [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, [16, 32], [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 194
[ , [15, 129], [15, 110], [15, 103], [15, 99], [15, 96], [15, 96], [15, 96], 13, 12, [16, 92], [16, 92], 13, [16, 90], 11, 11, [16, 88], 13, 11, [0, 85, "BK"], 11, 11, 13, 11, [0, 81, "BK"], 11, 11, [0, 79, "BK"], 11, 11, 11, 13, 11, 11, 11, [16, 76], 11, 11, 11, 12, 11, 11, [16, 72], [14, 16], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [14, 20], 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, [16, 36], [16, 36], 12, 11, 11, [16, 34], 11, 11, [16, 32], 12, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 195
[ , [15, 130], [15, 111], [15, 104], [15, 100], [15, 97], [15, 96], [15, 96], [0, 95, "BG3"], [16, 94], [16, 93], [16, 92], [0, 90, "Ja"], 11, [16, 90], 11, [16, 88], 13, 11, 11, 11, 11, [0, 83, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, [0, 77, "BK"], 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 70], [16, 70], [16, 68], 12, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 196
[ , [15, 130], [15, 112], [15, 104], [15, 100], [15, 98], [15, 96], [15, 96], [15, 96], [0, 94, "Ja"], [16, 94], [16, 92], 12, 11, 11, [16, 90], 13, [0, 87, "BK"], 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, [0, 79, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [16, 52], 13, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [0, 38, "Jo"], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 28], [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 197
[ , [15, 131], [15, 112], [15, 104], [15, 100], [15, 98], [15, 97], [15, 96], [15, 96], 12, [16, 94], [0, 92, "Ja"], [16, 92], 11, 11, 11, [0, 89, "BK"], 11, 11, 11, 11, [0, 85, "BK"], 11, [0, 83, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, [0, 77, "BK"], 11, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], [14, 38], 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], 13, [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 12, 11, [16, 38], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 34], [0, 32, "Jo"], 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 198
[ , [15, 132], [15, 112], [15, 104], [15, 101], [15, 99], [15, 98], [15, 97], [15, 96], [15, 96], [16, 95], 12, 11, [16, 92], 11, 11, [16, 90], 13, 11, 11, 11, 11, 13, 11, 13, 11, 11, [0, 81, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 13, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [14, 44], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, [16, 38], [16, 38], [0, 36, "Jo"], [16, 36], [16, 36], 11, 11, 11, 12, 11, 11, [16, 32], 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 199
[ , [15, 132], [15, 113], [15, 105], [15, 102], [15, 100], [15, 98], [15, 98], [16, 96], [15, 96], [15, 96], [16, 94], [0, 92, "Ja"], 11, [16, 92], 11, 11, 13, 11, 11, 13, 11, [0, 85, "BK"], 11, [0, 83, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, [14, 24], 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 12, 11, [16, 36], [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 200
[ , [15, 133], [15, 114], [15, 106], [15, 102], [15, 100], [15, 99], [15, 98], [16, 96], [16, 96], [15, 96], [0, 94, "Ja"], 12, 11, [16, 92], [16, 92], 13, [0, 89, "BK"], 11, 11, [0, 87, "BK"], 11, 11, 13, 11, 11, 11, 11, [0, 81, "BK"], 11, 11, 11, 11, 11, [0, 77, "BK"], 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 12, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 201
[ , [15, 134], [15, 114], [15, 106], [15, 103], [15, 100], [15, 100], [0, 98, "Hel"], [16, 97], [16, 96], [16, 96], 12, 11, 11, 11, [16, 92], [0, 91, "BK"], 11, 13, 11, 11, 11, 11, [0, 85, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 202
[ , [15, 134], [15, 115], [15, 107], [15, 104], [15, 101], [15, 100], 12, [16, 98], [16, 96], [16, 96], [16, 96], 13, 11, 11, 11, [16, 92], 13, [0, 89, "BK"], 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 203
[ , [15, 135], [15, 116], [15, 108], [15, 104], [15, 102], [15, 100], [15, 100], [16, 98], [16, 97], [16, 96], [16, 96], [0, 95, "BK"], 11, [16, 94], 11, [16, 92], 13, 11, 11, 11, 11, [0, 87, "BK"], 11, [0, 85, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 13, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], 11, [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 204
[ , [15, 136], [15, 116], [15, 108], [15, 104], [15, 102], [15, 101], [15, 100], [16, 99], [16, 98], [16, 97], [16, 96], [16, 96], 13, 11, [16, 94], 13, [0, 91, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [0, 38, "Jo"], 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 205
[ , [15, 136], [15, 116], [15, 108], [15, 104], [15, 103], [15, 102], [0, 100, "Hel"], [15, 100], [16, 98], [16, 98], [16, 97], [16, 96], [0, 95, "BK"], 11, 11, [0, 93, "BK"], 11, 13, 11, 11, 11, 11, [0, 87, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 12, 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 206
[ , [15, 137], [15, 117], [15, 109], [15, 105], [15, 104], [15, 102], 12, [16, 100], [16, 99], [16, 98], [16, 98], [16, 96], [16, 96], 11, 11, [16, 94], 13, [0, 91, "BK"], 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, [16, 38], [0, 36, "Jo"], 11, [16, 36], 11, 11, 11, 11, [0, 32, "Jo"], 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 207
[ , [15, 138], [15, 118], [15, 110], [15, 106], [15, 104], [15, 103], [15, 102], [16, 100], [16, 100], [16, 99], [16, 98], [16, 97], [16, 96], [16, 96], 11, 11, 13, 11, 11, 11, 11, [0, 89, "BK"], 11, [0, 87, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [16, 43], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 12, 11, [16, 36], [16, 36], 11, 11, 11, 12, 11, 11, [16, 32], 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 208
[ , [15, 138], [15, 118], [15, 110], [15, 106], [15, 104], [15, 104], [0, 102, "Hel"], [16, 101], [16, 100], [16, 100], [16, 99], [16, 98], 13, [16, 96], [16, 96], 13, [0, 93, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 85, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [16, 44], [0, 42, "Jo"], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, [16, 36], [16, 36], 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 209
[ , [15, 139], [15, 119], [15, 111], [15, 107], [15, 104], [15, 104], 12, [16, 102], [16, 100], [16, 100], [16, 100], [16, 98], [0, 97, "BK"], 11, [16, 96], [0, 95, "BK"], 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 12, 11, [16, 42], [16, 42], [0, 40, "Jo"], [16, 40], [16, 40], 11, 11, 11, 11, 11, [16, 36], [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 210
[ , [15, 140], [15, 120], [15, 112], [15, 108], [15, 105], [15, 104], [15, 104], [16, 102], [16, 101], [16, 100], [16, 100], 13, [16, 98], 11, 11, [16, 96], 13, [0, 93, "BK"], 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, [0, 85, "BK"], 11, 11, 11, 11, 11, [14, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 13, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 12, [16, 40], [16, 40], [16, 40], 11, 11, [16, 38], 11, 11, [16, 36], 12, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 211
[ , [15, 140], [15, 120], [15, 112], [15, 108], [15, 106], [15, 104], [15, 104], [16, 103], [16, 102], [16, 101], [16, 100], [0, 99, "BK"], 11, [16, 98], 11, [16, 96], 13, 11, 11, 11, 11, [0, 91, "BK"], 11, [0, 89, "BK"], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [14, 16], 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [14, 20], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], [16, 40], [0, 38, "Jo"], 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 212
[ , [15, 141], [15, 120], [15, 112], [15, 108], [15, 106], [15, 105], [15, 104], [15, 104], [16, 102], [16, 102], [16, 100], [16, 100], 11, 11, [16, 98], [16, 97], [0, 95, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 87, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 13, 11, 11, [16, 56], 11, 11, 11, [16, 54], [16, 54], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], [16, 40], 12, 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 213
[ , [15, 142], [15, 121], [15, 112], [15, 109], [15, 107], [15, 106], [15, 105], [15, 104], [16, 103], [16, 102], [16, 101], [16, 100], [16, 100], 11, 11, [16, 98], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, [14, 38], 11, 11, [16, 56], [16, 56], 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, [16, 38], 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 214
[ , [15, 142], [15, 122], [15, 113], [15, 110], [15, 108], [15, 106], [15, 106], [16, 104], [15, 104], [16, 103], [16, 102], [16, 101], [16, 100], [16, 100], 11, [16, 98], 12, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [0, 42, "Jo"], [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, [16, 38], [0, 36, "Jo"], 11, [16, 36], 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 215
[ , [15, 143], [15, 122], [15, 114], [15, 110], [15, 108], [15, 107], [15, 106], [16, 104], [16, 104], [15, 104], [16, 102], [16, 102], 13, [16, 100], [16, 100], 13, [16, 98], 13, 11, 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 12, 11, [16, 42], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 12, 11, 11, [16, 36], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 216
[ , [15, 144], [15, 123], [15, 114], [15, 111], [15, 108], [15, 108], [15, 107], [16, 105], [16, 104], [16, 104], 13, [16, 102], 13, [16, 100], [16, 100], [0, 99, "BK"], 11, 13, 11, [16, 96], 13, 11, 13, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 13, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], [16, 42], [0, 40, "Jo"], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 217
[ , [15, 144], [15, 124], [15, 115], [15, 112], [15, 109], [15, 108], [15, 108], [16, 106], [16, 104], [16, 104], [0, 103, "BK"], 11, [0, 101, "BK"], 11, [16, 100], [16, 100], 13, 13, 11, 11, 13, 11, [0, 93, "BK"], 11, [0, 91, "BK"], 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 13, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 38], 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 12, 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 218
[ , [15, 145], [15, 124], [15, 116], [15, 112], [15, 110], [15, 108], [15, 108], [16, 106], [16, 105], [16, 104], [16, 104], 13, 11, 11, 11, [16, 100], 13, [0, 97, "BK"], 11, 11, [0, 95, "BK"], 11, 11, 13, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [14, 24], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], [0, 38, "Jo"], 11, 11, 11, 11, 11, [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 219
[ , [15, 146], [15, 124], [15, 116], [15, 112], [15, 110], [15, 109], [15, 108], [16, 107], [16, 106], [16, 105], [16, 104], 13, 11, [16, 102], 11, [16, 100], 13, 11, 13, 11, 11, 11, 11, [0, 93, "BK"], 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 220
[ , [15, 146], [15, 125], [15, 116], [15, 112], [15, 111], [15, 110], [15, 109], [15, 108], [16, 106], [16, 106], [16, 104], [0, 103, "BK"], 11, 11, [16, 102], [16, 101], [0, 99, "BK"], 11, [0, 97, "BK"], 11, 11, 11, 13, 11, 13, 11, 11, 11, 11, [0, 89, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 32], [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 221
[ , [15, 147], [15, 126], [15, 117], [15, 112], [15, 112], [15, 110], [15, 110], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], 11, 11, 11, [16, 102], 12, 13, 11, 11, 11, 11, [0, 95, "BK"], 11, [0, 93, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 222
[ , [15, 148], [15, 126], [15, 118], [15, 113], [15, 112], [15, 111], [15, 110], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], 11, 11, [16, 102], 12, [0, 99, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, [16, 72], 13, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [0, 42, "Jo"], 11, [16, 42], 11, [16, 40], [16, 40], 11, 11, 11, 11, [0, 36, "Jo"], 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 223
[ , [15, 148], [15, 127], [15, 118], [15, 114], [15, 112], [15, 112], [15, 111], [16, 109], [16, 108], [16, 108], [16, 106], [16, 106], [16, 104], [16, 104], 11, 11, [16, 102], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, 11, [16, 56], [16, 56], [16, 56], 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 12, 11, 11, [16, 42], [0, 40, "Jo"], [16, 40], [16, 40], 11, 11, 11, 12, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 224
[ , [15, 149], [15, 128], [15, 119], [15, 114], [15, 112], [15, 112], [15, 112], [16, 110], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, 11, [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, 12, 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 225
[ , [15, 150], [15, 128], [15, 120], [15, 115], [15, 112], [15, 112], [15, 112], [16, 110], [16, 109], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], [16, 104], [14, 6], [16, 102], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, [14, 16], 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, 11, [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 226
[ , [15, 150], [15, 128], [15, 120], [15, 116], [15, 113], [15, 112], [15, 112], 13, [16, 110], [16, 109], [16, 108], [16, 108], [16, 106], [16, 106], [16, 105], [16, 104], 12, 11, [16, 102], 11, [16, 100], 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 14], 11, 11, 12, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, 11, [16, 56], [16, 56], [16, 56], [14, 48], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 48], [0, 46, "Jo"], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 227
[ , [15, 151], [15, 129], [15, 120], [15, 116], [15, 114], [15, 112], [15, 112], [0, 111, "BG3"], [16, 110], [16, 110], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 104], [16, 104], 11, 11, [16, 102], [16, 101], [16, 100], 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, 11, [16, 56], [16, 56], 12, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 12, 11, [16, 46], [16, 46], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], [16, 40], [0, 38, "Jo"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 228
[ , [15, 152], [15, 130], [15, 120], [15, 116], [15, 114], [15, 113], [15, 112], [15, 112], [16, 111], [16, 110], [16, 109], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], [16, 104], 13, 11, [16, 102], 13, [16, 100], 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, [14, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, 11, [16, 60], 11, 11, 11, [16, 58], 11, [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], 11, 11, [16, 42], 11, 11, [16, 40], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 229
[ , [15, 152], [15, 130], [15, 121], [15, 117], [15, 115], [15, 114], [15, 113], [15, 112], [15, 112], 13, [16, 110], [16, 108], [16, 108], [16, 108], 13, [16, 106], 13, [16, 104], 13, 11, [16, 102], 13, [16, 100], [16, 100], [14, 8], 11, [16, 98], [14, 10], 11, [16, 96], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], 13, [16, 68], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], 11, [16, 60], [16, 60], 11, 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 54], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], [16, 44], [0, 42, "Jo"], 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 230
[ , [15, 153], [15, 131], [15, 122], [15, 118], [15, 116], [15, 114], [15, 114], [16, 112], [15, 112], [0, 111, "BK"], [16, 110], 13, [16, 108], [16, 108], 13, [16, 106], 13, [16, 104], 13, 11, 11, 13, 11, [16, 100], 12, 11, 11, 12, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [14, 34], 11, [16, 68], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 12, 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 231
[ , [15, 154], [15, 132], [15, 122], [15, 118], [15, 116], [15, 115], [15, 114], [16, 112], [16, 112], [15, 112], 13, [0, 109, "BK"], 11, [16, 108], [0, 107, "BK"], 11, 13, 11, 13, 11, 11, 13, 11, 11, [16, 100], 11, 11, 11, 11, 11, [16, 96], [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, [14, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [16, 47], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 232
[ , [15, 154], [15, 132], [15, 123], [15, 119], [15, 116], [15, 116], [15, 115], [16, 113], [16, 112], [16, 112], 13, [16, 110], 11, [16, 108], [16, 108], 13, [0, 105, "BK"], 11, [0, 103, "BK"], 11, 11, [0, 101, "BK"], 11, 11, 11, [16, 100], 11, 11, 11, 11, 11, [16, 96], [16, 96], [14, 12], 11, [14, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], 11, [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], [16, 48], [0, 46, "Jo"], [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], [0, 40, "sp"], 11, [16, 40], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], [0, 6, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 233
[ , [15, 155], [15, 132], [15, 124], [15, 120], [15, 117], [15, 116], [15, 116], [16, 114], [16, 112], [16, 112], [0, 111, "BK"], 11, [16, 110], [16, 109], [16, 108], [0, 107, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 100], 11, 11, 11, 11, 11, [16, 96], 12, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 12, 11, [16, 46], [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, 12, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 234
[ , [15, 156], [15, 133], [15, 124], [15, 120], [15, 118], [15, 116], [15, 116], [16, 114], [16, 113], [16, 112], [16, 112], 11, 11, [16, 110], [16, 109], [16, 108], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, 11, 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 46], [0, 44, "Jo"], [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], [0, 38, "Jo"], 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 235
[ , [15, 156], [15, 134], [15, 124], [15, 120], [15, 118], [15, 117], [15, 116], [16, 115], [16, 114], [16, 113], [16, 112], [16, 112], 11, [16, 110], [16, 110], [16, 108], [16, 108], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], 11, [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 12, 11, [16, 44], [16, 44], 11, 11, 11, 11, 11, [16, 40], 12, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 236
[ , [15, 157], [15, 134], [15, 125], [15, 120], [15, 119], [15, 118], [15, 117], [15, 116], [16, 114], [16, 114], [16, 112], [16, 112], [16, 112], [16, 111], [16, 110], [16, 109], [16, 108], [16, 108], 11, 11, 11, [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], [16, 44], [0, 42, "Jo"], 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 237
[ , [15, 158], [15, 135], [15, 126], [15, 121], [15, 120], [15, 118], [15, 118], [16, 116], [16, 115], [16, 114], [16, 113], [16, 112], [16, 112], [16, 112], [16, 111], [16, 110], 13, [16, 108], [16, 108], 11, [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 62], [16, 60], [16, 60], [16, 60], 11, 11, [16, 58], [16, 58], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], 12, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 238
[ , [15, 158], [15, 136], [15, 126], [15, 122], [15, 120], [15, 119], [15, 118], [16, 116], [16, 116], [16, 115], [16, 114], [16, 112], [16, 112], [16, 112], [16, 112], [16, 110], 13, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, [16, 44], [16, 44], 11, 11, 11, [16, 42], 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 239
[ , [15, 159], [15, 136], [15, 127], [15, 122], [15, 120], [15, 120], [15, 119], [16, 116], [16, 116], [16, 116], [16, 114], 13, [16, 112], [16, 112], [16, 112], 13, 13, 11, [16, 108], [16, 108], [16, 108], [16, 106], [16, 106], [14, 8], [16, 104], 13, 11, 11, 11, 11, [16, 100], [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], 11, [16, 64], 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, [16, 42], [0, 40, "Jo"], 11, [16, 40], 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 240
[ , [15, 160], [15, 136], [15, 128], [15, 123], [15, 120], [15, 120], [15, 120], [16, 117], [16, 116], [16, 116], [16, 115], [0, 113, "BK"], 11, [16, 112], [16, 112], [0, 111, "BK"], [0, 109, "BK"], 11, 11, [16, 108], [16, 108], [16, 107], [16, 106], 12, 11, [14, 8], 11, 11, 11, 11, 11, [16, 100], [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], 11, [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [0, 46, "Jo"], 11, [16, 46], [16, 45], [16, 44], [16, 44], 11, 11, 11, 12, 11, 11, [16, 40], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 241
[ , [15, 160], [15, 137], [15, 128], [15, 124], [15, 121], [15, 120], [15, 120], [16, 118], [16, 117], [16, 116], [16, 116], [16, 114], 11, 11, [16, 112], [16, 112], 12, 11, 11, 11, [16, 108], [16, 108], [16, 107], [16, 106], 11, [16, 104], 11, 11, 11, 11, [14, 10], 11, [16, 100], [16, 100], [16, 100], 13, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 12, 11, [16, 46], [16, 46], [0, 44, "Jo"], [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 242
[ , [15, 161], [15, 138], [15, 128], [15, 124], [15, 122], [15, 120], [15, 120], [16, 118], [16, 118], [16, 116], [16, 116], [16, 115], [16, 114], 11, 11, [16, 112], 12, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], 11, 11, 11, 12, 11, 11, [16, 100], [16, 100], [14, 12], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 12, 11, [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 243
[ , [15, 162], [15, 138], [15, 128], [15, 124], [15, 122], [15, 121], [15, 120], [16, 119], [16, 118], [16, 117], [16, 116], [16, 116], 13, [16, 114], 11, [16, 112], [16, 112], 13, 11, 13, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, [16, 98], 13, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], [0, 38, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 244
[ , [15, 162], [15, 139], [15, 129], [15, 125], [15, 123], [15, 122], [15, 121], [15, 120], [16, 119], [16, 118], 13, [16, 116], 13, 11, [16, 114], 13, [16, 112], 13, 11, 13, 11, [16, 108], [16, 108], [16, 108], [16, 108], [16, 106], [16, 106], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, [14, 14], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [16, 76], 13, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [0, 50, "Jo"], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], [16, 44], [0, 42, "Jo"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 245
[ , [15, 163], [15, 140], [15, 130], [15, 126], [15, 124], [15, 122], [15, 122], [16, 120], [15, 120], [16, 118], [0, 117, "BK"], [16, 116], [0, 115, "BK"], 11, 11, [0, 113, "BK"], [16, 112], [0, 111, "BK"], 11, [0, 109, "BK"], 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], [14, 34], 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 12, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 46], 11, 11, [16, 44], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 246
[ , [15, 164], [15, 140], [15, 130], [15, 126], [15, 124], [15, 123], [15, 122], 13, [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], 11, 11, [16, 114], [16, 113], [16, 112], 11, 11, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], 11, 11, 11, [16, 66], [16, 66], [16, 64], [16, 64], [14, 48], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [0, 46, "Jo"], 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 247
[ , [15, 164], [15, 140], [15, 131], [15, 127], [15, 124], [15, 124], [15, 123], [0, 121, "DMa"], [16, 120], [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], 11, 11, [16, 114], [16, 113], [16, 112], 11, 11, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 106], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 70], [16, 68], [16, 68], 11, 11, 11, [16, 66], [16, 65], [16, 64], 12, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 12, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, [0, 40, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 248
[ , [15, 165], [15, 141], [15, 132], [15, 128], [15, 125], [15, 124], [15, 124], [16, 122], [16, 120], [16, 120], [16, 120], [16, 118], [16, 118], [16, 116], [16, 116], 11, [16, 114], [16, 114], [16, 113], [16, 112], 11, 11, 11, 11, 11, [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, [16, 46], [0, 44, "Jo"], 11, [16, 44], 11, 11, 11, 12, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 249
[ , [15, 166], [15, 142], [15, 132], [15, 128], [15, 126], [15, 124], [15, 124], 13, [16, 121], [16, 120], [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], [16, 116], [16, 115], [16, 114], [16, 114], [16, 113], [16, 112], 11, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, 11, [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 52], [16, 52], [16, 52], [16, 52], [16, 51], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 12, 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 250
[ , [15, 166], [15, 142], [15, 132], [15, 128], [15, 126], [15, 125], [15, 124], 13, [16, 122], [16, 120], [16, 120], [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], [16, 116], [14, 6], [16, 114], [16, 114], [16, 112], [16, 112], 11, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], [16, 104], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, 11, [16, 96], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [16, 52], [0, 50, "Jo"], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 251
[ , [15, 167], [15, 143], [15, 133], [15, 128], [15, 127], [15, 126], [15, 125], [0, 123, "Gur"], [16, 122], [16, 121], [16, 120], [16, 120], [16, 120], [16, 118], [16, 118], [16, 116], [16, 116], 12, 11, [16, 114], [16, 113], [16, 112], [16, 112], 11, 11, 11, 11, [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], [16, 104], 13, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, [16, 96], [14, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 12, 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, [16, 44], [16, 44], 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 252
[ , [15, 168], [15, 144], [15, 134], [15, 128], [15, 128], [15, 126], [15, 126], 12, [16, 123], [16, 122], [16, 120], [16, 120], [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], [16, 116], 11, 11, [16, 114], [16, 112], [16, 112], [16, 112], [14, 8], [16, 110], 11, [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], [14, 12], 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 50], [0, 48, "Jo"], [16, 48], [16, 48], 11, 11, 11, 11, 11, [16, 44], [16, 44], [0, 42, "Jo"], 11, 11, 11, 11, 11, [16, 40], [0, 38, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 253
[ , [15, 168], [15, 144], [15, 134], [15, 129], [15, 128], [15, 127], [15, 126], 12, [16, 124], [16, 122], [16, 121], [16, 120], [16, 120], [16, 120], [16, 119], [16, 118], [16, 116], [16, 116], [16, 116], 11, [16, 114], [16, 113], [16, 112], [16, 112], 12, 11, [16, 110], [16, 109], [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, 11, 11, 11, [16, 96], 11, 11, [14, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 65], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], 12, [16, 48], [16, 48], [16, 48], [0, 46, "Jo"], 11, [16, 46], 11, 11, [16, 44], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 254
[ , [15, 169], [15, 144], [15, 135], [15, 130], [15, 128], [15, 128], [15, 127], [15, 126], [16, 124], [16, 123], [16, 122], [16, 120], [16, 120], [16, 120], [16, 120], [16, 118], [16, 117], [16, 116], [16, 116], [16, 116], [16, 115], [16, 114], [16, 113], [16, 112], [16, 112], 11, 11, [16, 110], [14, 10], [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, 11, [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 69], [16, 68], [16, 68], 11, 11, [16, 66], [16, 66], [16, 64], [16, 64], 11, 11, 11, [16, 62], [16, 62], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], 12, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 4, "Jo"], 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 255
[ , [15, 170], [15, 145], [15, 136], [15, 130], [15, 128], [15, 128], [15, 128], [15, 127], [16, 124], [16, 124], [16, 122], [16, 121], [16, 120], [16, 120], [16, 120], [16, 119], [16, 118], [16, 117], [16, 116], [16, 116], [16, 116], [16, 114], [16, 114], [16, 113], [16, 112], [16, 112], 11, [16, 110], 12, 11, [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], 11, [16, 72], [16, 72], 11, 11, 11, [16, 70], [16, 70], [16, 68], [16, 68], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 58], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], 11, 11, 11, 11, 11, 11, [15, 2]],
#V   n = 256
[ , [15, 170], [15, 146], [15, 136], [15, 131], [15, 128], [15, 128], [15, 128], [15, 128], [16, 124], [16, 124], [16, 123], [16, 122], [16, 121], [16, 120], [16, 120], [16, 120], [16, 118], [16, 118], [16, 117], [16, 116], [16, 116], [16, 115], [16, 114], [16, 114], [16, 113], [16, 112], [16, 112], [16, 111], [16, 110], 11, 11, [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, 11, 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 36], 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 70], [16, 69], [16, 68], [16, 68], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], 11, [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, [16, 46], 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], [16, 4], [14, 128], 11, 11, 11, 11, 11, [15, 2]],
#V   n = 257
[ , [15, 171], [15, 146], [15, 136], [15, 132], [15, 128], [15, 128], [15, 128], [15, 128], [16, 125], [16, 124], [16, 124], [16, 122], [16, 122], [16, 121], [16, 120], [16, 120], [16, 119], [16, 118], [16, 118], [16, 117], [16, 116], [16, 116], [16, 115], [16, 114], [16, 114], [16, 112], [16, 112], [16, 112], [16, 111], [16, 110], 11, [16, 108], [16, 108], [16, 108], [16, 108], [16, 108], [16, 107], [16, 106], [16, 106], [16, 105], [16, 104], 11, 11, 11, 11, [14, 16], 11, 11, [16, 100], [16, 100], 11, 11, [16, 98], 11, 11, [16, 96], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 76], [16, 76], 11, 11, 11, [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 70], [16, 69], [16, 68], [16, 68], [16, 68], 11, [16, 66], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 54], [16, 53], [16, 52], [16, 52], [16, 52], [0, 50, "Jo"], [16, 50], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, [16, 46], [0, 44, "sp"], 11, [16, 44], 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 4], [16, 4], 12, 11, 11, 11, 11, 11, 11, [15, 2]]];
