/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.builder.util;

import thredds.catalog.DataFormatType;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import ucar.nc2.constants.FeatureType;

public class ThreddsMetadataBuilderUtils {
    private ThreddsMetadataBuilderUtils() {
    }

    public static ThreddsMetadataBuilder copyIntoNewThreddsMetadataBuilder(ThreddsMetadataBuilder source, ThreddsBuilderFactory builderFactory) {
        if (source == null) {
            throw new IllegalArgumentException("Source builder may not be null.");
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException("Builder factory may not be null.");
        }
        ThreddsMetadataBuilder result = builderFactory.newThreddsMetadataBuilder();
        ThreddsMetadataBuilderUtils.copyThreddsMetadataBuilder(source, result);
        return result;
    }

    public static ThreddsMetadataBuilder copyThreddsMetadataBuilder(ThreddsMetadataBuilder source, ThreddsMetadataBuilder recipient) {
        ThreddsMetadataBuilder.GeospatialCoverageBuilder geoCovBuilder;
        ThreddsMetadataBuilder.DatePointBuilder dpb;
        if (source == null) {
            throw new IllegalArgumentException("Source builder may not be null.");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient builder may not be null.");
        }
        if (source.getCollectionType() != null) {
            recipient.setCollectionType(source.getCollectionType());
        }
        if (source.getDataFormat() != null) {
            recipient.setDataFormat(source.getDataFormat());
        }
        recipient.setDataSizeInBytes(source.getDataSizeInBytes());
        if (source.getDataType() != null) {
            recipient.setDataType(source.getDataType());
        }
        if (source.getAvailableDatePointBuilder() != null) {
            dpb = source.getAvailableDatePointBuilder();
            recipient.setAvailableDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getCreatedDatePointBuilder() != null) {
            dpb = source.getCreatedDatePointBuilder();
            recipient.setCreatedDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getIssuedDatePointBuilder() != null) {
            dpb = source.getIssuedDatePointBuilder();
            recipient.setIssuedDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getMetadataCreatedDatePointBuilder() != null) {
            dpb = source.getMetadataCreatedDatePointBuilder();
            recipient.setMetadataCreatedDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getMetadataModifiedDatePointBuilder() != null) {
            dpb = source.getMetadataModifiedDatePointBuilder();
            recipient.setMetadataModifiedDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getModifiedDatePointBuilder() != null) {
            dpb = source.getModifiedDatePointBuilder();
            recipient.setModifiedDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if (source.getValidDatePointBuilder() != null) {
            dpb = source.getValidDatePointBuilder();
            recipient.setValidDatePointBuilder(dpb.getDate(), dpb.getDateFormat());
        }
        if ((geoCovBuilder = source.getGeospatialCoverageBuilder()) != null && geoCovBuilder.getCRS() != null) {
            recipient.setNewGeospatialCoverageBuilder(geoCovBuilder.getCRS());
        }
        if (source.getTemporalCoverageBuilder() != null) {
            ThreddsMetadataBuilder.DateRangeBuilder drb = source.getTemporalCoverageBuilder();
            recipient.setTemporalCoverageBuilder(drb.getStartDate(), drb.getStartDateFormat(), drb.getEndDate(), drb.getEndDateFormat(), drb.getDuration(), drb.getResolution());
        }
        ThreddsMetadataBuilderUtils.addCopiesOfContributorBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfCreatorBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfDocumentationBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfKeyphraseBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfProjectNameBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfPublisherBuilders(source, recipient);
        ThreddsMetadataBuilderUtils.addCopiesOfVariableGroupBuilders(source, recipient);
        return recipient;
    }

    public static ThreddsMetadataBuilder mergeTwoThreddsMetadata(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsBuilderFactory builderFactory) {
        ThreddsMetadataBuilder mergedResults = builderFactory.newThreddsMetadataBuilder();
        ThreddsMetadataBuilderUtils.mergeTwoThreddsMetadata(first, second, mergedResults);
        return mergedResults;
    }

    public static void mergeTwoThreddsMetadata(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedResults) {
        ThreddsMetadataBuilderUtils.mergeOverwriteCollectionType(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDataFormat(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDataSizeInBytes(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDataType(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateAvailable(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateCreated(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateIssued(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateMetadataCreated(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateMetadataModified(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateModified(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteDateValid(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteGeospatialCoverage(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.mergeOverwriteTemporalCoverage(first, second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfContributorBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfContributorBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfCreatorBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfCreatorBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfDocumentationBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfDocumentationBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfKeyphraseBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfKeyphraseBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfProjectNameBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfProjectNameBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfPublisherBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfPublisherBuilders(second, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfVariableGroupBuilders(first, mergedResults);
        ThreddsMetadataBuilderUtils.addCopiesOfVariableGroupBuilders(second, mergedResults);
    }

    private static void addCopiesOfDocumentationBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.DocumentationBuilder curDoc : source.getDocumentationBuilders()) {
            if (curDoc.isContainedContent()) {
                result.addDocumentation(curDoc.getDocType(), curDoc.getContent());
                continue;
            }
            result.addDocumentation(curDoc.getDocType(), curDoc.getTitle(), curDoc.getExternalReference());
        }
    }

    private static void addCopiesOfCreatorBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.ContributorBuilder curSourceCreator : source.getCreatorBuilder()) {
            ThreddsMetadataBuilder.ContributorBuilder curResultCreator = result.addCreator();
            ThreddsMetadataBuilderUtils.copySingleContributorBuilder(curSourceCreator, curResultCreator);
        }
    }

    private static void addCopiesOfContributorBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.ContributorBuilder curSourceContrib : source.getContributorBuilder()) {
            ThreddsMetadataBuilder.ContributorBuilder curResultContrib = result.addContributor();
            ThreddsMetadataBuilderUtils.copySingleContributorBuilder(curSourceContrib, curResultContrib);
        }
    }

    private static void addCopiesOfPublisherBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.ContributorBuilder curSourcePublisher : source.getPublisherBuilder()) {
            ThreddsMetadataBuilder.ContributorBuilder curResultPublisher = result.addPublisher();
            ThreddsMetadataBuilderUtils.copySingleContributorBuilder(curSourcePublisher, curResultPublisher);
        }
    }

    private static void addCopiesOfKeyphraseBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.KeyphraseBuilder curKeyphrase : source.getKeyphraseBuilders()) {
            result.addKeyphrase(curKeyphrase.getAuthority(), curKeyphrase.getPhrase());
        }
    }

    private static void addCopiesOfProjectNameBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.ProjectNameBuilder curProjName : source.getProjectNameBuilders()) {
            result.addProjectName(curProjName.getNamingAuthority(), curProjName.getName());
        }
    }

    private static void addCopiesOfVariableGroupBuilders(ThreddsMetadataBuilder source, ThreddsMetadataBuilder result) {
        for (ThreddsMetadataBuilder.VariableGroupBuilder curSourceVarGroupBuilder : source.getVariableGroupBuilders()) {
            ThreddsMetadataBuilder.VariableGroupBuilder curResultVarGroupBuilder = result.addVariableGroupBuilder();
            if (curSourceVarGroupBuilder.getVocabularyAuthorityId() != null) {
                curResultVarGroupBuilder.setVocabularyAuthorityId(curSourceVarGroupBuilder.getVocabularyAuthorityId());
            }
            if (curSourceVarGroupBuilder.getVocabularyAuthorityUrl() != null) {
                curResultVarGroupBuilder.setVocabularyAuthorityUrl(curSourceVarGroupBuilder.getVocabularyAuthorityUrl());
            }
            if (curSourceVarGroupBuilder.getVariableMapUrl() != null) {
                curResultVarGroupBuilder.setVariableMapUrl(curSourceVarGroupBuilder.getVariableMapUrl());
            }
            if (curSourceVarGroupBuilder.getVariableBuilders() == null) continue;
            for (ThreddsMetadataBuilder.VariableBuilder curSourceVarBuilder : curSourceVarGroupBuilder.getVariableBuilders()) {
                curResultVarGroupBuilder.addVariableBuilder(curSourceVarBuilder.getName(), curSourceVarBuilder.getDescription(), curSourceVarBuilder.getUnits(), curSourceVarBuilder.getVocabularyId(), curSourceVarBuilder.getVocabularyName());
            }
        }
    }

    private static void mergeOverwriteGeospatialCoverage(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        if (!ThreddsMetadataBuilderUtils.setGeospatialCoverateIfNotNull(second, mergedThreddsMetadata)) {
            ThreddsMetadataBuilderUtils.setGeospatialCoverateIfNotNull(first, mergedThreddsMetadata);
        }
    }

    private static void mergeOverwriteTemporalCoverage(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DateRangeBuilder temporalCov;
        ThreddsMetadataBuilder.DateRangeBuilder dateRangeBuilder = temporalCov = second.getTemporalCoverageBuilder() != null ? second.getTemporalCoverageBuilder() : first.getTemporalCoverageBuilder();
        if (temporalCov != null) {
            mergedThreddsMetadata.setTemporalCoverageBuilder(temporalCov.getStartDate(), temporalCov.getStartDateFormat(), temporalCov.getEndDate(), temporalCov.getEndDateFormat(), temporalCov.getDuration(), temporalCov.getResolution());
        }
    }

    private static void mergeOverwriteDateValid(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getValidDatePointBuilder() != null ? second.getValidDatePointBuilder() : first.getValidDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setValidDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateModified(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getModifiedDatePointBuilder() != null ? second.getModifiedDatePointBuilder() : first.getModifiedDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setModifiedDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateMetadataModified(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getMetadataModifiedDatePointBuilder() != null ? second.getMetadataModifiedDatePointBuilder() : first.getMetadataModifiedDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setMetadataModifiedDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateMetadataCreated(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getMetadataCreatedDatePointBuilder() != null ? second.getMetadataCreatedDatePointBuilder() : first.getMetadataCreatedDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setMetadataCreatedDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateIssued(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getIssuedDatePointBuilder() != null ? second.getIssuedDatePointBuilder() : first.getIssuedDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setIssuedDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateCreated(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getCreatedDatePointBuilder() != null ? second.getCreatedDatePointBuilder() : first.getCreatedDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setCreatedDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDateAvailable(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        ThreddsMetadataBuilder.DatePointBuilder date;
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = date = second.getAvailableDatePointBuilder() != null ? second.getAvailableDatePointBuilder() : first.getAvailableDatePointBuilder();
        if (date != null) {
            mergedThreddsMetadata.setAvailableDatePointBuilder(date.getDate(), date.getDateFormat());
        }
    }

    private static void mergeOverwriteDataType(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        FeatureType dataType;
        FeatureType featureType = dataType = second.getDataType() != null ? second.getDataType() : first.getDataType();
        if (dataType != null) {
            mergedThreddsMetadata.setDataType(dataType);
        }
    }

    private static void mergeOverwriteDataSizeInBytes(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        long dataSizeInBytes = second.getDataSizeInBytes() != -1L ? second.getDataSizeInBytes() : first.getDataSizeInBytes();
        mergedThreddsMetadata.setDataSizeInBytes(dataSizeInBytes);
    }

    private static void mergeOverwriteDataFormat(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        DataFormatType dataFormat;
        DataFormatType dataFormatType = dataFormat = second.getDataFormat() != null ? second.getDataFormat() : first.getDataFormat();
        if (dataFormat != null) {
            mergedThreddsMetadata.setDataFormat(dataFormat);
        }
    }

    private static void mergeOverwriteCollectionType(ThreddsMetadataBuilder first, ThreddsMetadataBuilder second, ThreddsMetadataBuilder mergedThreddsMetadata) {
        String collectionType;
        String string = collectionType = second.getCollectionType() != null ? second.getCollectionType() : first.getCollectionType();
        if (collectionType != null) {
            mergedThreddsMetadata.setCollectionType(collectionType);
        }
    }

    private static void copySingleContributorBuilder(ThreddsMetadataBuilder.ContributorBuilder source, ThreddsMetadataBuilder.ContributorBuilder recipient) {
        if (source.getNamingAuthority() != null) {
            recipient.setNamingAuthority(source.getNamingAuthority());
        }
        if (source.getName() != null) {
            recipient.setName(source.getName());
        }
        if (source.getEmail() != null) {
            recipient.setEmail(source.getEmail());
        }
        if (source.getWebPage() != null) {
            recipient.setWebPage(source.getWebPage());
        }
    }

    private static boolean setGeospatialCoverateIfNotNull(ThreddsMetadataBuilder source, ThreddsMetadataBuilder recipient) {
        ThreddsMetadataBuilder.GeospatialCoverageBuilder geoCovBuilder = source.getGeospatialCoverageBuilder();
        if (geoCovBuilder != null && geoCovBuilder.getCRS() != null) {
            recipient.setNewGeospatialCoverageBuilder(geoCovBuilder.getCRS());
            return true;
        }
        return false;
    }
}

