pragma Ada_2005;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with System;
with dbus_arch_deps_h;
with Interfaces.C.Strings;
with dbus_types_h;
limited with dbus_errors_h;
with dbus_memory_h;

package dbus_message_h is

   --  skipped empty struct DBusMessage

   type DBusMessageIter is record
      dummy1 : System.Address;  -- ../dbus/dbus-message.h:53
      dummy2 : System.Address;  -- ../dbus/dbus-message.h:54
      dummy3 : aliased dbus_arch_deps_h.dbus_uint32_t;  -- ../dbus/dbus-message.h:55
      dummy4 : aliased int;  -- ../dbus/dbus-message.h:56
      dummy5 : aliased int;  -- ../dbus/dbus-message.h:57
      dummy6 : aliased int;  -- ../dbus/dbus-message.h:58
      dummy7 : aliased int;  -- ../dbus/dbus-message.h:59
      dummy8 : aliased int;  -- ../dbus/dbus-message.h:60
      dummy9 : aliased int;  -- ../dbus/dbus-message.h:61
      dummy10 : aliased int;  -- ../dbus/dbus-message.h:62
      dummy11 : aliased int;  -- ../dbus/dbus-message.h:63
      pad1 : aliased int;  -- ../dbus/dbus-message.h:64
      pad2 : System.Address;  -- ../dbus/dbus-message.h:65
      pad3 : System.Address;  -- ../dbus/dbus-message.h:66
   end record;
   pragma Convention (C_Pass_By_Copy, DBusMessageIter);  -- ../dbus/dbus-message.h:51

   function dbus_message_new (message_type : int) return System.Address;  -- ../dbus/dbus-message.h:70
   pragma Import (C, dbus_message_new, "dbus_message_new");

   function dbus_message_new_method_call
     (bus_name : Interfaces.C.Strings.chars_ptr;
      path : Interfaces.C.Strings.chars_ptr;
      iface : Interfaces.C.Strings.chars_ptr;
      method : Interfaces.C.Strings.chars_ptr) return System.Address;  -- ../dbus/dbus-message.h:72
   pragma Import (C, dbus_message_new_method_call, "dbus_message_new_method_call");

   function dbus_message_new_method_return (method_call : System.Address) return System.Address;  -- ../dbus/dbus-message.h:77
   pragma Import (C, dbus_message_new_method_return, "dbus_message_new_method_return");

   function dbus_message_new_signal
     (path : Interfaces.C.Strings.chars_ptr;
      iface : Interfaces.C.Strings.chars_ptr;
      name : Interfaces.C.Strings.chars_ptr) return System.Address;  -- ../dbus/dbus-message.h:79
   pragma Import (C, dbus_message_new_signal, "dbus_message_new_signal");

   function dbus_message_new_error
     (reply_to : System.Address;
      error_name : Interfaces.C.Strings.chars_ptr;
      error_message : Interfaces.C.Strings.chars_ptr) return System.Address;  -- ../dbus/dbus-message.h:83
   pragma Import (C, dbus_message_new_error, "dbus_message_new_error");

   function dbus_message_new_error_printf
     (reply_to : System.Address;
      error_name : Interfaces.C.Strings.chars_ptr;
      error_format : Interfaces.C.Strings.chars_ptr  -- , ...
      ) return System.Address;  -- ../dbus/dbus-message.h:87
   pragma Import (C, dbus_message_new_error_printf, "dbus_message_new_error_printf");

   function dbus_message_copy (message : System.Address) return System.Address;  -- ../dbus/dbus-message.h:93
   pragma Import (C, dbus_message_copy, "dbus_message_copy");

   function dbus_message_ref (message : System.Address) return System.Address;  -- ../dbus/dbus-message.h:96
   pragma Import (C, dbus_message_ref, "dbus_message_ref");

   procedure dbus_message_unref (message : System.Address);  -- ../dbus/dbus-message.h:98
   pragma Import (C, dbus_message_unref, "dbus_message_unref");

   function dbus_message_get_type (message : System.Address) return int;  -- ../dbus/dbus-message.h:100
   pragma Import (C, dbus_message_get_type, "dbus_message_get_type");

   function dbus_message_set_path (message : System.Address; object_path : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:102
   pragma Import (C, dbus_message_set_path, "dbus_message_set_path");

   function dbus_message_get_path (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:105
   pragma Import (C, dbus_message_get_path, "dbus_message_get_path");

   function dbus_message_has_path (message : System.Address; object_path : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:107
   pragma Import (C, dbus_message_has_path, "dbus_message_has_path");

   function dbus_message_set_interface (message : System.Address; iface : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:110
   pragma Import (C, dbus_message_set_interface, "dbus_message_set_interface");

   function dbus_message_get_interface (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:113
   pragma Import (C, dbus_message_get_interface, "dbus_message_get_interface");

   function dbus_message_has_interface (message : System.Address; iface : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:115
   pragma Import (C, dbus_message_has_interface, "dbus_message_has_interface");

   function dbus_message_set_member (message : System.Address; member : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:118
   pragma Import (C, dbus_message_set_member, "dbus_message_set_member");

   function dbus_message_get_member (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:121
   pragma Import (C, dbus_message_get_member, "dbus_message_get_member");

   function dbus_message_has_member (message : System.Address; member : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:123
   pragma Import (C, dbus_message_has_member, "dbus_message_has_member");

   function dbus_message_set_error_name (message : System.Address; name : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:126
   pragma Import (C, dbus_message_set_error_name, "dbus_message_set_error_name");

   function dbus_message_get_error_name (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:129
   pragma Import (C, dbus_message_get_error_name, "dbus_message_get_error_name");

   function dbus_message_set_destination (message : System.Address; destination : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:131
   pragma Import (C, dbus_message_set_destination, "dbus_message_set_destination");

   function dbus_message_get_destination (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:134
   pragma Import (C, dbus_message_get_destination, "dbus_message_get_destination");

   function dbus_message_set_sender (message : System.Address; sender : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:136
   pragma Import (C, dbus_message_set_sender, "dbus_message_set_sender");

   function dbus_message_get_sender (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:139
   pragma Import (C, dbus_message_get_sender, "dbus_message_get_sender");

   function dbus_message_get_signature (message : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:141
   pragma Import (C, dbus_message_get_signature, "dbus_message_get_signature");

   procedure dbus_message_set_no_reply (message : System.Address; no_reply : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-message.h:143
   pragma Import (C, dbus_message_set_no_reply, "dbus_message_set_no_reply");

   function dbus_message_get_no_reply (message : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:146
   pragma Import (C, dbus_message_get_no_reply, "dbus_message_get_no_reply");

   function dbus_message_is_method_call
     (message : System.Address;
      iface : Interfaces.C.Strings.chars_ptr;
      method : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:148
   pragma Import (C, dbus_message_is_method_call, "dbus_message_is_method_call");

   function dbus_message_is_signal
     (message : System.Address;
      iface : Interfaces.C.Strings.chars_ptr;
      signal_name : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:152
   pragma Import (C, dbus_message_is_signal, "dbus_message_is_signal");

   function dbus_message_is_error (message : System.Address; error_name : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:156
   pragma Import (C, dbus_message_is_error, "dbus_message_is_error");

   function dbus_message_has_destination (message : System.Address; bus_name : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:159
   pragma Import (C, dbus_message_has_destination, "dbus_message_has_destination");

   function dbus_message_has_sender (message : System.Address; unique_bus_name : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:162
   pragma Import (C, dbus_message_has_sender, "dbus_message_has_sender");

   function dbus_message_has_signature (message : System.Address; signature : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:165
   pragma Import (C, dbus_message_has_signature, "dbus_message_has_signature");

   function dbus_message_get_serial (message : System.Address) return dbus_arch_deps_h.dbus_uint32_t;  -- ../dbus/dbus-message.h:168
   pragma Import (C, dbus_message_get_serial, "dbus_message_get_serial");

   procedure dbus_message_set_serial (message : System.Address; serial : dbus_arch_deps_h.dbus_uint32_t);  -- ../dbus/dbus-message.h:170
   pragma Import (C, dbus_message_set_serial, "dbus_message_set_serial");

   function dbus_message_set_reply_serial (message : System.Address; reply_serial : dbus_arch_deps_h.dbus_uint32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:173
   pragma Import (C, dbus_message_set_reply_serial, "dbus_message_set_reply_serial");

   function dbus_message_get_reply_serial (message : System.Address) return dbus_arch_deps_h.dbus_uint32_t;  -- ../dbus/dbus-message.h:176
   pragma Import (C, dbus_message_get_reply_serial, "dbus_message_get_reply_serial");

   procedure dbus_message_set_auto_start (message : System.Address; auto_start : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-message.h:179
   pragma Import (C, dbus_message_set_auto_start, "dbus_message_set_auto_start");

   function dbus_message_get_auto_start (message : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:182
   pragma Import (C, dbus_message_get_auto_start, "dbus_message_get_auto_start");

   function dbus_message_get_path_decomposed (message : System.Address; path : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:185
   pragma Import (C, dbus_message_get_path_decomposed, "dbus_message_get_path_decomposed");

   function dbus_message_append_args (message : System.Address; first_arg_type : int  -- , ...
      ) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:189
   pragma Import (C, dbus_message_append_args, "dbus_message_append_args");

   function dbus_message_append_args_valist
     (message : System.Address;
      first_arg_type : int;
      var_args : access System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:193
   pragma Import (C, dbus_message_append_args_valist, "dbus_message_append_args_valist");

   function dbus_message_get_args
     (message : System.Address;
      error : access dbus_errors_h.DBusError;
      first_arg_type : int  -- , ...
      ) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:197
   pragma Import (C, dbus_message_get_args, "dbus_message_get_args");

   function dbus_message_get_args_valist
     (message : System.Address;
      error : access dbus_errors_h.DBusError;
      first_arg_type : int;
      var_args : access System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:202
   pragma Import (C, dbus_message_get_args_valist, "dbus_message_get_args_valist");

   function dbus_message_contains_unix_fds (message : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:208
   pragma Import (C, dbus_message_contains_unix_fds, "dbus_message_contains_unix_fds");

   function dbus_message_iter_init (message : System.Address; iter : access DBusMessageIter) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:211
   pragma Import (C, dbus_message_iter_init, "dbus_message_iter_init");

   function dbus_message_iter_has_next (iter : access DBusMessageIter) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:214
   pragma Import (C, dbus_message_iter_has_next, "dbus_message_iter_has_next");

   function dbus_message_iter_next (iter : access DBusMessageIter) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:216
   pragma Import (C, dbus_message_iter_next, "dbus_message_iter_next");

   function dbus_message_iter_get_signature (iter : access DBusMessageIter) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:218
   pragma Import (C, dbus_message_iter_get_signature, "dbus_message_iter_get_signature");

   function dbus_message_iter_get_arg_type (iter : access DBusMessageIter) return int;  -- ../dbus/dbus-message.h:220
   pragma Import (C, dbus_message_iter_get_arg_type, "dbus_message_iter_get_arg_type");

   function dbus_message_iter_get_element_type (iter : access DBusMessageIter) return int;  -- ../dbus/dbus-message.h:222
   pragma Import (C, dbus_message_iter_get_element_type, "dbus_message_iter_get_element_type");

   procedure dbus_message_iter_recurse (iter : access DBusMessageIter; sub : access DBusMessageIter);  -- ../dbus/dbus-message.h:224
   pragma Import (C, dbus_message_iter_recurse, "dbus_message_iter_recurse");

   procedure dbus_message_iter_get_basic (iter : access DBusMessageIter; value : System.Address);  -- ../dbus/dbus-message.h:227
   pragma Import (C, dbus_message_iter_get_basic, "dbus_message_iter_get_basic");

   function dbus_message_iter_get_element_count (iter : access DBusMessageIter) return int;  -- ../dbus/dbus-message.h:230
   pragma Import (C, dbus_message_iter_get_element_count, "dbus_message_iter_get_element_count");

   function dbus_message_iter_get_array_len (iter : access DBusMessageIter) return int;  -- ../dbus/dbus-message.h:237
   pragma Import (C, dbus_message_iter_get_array_len, "dbus_message_iter_get_array_len");

   procedure dbus_message_iter_get_fixed_array
     (iter : access DBusMessageIter;
      value : System.Address;
      n_elements : access int);  -- ../dbus/dbus-message.h:240
   pragma Import (C, dbus_message_iter_get_fixed_array, "dbus_message_iter_get_fixed_array");

   procedure dbus_message_iter_init_append (message : System.Address; iter : access DBusMessageIter);  -- ../dbus/dbus-message.h:246
   pragma Import (C, dbus_message_iter_init_append, "dbus_message_iter_init_append");

   function dbus_message_iter_append_basic
     (iter : access DBusMessageIter;
      c_type : int;
      value : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:249
   pragma Import (C, dbus_message_iter_append_basic, "dbus_message_iter_append_basic");

   function dbus_message_iter_append_fixed_array
     (iter : access DBusMessageIter;
      element_type : int;
      value : System.Address;
      n_elements : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:253
   pragma Import (C, dbus_message_iter_append_fixed_array, "dbus_message_iter_append_fixed_array");

   function dbus_message_iter_open_container
     (iter : access DBusMessageIter;
      c_type : int;
      contained_signature : Interfaces.C.Strings.chars_ptr;
      sub : access DBusMessageIter) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:258
   pragma Import (C, dbus_message_iter_open_container, "dbus_message_iter_open_container");

   function dbus_message_iter_close_container (iter : access DBusMessageIter; sub : access DBusMessageIter) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:263
   pragma Import (C, dbus_message_iter_close_container, "dbus_message_iter_close_container");

   procedure dbus_message_iter_abandon_container (iter : access DBusMessageIter; sub : access DBusMessageIter);  -- ../dbus/dbus-message.h:266
   pragma Import (C, dbus_message_iter_abandon_container, "dbus_message_iter_abandon_container");

   procedure dbus_message_lock (message : System.Address);  -- ../dbus/dbus-message.h:270
   pragma Import (C, dbus_message_lock, "dbus_message_lock");

   function dbus_set_error_from_message (error : access dbus_errors_h.DBusError; message : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:273
   pragma Import (C, dbus_set_error_from_message, "dbus_set_error_from_message");

   function dbus_message_allocate_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:278
   pragma Import (C, dbus_message_allocate_data_slot, "dbus_message_allocate_data_slot");

   procedure dbus_message_free_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t);  -- ../dbus/dbus-message.h:280
   pragma Import (C, dbus_message_free_data_slot, "dbus_message_free_data_slot");

   function dbus_message_set_data
     (message : System.Address;
      slot : dbus_arch_deps_h.dbus_int32_t;
      data : System.Address;
      free_data_func : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:282
   pragma Import (C, dbus_message_set_data, "dbus_message_set_data");

   function dbus_message_get_data (message : System.Address; slot : dbus_arch_deps_h.dbus_int32_t) return System.Address;  -- ../dbus/dbus-message.h:287
   pragma Import (C, dbus_message_get_data, "dbus_message_get_data");

   function dbus_message_type_from_string (type_str : Interfaces.C.Strings.chars_ptr) return int;  -- ../dbus/dbus-message.h:291
   pragma Import (C, dbus_message_type_from_string, "dbus_message_type_from_string");

   function dbus_message_type_to_string (c_type : int) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-message.h:293
   pragma Import (C, dbus_message_type_to_string, "dbus_message_type_to_string");

   function dbus_message_marshal
     (msg : System.Address;
      marshalled_data_p : System.Address;
      len_p : access int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:296
   pragma Import (C, dbus_message_marshal, "dbus_message_marshal");

   function dbus_message_demarshal
     (str : Interfaces.C.Strings.chars_ptr;
      len : int;
      error : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-message.h:300
   pragma Import (C, dbus_message_demarshal, "dbus_message_demarshal");

   function dbus_message_demarshal_bytes_needed (str : Interfaces.C.Strings.chars_ptr; len : int) return int;  -- ../dbus/dbus-message.h:305
   pragma Import (C, dbus_message_demarshal_bytes_needed, "dbus_message_demarshal_bytes_needed");

   procedure dbus_message_set_allow_interactive_authorization (message : System.Address; allow : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-message.h:309
   pragma Import (C, dbus_message_set_allow_interactive_authorization, "dbus_message_set_allow_interactive_authorization");

   function dbus_message_get_allow_interactive_authorization (message : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-message.h:313
   pragma Import (C, dbus_message_get_allow_interactive_authorization, "dbus_message_get_allow_interactive_authorization");

end dbus_message_h;
