! *****************************************************************************
!> \brief This routine calculates the maximum density matrix element, when
!>        screening on an initial density matrix is applied. Due to symmetry of
!>        the ERI's, there are always 4 matrix elements to be considered.
!>        CASE 0-15 belong to an energy calculation (linear screening)
!>        CASE 16-31 belong to a force calculation (square screening)
!> \param ptr_p_1 Pointers to atomic denisty matrices
!> \param ptr_p_2 Pointers to atomic denisty matrices
!> \param ptr_p_3 Pointers to atomic denisty matrices
!> \param ptr_p_4 Pointers to atomic denisty matrices
!> \param iset Current set
!> \param jset Current set
!> \param kset Current set
!> \param lset Current set
!> \param pmax_val value to be calculated
!> \param swap_id Defines how the matrices are accessed
!> \par History
!>      06.2009 created [Manuel Guidon]
!> \author Manuel Guidon
! **************************************************************************************************
  PURE SUBROUTINE get_pmax_val(ptr_p_1, ptr_p_2, ptr_p_3, ptr_p_4, &
                               iset, jset, kset, lset, &
                               pmax_val, swap_id)

     REAL(dp), DIMENSION(:, :), POINTER        :: ptr_p_1, ptr_p_2, ptr_p_3, ptr_p_4
     INTEGER, INTENT(IN)                      :: iset, jset, kset, lset

     REAL(dp), INTENT(OUT)                    :: pmax_val
     INTEGER, INTENT(IN)                      :: swap_id

     REAL(dp)                                 :: pmax_1, pmax_2, pmax_3, pmax_4

     SELECT CASE (swap_id)
     CASE (0)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (1)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (2)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (3)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (4)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (5)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (6)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (7)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (8)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (9)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (10)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (11)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (12)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (13)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (14)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (15)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1, pmax_2, pmax_3, pmax_4)
     CASE (16)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (17)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (18)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (19)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (20)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (21)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (22)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (23)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(kset, jset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (24)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (25)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (26)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (27)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(lset, iset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (28)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (29)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(lset, jset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (30)
        pmax_1 = ptr_p_1(kset, iset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     CASE (31)
        pmax_1 = ptr_p_1(iset, kset)
        pmax_2 = ptr_p_2(jset, lset)
        pmax_3 = ptr_p_3(iset, lset)
        pmax_4 = ptr_p_4(jset, kset)
        pmax_val = MAX(pmax_1+pmax_2, pmax_3+pmax_4)
     END SELECT

  END SUBROUTINE get_pmax_val
