//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/MessageService.h
//! @brief     Defines MessageService class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_MESSAGESERVICE_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_MESSAGESERVICE_H

#include <QList>
#include <QPair>
#include <QString>

class QObject;

//! @class MessageService
//! @brief The service to collect messages from different senders.

class MessageService {
public:
    void addError(QObject* sender, const QString& description);
    void addWarning(QObject* sender, const QString& description);

    QStringList errors(bool includeSenders = false) const;
    QStringList warnings(bool includeSenders = false) const;

private:
    using Messages = QList<QPair<QString, QString>>; // pair of sender & description

    QStringList descriptions(const Messages& messages, bool includeSenders) const;

    Messages m_warnings;
    Messages m_errors;
};

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_MESSAGESERVICE_H
