/*
 *
 * test-decrypt-ccmp.c
 *
 * Copyright (C) 2012 Carlos Alberto Lopez Perez <clopez@igalia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>

#include "aircrack-ng/crypto/crypto.h"
#include "tests.h"

#define BUFFER_SIZE 65536

int main(int argc, char ** argv)
{
	if (argc < 1) return 1;

	int error = 0;

	int caplen1 = 81;
	unsigned char tk1[16]
		= "\x1d\x03\x5e\x8b\xeb\x4f\x83\x61\x1d\xc9\x3e\x26\x57\xce\xcf\x69";
	unsigned char h80211[1496]
		= "\x08\x41\x02\x01\x00\x0b\x86\xc2\xa4\x85\x00\x13\xce\x55\x98\xef"
		  "\x00\x0f\x66\xe3\xe4\x01\x20\x2e\x01\x00\x00\x20\x00\x00\x00\x00"
		  "\x95\xc3\x1e\x2d\x02\x01\x58\x9f\x4d\xeb\xe2\x27\xc4\xe9\xc2\x1d"
		  "\xb1\x2c\x7a\x66\x6a\x35\x80\x8a\xbe\x1e\x73\x8d\xab\x1d\xa3\x6b"
		  "\xa0\xf3\x16\x81\x70\x9a\x94\xf0\xb6\x53\x2c\xd6\x93\x5b\x14\x13"
		  "\x59\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		  "\x00\x41\xe2\x61\x88\x6d\xb4\xde\x64\x11\x22\xc7\xc2\x24\x02\x60"
		  "\x51\x00\x00\x30\x82\x09\x57\x76\x59\xa9\xd2\x35\x57\x73\x12\xc4"
		  "\x69\x34\x0f\xd0\x2c\x1f\x55\xa9\xcf\x6a\xc3\x08\x03\x6f\xa1\x4a"
		  "\x9e\xa6\xef\x71\x6d\xb6\x2f\xcc\x0c\xbb\x40\x6e\x90\x1d\x3e\xa2"
		  "\x53\xf9\x26\x71\x65\x02\x47\xd1\xb6\xb1\x01\xd9\x48\x80\xcd\x6c"
		  "\x65\x75\x5b\xf4\x95\x1a\x68\xae\xdf\x8b\x8d\xbb\x5f\x4f\xd5\x8b"
		  "\x66\xb1\x3c\x72\x16\xe8\x5b\x70\x6f\x1b\xdd\xa7\x8a\xd8\x24\xed"
		  "\xc9\x77\x1a\xa0\x74\x36\x3e\x70\x5b\x52\xbd\x7c\x11\x50\x60\x1d"
		  "\x24\x85\x8b\x8a\xb3\x63\x5c\x5b\x09\x94\xaf\xa5\xe8\xc4\xae\x65"
		  "\x92\xa8\x26\xfd\x28\x43\x37\x4c\x6d\x19\x79\x14\x95\x40\x5a\xf6"
		  "\x98\xb7\xd7\x79\xfb\xfe\xbd\x0c\xc5\xf8\x77\xaf\x98\x9e\xf4\xad"
		  "\xce\x40\xcc\x28\xeb\xc6\xa9\xd7\xf9\x98\xfc\xbb\xc3\x66\x94\x4e"
		  "\xea\x6e\xdd\x30\x3b\x65\x6b\xfd\x05\xa8\x68\x2e\x7e\xaa\x43\xe4"
		  "\x65\x26\x11\x83\x86\xe1\x68\x15\x90\xdf\x81\x5c\x01\xdf\x3d\x85"
		  "\x56\x34\x14\x31\x2a\xbf\x6f\xb5\xd6\xcf\xbe\xe9\x07\xc9\x36\xe7"
		  "\x31\x83\x5b\xfa\x4a\x29\x62\xfe\x76\x40\xed\x64\xb8\x2a\xc7\x3c"
		  "\xb5\x76\xd9\x07\x2b\x3a\xde\xc1\xaa\xaa\xd5\x24\xbf\x74\x91\xd9"
		  "\x1a\xb3\x93\x83\xda\xa6\xb0\xd2\xc7\xbe\x0c\xdd\x17\x87\xff\xa2"
		  "\x21\x95\xe9\x08\x3b\x97\xde\x62\x3c\x17\x7c\xf1\xfc\x58\x21\x8f"
		  "\x11\x28\x79\xed\x9e\xa5\x4a\xb3\x48\x8a\xf6\xcd\xd1\xb4\x54\xe6"
		  "\xfc\x5b\x87\xd6\x81\x67\x14\x0a\xd4\x4e\xf6\x7a\x66\xc1\x87\xc3"
		  "\x9e\xb0\xbe\x15\xb4\xb8\xca\x6a\x54\x80\x72\x23\xdf\x10\x70\x4a"
		  "\xb5\x6b\xef\x56\x94\x96\xc0\x65\x79\x14\xc0\xc5\x88\x26\x52\xa0"
		  "\x32\xd0\xe2\x2e\x9a\x31\x36\xf1\x4b\x29\x2e\x68\x6c\x07\x67\x36"
		  "\xc0\x43\xe3\x95\xea\x90\xce\xe2\x2d\x34\x3d\x96\x29\x1f\xb4\x4d"
		  "\x61\x8d\xd5\xdb\xde\xce\x65\xcc\xfc\x0e\x30\xa0\xfb\x92\xd2\xd0"
		  "\xac\x9f\x6b\xe4\xf2\x2f\x86\xf6\x91\xd6\x18\x97\x68\x27\xd1\x4b"
		  "\x4f\x92\xda\x63\x32\xbf\x0f\x95\x8a\x10\xb0\xc5\xc2\x5a\xa9\x31"
		  "\x67\x8f\x23\x21\xc5\x96\x97\x2d\x14\x46\xbb\x3f\x82\x4a\x31\x0a"
		  "\x6c\x0f\x21\xab\x52\x4b\x9c\x89\xdf\x00\xbb\x80\x4f\xa8\x78\xe6"
		  "\x9b\x0a\x96\xb8\x81\x03\x74\x93\x32\xc8\x3a\x72\x31\x58\x72\xec"
		  "\xab\x33\x60\xeb\x0c\xb4\x35\x7e\x40\x0c\x74\x24\xb1\xd9\x84\xc6"
		  "\x3d\x88\x6f\x7d\x8c\xfd\xe2\x59\xb5\x24\xe1\x9b\xbf\x84\xf6\x43"
		  "\x67\x95\x88\x52\x87\x82\x47\xc2\x3f\xae\x56\x2a\x31\xd9\x07\x27"
		  "\x01\xc6\xef\x0a\x12\x38\x03\x93\x91\x9c\xaa\xc6\x14\x3a\x1b\x26"
		  "\x6e\x16\x0b\xb1\xc1\xef\x8d\x0c\xa8\x82\xc4\x5a\x28\xd4\xd0\x46"
		  "\x90\xc9\xbc\xac\x37\x68\x03\xbe\x6f\x4f\x60\x6f\xee\xb8\x34\x03"
		  "\x3a\x7d\xd0\x9f\xc9\x8d\x95\xc1\x0f\x3d\xc8\xeb\x84\xfe\x42\xd7"
		  "\xf2\xae\x14\xf0\x1b\xcf\x95\x23\x54\xb7\x2e\x68\x79\xe2\xf3\x22"
		  "\xe7\x6f\x51\x5e\xa2\xe3\xd3\xb5\x6d\xea\x77\xc0\xb3\xbc\x4f\x55"
		  "\xf2\x04\xc8\x63\x14\x8d\x17\xd6\x7f\x79\x8d\x95\xd3\x76\x35\x3a"
		  "\x09\xe4\xb8\x08\xe1\xfb\xe1\xf5\xb7\xc4\x7a\x66\xfb\xe6\x59\xc2"
		  "\x9b\x60\xc5\xe5\xb1\x47\xcc\x12\xdc\xb7\x1f\x9e\xb8\x55\xfb\x5d"
		  "\x01\xcf\x69\x2a\x85\x55\x55\xe9\x67\x64\x39\x66\xda\xe0\x94\x7f"
		  "\xe4\xd1\xd9\x3e\xbd\x54\x13\x1c\xd6\x49\xdd\x22\xdf\xba\xce\x0b"
		  "\xc6\x09\x9f\x17\xea\xea\xdd\x90\x25\xec\xa4\xb1\x31\x79\x53\x60"
		  "\x14\x17\xe3\xe0\x17\x35\x88\x71\xc6\xd5\xe1\x74\x4c\xd0\xb8\xec"
		  "\xdd\xd2\x8f\x39\xe6\xb4\xe4\xfd\x39\xf0\x5b\x56\xce\xe5\x0d\x9c"
		  "\x72\x22\x81\x4e\x9c\xa5\x3b\x6b\x03\x66\x45\x31\xe9\x40\x52\x3b"
		  "\x30\x37\x8c\xb1\xb9\xdb\xdd\x0f\xda\x23\x44\xb8\xd0\x67\x45\xf0"
		  "\x1f\x36\x81\x7b\xc5\x7a\x3d\x71\xe3\xe0\xcc\xe0\x43\x21\x42\x67"
		  "\xc7\x35\x75\x12\x43\x38\x7f\x20\x5b\xab\xda\x6c\xfc\x86\x08\xdb"
		  "\x05\xb8\x73\x2b\x37\x32\xeb\x86\xe0\x9d\xc4\xba\xcb\x19\x41\x5a"
		  "\xb0\xf7\xa8\x41\xb5\xd5\x84\x1a\x07\x78\x0d\x8a\x6c\x52\xb0\xac"
		  "\xaa\x7f\x36\x65\x21\x90\xf1\xf6\x04\x39\x57\x89\xfa\x8b\xbc\xf8"
		  "\x2f\x5a\xe6\x51\xe7\x48\x5f\xdb\x57\xfa\x2b\x85\x64\x74\xb0\x0d"
		  "\x83\x51\x31\x1e\x59\x8b\x5c\x9b\xb8\xc8\x09\x56\x1c\x40\x78\xee"
		  "\x8d\xd6\x69\xbd\x72\x5a\x51\xfb\x97\x03\x17\xe5\x14\xa6\xde\x2f"
		  "\x48\x5b\xf0\xe8\xec\xb2\x6a\x91\x59\x6a\x05\xcb\x4b\xe4\xd2\x9b"
		  "\x4c\xc6\x91\xf1\xe4\x04\xa0\xd3\xf6\xee\x2f\x45\xde\x11\x58\x36"
		  "\xff\x44\x75\x9f\x86\xf6\x09\x35\xba\xfe\x2d\x5c\x93\x80\x21\x3e"
		  "\xa0\xa8\x68\x39\x56\xa6\x23\xe9\x4a\x34\xd7\x67\x24\x5d\x56\x8d"
		  "\xa8\x43\x4d\xe5\xc7\x2a\xee\x36\x91\xec\x79\xbd\x10\x24\xe0\x79"
		  "\xc8\xca\xe9\xbb\x38\x81\x69\xd2\x35\x2c\xcf\x49\x20\x08\x73\xd0"
		  "\x98\x45\xda\x7a\xfd\x6f\xf6\x0c\xee\xbd\xcd\x7f\x48\x6e\xfd\x54"
		  "\xc4\xe3\x0b\xb8\x9a\xc0\xf1\x10\x14\xb7\x3c\x79\x0d\xd5\x9a\x95"
		  "\x56\x47\x8b\x94\xda\x01\xa8\x5a\x2a\xa0\x06\x66\xb7\x51\xe3\x7c"
		  "\x3a\xe6\x1e\x2a\x11\x17\x27\xb9\x37\x0c\xa3\x64\xf6\x29\x00\xdf"
		  "\xd8\x24\xe1\x18\x43\xc0\xbb\xd2\x7c\x50\x5d\xf3\x79\x4e\xd6\x54"
		  "\x93\x5e\x35\x88\xa6\x13\x1e\x98\x38\xa8\x73\xc9\xc6\x88\xc0\xdb"
		  "\x4c\xc8\xbc\x8c\x32\x41\x84\x57\x15\x33\x4b\x60\x7f\xb2\x3f\x85"
		  "\xfe\x5a\x5a\x9f\xf1\x9f\x6c\x76\x33\x41\x13\x8f\x90\x3f\x45\x5a"
		  "\xcc\x81\x03\xa5\x82\x5a\xca\xec\xae\x5b\xc8\x17\xc2\x18\x9b\xa3"
		  "\x99\x0e\x07\x4e\xd2\xa7\xa2\x5a\x24\xd4\xf2\x3a\x6e\x15\x1d\x21"
		  "\x21\x28\xd6\x62\xf6\x90\x80\xbb\xf4\xdb\xf9\x76\xb8\xd9\xeb\xb4"
		  "\xe5\x13\xb6\x1e\x42\x22\x7c\xc4\xdb\xff\xe8\xbb\xf2\xf1\xd3\x4d"
		  "\x18\xcf\xa8\xfd\xd7\xd0\x34\x24\xf2\x5d\xb2\x1c\x6a\x05\x07\xd5"
		  "\xc9\xff\xc0\xe2\x96\xa3\x68\x53\x3f\xba\x0e\x07\xbd\x37\xf7\x5f"
		  "\xae\x5d\x7c\x5e\x3b\x56\x1a\x51\xac\xa8\x46\x4a\x77\xc8\x6a\xc1"
		  "\x68\x49\x11\xa0\x47\x64\x1f\x75\x95\xf2\x26\xf1\x0e\x44\x0b\x62"
		  "\x8c\x81\x31\x75\x0b\xc0\x24\x64\x4b\xad\x2f\x19\x98\xad\x68\xc1"
		  "\xba\x71\xd2\xa1\xc4\xc7\xa9\x9e\xc8\xba\x5d\x9a\xe4\x0b\xd1\x48"
		  "\xb3\x27\xaa\xe7\xf1\x40\xb4\x28\x2d\xac\x38\x68\x14\xc8\xb8\xe2"
		  "\xd4\x4c\xd4\xfa\x2f\x69\x2b\xf5\xaf\x10\x3d\x13\x21\x26\x94\x0b"
		  "\x4c\xb2\x5f\x99\xac\x04\x88\x74\x43\x76\x75\x4c\x27\x5c\x36\xee"
		  "\x32\x75\x3e\x55\x38\xc7\xd5\x76\x9d\xbd\xfc\xa3\x55\x08\xbf\x3a"
		  "\xb3\x82\x89\xb3\x0d\x3e\x54\xbc\x30\xfa\xb7\xc3\xf9\x9f\xbe\xfc"
		  "\x87\x89\x3c\x6d\x0b\x69\x7b\xbf";
	unsigned char expected[1496]
		= "\x08\x41\x02\x01\x00\x0b\x86\xc2\xa4\x85\x00\x13\xce\x55\x98\xef"
		  "\x00\x0f\x66\xe3\xe4\x01\x20\x2e\x01\x00\x00\x20\x00\x00\x00\x00"
		  "\xaa\xaa\x03\x00\x00\x00\x08\x00\x45\x00\x00\x21\x6a\x12\x00\x00"
		  "\x01\x01\xf7\x43\xac\x10\x00\x65\xac\x10\x00\x01\x08\x00\x26\x67"
		  "\x04\x00\x03\x00\x44\x48\x43\x50\x43\x34\x65\x66\x21\x68\xa8\xc7"
		  "\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		  "\x00\x41\xe2\x61\x88\x6d\xb4\xde\x64\x11\x22\xc7\xc2\x24\x02\x60"
		  "\x51\x00\x00\x30\x82\x09\x57\x76\x59\xa9\xd2\x35\x57\x73\x12\xc4"
		  "\x69\x34\x0f\xd0\x2c\x1f\x55\xa9\xcf\x6a\xc3\x08\x03\x6f\xa1\x4a"
		  "\x9e\xa6\xef\x71\x6d\xb6\x2f\xcc\x0c\xbb\x40\x6e\x90\x1d\x3e\xa2"
		  "\x53\xf9\x26\x71\x65\x02\x47\xd1\xb6\xb1\x01\xd9\x48\x80\xcd\x6c"
		  "\x65\x75\x5b\xf4\x95\x1a\x68\xae\xdf\x8b\x8d\xbb\x5f\x4f\xd5\x8b"
		  "\x66\xb1\x3c\x72\x16\xe8\x5b\x70\x6f\x1b\xdd\xa7\x8a\xd8\x24\xed"
		  "\xc9\x77\x1a\xa0\x74\x36\x3e\x70\x5b\x52\xbd\x7c\x11\x50\x60\x1d"
		  "\x24\x85\x8b\x8a\xb3\x63\x5c\x5b\x09\x94\xaf\xa5\xe8\xc4\xae\x65"
		  "\x92\xa8\x26\xfd\x28\x43\x37\x4c\x6d\x19\x79\x14\x95\x40\x5a\xf6"
		  "\x98\xb7\xd7\x79\xfb\xfe\xbd\x0c\xc5\xf8\x77\xaf\x98\x9e\xf4\xad"
		  "\xce\x40\xcc\x28\xeb\xc6\xa9\xd7\xf9\x98\xfc\xbb\xc3\x66\x94\x4e"
		  "\xea\x6e\xdd\x30\x3b\x65\x6b\xfd\x05\xa8\x68\x2e\x7e\xaa\x43\xe4"
		  "\x65\x26\x11\x83\x86\xe1\x68\x15\x90\xdf\x81\x5c\x01\xdf\x3d\x85"
		  "\x56\x34\x14\x31\x2a\xbf\x6f\xb5\xd6\xcf\xbe\xe9\x07\xc9\x36\xe7"
		  "\x31\x83\x5b\xfa\x4a\x29\x62\xfe\x76\x40\xed\x64\xb8\x2a\xc7\x3c"
		  "\xb5\x76\xd9\x07\x2b\x3a\xde\xc1\xaa\xaa\xd5\x24\xbf\x74\x91\xd9"
		  "\x1a\xb3\x93\x83\xda\xa6\xb0\xd2\xc7\xbe\x0c\xdd\x17\x87\xff\xa2"
		  "\x21\x95\xe9\x08\x3b\x97\xde\x62\x3c\x17\x7c\xf1\xfc\x58\x21\x8f"
		  "\x11\x28\x79\xed\x9e\xa5\x4a\xb3\x48\x8a\xf6\xcd\xd1\xb4\x54\xe6"
		  "\xfc\x5b\x87\xd6\x81\x67\x14\x0a\xd4\x4e\xf6\x7a\x66\xc1\x87\xc3"
		  "\x9e\xb0\xbe\x15\xb4\xb8\xca\x6a\x54\x80\x72\x23\xdf\x10\x70\x4a"
		  "\xb5\x6b\xef\x56\x94\x96\xc0\x65\x79\x14\xc0\xc5\x88\x26\x52\xa0"
		  "\x32\xd0\xe2\x2e\x9a\x31\x36\xf1\x4b\x29\x2e\x68\x6c\x07\x67\x36"
		  "\xc0\x43\xe3\x95\xea\x90\xce\xe2\x2d\x34\x3d\x96\x29\x1f\xb4\x4d"
		  "\x61\x8d\xd5\xdb\xde\xce\x65\xcc\xfc\x0e\x30\xa0\xfb\x92\xd2\xd0"
		  "\xac\x9f\x6b\xe4\xf2\x2f\x86\xf6\x91\xd6\x18\x97\x68\x27\xd1\x4b"
		  "\x4f\x92\xda\x63\x32\xbf\x0f\x95\x8a\x10\xb0\xc5\xc2\x5a\xa9\x31"
		  "\x67\x8f\x23\x21\xc5\x96\x97\x2d\x14\x46\xbb\x3f\x82\x4a\x31\x0a"
		  "\x6c\x0f\x21\xab\x52\x4b\x9c\x89\xdf\x00\xbb\x80\x4f\xa8\x78\xe6"
		  "\x9b\x0a\x96\xb8\x81\x03\x74\x93\x32\xc8\x3a\x72\x31\x58\x72\xec"
		  "\xab\x33\x60\xeb\x0c\xb4\x35\x7e\x40\x0c\x74\x24\xb1\xd9\x84\xc6"
		  "\x3d\x88\x6f\x7d\x8c\xfd\xe2\x59\xb5\x24\xe1\x9b\xbf\x84\xf6\x43"
		  "\x67\x95\x88\x52\x87\x82\x47\xc2\x3f\xae\x56\x2a\x31\xd9\x07\x27"
		  "\x01\xc6\xef\x0a\x12\x38\x03\x93\x91\x9c\xaa\xc6\x14\x3a\x1b\x26"
		  "\x6e\x16\x0b\xb1\xc1\xef\x8d\x0c\xa8\x82\xc4\x5a\x28\xd4\xd0\x46"
		  "\x90\xc9\xbc\xac\x37\x68\x03\xbe\x6f\x4f\x60\x6f\xee\xb8\x34\x03"
		  "\x3a\x7d\xd0\x9f\xc9\x8d\x95\xc1\x0f\x3d\xc8\xeb\x84\xfe\x42\xd7"
		  "\xf2\xae\x14\xf0\x1b\xcf\x95\x23\x54\xb7\x2e\x68\x79\xe2\xf3\x22"
		  "\xe7\x6f\x51\x5e\xa2\xe3\xd3\xb5\x6d\xea\x77\xc0\xb3\xbc\x4f\x55"
		  "\xf2\x04\xc8\x63\x14\x8d\x17\xd6\x7f\x79\x8d\x95\xd3\x76\x35\x3a"
		  "\x09\xe4\xb8\x08\xe1\xfb\xe1\xf5\xb7\xc4\x7a\x66\xfb\xe6\x59\xc2"
		  "\x9b\x60\xc5\xe5\xb1\x47\xcc\x12\xdc\xb7\x1f\x9e\xb8\x55\xfb\x5d"
		  "\x01\xcf\x69\x2a\x85\x55\x55\xe9\x67\x64\x39\x66\xda\xe0\x94\x7f"
		  "\xe4\xd1\xd9\x3e\xbd\x54\x13\x1c\xd6\x49\xdd\x22\xdf\xba\xce\x0b"
		  "\xc6\x09\x9f\x17\xea\xea\xdd\x90\x25\xec\xa4\xb1\x31\x79\x53\x60"
		  "\x14\x17\xe3\xe0\x17\x35\x88\x71\xc6\xd5\xe1\x74\x4c\xd0\xb8\xec"
		  "\xdd\xd2\x8f\x39\xe6\xb4\xe4\xfd\x39\xf0\x5b\x56\xce\xe5\x0d\x9c"
		  "\x72\x22\x81\x4e\x9c\xa5\x3b\x6b\x03\x66\x45\x31\xe9\x40\x52\x3b"
		  "\x30\x37\x8c\xb1\xb9\xdb\xdd\x0f\xda\x23\x44\xb8\xd0\x67\x45\xf0"
		  "\x1f\x36\x81\x7b\xc5\x7a\x3d\x71\xe3\xe0\xcc\xe0\x43\x21\x42\x67"
		  "\xc7\x35\x75\x12\x43\x38\x7f\x20\x5b\xab\xda\x6c\xfc\x86\x08\xdb"
		  "\x05\xb8\x73\x2b\x37\x32\xeb\x86\xe0\x9d\xc4\xba\xcb\x19\x41\x5a"
		  "\xb0\xf7\xa8\x41\xb5\xd5\x84\x1a\x07\x78\x0d\x8a\x6c\x52\xb0\xac"
		  "\xaa\x7f\x36\x65\x21\x90\xf1\xf6\x04\x39\x57\x89\xfa\x8b\xbc\xf8"
		  "\x2f\x5a\xe6\x51\xe7\x48\x5f\xdb\x57\xfa\x2b\x85\x64\x74\xb0\x0d"
		  "\x83\x51\x31\x1e\x59\x8b\x5c\x9b\xb8\xc8\x09\x56\x1c\x40\x78\xee"
		  "\x8d\xd6\x69\xbd\x72\x5a\x51\xfb\x97\x03\x17\xe5\x14\xa6\xde\x2f"
		  "\x48\x5b\xf0\xe8\xec\xb2\x6a\x91\x59\x6a\x05\xcb\x4b\xe4\xd2\x9b"
		  "\x4c\xc6\x91\xf1\xe4\x04\xa0\xd3\xf6\xee\x2f\x45\xde\x11\x58\x36"
		  "\xff\x44\x75\x9f\x86\xf6\x09\x35\xba\xfe\x2d\x5c\x93\x80\x21\x3e"
		  "\xa0\xa8\x68\x39\x56\xa6\x23\xe9\x4a\x34\xd7\x67\x24\x5d\x56\x8d"
		  "\xa8\x43\x4d\xe5\xc7\x2a\xee\x36\x91\xec\x79\xbd\x10\x24\xe0\x79"
		  "\xc8\xca\xe9\xbb\x38\x81\x69\xd2\x35\x2c\xcf\x49\x20\x08\x73\xd0"
		  "\x98\x45\xda\x7a\xfd\x6f\xf6\x0c\xee\xbd\xcd\x7f\x48\x6e\xfd\x54"
		  "\xc4\xe3\x0b\xb8\x9a\xc0\xf1\x10\x14\xb7\x3c\x79\x0d\xd5\x9a\x95"
		  "\x56\x47\x8b\x94\xda\x01\xa8\x5a\x2a\xa0\x06\x66\xb7\x51\xe3\x7c"
		  "\x3a\xe6\x1e\x2a\x11\x17\x27\xb9\x37\x0c\xa3\x64\xf6\x29\x00\xdf"
		  "\xd8\x24\xe1\x18\x43\xc0\xbb\xd2\x7c\x50\x5d\xf3\x79\x4e\xd6\x54"
		  "\x93\x5e\x35\x88\xa6\x13\x1e\x98\x38\xa8\x73\xc9\xc6\x88\xc0\xdb"
		  "\x4c\xc8\xbc\x8c\x32\x41\x84\x57\x15\x33\x4b\x60\x7f\xb2\x3f\x85"
		  "\xfe\x5a\x5a\x9f\xf1\x9f\x6c\x76\x33\x41\x13\x8f\x90\x3f\x45\x5a"
		  "\xcc\x81\x03\xa5\x82\x5a\xca\xec\xae\x5b\xc8\x17\xc2\x18\x9b\xa3"
		  "\x99\x0e\x07\x4e\xd2\xa7\xa2\x5a\x24\xd4\xf2\x3a\x6e\x15\x1d\x21"
		  "\x21\x28\xd6\x62\xf6\x90\x80\xbb\xf4\xdb\xf9\x76\xb8\xd9\xeb\xb4"
		  "\xe5\x13\xb6\x1e\x42\x22\x7c\xc4\xdb\xff\xe8\xbb\xf2\xf1\xd3\x4d"
		  "\x18\xcf\xa8\xfd\xd7\xd0\x34\x24\xf2\x5d\xb2\x1c\x6a\x05\x07\xd5"
		  "\xc9\xff\xc0\xe2\x96\xa3\x68\x53\x3f\xba\x0e\x07\xbd\x37\xf7\x5f"
		  "\xae\x5d\x7c\x5e\x3b\x56\x1a\x51\xac\xa8\x46\x4a\x77\xc8\x6a\xc1"
		  "\x68\x49\x11\xa0\x47\x64\x1f\x75\x95\xf2\x26\xf1\x0e\x44\x0b\x62"
		  "\x8c\x81\x31\x75\x0b\xc0\x24\x64\x4b\xad\x2f\x19\x98\xad\x68\xc1"
		  "\xba\x71\xd2\xa1\xc4\xc7\xa9\x9e\xc8\xba\x5d\x9a\xe4\x0b\xd1\x48"
		  "\xb3\x27\xaa\xe7\xf1\x40\xb4\x28\x2d\xac\x38\x68\x14\xc8\xb8\xe2"
		  "\xd4\x4c\xd4\xfa\x2f\x69\x2b\xf5\xaf\x10\x3d\x13\x21\x26\x94\x0b"
		  "\x4c\xb2\x5f\x99\xac\x04\x88\x74\x43\x76\x75\x4c\x27\x5c\x36\xee"
		  "\x32\x75\x3e\x55\x38\xc7\xd5\x76\x9d\xbd\xfc\xa3\x55\x08\xbf\x3a"
		  "\xb3\x82\x89\xb3\x0d\x3e\x54\xbc\x30\xfa\xb7\xc3\xf9\x9f\xbe\xfc"
		  "\x87\x89\x3c\x6d\x0b\x69\x7b\xbf";

	unsigned char expected_output[BUFFER_SIZE];
	unsigned char input[BUFFER_SIZE];

	bzero(&expected_output, BUFFER_SIZE);
	bzero(&input, BUFFER_SIZE);
	memcpy(&expected_output, expected, sizeof(expected));
	memcpy(&input, h80211, sizeof(h80211));

	if (!decrypt_ccmp(input, caplen1, tk1)) error++;
	error += test(input, expected_output, sizeof(expected), argv[0]);

	return error;
}
