/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20140715

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#ifndef __OS2__
#ifdef __GNUC__
#undef alloca
#ifndef ANDROID_COMPILE
#define        alloca(n)       __builtin_alloca (n)
#endif
#else
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H.  */
#if !defined(_AIX) && !defined(WINCE)
#ifndef _MSC_VER
extern char *alloca();
#else
#define alloca(n)   _alloca(n)
#endif  /* MSVC */
#endif /* Not AIX and not WINCE.  */
#endif /* HAVE_ALLOCA_H.  */
#endif /* GCC.  */
#endif /* __OS2__ */

/* SunOS 4.x specific stuff */
#if defined(sun) || defined(__sun)
#  if !defined(__SVR4) && !defined(__svr4__)
#    ifdef __sparc__
#      define YYFREE
#    endif
#  endif
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "drive.h"
#include "interrupt.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "tapeport.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"
#include "vsync.h"

#ifdef AMIGA_MORPHOS
#undef REG_PC
#endif

#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

#ifdef __IBMC__
static void __yy_memcpy (char *to, char *from, int count);
#endif

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern void free_buffer(void);
extern void make_buffer(char *str);
extern int yylex(void);
extern int cur_len, last_len;

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COND_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

#define YYDEBUG 1

#line 139 "mon_parse.y"
#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
typedef union {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 177 "mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_LOG 279
#define CMD_LOGNAME 280
#define CMD_SIDEFX 281
#define CMD_DUMMY 282
#define CMD_RETURN 283
#define CMD_BLOCK_READ 284
#define CMD_BLOCK_WRITE 285
#define CMD_UP 286
#define CMD_DOWN 287
#define CMD_LOAD 288
#define CMD_SAVE 289
#define CMD_VERIFY 290
#define CMD_BVERIFY 291
#define CMD_IGNORE 292
#define CMD_HUNT 293
#define CMD_FILL 294
#define CMD_MOVE 295
#define CMD_GOTO 296
#define CMD_REGISTERS 297
#define CMD_READSPACE 298
#define CMD_WRITESPACE 299
#define CMD_RADIX 300
#define CMD_MEM_DISPLAY 301
#define CMD_BREAK 302
#define CMD_TRACE 303
#define CMD_IO 304
#define CMD_BRMON 305
#define CMD_COMPARE 306
#define CMD_DUMP 307
#define CMD_UNDUMP 308
#define CMD_EXIT 309
#define CMD_DELETE 310
#define CMD_CONDITION 311
#define CMD_COMMAND 312
#define CMD_ASSEMBLE 313
#define CMD_DISASSEMBLE 314
#define CMD_NEXT 315
#define CMD_STEP 316
#define CMD_PRINT 317
#define CMD_DEVICE 318
#define CMD_HELP 319
#define CMD_WATCH 320
#define CMD_DISK 321
#define CMD_QUIT 322
#define CMD_CHDIR 323
#define CMD_BANK 324
#define CMD_LOAD_LABELS 325
#define CMD_SAVE_LABELS 326
#define CMD_ADD_LABEL 327
#define CMD_DEL_LABEL 328
#define CMD_SHOW_LABELS 329
#define CMD_CLEAR_LABELS 330
#define CMD_RECORD 331
#define CMD_MON_STOP 332
#define CMD_PLAYBACK 333
#define CMD_CHAR_DISPLAY 334
#define CMD_SPRITE_DISPLAY 335
#define CMD_TEXT_DISPLAY 336
#define CMD_SCREENCODE_DISPLAY 337
#define CMD_ENTER_DATA 338
#define CMD_ENTER_BIN_DATA 339
#define CMD_KEYBUF 340
#define CMD_BLOAD 341
#define CMD_BSAVE 342
#define CMD_SCREEN 343
#define CMD_UNTIL 344
#define CMD_CPU 345
#define CMD_YYDEBUG 346
#define CMD_BACKTRACE 347
#define CMD_SCREENSHOT 348
#define CMD_PWD 349
#define CMD_DIR 350
#define CMD_MKDIR 351
#define CMD_RMDIR 352
#define CMD_RESOURCE_GET 353
#define CMD_RESOURCE_SET 354
#define CMD_LOAD_RESOURCES 355
#define CMD_SAVE_RESOURCES 356
#define CMD_ATTACH 357
#define CMD_DETACH 358
#define CMD_MON_RESET 359
#define CMD_TAPECTRL 360
#define CMD_CARTFREEZE 361
#define CMD_UPDB 362
#define CMD_JPDB 363
#define CMD_CPUHISTORY 364
#define CMD_MEMMAPZAP 365
#define CMD_MEMMAPSHOW 366
#define CMD_MEMMAPSAVE 367
#define CMD_COMMENT 368
#define CMD_LIST 369
#define CMD_STOPWATCH 370
#define RESET 371
#define CMD_EXPORT 372
#define CMD_AUTOSTART 373
#define CMD_AUTOLOAD 374
#define CMD_MAINCPU_TRACE 375
#define CMD_WARP 376
#define CMD_LABEL_ASGN 377
#define L_PAREN 378
#define R_PAREN 379
#define ARG_IMMEDIATE 380
#define REG_A 381
#define REG_X 382
#define REG_Y 383
#define COMMA 384
#define INST_SEP 385
#define L_BRACKET 386
#define R_BRACKET 387
#define LESS_THAN 388
#define REG_U 389
#define REG_S 390
#define REG_PC 391
#define REG_PCR 392
#define REG_B 393
#define REG_C 394
#define REG_D 395
#define REG_E 396
#define REG_H 397
#define REG_L 398
#define REG_AF 399
#define REG_BC 400
#define REG_DE 401
#define REG_HL 402
#define REG_IX 403
#define REG_IY 404
#define REG_SP 405
#define REG_IXH 406
#define REG_IXL 407
#define REG_IYH 408
#define REG_IYL 409
#define PLUS 410
#define MINUS 411
#define STRING 412
#define FILENAME 413
#define R_O_L 414
#define R_O_L_Q 415
#define OPCODE 416
#define LABEL 417
#define BANKNAME 418
#define CPUTYPE 419
#define MON_REGISTER 420
#define COND_OP 421
#define RADIX_TYPE 422
#define INPUT_SPEC 423
#define CMD_CHECKPT_ON 424
#define CMD_CHECKPT_OFF 425
#define TOGGLE 426
#define MASK 427
#define YYERRCODE 256
typedef short YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   33,   33,   35,   35,   35,   34,   34,
   34,   34,   34,   34,   34,   34,   34,   34,   34,   34,
   34,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   49,
   49,   49,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   37,   37,   52,   39,   39,   39,   39,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   40,   40,   40,   40,   40,   40,   40,   40,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   42,
   42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   45,   45,   45,   46,   46,   47,   22,   23,
   23,   24,   27,   27,   12,   12,   17,   17,   18,   18,
   21,   21,   50,   50,   53,   16,   16,    2,    2,    1,
    1,    1,    4,    4,    3,    3,    3,   48,   48,   13,
   13,   13,   13,   13,   14,   15,    9,    9,    9,    9,
    9,    9,    9,    5,    5,    6,    6,    6,    6,    6,
    7,    7,    7,   25,   25,   26,   26,   28,   28,   29,
   29,   29,   19,   19,   10,   10,   10,   10,   11,   11,
   11,    8,    8,    8,    8,    8,   54,   54,   54,   20,
   51,   51,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   31,   31,   31,   31,   32,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    6,    8,   10,   12,    4,    6,    8,
   10,   12,   14,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    3,    2,    3,    1,    2,
    3,    3,    5,    3,    5,    3,    5,    3,    5,    3,
    2,    3,    2,    4,    5,    0,    5,    3,    3,    2,
    5,    5,    5,    5,    5,    3,    2,    3,    2,    3,
    2,    3,    2,    3,    2,    2,    2,    4,    5,    5,
    5,    2,    3,    2,    5,    2,    5,    2,    3,    2,
    3,    2,    3,    5,    3,    2,    5,    5,    4,    3,
    2,    3,    2,    3,    2,    3,    3,    2,    2,    3,
    2,    2,    2,    3,    3,    3,    2,    3,    3,    3,
    3,    2,    3,    2,    3,    3,    3,    5,    3,    4,
    3,    3,    2,    4,    4,    2,    3,    4,    3,    3,
    2,    5,    5,    4,    5,    3,    4,    5,    4,    5,
    5,    4,    5,    5,    2,    3,    4,    3,    3,    5,
    3,    5,    3,    2,    3,    4,    2,    2,    1,    1,
    0,    1,    1,    1,    1,    1,    2,    1,    1,    0,
    1,    2,    3,    1,    3,    1,    1,    1,    1,    3,
    1,    3,    2,    0,    1,    3,    1,    1,    0,    1,
    1,    1,    1,    1,    1,    1,    3,    3,    3,    3,
    3,    3,    1,    2,    0,    3,    3,    3,    3,    1,
    1,    1,    4,    3,    1,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    3,    2,    2,
    1,    1,    2,    1,    3,    3,    3,    3,    3,    5,
    7,    5,    3,    3,    3,    3,    3,    3,    5,    5,
    5,    5,    0,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    4,    3,    4,    2,    3,    3,
    3,    3,    5,    5,    6,    5,    6,    4,    5,    5,
    5,    5,    3,    5,    1,    1,    1,    1,    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    4,    9,   10,   11,   12,   13,
   14,   15,   16,   17,   18,   19,   20,   59,  262,  263,
  264,  265,  261,  260,  259,  220,  221,  222,  223,  224,
  201,    0,  253,    0,  266,    0,  233,  254,    8,    7,
    6,    0,  125,  194,  193,    0,    0,  121,    0,  123,
   44,    0,    0,  218,   51,    0,   53,    0,    0,    0,
    0,    0,  207,  255,  258,  257,  256,  206,    0,  211,
  217,    0,    0,  226,    0,  215,  225,    0,    0,    0,
    0,   27,    0,    0,   60,    0,  204,    0,  128,    0,
  208,    0,    0,   87,  198,    0,    0,  102,    0,  108,
    0,   28,    0,    0,    0,  133,    0,    0,  116,    0,
    0,    0,    0,   80,   49,    0,   47,    0,    0,    0,
  129,  189,    0,  137,    0,  106,    0,  132,  192,    0,
    0,    0,   22,    0,    0,    0,    0,    0,    0,    0,
    0,   71,    0,   73,    0,  184,    0,    0,   89,    0,
   91,    0,   93,    0,   95,    0,  187,    0,    0,    0,
    0,   55,    0,  104,    0,   30,  188,  142,    0,  144,
  190,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  153,    0,    0,  156,    0,    0,   32,    0,   96,   97,
    0,    0,    0,    0,  195,    0,  175,    0,  161,  131,
    0,    0,    0,    0,   57,    0,    0,    0,    0,    0,
    0,    0,    0,  296,    0,  298,  299,  302,  305,  306,
  307,  308,  309,  310,  311,  300,  303,  301,  304,    0,
  270,    0,  110,    0,  112,    2,    5,    0,    0,    0,
    0,    0,  139,  202,  124,  126,  120,  122,    0,    0,
    0,    0,  196,    0,    0,    0,    0,    0,  113,    0,
    0,    0,    0,    0,    0,   26,    0,   61,    0,    0,
   62,  127,    0,   86,  197,    0,    0,   29,    0,   45,
   46,  115,    0,    0,    0,   78,    0,   79,    0,    0,
  136,  130,  138,    0,  135,  140,   24,   23,    0,    0,
   64,    0,   66,    0,   68,    0,   70,   72,  183,  185,
   88,   90,   92,   94,  247,  246,    0,  245,  141,    0,
    0,   56,  103,   31,  147,    0,  143,  145,  146,  149,
    0,  151,  152,    0,  178,    0,    0,  157,    0,    0,
    0,    0,    0,  159,  176,  160,  179,    0,  181,    0,
  134,   58,    0,    0,    0,    0,    0,    0,    0,    0,
  273,    0,  335,  336,  339,  338,    0,    0,  337,    0,
    0,    0,    0,    0,  312,    0,    0,    0,  109,  111,
  232,  231,    0,    0,  229,  230,    0,    0,    0,   52,
   54,    0,  167,    0,    0,  172,    0,    0,  252,  251,
  250,    0,  249,  210,  212,  216,    0,    0,  205,  203,
    0,    0,    0,    0,    0,    0,    0,    0,  240,  242,
  241,  119,    0,    0,    0,    0,   50,   48,    0,    0,
    0,    0,    0,    0,  186,    0,  164,    0,  169,    0,
    0,  150,  177,  154,  155,  158,   38,    0,   33,    0,
    0,   98,    0,    0,    0,    0,   74,  283,  284,  285,
  286,  287,  288,    0,    0,  320,    0,  316,    0,    0,
    0,    0,    0,    0,    0,    0,  319,  321,  275,  276,
  277,  322,  278,  313,  173,  213,  174,  162,  165,  170,
  171,  114,  248,   84,   83,   81,   85,    0,  101,  107,
   82,    0,    0,    0,  117,  118,    0,   77,    0,  105,
   25,   63,   65,   67,   69,  244,  163,  168,  148,    0,
    0,   99,  100,  180,  182,   75,    0,    0,    0,  317,
  315,    0,    0,    0,  328,    0,    0,    0,    0,    0,
    0,  239,  238,    0,  237,  236,  268,  267,   39,    0,
   34,    0,  289,  282,  290,  291,  292,  280,    0,  330,
    0,  326,  324,    0,  329,  331,  332,  323,  334,  243,
    0,    0,    0,  327,  325,   40,    0,   35,    0,  281,
    0,    0,   41,    0,   36,    0,    0,    0,   42,    0,
   37,    0,   43,
};
static const YYINT yydgoto[] = {                        102,
  191,  192,  193,  487,  513,  518,  519,  174,  134,  295,
  135,  296,  136,  176,  177,  169,  196,  197,  137,  103,
  138,  223,  272,  230,  417,  418,  146,  502,  503,  331,
  468,  469,  104,  105,  143,  106,  107,  108,  109,  110,
  111,  112,  113,  114,  115,  116,  117,  488,  118,  186,
  525,  387,  187,  526,
};
static const YYINT yysindex[] = {                      1389,
  116,    0,    0, -253, -242, -234, -188,  218,  116,  116,
  129,  129, -242, -242, -242, -242,  -46, 1762, 1762, 1762,
 1387,   83, -164,  814,  376,  376, 1387, 1762, -242, -242,
  218,  561,  -46,  -46, 1842, 1511,  129,  129,  116,  859,
 -126,  376, -367,  218, -376,  167,   35,   35, 1842,   12,
  859,  859, -242,  218, -242, 1511, 1511, 1511, 1511, 1842,
  218, -367, -242, -242, 1387, 1511,  -72,  218,  218, -242,
  218, -331, -376, -376, -312, -310, -242, -242, -242,  116,
  129, -258,  218, 1898, 1898,  129,  218,  129, -242, -331,
  912, -101,  218, -242, -242, -277, -166, -117, 1886,  561,
  561,    0,  -97, 1536,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  116,    0,   75,    0, -235,    0,    0,    0,    0,
    0,  218,    0,    0,    0,  218,  218,    0,  218,    0,
    0, 1111, 1111,    0,    0,  116,    0,  116,  154,  616,
  154,  154,    0,    0,    0,    0,    0,    0,  129,    0,
    0, -258, -258,    0, -258,    0,    0, -258, -258,  218,
 -258,    0,  -86,  -88,    0,  277,    0,  218,    0, -258,
    0,  218, -258,    0,    0,  -79, 1762,    0, 1762,    0,
  218,    0, -258,  218,  218,    0,    0,  218,    0,  -76,
 -227,  218,  218,    0,    0,  116,    0,  116,   75,  218,
    0,    0,  218,    0, 1762,    0,  218,    0,    0,  218,
  218,  129,    0, -258,  218, -258,  218, -258,  218, -258,
  218,    0,  218,    0,  218,    0,  218,  218,    0,  218,
    0,  218,    0,  218,    0,  371,    0,  218,  154,  154,
  218,    0,  218,    0,  218,    0,    0,    0,  129,    0,
    0,  218,  218,  218,  218, -216,  218,  218,  116,   75,
    0,  116,  116,    0,  218, 1898,    0,  948,    0,    0,
  116, -258,  218,    0,    0,  218,    0,  218,    0,    0,
  129,  129,  218,  218,    0, 1842,  738, 1898, -187,  515,
 1142, 1898, -184,    0, -183,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -181,
    0,  218,    0,  218,    0,    0,    0,   56,  116,  116,
  116,  116,    0,    0,    0,    0,    0,    0,  -34,  495,
   75,   75,    0, -258,    0, 1681, -258, 1725,    0,  116,
  -98, 1842,  933,  371, 1842,    0, 1898,    0, 1898, -139,
    0,    0, 1762,    0,    0,  -54,  -54,    0, 1842,    0,
    0,    0,  467,  218, -196,    0, -193,    0,   75,   75,
    0,    0,    0,  -54,    0,    0,    0,    0, -182, -242,
    0, -242,    0, -177,    0, -174,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  129,    0,    0, 1744,
 1706,    0,    0,    0,    0,  116,    0,    0,    0,    0,
  218,    0,    0,   75,    0,   75,   75,    0,  218,  129,
  129,  847,  116,    0,    0,    0,    0, 1898,    0, 1898,
    0,    0,  193, -125, -123, -118, -115, -114, -104, -306,
    0, -274,    0,    0,    0,    0,  566, -157,    0, -122,
  577, -108, -107, -245,    0, -274, -274, 1916,    0,    0,
    0,    0,  180,  180,    0,    0,  218, 1842,  218,    0,
    0,  218,    0,  218,  218,    0,  218,   75,    0,    0,
    0, -112,    0,    0,    0,    0,  129,  218,    0,    0,
  218,  467,  218,  218,  218,  467, -140, -249,    0,    0,
    0,    0,  218, -105,  218,  -96,    0,    0,  218,  218,
  218,  218,  218,  218,    0,  371,    0,  218,    0,  218,
   75,    0,    0,    0,    0,    0,    0,  735,    0,  735,
  218,    0,   75,  218,  218,  218,    0,    0,    0,    0,
    0,    0,    0,  -85, -261,    0, -274,    0,  -87, -274,
  670, -346, -274, -274,  458,  -71,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -99,    0,    0,
    0, -252,  266,  605,    0,    0, -193,    0, -193,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  129,
  129,    0,    0,    0,    0,    0, -153,  -52,  -49,    0,
    0,  -47, -274,  -43,    0, -343,  -38,  -26,  -25,  -22,
  -50,    0,    0, 1842,    0,    0,    0,    0,    0,  735,
    0,  735,    0,    0,    0,    0,    0,    0,  -18,    0,
  -20,    0,    0,  -15,    0,    0,    0,    0,    0,    0,
  129,  129,  -48,    0,    0,    0,  735,    0,  735,    0,
  129,  129,    0,  735,    0,  735,  129,  218,    0,  735,
    0,  218,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  143,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1780, 1780,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  143,  143,    0,    0,
    0, 1780,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  304,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  143,    0,    0,    0, 1528,    0,  143,    0,  304,
    0,    0,    0,    0,    0,    0,    0,    0,  -68,    0,
    0,    0,    0,  338,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,    0,
    0,  361, 1860,    0, 1131,    0,    0,  680, 1860,    0,
 1926,    0,    0,    0,    0,    0,    0,    0,    0, 1798,
    0,    0,  436,    0,    0, 1820,    0,    0,    0,    0,
    0,    0, 1860,    0,    0,    0, 1137,    0,    0,    0,
  -33,  -24,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -27,    0, -219,    0, -219,    0,  -21,    0,  -21,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143,    0, 1263,    0,    0,    0,    0,    0,    0,
 1926, 1926,    0,    0,    0,    0,    0,    0,   60,    0,
    0,    0,   65,    0,  121,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  221,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1659,    0,
    0,    0,    0, 1659,  986,    0, 1659,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  391,  391,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  391,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  680,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  772,
  772,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  300,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  764,  791,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  680,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  407,    0,  442,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  366,    0,    0,    0,    0,  378,    0,
    0,    0,    0,    0,    0,  401,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  480,    0,    0,
    0,    0,    0,    0,    0,    0,  414,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  772,
  772,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  772,  772,    0,    0,    0,    0,    0,    0,    0,    0,
  772,  772,    0,    0,    0,    0,  772,    0,    0,    0,
    0,    0,    0,
};
static const YYINT yygindex[] = {                         0,
   38,   48,  283, -176, -298, -393,    0,  650,  640,   37,
    0,  555,  551, -291,    0,  710,    0,    7,    0, -375,
  -12,   31,  279,   51,   29, -141,  765,    0, -103,    0,
   -9,  -74,    0,  318,   -6,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  282,    0,    0,
    0,    0,   54,    0,
};
#define YYTABLESIZE 2307
static const YYINT yytable[] = {                        148,
  150,  151,  139,  642,  155,  157,  139,  341,  339,  184,
  340,  524,  342,  144,  182,  185,  189,  194,  198,  200,
  202,  139,  140,  141,  206,  209,  140,  141,  384,  214,
  215,  217,  199,  221,  224,  226,  219,  228,  229,  233,
  635,  140,  141,  663,  242,  244,  222,  246,  225,  249,
  251,  253,  255,  168,  257,  172,  178,  179,  262,  264,
  266,  267,  268,  636,  270,  203,  664,  139,  168,  168,
  168,  506,  564,  227,  281,  506,  284,  565,  514,  287,
  289,  290,  271,  213,  297,  299,  300,  140,  141,  139,
  305,  139,  258,  333,  335,  529,  482,  341,  339,  275,
  340,  276,  342,  248,  250,  252,  254,  463,  464,  140,
  141,  140,  141,  263,  465,  466,  341,  339,  598,  340,
  628,  342,  602,  273,  274,  154,  643,  343,  629,  139,
  126,  127,  128,  129,  130,  345,  168,  168,  575,  346,
  347,  576,  348,  139,  119,  120,  121,  122,  303,  140,
  141,  123,  124,  125,  139,  132,  154,  306,  119,  120,
  121,  122,  359,  140,  141,  123,  124,  125,  604,  139,
  145,  604,  142,  366,  140,  141,  368,  492,  336,  371,
  495,  372,  219,  139,  344,  374,  369,  293,  375,  140,
  141,  147,  383,  219,  378,  431,  462,  380,  381,  476,
  477,  382,  478,  140,  141,  386,  388,  293,  293,  163,
  646,  164,  391,  392,  512,  523,  393,  165,  166,  167,
  395,  341,   99,  396,  397,  398,  342,  653,  401,  654,
  403,  647,  405,  648,  407,  530,  408,  149,  409,  533,
  410,  411,  534,  412,  376,  413,  377,  414,  655,  656,
  657,  419,  569,  558,  422,  559,  423,  188,  424,  304,
  560,  570,  425,  561,  562,  427,  428,  429,  430,  298,
  432,  433,  394,  435,  563,  573,  574,  603,  438,  607,
  131,  126,  127,  128,  129,  130,  444,  222,  609,  445,
  144,  446,  156,  158,  447,  449,  451,  452,  627,  499,
  173,  173,  173,  180,  126,  127,  128,  129,  130,  201,
  173,  481,  641,  499,  500,  294,  293,  212,  216,  218,
  295,  604,  631,  644,  440,  479,  658,  480,  500,  659,
  139,  238,  669,  344,  680,  294,  294,    1,  139,  660,
  295,  295,  256,  662,  490,  491,  265,  261,  665,  154,
  140,  141,  126,  127,  128,  129,  130,  184,  140,  141,
  666,  667,  282,  283,  668,  673,  674,  288,  293,  291,
  521,  675,  119,  120,  121,  122,  297,  522,  219,  123,
  124,  125,  527,  528,  139,  126,  127,  128,  129,  130,
  219,   76,  507,  494,  616,  219,  297,  297,  593,  219,
  219,  219,  219,  584,  140,  141,  219,  219,  219,  353,
  535,  164,  219,  219,  219,  219,  219,  165,  166,  167,
  511,  337,  139,  510,  542,    0,    0,  543,  239,  544,
  545,    0,  546,  547,  549,  552,  126,  127,  128,  129,
  130,    0,  140,  141,  294,    0,  557,  145,  139,  295,
  360,    0,  566,  361,  362,    0,  363,  568,  540,  364,
  365,  572,  367,    0,    0,    0,  577,  578,  140,  141,
  556,  373,    0,  139,  362,    0,  274,    0,    0,    0,
  585,    0,  587,    0,  379,  588,    0,  589,  590,  551,
  591,  592,  385,  140,  141,  594,  274,  274,    0,  521,
  595,  596,  131,  521,  597,  297,  599,  600,  601,    0,
    0,  605,  154,  399,    0,  400,  606,  402,  608,  404,
    0,  406,  610,  611,  612,  613,  614,  615,    0,    0,
  517,  617,  139,  618,  619,  131,  341,  339,    0,  340,
    0,  342,    0,    0,  622,    0,  623,  624,  625,  626,
  426,    0,  140,  141,    0,  318,    0,  630,    0,  191,
  632,  634,  219,  637,  638,  640,    0,    0,  175,  175,
  175,  181,  183,  443,  175,  318,  318,  181,  175,  191,
  191,    0,  448,  450,  231,  181,  175,    0,  453,    0,
  220,  521,    0,    0,    0,    0,  232,  234,  236,  181,
  240,  241,  243,    0,    0,  274,  175,  175,  175,  175,
  181,    0,    0,  649,  651,  181,  175,  219,  219,  219,
  219,  279,    0,  661,  219,  219,  219,  119,  120,  121,
  122,  139,  489,  314,  123,  124,  125,    0,  173,    0,
  497,  279,  279,  195,  504,    0,  235,  508,  152,  153,
  133,  140,  141,  314,  314,    0,  333,    0,  133,  133,
  370,  515,  271,    0,  676,  678,  235,  235,  517,  269,
    0,    0,    0,    0,  683,  685,  333,  333,  219,    0,
  689,  691,  271,  271,  318,  693,    0,    0,  133,  269,
  269,  209,  219,  219,  219,  219,    0,  272,  536,  219,
  219,  219,  538,  173,  209,  219,  219,  219,  219,  219,
    0,  209,  209,  354,  356,  357,  358,  272,  272,  280,
    0,  548,  550,  119,  120,  121,  122,    0,    0,  133,
  123,  124,  125,  285,  286,  234,  126,  127,  128,  129,
  130,  208,  210,  211,    0,    0,    0,  175,  330,  175,
  279,  119,  120,  121,  122,  234,  234,    0,  123,  124,
  125,    0,  314,    0,  126,  127,  128,  129,  130,    0,
  586,  338,  219,    0,    0,  175,    0,  159,  160,  161,
  162,  133,  415,    0,    0,  333,    0,  219,  536,    0,
    0,  349,  350,  204,  205,  351,    0,  352,  269,    0,
    0,  133,  133,  227,  227,  133,  227,  133,  227,  332,
  334,  235,  237,  420,  421,    0,  207,  245,  164,  247,
    0,    0,    0,    0,  165,  166,  167,  259,  260,    0,
  228,  228,    0,  228,  269,  228,  140,  141,  441,  463,
  464,  277,  278,  279,  516,    0,  465,  466,  639,    0,
    0,    0,  219,  292,    0,  389,  181,  390,  301,  302,
  645,  119,  120,  121,  122,  133,    0,  133,  123,  124,
  125,  355,    0,  164,  126,  127,  128,  129,  130,  165,
  166,  167,    0,    0,    0,    0,  131,    0,  341,  339,
    0,  340,    0,  342,    0,    0,  463,  464,    0,    0,
  181,  650,  652,  465,  466,  416,  175,    0,  181,    0,
    0,  171,  181,    0,    0,  181,    0,    0,  434,    0,
    0,  436,  437,  175,    0,  467,  670,    0,  133,  181,
  442,  133,  133,    0,    0,  439,  219,  219,  219,  219,
  133,    0,    0,  219,  219,  219,    0,  463,  464,    0,
    0,    0,  677,  679,  465,  466,  460,  461,  463,  464,
  474,  475,  684,  686,    0,  465,  466,    0,  690,    0,
  181,  175,    0,    0,    0,    0,  567,    0,  483,  484,
  485,  486,  516,    0,    0,  166,    0,  571,  133,  133,
  133,  133,  175,    0,  119,  120,  121,  122,    0,  498,
    0,  123,  124,  125,  126,  127,  128,  129,  130,  133,
  501,    0,    0,  416,    0,    0,    0,    0,  509,  227,
  227,  227,  227,  227,  131,    0,  227,  227,  227,  227,
    0,    0,  520,  227,  227,  227,  227,  227,  181,  227,
  227,  219,  219,  219,  219,  219,  228,  228,  228,  228,
  228,  463,  464,  228,  228,  228,  228,    0,  465,  466,
  228,  228,  228,  228,  228,  541,  228,  228,    0,  139,
  119,  120,  121,  122,    0,  133,  170,  123,  124,  125,
  633,    0,  553,  126,  127,  128,  129,  130,    0,  140,
  141,  219,  133,    0,    0,    0,    0,  554,  620,  555,
  621,    0,  139,  119,  120,  121,  122,    0,    0,  170,
  123,  124,  125,    0,  139,    0,  126,  127,  128,  129,
  130,    0,  140,  141,    0,    0,    0,  583,  126,  127,
  128,  129,  130,    0,  140,  141,    8,  454,  455,  456,
  457,  458,  459,    0,    0,    0,    0,  227,    0,    0,
  132,  501,  341,  339,    0,  340,    0,  342,    0,    0,
    0,  520,    0,    0,  531,  520,  532,  294,    0,  164,
    0,    0,    0,    0,  228,  165,  166,  167,    0,    0,
  227,    0,    0,  227,    0,  416,    0,  140,  141,  119,
  120,  121,  122,    0,  181,  505,  123,  124,  125,    0,
  671,    0,  672,    0,    0,  164,    0,  228,    0,    0,
  228,  165,  166,  167,    0,    0,    0,  126,  127,  128,
  129,  130,    0,    0,    0,    0,    0,  681,    0,  682,
  171,    0,    0,    0,  687,  190,  688,    0,    0,    0,
  692,  196,  196,  196,  196,  196,  166,    0,  196,  196,
  196,  196,  166,  520,    0,  196,  196,  196,  196,  196,
    0,    0,    8,  171,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,    0,    0,  166,  166,  166,  166,  166,
    0,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,    0,  166,  166,  166,
  166,  166,  166,    0,    0,    0,    0,  119,  120,  121,
  122,    0,    0,    0,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,    0,    0,  219,  219,  219,
  219,    0,  207,  219,  219,  219,  219,    8,  119,  120,
  121,  122,  196,    8,    0,  123,  124,  125,    0,  166,
  166,    0,  207,  207,    0,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    0,    0,    8,    8,    8,    8,
    8,    0,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    0,    8,    8,
    8,    8,    8,    8,    0,    0,    0,    0,  196,    0,
    0,    0,  470,    8,    0,  471,    0,    0,    0,    8,
  131,    0,    0,    0,  472,    0,  473,    0,  196,  196,
    0,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    0,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    0,    8,    8,    8,    8,    8,    8,
    0,    0,  139,  119,  120,  121,  122,    0,    0,    1,
  123,  124,  125,    0,    0,    2,  126,  127,  128,  129,
  130,    0,  140,  141,    3,    0,    0,    4,    5,    6,
    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
   17,   18,   19,   20,   21,   22,    8,    8,   23,   24,
   25,   26,   27,    0,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,   88,   89,   90,   91,   92,    0,
   93,   94,   95,   96,   97,   98,  139,  119,  120,  121,
  122,    0,    0,  170,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,  219,  140,  141,    0,    0,
    0,  219,  219,  219,    0,    0,    1,  219,  219,  219,
  219,  219,    2,  171,   99,    0,    0,    0,    0,    0,
    0,    0,  100,  101,    4,    5,    6,    7,    8,    9,
   10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
   20,   21,   22,    0,    0,   23,   24,   25,   26,   27,
    0,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
   57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,   88,   89,   90,   91,   92,    0,   93,   94,   95,
   96,   97,   98,    0,  214,  219,  219,  219,  219,    0,
    0,    0,  219,  219,  219,    0,    0,  171,  219,  219,
  219,  219,  219,    0,  214,  214,  493,  119,  120,  121,
  122,    0,    0,  170,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,    0,    0,    0,    0,  100,
  101,  539,  119,  120,  121,  122,    0,    0,  170,  123,
  124,  125,    0,    0,    0,  126,  127,  128,  129,  130,
  496,  119,  120,  121,  122,    0,    0,    0,  123,  124,
  125,    0,    0,    0,  126,  127,  128,  129,  130,  537,
  119,  120,  121,  122,    0,    0,    0,  123,  124,  125,
    0,    0,    0,  126,  127,  128,  129,  130,  119,  120,
  121,  122,    0,    0,  170,  123,  124,  125,    0,    0,
    0,  126,  127,  128,  129,  130,  200,  200,  200,  200,
    0,    0,  200,  200,  200,  200,    0,    0,    0,  200,
  200,  200,  200,  200,  219,  219,  219,  219,    0,    0,
  219,  219,  219,  219,    0,    0,    0,  219,  219,  219,
  219,  219,    0,    0,    0,  219,  199,  199,  199,  199,
    0,    0,  199,  199,  199,  199,    0,    0,    0,  199,
  199,  199,  199,  199,    0,    0,    0,  171,  119,  120,
  121,  122,    0,    0,    0,  123,  124,  125,    0,    0,
    0,  126,  127,  128,  129,  130,  219,  219,  219,  219,
    0,    0,  171,  219,  219,  219,    0,    0,    0,  219,
  219,  219,  219,  219,    0,    0,    0,    0,    0,    0,
    0,  171,  119,  120,  121,  122,    0,    0,    0,  123,
  124,  125,    0,    0,  119,  120,  121,  122,    0,    0,
  171,  123,  124,  125,    0,    0,    0,    0,    0,    0,
    0,    0,  119,  120,  121,  122,    0,    0,  171,  123,
  124,  125,  219,  219,  219,  219,    0,    0,    0,  219,
  219,  219,    0,    0,    0,    0,  200,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  219,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  199,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  171,    0,
    0,    0,    0,  307,    0,  308,  309,    0,    0,  310,
    0,  311,    0,  312,    0,    0,  219,    0,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,    0,    0,  579,  580,    0,
    0,    0,    0,    0,  465,  581,  582,
};
static const YYINT yycheck[] = {                          6,
    7,    8,  256,  256,   11,   12,  256,   42,   43,   22,
   45,  387,   47,  256,   21,   22,   23,   24,   25,   26,
   27,  256,  276,  277,   31,   32,  276,  277,  256,   36,
   37,   38,   26,   40,   41,   42,  256,   44,  415,   46,
  387,  276,  277,  387,   51,   52,  414,   54,   42,   56,
   57,   58,   59,   17,   61,   18,   19,   20,   65,   66,
   67,   68,   69,  410,   71,   28,  410,  256,   32,   33,
   34,  363,  379,   43,   81,  367,   83,  384,  377,   86,
   87,   88,  414,   36,   91,   92,   93,  276,  277,  256,
   97,  256,   62,  100,  101,  394,   41,   42,   43,  412,
   45,  412,   47,   56,   57,   58,   59,  382,  383,  276,
  277,  276,  277,   66,  389,  390,   42,   43,  512,   45,
  382,   47,  516,   73,   74,  384,  379,  134,  390,  256,
  270,  271,  272,  273,  274,  142,  100,  101,  384,  146,
  147,  387,  149,  256,  257,  258,  259,  260,  426,  276,
  277,  264,  265,  266,  256,   40,  384,  275,  257,  258,
  259,  260,  169,  276,  277,  264,  265,  266,  421,  256,
  413,  421,  426,  180,  276,  277,  183,  354,  276,  186,
  357,  188,   40,  256,  420,  192,  275,  256,  268,  276,
  277,  426,  269,  413,  201,  412,  384,  204,  205,  384,
  384,  208,  384,  276,  277,  212,  213,  276,  277,  256,
  604,  258,  219,  220,  269,  412,  223,  264,  265,  266,
  227,   42,  416,  230,  231,  232,   47,  381,  235,  383,
  237,  607,  239,  609,  241,  418,  243,  426,  245,  417,
  247,  248,  417,  250,  197,  252,  199,  254,  402,  403,
  404,  258,  410,  379,  261,  379,  263,  422,  265,  426,
  379,  384,  269,  379,  379,  272,  273,  274,  275,  371,
  277,  278,  225,  280,  379,  384,  384,  418,  285,  385,
  420,  270,  271,  272,  273,  274,  293,  414,  385,  296,
  256,  298,   11,   12,  301,  302,  303,  304,  384,  412,
   18,   19,   20,   21,  270,  271,  272,  273,  274,   27,
   28,  256,  384,  412,  427,  256,  385,   35,   37,   38,
  256,  421,  410,   58,  288,  332,  379,  334,  427,  379,
  256,   49,  383,  420,  383,  276,  277,    0,  256,  387,
  276,  277,   60,  387,  351,  352,  419,   65,  387,  384,
  276,  277,  270,  271,  272,  273,  274,  370,  276,  277,
  387,  387,   81,   82,  387,  384,  387,   86,   90,   88,
  383,  387,  257,  258,  259,  260,  256,  384,  412,  264,
  265,  266,  389,  390,  256,  270,  271,  272,  273,  274,
  418,  416,  364,  356,  536,  417,  276,  277,  502,  257,
  258,  259,  260,  478,  276,  277,  264,  265,  266,  256,
  417,  258,  270,  271,  272,  273,  274,  264,  265,  266,
  373,  104,  256,  370,  431,   -1,   -1,  434,  417,  436,
  437,   -1,  439,  440,  441,  442,  270,  271,  272,  273,
  274,   -1,  276,  277,  385,   -1,  453,  413,  256,  385,
  169,   -1,  462,  172,  173,   -1,  175,  467,  421,  178,
  179,  471,  181,   -1,   -1,   -1,  476,  477,  276,  277,
  278,  190,   -1,  256,  193,   -1,  256,   -1,   -1,   -1,
  487,   -1,  489,   -1,  203,  492,   -1,  494,  495,  442,
  497,  498,  211,  276,  277,  502,  276,  277,   -1,  512,
  507,  508,  420,  516,  511,  385,  513,  514,  515,   -1,
   -1,  518,  384,  232,   -1,  234,  523,  236,  525,  238,
   -1,  240,  529,  530,  531,  532,  533,  534,   -1,   -1,
   64,  538,  256,  540,  541,  420,   42,   43,   -1,   45,
   -1,   47,   -1,   -1,  551,   -1,  553,  554,  555,  556,
  269,   -1,  276,  277,   -1,  256,   -1,  567,   -1,  256,
  570,  571,  420,  573,  574,  575,   -1,   -1,   18,   19,
   20,   21,   22,  292,   24,  276,  277,   27,   28,  276,
  277,   -1,  301,  302,  418,   35,   36,   -1,  306,   -1,
   40,  604,   -1,   -1,   -1,   -1,   46,   47,   48,   49,
   50,   51,   52,   -1,   -1,  385,   56,   57,   58,   59,
   60,   -1,   -1,  620,  621,   65,   66,  257,  258,  259,
  260,  256,   -1,  633,  264,  265,  266,  257,  258,  259,
  260,  256,  350,  256,  264,  265,  266,   -1,  356,   -1,
  358,  276,  277,  268,  362,   -1,  256,  365,    9,   10,
    1,  276,  277,  276,  277,   -1,  256,   -1,    9,   10,
  384,  379,  256,   -1,  671,  672,  276,  277,   64,  256,
   -1,   -1,   -1,   -1,  681,  682,  276,  277,   39,   -1,
  687,  688,  276,  277,  385,  692,   -1,   -1,   39,  276,
  277,  256,  257,  258,  259,  260,   -1,  256,  417,  264,
  265,  266,  420,  421,  269,  270,  271,  272,  273,  274,
   -1,  276,  277,  159,  160,  161,  162,  276,  277,   80,
   -1,  440,  441,  257,  258,  259,  260,   -1,   -1,   80,
  264,  265,  266,   84,   85,  256,  270,  271,  272,  273,
  274,   32,   33,   34,   -1,   -1,   -1,  197,   99,  199,
  385,  257,  258,  259,  260,  276,  277,   -1,  264,  265,
  266,   -1,  385,   -1,  270,  271,  272,  273,  274,   -1,
  488,  132,  412,   -1,   -1,  225,   -1,   13,   14,   15,
   16,  132,  412,   -1,   -1,  385,   -1,  427,  507,   -1,
   -1,  152,  153,   29,   30,  156,   -1,  158,  385,   -1,
   -1,  152,  153,   40,   41,  156,   43,  158,   45,  100,
  101,   47,   48,  259,  260,   -1,  256,   53,  258,   55,
   -1,   -1,   -1,   -1,  264,  265,  266,   63,   64,   -1,
   40,   41,   -1,   43,   70,   45,  276,  277,  288,  382,
  383,   77,   78,   79,  378,   -1,  389,  390,  391,   -1,
   -1,   -1,  417,   89,   -1,  216,  306,  218,   94,   95,
  256,  257,  258,  259,  260,  216,   -1,  218,  264,  265,
  266,  256,   -1,  258,  270,  271,  272,  273,  274,  264,
  265,  266,   -1,   -1,   -1,   -1,  420,   -1,   42,   43,
   -1,   45,   -1,   47,   -1,   -1,  382,  383,   -1,   -1,
  350,  620,  621,  389,  390,  256,  356,   -1,  358,   -1,
   -1,  417,  362,   -1,   -1,  365,   -1,   -1,  279,   -1,
   -1,  282,  283,  373,   -1,  411,  644,   -1,  279,  379,
  291,  282,  283,   -1,   -1,  286,  257,  258,  259,  260,
  291,   -1,   -1,  264,  265,  266,   -1,  382,  383,   -1,
   -1,   -1,  671,  672,  389,  390,  307,  308,  382,  383,
  311,  312,  681,  682,   -1,  389,  390,   -1,  687,   -1,
  420,  421,   -1,   -1,   -1,   -1,  411,   -1,  339,  340,
  341,  342,  378,   -1,   -1,    0,   -1,  411,  339,  340,
  341,  342,  442,   -1,  257,  258,  259,  260,   -1,  360,
   -1,  264,  265,  266,  270,  271,  272,  273,  274,  360,
  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,  369,  256,
  257,  258,  259,  260,  420,   -1,  263,  264,  265,  266,
   -1,   -1,  383,  270,  271,  272,  273,  274,  488,  276,
  277,  270,  271,  272,  273,  274,  256,  257,  258,  259,
  260,  382,  383,  263,  264,  265,  266,   -1,  389,  390,
  270,  271,  272,  273,  274,  426,  276,  277,   -1,  256,
  257,  258,  259,  260,   -1,  426,  263,  264,  265,  266,
  411,   -1,  443,  270,  271,  272,  273,  274,   -1,  276,
  277,  412,  443,   -1,   -1,   -1,   -1,  448,  548,  450,
  550,   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,  256,   -1,  270,  271,  272,  273,
  274,   -1,  276,  277,   -1,   -1,   -1,  478,  270,  271,
  272,  273,  274,   -1,  276,  277,    0,  400,  401,  402,
  403,  404,  405,   -1,   -1,   -1,   -1,  384,   -1,   -1,
   40,  502,   42,   43,   -1,   45,   -1,   47,   -1,   -1,
   -1,  512,   -1,   -1,  400,  516,  402,  256,   -1,  258,
   -1,   -1,   -1,   -1,  384,  264,  265,  266,   -1,   -1,
  417,   -1,   -1,  420,   -1,  536,   -1,  276,  277,  257,
  258,  259,  260,   -1,  644,  263,  264,  265,  266,   -1,
  650,   -1,  652,   -1,   -1,  258,   -1,  417,   -1,   -1,
  420,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,   -1,   -1,   -1,   -1,   -1,  677,   -1,  679,
  417,   -1,   -1,   -1,  684,  422,  686,   -1,   -1,   -1,
  690,  256,  257,  258,  259,  260,  261,   -1,  263,  264,
  265,  266,  267,  604,   -1,  270,  271,  272,  273,  274,
   -1,   -1,    0,  417,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,   -1,   -1,  300,  301,  302,  303,  304,
   -1,  306,  307,  308,  309,  310,  311,  312,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,   -1,  372,  373,  374,
  375,  376,  377,   -1,   -1,   -1,   -1,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,   -1,   -1,  257,  258,  259,
  260,   -1,  256,  263,  264,  265,  266,  261,  257,  258,
  259,  260,  417,  267,   -1,  264,  265,  266,   -1,  424,
  425,   -1,  276,  277,   -1,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,   -1,   -1,  300,  301,  302,  303,
  304,   -1,  306,  307,  308,  309,  310,  311,  312,  313,
  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
  344,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,   -1,  372,  373,
  374,  375,  376,  377,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  381,  261,   -1,  384,   -1,   -1,   -1,  267,
  420,   -1,   -1,   -1,  393,   -1,  395,   -1,  276,  277,
   -1,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  424,  425,  300,  301,  302,  303,  304,   -1,  306,  307,
  308,  309,  310,  311,  312,  313,  314,  315,  316,  317,
  318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,   -1,  372,  373,  374,  375,  376,  377,
   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,  261,
  264,  265,  266,   -1,   -1,  267,  270,  271,  272,  273,
  274,   -1,  276,  277,  276,   -1,   -1,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  424,  425,  300,  301,
  302,  303,  304,   -1,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,
  322,  323,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,  336,  337,  338,  339,  340,  341,
  342,  343,  344,  345,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,   -1,
  372,  373,  374,  375,  376,  377,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  258,  276,  277,   -1,   -1,
   -1,  264,  265,  266,   -1,   -1,  261,  270,  271,  272,
  273,  274,  267,  417,  416,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  424,  425,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,   -1,   -1,  300,  301,  302,  303,  304,
   -1,  306,  307,  308,  309,  310,  311,  312,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,   -1,  372,  373,  374,
  375,  376,  377,   -1,  256,  257,  258,  259,  260,   -1,
   -1,   -1,  264,  265,  266,   -1,   -1,  417,  270,  271,
  272,  273,  274,   -1,  276,  277,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,   -1,   -1,   -1,   -1,  424,
  425,  256,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,
  256,  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,  256,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,   -1,  270,  271,  272,  273,  274,  257,  258,
  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,   -1,   -1,   -1,  417,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,   -1,   -1,   -1,  417,  257,  258,
  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,  417,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,  257,  258,  259,  260,   -1,   -1,
  417,  264,  265,  266,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  257,  258,  259,  260,   -1,   -1,  417,  264,
  265,  266,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,
   -1,   -1,   -1,  378,   -1,  380,  381,   -1,   -1,  384,
   -1,  386,   -1,  388,   -1,   -1,  417,   -1,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,   -1,   -1,  382,  383,   -1,
   -1,   -1,   -1,   -1,  389,  390,  391,
};
#define YYFINAL 102
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 427
#define YYUNDFTOKEN 484
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,"':'",0,
0,0,0,0,"'@'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_LOG","CMD_LOGNAME",
"CMD_SIDEFX","CMD_DUMMY","CMD_RETURN","CMD_BLOCK_READ","CMD_BLOCK_WRITE",
"CMD_UP","CMD_DOWN","CMD_LOAD","CMD_SAVE","CMD_VERIFY","CMD_BVERIFY",
"CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO","CMD_REGISTERS",
"CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY","CMD_BREAK",
"CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP","CMD_UNDUMP",
"CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND","CMD_ASSEMBLE",
"CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE","CMD_HELP",
"CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK","CMD_LOAD_LABELS",
"CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL","CMD_SHOW_LABELS",
"CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_MKDIR","CMD_RMDIR",
"CMD_RESOURCE_GET","CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES",
"CMD_ATTACH","CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_CARTFREEZE",
"CMD_UPDB","CMD_JPDB","CMD_CPUHISTORY","CMD_MEMMAPZAP","CMD_MEMMAPSHOW",
"CMD_MEMMAPSAVE","CMD_COMMENT","CMD_LIST","CMD_STOPWATCH","RESET","CMD_EXPORT",
"CMD_AUTOSTART","CMD_AUTOLOAD","CMD_MAINCPU_TRACE","CMD_WARP","CMD_LABEL_ASGN",
"L_PAREN","R_PAREN","ARG_IMMEDIATE","REG_A","REG_X","REG_Y","COMMA","INST_SEP",
"L_BRACKET","R_BRACKET","LESS_THAN","REG_U","REG_S","REG_PC","REG_PCR","REG_B",
"REG_C","REG_D","REG_E","REG_H","REG_L","REG_AF","REG_BC","REG_DE","REG_HL",
"REG_IX","REG_IY","REG_SP","REG_IXH","REG_IXL","REG_IYH","REG_IYL","PLUS",
"MINUS","STRING","FILENAME","R_O_L","R_O_L_Q","OPCODE","LABEL","BANKNAME",
"CPUTYPE","MON_REGISTER","COND_OP","RADIX_TYPE","INPUT_SPEC","CMD_CHECKPT_ON",
"CMD_CHECKPT_OFF","TOGGLE","MASK",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : CMD_SCREEN address end_cmd",
"machine_state_rules : CMD_WARP end_cmd",
"machine_state_rules : CMD_WARP TOGGLE end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_DUMMY TOGGLE end_cmd",
"monitor_state_rules : CMD_DUMMY end_cmd",
"monitor_state_rules : CMD_LOG TOGGLE end_cmd",
"monitor_state_rules : CMD_LOG end_cmd",
"monitor_state_rules : CMD_LOGNAME filename end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE TOGGLE end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_MKDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_RMDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_UPDB number end_cmd",
"monitor_misc_rules : CMD_JPDB number number end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num address end_cmd",
"disk_rules : CMD_BLOAD filename device_num error",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num opt_address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"rest_of_line_or_quoted : R_O_L_Q",
"filename : FILENAME",
"filename : error",
"device_num : d_number",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COND_OP cond_expr",
"cond_expr : cond_expr COND_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : cond_operand",
"cond_operand : register",
"cond_operand : number",
"cond_operand : '@' BANKNAME ':' address",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"guess_default : B_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"number : H_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : B_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1150 "mon_parse.y"

int parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   if (default_memspace == e_comp_space) {
       /*
        * If the command is to be executed when the default address space is the main cpu,
        * Ensure drive CPU emulation is up to date with main cpu CLOCK.
        */
       drive_cpu_execute_all(maincpu_clk);
   }

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COND_OP:
           mon_out("Conditional operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();

   return rc;
}

static int yyerror(char *s)
{
#if 0
   fprintf(stderr, "ERR:%s\n", s);
#endif
   return 0;
}

static int resolve_datatype(unsigned guess_type, const char *num)
{
   /* FIXME: Handle cases when default type is non-numerical */
   if (default_radix == e_hexadecimal) {
       return (int)strtol(num, NULL, 16);
   }

   if ((guess_type == D_NUMBER) || (default_radix == e_decimal)) {
       return (int)strtol(num, NULL, 10);
   }

   if ((guess_type == O_NUMBER) || (default_radix == e_octal)) {
       return (int)strtol(num, NULL, 8);
   }

   return (int)strtol(num, NULL, 2);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = (int)new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = (int)new_addr(memspace, sa);
    return 0;
}
#line 1746 "mon_parse.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 204 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 2:
#line 205 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 3:
#line 206 "mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
break;
case 8:
#line 215 "mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
break;
case 21:
#line 230 "mon_parse.y"
	{ return ERR_BAD_CMD; }
break;
case 22:
#line 234 "mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
break;
case 23:
#line 236 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
break;
case 24:
#line 238 "mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
break;
case 25:
#line 240 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 26:
#line 242 "mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
break;
case 27:
#line 244 "mon_parse.y"
	{ mon_go(); }
break;
case 28:
#line 246 "mon_parse.y"
	{ mon_display_io_regs(0); }
break;
case 29:
#line 248 "mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
break;
case 30:
#line 250 "mon_parse.y"
	{ monitor_cpu_type_set(""); }
break;
case 31:
#line 252 "mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
break;
case 32:
#line 254 "mon_parse.y"
	{ mon_cpuhistory(-1,  0,  0,  0,   0,   0); }
break;
case 33:
#line 256 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-1].i,  0,  0,   0,   0); }
break;
case 34:
#line 258 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
break;
case 35:
#line 260 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
break;
case 36:
#line 262 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i,  yystack.l_mark[-1].i,   0); }
break;
case 37:
#line 264 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i,  yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
break;
case 38:
#line 266 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i,  0,  0,  0,   0,   0); }
break;
case 39:
#line 268 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,  0,   0,   0); }
break;
case 40:
#line 270 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
break;
case 41:
#line 272 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
break;
case 42:
#line 274 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0); }
break;
case 43:
#line 276 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-11].i, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
break;
case 44:
#line 278 "mon_parse.y"
	{ mon_instruction_return(); }
break;
case 45:
#line 280 "mon_parse.y"
	{ mon_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
break;
case 46:
#line 282 "mon_parse.y"
	{ mon_read_snapshot(yystack.l_mark[-1].str, 0); }
break;
case 47:
#line 284 "mon_parse.y"
	{ mon_instructions_step(-1); }
break;
case 48:
#line 286 "mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
break;
case 49:
#line 288 "mon_parse.y"
	{ mon_instructions_next(-1); }
break;
case 50:
#line 290 "mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
break;
case 51:
#line 292 "mon_parse.y"
	{ mon_stack_up(-1); }
break;
case 52:
#line 294 "mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
break;
case 53:
#line 296 "mon_parse.y"
	{ mon_stack_down(-1); }
break;
case 54:
#line 298 "mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
break;
case 55:
#line 300 "mon_parse.y"
	{ mon_display_screen(-1); }
break;
case 56:
#line 302 "mon_parse.y"
	{ mon_display_screen(yystack.l_mark[-1].a); }
break;
case 57:
#line 304 "mon_parse.y"
	{
                        mon_out("Warp mode is %s.\n",
                                vsync_get_warp_mode() ? "on" : "off");
                     }
break;
case 58:
#line 309 "mon_parse.y"
	{
                        vsync_set_warp_mode(!vsync_get_warp_mode());
                     }
break;
case 60:
#line 316 "mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
break;
case 61:
#line 318 "mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
break;
case 63:
#line 323 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
break;
case 64:
#line 328 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
break;
case 65:
#line 333 "mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 66:
#line 335 "mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
break;
case 67:
#line 337 "mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
break;
case 68:
#line 339 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
break;
case 69:
#line 341 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 70:
#line 343 "mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
break;
case 71:
#line 345 "mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
break;
case 72:
#line 347 "mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
break;
case 73:
#line 349 "mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
break;
case 74:
#line 351 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
break;
case 75:
#line 355 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
break;
case 76:
#line 361 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
break;
case 77:
#line 362 "mon_parse.y"
	{ }
break;
case 78:
#line 364 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
break;
case 79:
#line 366 "mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
break;
case 80:
#line 368 "mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
break;
case 81:
#line 372 "mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 82:
#line 374 "mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
break;
case 83:
#line 376 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 84:
#line 378 "mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
break;
case 85:
#line 380 "mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 86:
#line 382 "mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 87:
#line 384 "mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 88:
#line 386 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
break;
case 89:
#line 388 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
break;
case 90:
#line 390 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
break;
case 91:
#line 392 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
break;
case 92:
#line 394 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
break;
case 93:
#line 396 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
break;
case 94:
#line 398 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
break;
case 95:
#line 400 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
break;
case 96:
#line 402 "mon_parse.y"
	{ mon_memmap_zap(); }
break;
case 97:
#line 404 "mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
break;
case 98:
#line 406 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
break;
case 99:
#line 408 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
break;
case 100:
#line 410 "mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 101:
#line 414 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 102:
#line 423 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 103:
#line 426 "mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE, TRUE);
                  }
break;
case 104:
#line 430 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 105:
#line 433 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 106:
#line 442 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 107:
#line 445 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_exec | e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
break;
case 108:
#line 454 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
break;
case 109:
#line 459 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
break;
case 110:
#line 461 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
break;
case 111:
#line 463 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
break;
case 112:
#line 465 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
break;
case 113:
#line 467 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
break;
case 114:
#line 469 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
break;
case 115:
#line 471 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
break;
case 116:
#line 473 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
break;
case 117:
#line 475 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
break;
case 118:
#line 477 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
break;
case 119:
#line 479 "mon_parse.y"
	{ return ERR_EXPECT_STRING; }
break;
case 120:
#line 483 "mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
break;
case 121:
#line 485 "mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
break;
case 122:
#line 490 "mon_parse.y"
	{ 
                         break_on_dummy_access = ((yystack.l_mark[-1].action == e_TOGGLE) ? (break_on_dummy_access ^ 1) : yystack.l_mark[-1].action); 
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
break;
case 123:
#line 497 "mon_parse.y"
	{
                         mon_out("Checkpoints will %strigger on dummy accesses.\n",
                                   break_on_dummy_access ? "" : "not ");
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
break;
case 124:
#line 505 "mon_parse.y"
	{ 
                        int logenabled;
                        resources_get_int("MonitorLogEnabled", &logenabled);
                        logenabled = ((yystack.l_mark[-1].action == e_TOGGLE) ? (logenabled ^ 1) : yystack.l_mark[-1].action);
                        resources_set_int("MonitorLogEnabled", logenabled);
                     }
break;
case 125:
#line 512 "mon_parse.y"
	{
                         int logenabled;
                         const char *logfilename;
                         resources_get_int("MonitorLogEnabled", &logenabled);
                         resources_get_string("MonitorLogFileName", &logfilename);
                         if (logenabled) {
                            mon_out("Logging to '%s' is enabled.\n", logfilename);
                         } else {
                            mon_out("Logging is disabled.\n");
                         }
                     }
break;
case 126:
#line 524 "mon_parse.y"
	{ 
                        resources_set_string("MonitorLogFileName", yystack.l_mark[-1].str);
                     }
break;
case 127:
#line 528 "mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
break;
case 128:
#line 530 "mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
break;
case 129:
#line 548 "mon_parse.y"
	{ monitor_change_device(e_default_space); }
break;
case 130:
#line 550 "mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
break;
case 131:
#line 552 "mon_parse.y"
	{ mon_export(); }
break;
case 132:
#line 554 "mon_parse.y"
	{ mon_quit(); YYACCEPT; }
break;
case 133:
#line 556 "mon_parse.y"
	{ mon_exit(); YYACCEPT; }
break;
case 134:
#line 558 "mon_parse.y"
	{ mon_maincpu_toggle_trace(yystack.l_mark[-1].action); }
break;
case 135:
#line 562 "mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
break;
case 136:
#line 564 "mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
break;
case 137:
#line 566 "mon_parse.y"
	{ mon_command_print_help(NULL); }
break;
case 138:
#line 568 "mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
break;
case 139:
#line 570 "mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
break;
case 140:
#line 572 "mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
break;
case 141:
#line 574 "mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
break;
case 142:
#line 576 "mon_parse.y"
	{ mon_backtrace(); }
break;
case 143:
#line 578 "mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
break;
case 144:
#line 580 "mon_parse.y"
	{ mon_show_pwd(); }
break;
case 145:
#line 582 "mon_parse.y"
	{ mon_make_dir(yystack.l_mark[-1].str); }
break;
case 146:
#line 584 "mon_parse.y"
	{ mon_remove_dir(yystack.l_mark[-1].str); }
break;
case 147:
#line 586 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
break;
case 148:
#line 588 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
break;
case 149:
#line 590 "mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
break;
case 150:
#line 592 "mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
break;
case 151:
#line 594 "mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
break;
case 152:
#line 596 "mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
break;
case 153:
#line 598 "mon_parse.y"
	{ mon_reset_machine(-1); }
break;
case 154:
#line 600 "mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
break;
case 155:
#line 602 "mon_parse.y"
	{ mon_tape_ctrl(TAPEPORT_PORT_1, yystack.l_mark[-1].i); }
break;
case 156:
#line 604 "mon_parse.y"
	{ mon_cart_freeze(); }
break;
case 157:
#line 606 "mon_parse.y"
	{ mon_userport_set_output(yystack.l_mark[-1].i); }
break;
case 158:
#line 608 "mon_parse.y"
	{ mon_joyport_set_output(yystack.l_mark[-2].i, yystack.l_mark[-1].i); }
break;
case 159:
#line 610 "mon_parse.y"
	{ }
break;
case 160:
#line 612 "mon_parse.y"
	{ mon_stopwatch_reset(); }
break;
case 161:
#line 614 "mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
break;
case 162:
#line 618 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE); }
break;
case 163:
#line 620 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE); }
break;
case 164:
#line 622 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 165:
#line 624 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
break;
case 166:
#line 626 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 167:
#line 628 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 168:
#line 630 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
break;
case 169:
#line 632 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 170:
#line 634 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,FALSE); }
break;
case 171:
#line 636 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,TRUE); }
break;
case 172:
#line 638 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
break;
case 173:
#line 640 "mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 174:
#line 642 "mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
break;
case 175:
#line 644 "mon_parse.y"
	{ mon_drive_list(-1); }
break;
case 176:
#line 646 "mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
break;
case 177:
#line 648 "mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
break;
case 178:
#line 650 "mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
break;
case 179:
#line 652 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
break;
case 180:
#line 654 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
break;
case 181:
#line 656 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
break;
case 182:
#line 658 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
break;
case 183:
#line 662 "mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
break;
case 184:
#line 664 "mon_parse.y"
	{ mon_end_recording(); }
break;
case 185:
#line 666 "mon_parse.y"
	{ mon_playback_commands(yystack.l_mark[-1].str,true); }
break;
case 186:
#line 670 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
break;
case 187:
#line 672 "mon_parse.y"
	{ printf("Not yet.\n"); }
break;
case 188:
#line 676 "mon_parse.y"
	{ yydebug = 1; }
break;
case 189:
#line 679 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 190:
#line 682 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 191:
#line 683 "mon_parse.y"
	{ yyval.str = NULL; }
break;
case 192:
#line 686 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
break;
case 194:
#line 690 "mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
break;
case 196:
#line 694 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
break;
case 197:
#line 697 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
break;
case 198:
#line 698 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 199:
#line 701 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 200:
#line 702 "mon_parse.y"
	{ yyval.i = 0; }
break;
case 201:
#line 705 "mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
break;
case 202:
#line 711 "mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
break;
case 205:
#line 724 "mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (uint16_t) yystack.l_mark[0].i); }
break;
case 206:
#line 727 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 207:
#line 728 "mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
break;
case 209:
#line 732 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
break;
case 210:
#line 735 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
break;
case 211:
#line 737 "mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 212:
#line 739 "mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
break;
case 213:
#line 742 "mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
break;
case 214:
#line 743 "mon_parse.y"
	{ yyval.a = BAD_ADDR; }
break;
case 215:
#line 747 "mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 216:
#line 752 "mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
break;
case 217:
#line 757 "mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
break;
case 220:
#line 770 "mon_parse.y"
	{ yyval.i = e_comp_space; }
break;
case 221:
#line 771 "mon_parse.y"
	{ yyval.i = e_disk8_space; }
break;
case 222:
#line 772 "mon_parse.y"
	{ yyval.i = e_disk9_space; }
break;
case 223:
#line 773 "mon_parse.y"
	{ yyval.i = e_disk10_space; }
break;
case 224:
#line 774 "mon_parse.y"
	{ yyval.i = e_disk11_space; }
break;
case 225:
#line 777 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
break;
case 226:
#line 779 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 227:
#line 781 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
break;
case 228:
#line 782 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
break;
case 229:
#line 783 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
break;
case 230:
#line 784 "mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
break;
case 231:
#line 785 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
break;
case 232:
#line 786 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 233:
#line 787 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 234:
#line 790 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 235:
#line 791 "mon_parse.y"
	{ yyval.cond_node = 0; }
break;
case 236:
#line 794 "mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
break;
case 237:
#line 799 "mon_parse.y"
	{ return ERR_INCOMPLETE_COND_OP; }
break;
case 238:
#line 801 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
break;
case 239:
#line 803 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
break;
case 240:
#line 805 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
break;
case 241:
#line 808 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 242:
#line 814 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
break;
case 243:
#line 820 "mon_parse.y"
	{yyval.cond_node=new_cond;
                            yyval.cond_node->operation=e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-2].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = yystack.l_mark[0].a; yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;  
                        }
break;
case 246:
#line 836 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 247:
#line 837 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 250:
#line 844 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
break;
case 251:
#line 845 "mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
break;
case 252:
#line 846 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
break;
case 253:
#line 849 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 254:
#line 850 "mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
break;
case 255:
#line 853 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 256:
#line 854 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 257:
#line 855 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 258:
#line 856 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
break;
case 259:
#line 859 "mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
break;
case 260:
#line 860 "mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
break;
case 261:
#line 861 "mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
break;
case 262:
#line 864 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 263:
#line 865 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 264:
#line 866 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 265:
#line 867 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 266:
#line 868 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 270:
#line 876 "mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
break;
case 272:
#line 887 "mon_parse.y"
	{ asm_mode = 0; }
break;
case 273:
#line 890 "mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
break;
case 274:
#line 897 "mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
break;
case 275:
#line 908 "mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 276:
#line 919 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
break;
case 277:
#line 927 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
break;
case 278:
#line 946 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
break;
case 279:
#line 952 "mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
break;
case 280:
#line 960 "mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
break;
case 281:
#line 969 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
break;
case 282:
#line 971 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 283:
#line 972 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
break;
case 284:
#line 973 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
break;
case 285:
#line 974 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
break;
case 286:
#line 975 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
break;
case 287:
#line 976 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
break;
case 288:
#line 977 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
break;
case 289:
#line 979 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 290:
#line 981 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 291:
#line 983 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 292:
#line 985 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
break;
case 293:
#line 986 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
break;
case 294:
#line 987 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
break;
case 295:
#line 988 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
break;
case 296:
#line 989 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
break;
case 297:
#line 990 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
break;
case 298:
#line 991 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
break;
case 299:
#line 992 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
break;
case 300:
#line 993 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
break;
case 301:
#line 994 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
break;
case 302:
#line 995 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
break;
case 303:
#line 996 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
break;
case 304:
#line 997 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
break;
case 305:
#line 998 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
break;
case 306:
#line 999 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
break;
case 307:
#line 1000 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
break;
case 308:
#line 1001 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
break;
case 309:
#line 1002 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
break;
case 310:
#line 1003 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
break;
case 311:
#line 1004 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
break;
case 312:
#line 1006 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
break;
case 313:
#line 1007 "mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 314:
#line 1022 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 315:
#line 1026 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 316:
#line 1030 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 317:
#line 1034 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 318:
#line 1038 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 319:
#line 1042 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 320:
#line 1046 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 321:
#line 1050 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 322:
#line 1054 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 323:
#line 1066 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 324:
#line 1081 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
break;
case 325:
#line 1085 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
break;
case 326:
#line 1089 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
break;
case 327:
#line 1093 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
break;
case 328:
#line 1097 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
break;
case 329:
#line 1101 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
break;
case 330:
#line 1105 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
break;
case 331:
#line 1109 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
break;
case 332:
#line 1113 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
break;
case 333:
#line 1125 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
break;
case 334:
#line 1130 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
break;
case 335:
#line 1138 "mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
break;
case 336:
#line 1139 "mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
break;
case 337:
#line 1140 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
break;
case 338:
#line 1141 "mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
break;
case 339:
#line 1145 "mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
break;
#line 3483 "mon_parse.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                yys = yyname[YYTRANSLATE(yychar)];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
