/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2019-20 Sean Anderson <seanga2@gmail.com>
 */

#ifndef CLOCK_K210_SYSCTL_H
#define CLOCK_K210_SYSCTL_H

/*
 * Arbitrary identifiers for clocks.
 */
#define K210_CLK_NONE   0
#define K210_CLK_IN0_H  1
#define K210_CLK_PLL0_H 2
#define K210_CLK_PLL0   3
#define K210_CLK_PLL1   4
#define K210_CLK_PLL2   5
#define K210_CLK_PLL2_H 6
#define K210_CLK_CPU    7
#define K210_CLK_SRAM0  8
#define K210_CLK_SRAM1  9
#define K210_CLK_APB0   10
#define K210_CLK_APB1   11
#define K210_CLK_APB2   12
#define K210_CLK_ROM    13
#define K210_CLK_DMA    14
#define K210_CLK_AI     15
#define K210_CLK_DVP    16
#define K210_CLK_FFT    17
#define K210_CLK_GPIO   18
#define K210_CLK_SPI0   19
#define K210_CLK_SPI1   20
#define K210_CLK_SPI2   21
#define K210_CLK_SPI3   22
#define K210_CLK_I2S0   23
#define K210_CLK_I2S1   24
#define K210_CLK_I2S2   25
#define K210_CLK_I2S0_M 26
#define K210_CLK_I2S1_M 27
#define K210_CLK_I2S2_M 28
#define K210_CLK_I2C0   29
#define K210_CLK_I2C1   30
#define K210_CLK_I2C2   31
#define K210_CLK_UART1  32
#define K210_CLK_UART2  33
#define K210_CLK_UART3  34
#define K210_CLK_AES    35
#define K210_CLK_FPIOA  36
#define K210_CLK_TIMER0 37
#define K210_CLK_TIMER1 38
#define K210_CLK_TIMER2 39
#define K210_CLK_WDT0   40
#define K210_CLK_WDT1   41
#define K210_CLK_SHA    42
#define K210_CLK_OTP    43
#define K210_CLK_RTC    44
#define K210_CLK_ACLK   45

#endif /* CLOCK_K210_SYSCTL_H */
