/* TagTable.c generated by valac 0.40.4, the Vala compiler
 * generated from TagTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>
#include <time.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TAG_ID (tag_id_get_type ())
typedef struct _TagID TagID;

#define TYPE_TAG_ROW (tag_row_get_type ())
#define TAG_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_ROW, TagRow))
#define TAG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_ROW, TagRowClass))
#define IS_TAG_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_ROW))
#define IS_TAG_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_ROW))
#define TAG_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_ROW, TagRowClass))

typedef struct _TagRow TagRow;
typedef struct _TagRowClass TagRowClass;
typedef struct _TagRowPrivate TagRowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecTagRow ParamSpecTagRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_TAG_TABLE (tag_table_get_type ())
#define TAG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_TABLE, TagTable))
#define TAG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_TABLE, TagTableClass))
#define IS_TAG_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_TABLE))
#define IS_TAG_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_TABLE))
#define TAG_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_TABLE, TagTableClass))

typedef struct _TagTable TagTable;
typedef struct _TagTableClass TagTableClass;
typedef struct _TagTablePrivate TagTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tag_row_unref0(var) ((var == NULL) ? NULL : (var = (tag_row_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TagID {
	gint64 id;
};

struct _TagRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagRowPrivate * priv;
	TagID tag_id;
	gchar* name;
	GeeSet* source_id_list;
	time_t time_created;
};

struct _TagRowClass {
	GTypeClass parent_class;
	void (*finalize) (TagRow *self);
};

struct _ParamSpecTagRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _TagTable {
	DatabaseTable parent_instance;
	TagTablePrivate * priv;
};

struct _TagTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _PhotoID {
	gint64 id;
};


static gpointer tag_row_parent_class = NULL;
static gpointer tag_table_parent_class = NULL;
static TagTable* tag_table_instance;
static TagTable* tag_table_instance = NULL;
extern sqlite3* database_table_db;

GType tag_id_get_type (void) G_GNUC_CONST;
TagID* tag_id_dup (const TagID* self);
void tag_id_free (TagID* self);
#define TAG_ID_INVALID ((gint64) -1)
void tag_id_init (TagID *self,
                  gint64 id);
gboolean tag_id_is_invalid (TagID *self);
gboolean tag_id_is_valid (TagID *self);
gpointer tag_row_ref (gpointer instance);
void tag_row_unref (gpointer instance);
GParamSpec* param_spec_tag_row (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_tag_row (GValue* value,
                        gpointer v_object);
void value_take_tag_row (GValue* value,
                         gpointer v_object);
gpointer value_get_tag_row (const GValue* value);
GType tag_row_get_type (void) G_GNUC_CONST;
TagRow* tag_row_new (void);
TagRow* tag_row_construct (GType object_type);
static void tag_row_finalize (TagRow * obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType tag_table_get_type (void) G_GNUC_CONST;
static TagTable* tag_table_new (void);
static TagTable* tag_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
void database_table_fatal (const gchar* op,
                           gint res);
TagTable* tag_table_get_instance (void);
void tag_table_upgrade_for_htags (void);
GQuark database_error_quark (void);
GeeList* tag_table_get_all_rows (TagTable* self,
                                 GError** error);
#define TAG_PATH_SEPARATOR_STRING "/"
void tag_table_rename (TagTable* self,
                       TagID* tag_id,
                       const gchar* new_name,
                       GError** error);
TagRow* tag_table_add (TagTable* self,
                       const gchar* name,
                       GError** error);
gulong now_sec (void);
void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
void tag_table_create_from_row (TagTable* self,
                                TagRow* row,
                                TagID* result,
                                GError** error);
static gchar* tag_table_serialize_source_ids (TagTable* self,
                                       GeeCollection* source_ids);
void tag_table_remove (TagTable* self,
                       TagID* tag_id,
                       GError** error);
void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
gchar* tag_table_get_name (TagTable* self,
                           TagID* tag_id,
                           GError** error);
gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt* * stmt);
TagRow* tag_table_get_row (TagTable* self,
                           TagID* tag_id,
                           GError** error);
static GeeSet* tag_table_unserialize_source_ids (TagTable* self,
                                          const gchar* text_list);
void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
void tag_table_set_tagged_sources (TagTable* self,
                                   TagID* tag_id,
                                   GeeCollection* source_ids,
                                   GError** error);
gboolean is_string_empty (const gchar* s);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
gint64 parse_int64 (const gchar* str,
                    gint num_base);
void photo_id_init (PhotoID *self,
                    gint64 id);
static void tag_table_finalize (DatabaseTable * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void
tag_id_init (TagID *self,
             gint64 id)
{
#line 12 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	memset (self, 0, sizeof (TagID));
#line 13 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	(*self).id = id;
#line 260 "TagTable.c"
}


gboolean
tag_id_is_invalid (TagID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _tmp0_ == TAG_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 275 "TagTable.c"
}


gboolean
tag_id_is_valid (TagID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 21 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _tmp0_ != TAG_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 290 "TagTable.c"
}


TagID*
tag_id_dup (const TagID* self)
{
	TagID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	dup = g_new0 (TagID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	memcpy (dup, self, sizeof (TagID));
#line 7 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return dup;
#line 304 "TagTable.c"
}


void
tag_id_free (TagID* self)
{
#line 7 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_free (self);
#line 313 "TagTable.c"
}


GType
tag_id_get_type (void)
{
	static volatile gsize tag_id_type_id__volatile = 0;
	if (g_once_init_enter (&tag_id_type_id__volatile)) {
		GType tag_id_type_id;
		tag_id_type_id = g_boxed_type_register_static ("TagID", (GBoxedCopyFunc) tag_id_dup, (GBoxedFreeFunc) tag_id_free);
		g_once_init_leave (&tag_id_type_id__volatile, tag_id_type_id);
	}
	return tag_id_type_id__volatile;
}


TagRow*
tag_row_construct (GType object_type)
{
	TagRow* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	self = (TagRow*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return self;
#line 338 "TagTable.c"
}


TagRow*
tag_row_new (void)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return tag_row_construct (TYPE_TAG_ROW);
#line 347 "TagTable.c"
}


static void
value_tag_row_init (GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	value->data[0].v_pointer = NULL;
#line 356 "TagTable.c"
}


static void
value_tag_row_free_value (GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		tag_row_unref (value->data[0].v_pointer);
#line 367 "TagTable.c"
	}
}


static void
value_tag_row_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		dest_value->data[0].v_pointer = tag_row_ref (src_value->data[0].v_pointer);
#line 380 "TagTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 384 "TagTable.c"
	}
}


static gpointer
value_tag_row_peek_pointer (const GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return value->data[0].v_pointer;
#line 394 "TagTable.c"
}


static gchar*
value_tag_row_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (collect_values[0].v_pointer) {
#line 406 "TagTable.c"
		TagRow * object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 413 "TagTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 417 "TagTable.c"
		}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = tag_row_ref (object);
#line 421 "TagTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = NULL;
#line 425 "TagTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return NULL;
#line 429 "TagTable.c"
}


static gchar*
value_tag_row_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	TagRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 445 "TagTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		*object_p = NULL;
#line 451 "TagTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		*object_p = value->data[0].v_pointer;
#line 455 "TagTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		*object_p = tag_row_ref (value->data[0].v_pointer);
#line 459 "TagTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return NULL;
#line 463 "TagTable.c"
}


GParamSpec*
param_spec_tag_row (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecTagRow* spec;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TAG_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return G_PARAM_SPEC (spec);
#line 483 "TagTable.c"
}


gpointer
value_get_tag_row (const GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return value->data[0].v_pointer;
#line 494 "TagTable.c"
}


void
value_set_tag_row (GValue* value,
                   gpointer v_object)
{
	TagRow * old;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		tag_row_ref (value->data[0].v_pointer);
#line 517 "TagTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = NULL;
#line 521 "TagTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		tag_row_unref (old);
#line 527 "TagTable.c"
	}
}


void
value_take_tag_row (GValue* value,
                    gpointer v_object)
{
	TagRow * old;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = v_object;
#line 549 "TagTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		value->data[0].v_pointer = NULL;
#line 553 "TagTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		tag_row_unref (old);
#line 559 "TagTable.c"
	}
}


static void
tag_row_class_init (TagRowClass * klass)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	tag_row_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	((TagRowClass *) klass)->finalize = tag_row_finalize;
#line 571 "TagTable.c"
}


static void
tag_row_instance_init (TagRow * self)
{
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	self->ref_count = 1;
#line 580 "TagTable.c"
}


static void
tag_row_finalize (TagRow * obj)
{
	TagRow * self;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAG_ROW, TagRow);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_signal_handlers_destroy (self);
#line 27 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_free0 (self->name);
#line 28 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_object_unref0 (self->source_id_list);
#line 596 "TagTable.c"
}


GType
tag_row_get_type (void)
{
	static volatile gsize tag_row_type_id__volatile = 0;
	if (g_once_init_enter (&tag_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tag_row_init, value_tag_row_free_value, value_tag_row_copy_value, value_tag_row_peek_pointer, "p", value_tag_row_collect_value, "p", value_tag_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TagRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagRow), 0, (GInstanceInitFunc) tag_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tag_row_type_id;
		tag_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TagRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tag_row_type_id__volatile, tag_row_type_id);
	}
	return tag_row_type_id__volatile;
}


gpointer
tag_row_ref (gpointer instance)
{
	TagRow * self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return instance;
#line 625 "TagTable.c"
}


void
tag_row_unref (gpointer instance)
{
	TagRow * self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		TAG_ROW_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 640 "TagTable.c"
	}
}


static TagTable*
tag_table_construct (GType object_type)
{
	TagTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
#line 35 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	self = (TagTable*) database_table_construct (object_type);
#line 36 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "TagTable");
#line 39 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 39 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "TagTable " "(" "id INTEGER PRIMARY KEY, " "name TEXT UNIQUE NOT NULL, " "photo_id_list TEXT, " "time_created INTEGER" ")", -1, &_tmp1_, NULL);
#line 39 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 39 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 39 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 47 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 47 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 49 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 49 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_step (_tmp4_);
#line 50 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = res;
#line 50 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 683 "TagTable.c"
		gint _tmp6_;
#line 51 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp6_ = res;
#line 51 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		database_table_fatal ("create TagTable", _tmp6_);
#line 689 "TagTable.c"
	}
#line 35 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 35 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return self;
#line 695 "TagTable.c"
}


static TagTable*
tag_table_new (void)
{
#line 35 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return tag_table_construct (TYPE_TAG_TABLE);
#line 704 "TagTable.c"
}


static gpointer
_database_table_ref0 (gpointer self)
{
#line 58 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 713 "TagTable.c"
}


TagTable*
tag_table_get_instance (void)
{
	TagTable* result = NULL;
	TagTable* _tmp0_;
	TagTable* _tmp2_;
	TagTable* _tmp3_;
#line 55 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = tag_table_instance;
#line 55 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp0_ == NULL) {
#line 728 "TagTable.c"
		TagTable* _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp1_ = tag_table_new ();
#line 56 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_database_table_unref0 (tag_table_instance);
#line 56 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		tag_table_instance = _tmp1_;
#line 736 "TagTable.c"
	}
#line 58 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = tag_table_instance;
#line 58 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 58 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _tmp3_;
#line 58 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 746 "TagTable.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return self ? g_object_ref (self) : NULL;
#line 755 "TagTable.c"
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 778 "TagTable.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 782 "TagTable.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 788 "TagTable.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 792 "TagTable.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 796 "TagTable.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 804 "TagTable.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 832 "TagTable.c"
				goto __catch21_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 841 "TagTable.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 855 "TagTable.c"
				goto __catch21_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 866 "TagTable.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 880 "TagTable.c"
	}
	goto __finally21;
	__catch21_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 894 "TagTable.c"
	}
	__finally21:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 905 "TagTable.c"
	}
}


void
tag_table_upgrade_for_htags (void)
{
	TagTable* table = NULL;
	TagTable* _tmp0_;
	GError * _inner_error_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = tag_table_get_instance ();
#line 62 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	table = _tmp0_;
#line 920 "TagTable.c"
	{
		GeeList* rows = NULL;
		TagTable* _tmp1_;
		GeeList* _tmp2_;
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp1_ = table;
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp2_ = tag_table_get_all_rows (_tmp1_, &_inner_error_);
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		rows = _tmp2_;
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 935 "TagTable.c"
				goto __catch20_database_error;
			}
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_database_table_unref0 (table);
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_clear_error (&_inner_error_);
#line 65 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return;
#line 946 "TagTable.c"
		}
		{
			GeeList* _row_list = NULL;
			GeeList* _tmp3_;
			GeeList* _tmp4_;
			gint _row_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _row_index = 0;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp3_ = rows;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp4_ = _g_object_ref0 (_tmp3_);
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_row_list = _tmp4_;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp5_ = _row_list;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp7_ = _tmp6_;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_row_size = _tmp7_;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_row_index = -1;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			while (TRUE) {
#line 975 "TagTable.c"
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				TagRow* row = NULL;
				GeeList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				TagRow* _tmp14_;
				TagRow* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				TagTable* _tmp18_;
				TagRow* _tmp19_;
				TagID _tmp20_;
				TagRow* _tmp21_;
				const gchar* _tmp22_;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp8_ = _row_index;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_row_index = _tmp8_ + 1;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp9_ = _row_index;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp10_ = _row_size;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					break;
#line 1004 "TagTable.c"
				}
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp11_ = _row_list;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp12_ = _row_index;
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				row = (TagRow*) _tmp13_;
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp14_ = row;
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp15_ = row;
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp16_ = _tmp15_->name;
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp17_ = string_replace (_tmp16_, TAG_PATH_SEPARATOR_STRING, "-");
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_g_free0 (_tmp14_->name);
#line 68 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp14_->name = _tmp17_;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp18_ = table;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp19_ = row;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp20_ = _tmp19_->tag_id;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp21_ = row;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp22_ = _tmp21_->name;
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				tag_table_rename (_tmp18_, &_tmp20_, _tmp22_, &_inner_error_);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tag_row_unref0 (row);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_object_unref0 (_row_list);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_object_unref0 (rows);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 1048 "TagTable.c"
						goto __catch20_database_error;
					}
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tag_row_unref0 (row);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_object_unref0 (_row_list);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_object_unref0 (rows);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_database_table_unref0 (table);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					g_clear_error (&_inner_error_);
#line 69 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					return;
#line 1065 "TagTable.c"
				}
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tag_row_unref0 (row);
#line 1069 "TagTable.c"
			}
#line 67 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_g_object_unref0 (_row_list);
#line 1073 "TagTable.c"
		}
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_g_object_unref0 (rows);
#line 1077 "TagTable.c"
	}
	goto __finally20;
	__catch20_database_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		e = _inner_error_;
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_inner_error_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp23_ = e->message;
#line 72 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_error ("TagTable.vala:72: TagTable: can't upgrade tag names for hierarchical t" \
"ag support: %s", _tmp23_);
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_g_error_free0 (e);
#line 1094 "TagTable.c"
	}
	__finally20:
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_database_table_unref0 (table);
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		g_clear_error (&_inner_error_);
#line 64 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return;
#line 1107 "TagTable.c"
	}
#line 61 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_database_table_unref0 (table);
#line 1111 "TagTable.c"
}


TagRow*
tag_table_add (TagTable* self,
               const gchar* name,
               GError** error)
{
	TagRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	time_t time_created = 0;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	time_t _tmp9_;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_;
	TagRow* row = NULL;
	TagRow* _tmp14_;
	TagRow* _tmp15_;
	sqlite3* _tmp16_;
	TagRow* _tmp17_;
	gchar* _tmp18_;
	TagRow* _tmp19_;
	TagRow* _tmp20_;
	time_t _tmp21_;
	GError * _inner_error_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 76 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 78 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 78 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO TagTable (name, time_created) VALUES (?, ?)", -1, &_tmp1_, NULL);
#line 78 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 78 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 80 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 80 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 82 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	time_created = (time_t) now_sec ();
#line 84 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 84 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = g_strdup (name);
#line 84 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp6_ = g_free;
#line 84 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 85 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp7_ = res;
#line 85 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 86 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp8_ = stmt;
#line 86 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp9_ = time_created;
#line 86 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_int64 (_tmp8_, 2, (gint64) _tmp9_);
#line 87 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp10_ = res;
#line 87 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 89 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp11_ = stmt;
#line 89 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_step (_tmp11_);
#line 90 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp12_ = res;
#line 90 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 1197 "TagTable.c"
		gint _tmp13_;
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp13_ = res;
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		database_table_throw_error ("TagTable.add", _tmp13_, &_inner_error_);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_propagate_error (error, _inner_error_);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return NULL;
#line 1213 "TagTable.c"
			} else {
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_clear_error (&_inner_error_);
#line 91 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return NULL;
#line 1223 "TagTable.c"
			}
		}
	}
#line 93 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp14_ = tag_row_new ();
#line 93 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	row = _tmp14_;
#line 94 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp15_ = row;
#line 94 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp16_ = database_table_db;
#line 94 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	tag_id_init (&_tmp15_->tag_id, sqlite3_last_insert_rowid (_tmp16_));
#line 95 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp17_ = row;
#line 95 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp18_ = g_strdup (name);
#line 95 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_free0 (_tmp17_->name);
#line 95 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp17_->name = _tmp18_;
#line 96 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp19_ = row;
#line 96 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_object_unref0 (_tmp19_->source_id_list);
#line 96 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp19_->source_id_list = NULL;
#line 97 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp20_ = row;
#line 97 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp21_ = time_created;
#line 97 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp20_->time_created = _tmp21_;
#line 99 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = row;
#line 99 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 99 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 1263 "TagTable.c"
}


void
tag_table_create_from_row (TagTable* self,
                           TagRow* row,
                           TagID* result,
                           GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_;
	GeeSet* _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	gint _tmp13_;
	sqlite3_stmt* _tmp14_;
	time_t _tmp15_;
	gint _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_;
	sqlite3* _tmp20_;
	TagID _tmp21_ = {0};
	GError * _inner_error_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (IS_TAG_TABLE (self));
#line 103 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (IS_TAG_ROW (row));
#line 105 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 105 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO TagTable (name, photo_id_list, time_created) VALUES (?, ?," \
" ?)", -1, &_tmp1_, NULL);
#line 105 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 105 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 105 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 107 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 109 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 109 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = row->name;
#line 109 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 109 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp7_ = g_free;
#line 109 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 110 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp8_ = res;
#line 110 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 111 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp9_ = stmt;
#line 111 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp10_ = row->source_id_list;
#line 111 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp11_ = tag_table_serialize_source_ids (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
#line 111 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp12_ = g_free;
#line 111 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_text (_tmp9_, 2, _tmp11_, -1, _tmp12_);
#line 112 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp13_ = res;
#line 112 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 113 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp14_ = stmt;
#line 113 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp15_ = row->time_created;
#line 113 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_int64 (_tmp14_, 3, (gint64) _tmp15_);
#line 114 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp16_ = res;
#line 114 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp16_ == SQLITE_OK, "res == Sqlite.OK");
#line 116 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp17_ = stmt;
#line 116 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_step (_tmp17_);
#line 117 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp18_ = res;
#line 117 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp18_ != SQLITE_DONE) {
#line 1361 "TagTable.c"
		gint _tmp19_;
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp19_ = res;
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		database_table_throw_error ("TagTable.create_from_row", _tmp19_, &_inner_error_);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_propagate_error (error, _inner_error_);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return;
#line 1377 "TagTable.c"
			} else {
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_clear_error (&_inner_error_);
#line 118 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return;
#line 1387 "TagTable.c"
			}
		}
	}
#line 120 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp20_ = database_table_db;
#line 120 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	tag_id_init (&_tmp21_, sqlite3_last_insert_rowid (_tmp20_));
#line 120 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	*result = _tmp21_;
#line 120 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 120 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return;
#line 1401 "TagTable.c"
}


void
tag_table_remove (TagTable* self,
                  TagID* tag_id,
                  GError** error)
{
	TagID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (IS_TAG_TABLE (self));
#line 123 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (tag_id != NULL);
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = *tag_id;
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp1_ = _tmp0_.id;
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_propagate_error (error, _inner_error_);
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return;
#line 1431 "TagTable.c"
		} else {
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_clear_error (&_inner_error_);
#line 124 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return;
#line 1439 "TagTable.c"
		}
	}
}


gchar*
tag_table_get_name (TagTable* self,
                    TagID* tag_id,
                    GError** error)
{
	gchar* result = NULL;
	sqlite3_stmt* stmt = NULL;
	TagID _tmp0_;
	gint64 _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 127 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 127 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (tag_id != NULL, NULL);
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = *tag_id;
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp1_ = _tmp0_.id;
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "name", &_tmp2_);
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp2_;
#line 129 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (!_tmp3_) {
#line 130 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		result = NULL;
#line 130 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_sqlite3_finalize0 (stmt);
#line 130 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return result;
#line 1481 "TagTable.c"
	}
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, 0);
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _tmp6_;
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 132 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 1495 "TagTable.c"
}


TagRow*
tag_table_get_row (TagTable* self,
                   TagID* tag_id,
                   GError** error)
{
	TagRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	TagID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	TagRow* row = NULL;
	TagRow* _tmp12_;
	TagRow* _tmp13_;
	TagID _tmp14_;
	TagRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	TagRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	const gchar* _tmp21_;
	GeeSet* _tmp22_;
	TagRow* _tmp23_;
	sqlite3_stmt* _tmp24_;
	GError * _inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 135 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (tag_id != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 137 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, photo_id_list, time_created FROM TagTable WHERE id=?", -1, &_tmp1_, NULL);
#line 137 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 137 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 137 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 139 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 139 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 141 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 141 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = *tag_id;
#line 141 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp6_ = _tmp5_.id;
#line 141 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 142 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp7_ = res;
#line 142 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 144 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp8_ = stmt;
#line 144 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_step (_tmp8_);
#line 145 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp9_ = res;
#line 145 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp9_ == SQLITE_DONE) {
#line 146 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		result = NULL;
#line 146 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_sqlite3_finalize0 (stmt);
#line 146 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return result;
#line 1576 "TagTable.c"
	} else {
		gint _tmp10_;
#line 147 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp10_ = res;
#line 147 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (_tmp10_ != SQLITE_ROW) {
#line 1583 "TagTable.c"
			gint _tmp11_;
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp11_ = res;
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			database_table_throw_error ("TagTable.get_row", _tmp11_, &_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					g_propagate_error (error, _inner_error_);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_sqlite3_finalize0 (stmt);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					return NULL;
#line 1599 "TagTable.c"
				} else {
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_sqlite3_finalize0 (stmt);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					return NULL;
#line 1609 "TagTable.c"
				}
			}
		}
	}
#line 150 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp12_ = tag_row_new ();
#line 150 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	row = _tmp12_;
#line 151 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp13_ = row;
#line 151 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp14_ = *tag_id;
#line 151 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp13_->tag_id = _tmp14_;
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp15_ = row;
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp16_ = stmt;
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp17_ = sqlite3_column_text (_tmp16_, 0);
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_free0 (_tmp15_->name);
#line 152 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp15_->name = _tmp18_;
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp19_ = row;
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp20_ = stmt;
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp21_ = sqlite3_column_text (_tmp20_, 1);
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp22_ = tag_table_unserialize_source_ids (self, _tmp21_);
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_object_unref0 (_tmp19_->source_id_list);
#line 153 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp19_->source_id_list = _tmp22_;
#line 154 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp23_ = row;
#line 154 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp24_ = stmt;
#line 154 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp23_->time_created = (time_t) sqlite3_column_int64 (_tmp24_, 2);
#line 156 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = row;
#line 156 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 156 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 1660 "TagTable.c"
}


GeeList*
tag_table_get_all_rows (TagTable* self,
                        GError** error)
{
	GeeList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp4_;
	GError * _inner_error_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 161 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, photo_id_list, time_created FROM TagTable", -1, &_tmp1_, NULL);
#line 161 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 161 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 163 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 163 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 165 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_TAG_ROW, (GBoxedCopyFunc) tag_row_ref, (GDestroyNotify) tag_row_unref, NULL, NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList);
#line 1698 "TagTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 167 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp5_ = TRUE;
#line 167 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		while (TRUE) {
#line 1705 "TagTable.c"
			sqlite3_stmt* _tmp6_;
			gint _tmp7_;
			TagRow* row = NULL;
			TagRow* _tmp10_;
			TagRow* _tmp11_;
			sqlite3_stmt* _tmp12_;
			TagRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			TagRow* _tmp17_;
			sqlite3_stmt* _tmp18_;
			const gchar* _tmp19_;
			GeeSet* _tmp20_;
			TagRow* _tmp21_;
			sqlite3_stmt* _tmp22_;
			GeeList* _tmp23_;
			TagRow* _tmp24_;
#line 167 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (!_tmp5_) {
#line 1726 "TagTable.c"
			}
#line 167 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp5_ = FALSE;
#line 168 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp6_ = stmt;
#line 168 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			res = sqlite3_step (_tmp6_);
#line 169 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp7_ = res;
#line 169 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (_tmp7_ == SQLITE_DONE) {
#line 170 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				break;
#line 1740 "TagTable.c"
			} else {
				gint _tmp8_;
#line 171 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp8_ = res;
#line 171 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (_tmp8_ != SQLITE_ROW) {
#line 1747 "TagTable.c"
					gint _tmp9_;
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp9_ = res;
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					database_table_throw_error ("TagTable.get_all_rows", _tmp9_, &_inner_error_);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							g_propagate_error (error, _inner_error_);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							_g_object_unref0 (rows);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							_sqlite3_finalize0 (stmt);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							return NULL;
#line 1765 "TagTable.c"
						} else {
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							_g_object_unref0 (rows);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							_sqlite3_finalize0 (stmt);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							g_clear_error (&_inner_error_);
#line 172 "/home/jens/Source/shotwell/src/db/TagTable.vala"
							return NULL;
#line 1777 "TagTable.c"
						}
					}
				}
			}
#line 175 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp10_ = tag_row_new ();
#line 175 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			row = _tmp10_;
#line 176 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp11_ = row;
#line 176 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp12_ = stmt;
#line 176 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			tag_id_init (&_tmp11_->tag_id, sqlite3_column_int64 (_tmp12_, 0));
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp13_ = row;
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp14_ = stmt;
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 1);
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_g_free0 (_tmp13_->name);
#line 177 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp13_->name = _tmp16_;
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp17_ = row;
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp18_ = stmt;
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp19_ = sqlite3_column_text (_tmp18_, 2);
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp20_ = tag_table_unserialize_source_ids (self, _tmp19_);
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_g_object_unref0 (_tmp17_->source_id_list);
#line 178 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp17_->source_id_list = _tmp20_;
#line 179 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp21_ = row;
#line 179 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp22_ = stmt;
#line 179 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp21_->time_created = (time_t) sqlite3_column_int64 (_tmp22_, 3);
#line 181 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp23_ = rows;
#line 181 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp24_ = row;
#line 181 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_);
#line 167 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tag_row_unref0 (row);
#line 1830 "TagTable.c"
		}
	}
#line 184 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = rows;
#line 184 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 184 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 1839 "TagTable.c"
}


void
tag_table_rename (TagTable* self,
                  TagID* tag_id,
                  const gchar* new_name,
                  GError** error)
{
	TagID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (IS_TAG_TABLE (self));
#line 187 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (tag_id != NULL);
#line 187 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (new_name != NULL);
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = *tag_id;
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp1_ = _tmp0_.id;
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "name", new_name, &_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_propagate_error (error, _inner_error_);
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return;
#line 1872 "TagTable.c"
		} else {
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_clear_error (&_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			return;
#line 1880 "TagTable.c"
		}
	}
}


void
tag_table_set_tagged_sources (TagTable* self,
                              TagID* tag_id,
                              GeeCollection* source_ids,
                              GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	TagID _tmp9_;
	gint64 _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (IS_TAG_TABLE (self));
#line 191 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (tag_id != NULL);
#line 191 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_if_fail (GEE_IS_COLLECTION (source_ids));
#line 193 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = database_table_db;
#line 193 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE TagTable SET photo_id_list=? WHERE id=?", -1, &_tmp1_, NULL);
#line 193 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 193 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	stmt = _tmp1_;
#line 193 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = _tmp2_;
#line 194 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = res;
#line 194 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 196 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp4_ = stmt;
#line 196 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp5_ = tag_table_serialize_source_ids (self, source_ids);
#line 196 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp6_ = g_free;
#line 196 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 197 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp7_ = res;
#line 197 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 198 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp8_ = stmt;
#line 198 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp9_ = *tag_id;
#line 198 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp10_ = _tmp9_.id;
#line 198 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_bind_int64 (_tmp8_, 2, _tmp10_);
#line 199 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp11_ = res;
#line 199 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 201 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp12_ = stmt;
#line 201 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	res = sqlite3_step (_tmp12_);
#line 202 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp13_ = res;
#line 202 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp13_ != SQLITE_DONE) {
#line 1961 "TagTable.c"
		gint _tmp14_;
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp14_ = res;
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		database_table_throw_error ("TagTable.set_tagged_photos", _tmp14_, &_inner_error_);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_propagate_error (error, _inner_error_);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return;
#line 1977 "TagTable.c"
			} else {
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_sqlite3_finalize0 (stmt);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				g_clear_error (&_inner_error_);
#line 203 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				return;
#line 1987 "TagTable.c"
			}
		}
	}
#line 191 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1993 "TagTable.c"
}


static gchar*
tag_table_serialize_source_ids (TagTable* self,
                                GeeCollection* source_ids)
{
	gchar* result = NULL;
	GString* _result_ = NULL;
	GString* _tmp0_;
	const gchar* _tmp8_ = NULL;
	GString* _tmp9_;
	gssize _tmp10_;
	gchar* _tmp13_;
#line 206 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 206 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail ((source_ids == NULL) || GEE_IS_COLLECTION (source_ids), NULL);
#line 207 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (source_ids == NULL) {
#line 208 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		result = NULL;
#line 208 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return result;
#line 2018 "TagTable.c"
	}
#line 210 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = g_string_new ("");
#line 210 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_result_ = _tmp0_;
#line 2024 "TagTable.c"
	{
		GeeIterator* _source_id_it = NULL;
		GeeIterator* _tmp1_;
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (source_ids, GEE_TYPE_ITERABLE, GeeIterable));
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_source_id_it = _tmp1_;
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		while (TRUE) {
#line 2034 "TagTable.c"
			GeeIterator* _tmp2_;
			gchar* source_id = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GString* _tmp5_;
			const gchar* _tmp6_;
			GString* _tmp7_;
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp2_ = _source_id_it;
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				break;
#line 2048 "TagTable.c"
			}
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp3_ = _source_id_it;
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			source_id = (gchar*) _tmp4_;
#line 213 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp5_ = _result_;
#line 213 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp6_ = source_id;
#line 213 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_string_append (_tmp5_, _tmp6_);
#line 214 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp7_ = _result_;
#line 214 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			g_string_append (_tmp7_, ",");
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_g_free0 (source_id);
#line 2068 "TagTable.c"
		}
#line 212 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_g_object_unref0 (_source_id_it);
#line 2072 "TagTable.c"
	}
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp9_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp10_ = _tmp9_->len;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (_tmp10_ != ((gssize) 0)) {
#line 2080 "TagTable.c"
		GString* _tmp11_;
		const gchar* _tmp12_;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp11_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp12_ = _tmp11_->str;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp8_ = _tmp12_;
#line 2089 "TagTable.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		_tmp8_ = NULL;
#line 2093 "TagTable.c"
	}
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp13_ = g_strdup (_tmp8_);
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _tmp13_;
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_g_string_free0 (_result_);
#line 217 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 2103 "TagTable.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2121 "TagTable.c"
}


static GeeSet*
tag_table_unserialize_source_ids (TagTable* self,
                                  const gchar* text_list)
{
	GeeSet* result = NULL;
	GeeSet* _result_ = NULL;
	GeeHashSet* _tmp0_;
	gchar** split = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint split_length1;
	gint _split_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 220 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	g_return_val_if_fail (IS_TAG_TABLE (self), NULL);
#line 221 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
#line 223 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	if (text_list == NULL) {
#line 224 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		result = _result_;
#line 224 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		return result;
#line 2151 "TagTable.c"
	}
#line 226 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp2_ = _tmp1_ = g_strsplit (text_list, ",", 0);
#line 226 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	split = _tmp2_;
#line 226 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	split_length1 = _vala_array_length (_tmp1_);
#line 226 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_split_size_ = split_length1;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3_ = split;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	_tmp3__length1 = split_length1;
#line 2165 "TagTable.c"
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		token_collection = _tmp3_;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		token_collection_length1 = _tmp3__length1;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
		for (token_it = 0; token_it < _tmp3__length1; token_it = token_it + 1) {
#line 2177 "TagTable.c"
			gchar* _tmp4_;
			gchar* token = NULL;
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			_tmp4_ = g_strdup (token_collection[token_it]);
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
			token = _tmp4_;
#line 2184 "TagTable.c"
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
#line 228 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp5_ = token;
#line 228 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (is_string_empty (_tmp5_)) {
#line 229 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_free0 (token);
#line 229 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					continue;
#line 2196 "TagTable.c"
				}
#line 236 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_tmp6_ = token;
#line 236 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				if (g_ascii_isdigit (string_get (_tmp6_, (glong) 0))) {
#line 2202 "TagTable.c"
					GeeSet* _tmp7_;
					const gchar* _tmp8_;
					PhotoID _tmp9_ = {0};
					gchar* _tmp10_;
					gchar* _tmp11_;
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp7_ = _result_;
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp8_ = token;
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					photo_id_init (&_tmp9_, parse_int64 (_tmp8_, 10));
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp10_ = photo_id_upgrade_photo_id_to_source_id (&_tmp9_);
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp11_ = _tmp10_;
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
#line 238 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_g_free0 (_tmp11_);
#line 2222 "TagTable.c"
				} else {
					const gchar* _tmp12_;
#line 239 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					_tmp12_ = token;
#line 239 "/home/jens/Source/shotwell/src/db/TagTable.vala"
					if (g_ascii_isalpha (string_get (_tmp12_, (glong) 0))) {
#line 2229 "TagTable.c"
						GeeSet* _tmp13_;
						const gchar* _tmp14_;
#line 241 "/home/jens/Source/shotwell/src/db/TagTable.vala"
						_tmp13_ = _result_;
#line 241 "/home/jens/Source/shotwell/src/db/TagTable.vala"
						_tmp14_ = token;
#line 241 "/home/jens/Source/shotwell/src/db/TagTable.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), _tmp14_);
#line 2238 "TagTable.c"
					}
				}
#line 227 "/home/jens/Source/shotwell/src/db/TagTable.vala"
				_g_free0 (token);
#line 2243 "TagTable.c"
			}
		}
	}
#line 245 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	result = _result_;
#line 245 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 245 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	return result;
#line 2253 "TagTable.c"
}


static void
tag_table_class_init (TagTableClass * klass)
{
#line 32 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	tag_table_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	((DatabaseTableClass *) klass)->finalize = tag_table_finalize;
#line 2264 "TagTable.c"
}


static void
tag_table_instance_init (TagTable * self)
{
}


static void
tag_table_finalize (DatabaseTable * obj)
{
	TagTable * self;
#line 32 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAG_TABLE, TagTable);
#line 32 "/home/jens/Source/shotwell/src/db/TagTable.vala"
	DATABASE_TABLE_CLASS (tag_table_parent_class)->finalize (obj);
#line 2282 "TagTable.c"
}


GType
tag_table_get_type (void)
{
	static volatile gsize tag_table_type_id__volatile = 0;
	if (g_once_init_enter (&tag_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TagTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagTable), 0, (GInstanceInitFunc) tag_table_instance_init, NULL };
		GType tag_table_type_id;
		tag_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "TagTable", &g_define_type_info, 0);
		g_once_init_leave (&tag_table_type_id__volatile, tag_table_type_id);
	}
	return tag_table_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



