/********************************************************************
 Flush register windows on sparc.

 This function is in a separate file to prevent inlining. The "flushw"
 assembler instruction used on sparcv9 flushes all register windows
 except the current one, so if it is inlined, the current register
 window of the process executing the instruction will not be flushed
 correctly.

 See https://bugs.ruby-lang.org/issues/5244 for discussion.
*********************************************************************/
void
rb_sparc_flush_register_windows(void)
{
/*
 * gcc doesn't provide "asm" keyword if -ansi and the various -std options
 * are given.
 * https://gcc.gnu.org/onlinedocs/gcc/Alternate-Keywords.html
 */
#ifndef __GNUC__
#define __asm__ asm
#endif

    __asm__
#ifdef __GNUC__
    __volatile__
#endif

/* This condition should be in sync with one in configure.ac */
#if defined(__sparcv9) || defined(__sparc_v9__) || defined(__arch64__)
# ifdef __GNUC__
    ("flushw" : : : "%o7")
# else
    ("flushw")
# endif /* __GNUC__ */
#else
    ("ta 0x03")
#endif
    ;
}
