/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2PARSER_H_INCLUDED
#define FB2PARSER_H_INCLUDED


namespace libebook
{

class FB2XMLParserContext;

class FB2Parser
{
  // no copying
  FB2Parser(const FB2Parser &other);
  FB2Parser &operator=(const FB2Parser &other);

public:
  explicit FB2Parser(librevenge::RVNGInputStream *input);

  bool parse(FB2XMLParserContext *context) const;
  bool parse(librevenge::RVNGTextInterface *document) const;

private:
  librevenge::RVNGInputStream *const m_input;
};

}

#endif // FB2PARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
